<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.1.0
*/namespace
Adminer;$ia="5.1.0";error_reporting(24575);set_error_handler(function($yc,$_c){return!!preg_match('~^(Trying to access array offset on( value of type)? null|Undefined (array key|offset|index))~',$_c);},E_WARNING|E_NOTICE);$Uc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Uc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Si=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Si)$$X=$Si;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$h;return$h;}function
adminer(){global$b;return$b;}function
driver(){global$n;return$n;}function
version(){global$ia;return$ia;}function
idf_unescape($x){if(!preg_match('~^[`\'"[]~',$x))return$x;$se=substr($x,-1);return
str_replace($se.$se,$se,substr($x,1,-1));}function
q($Q){global$h;return$h->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($Ag,$Uc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($_,$X)=each($Ag)){foreach($X
as$je=>$W){unset($Ag[$_][$je]);if(is_array($W)){$Ag[$_][stripslashes($je)]=$W;$Ag[]=&$Ag[$_][stripslashes($je)];}else$Ag[$_][stripslashes($je)]=($Uc?$W:stripslashes($W));}}}}function
bracket_escape($x,$Da=false){static$Bi=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($x,($Da?array_flip($Bi):$Bi));}function
min_version($jj,$Fe="",$i=null){global$h;if(!$i)$i=$h;$uh=$i->server_info;if($Fe&&preg_match('~([\d.]+)-MariaDB~',$uh,$C)){$uh=$C[1];$jj=$Fe;}return$jj&&version_compare($uh,$jj)>=0;}function
charset($h){return(min_version("5.5.3",0,$h)?"utf8mb4":"utf8");}function
ini_bool($Vd){$X=ini_get($Vd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($ij,$N,$V,$G){$_SESSION["pwds"][$ij][$N][$V]=($_COOKIE["adminer_key"]&&is_string($G)?array(encrypt_string($G,$_COOKIE["adminer_key"])):$G);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$p=0){global$h;return$h->result($H,$p);}function
get_vals($H,$e=0){global$h;$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$e];}return$J;}function
get_key_vals($H,$i=null,$xh=true){global$h;if(!is_object($i))$i=$h;$J=array();$I=$i->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($xh)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$i=null,$o="<p class='error'>"){global$h;$rb=(is_object($i)?$i:$h);$J=array();$I=$rb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!is_object($i)&&$o&&(defined('Adminer\PAGE_HEADER')||$o=="-- "))echo$o.error()."\n";return$J;}function
unique_array($K,$z){foreach($z
as$y){if(preg_match("~PRIMARY|UNIQUE~",$y["type"])){$J=array();foreach($y["columns"]as$_){if(!isset($K[$_]))continue
2;$J[$_]=$K[$_];}return$J;}}}function
escape_key($_){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$_,$C))return$C[1].idf_escape(idf_unescape($C[2])).$C[3];return
idf_escape($_);}function
where($Z,$q=array()){global$h;$J=array();foreach((array)$Z["where"]as$_=>$X){$_=bracket_escape($_,1);$e=escape_key($_);$Sc=$q[$_]["type"];$J[]=$e.(JUSH=="sql"&&$Sc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Sc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($q[$_],q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$Sc)&&preg_match("~[^ -@]~",$X))$J[]="$e = ".q($X)." COLLATE ".charset($h)."_bin";}foreach((array)$Z["null"]as$_)$J[]=escape_key($_)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,$q=array()){parse_str($X,$Va);remove_slashes(array(&$Va));return
where($Va,$q);}function
where_link($v,$e,$Y,$Af="="){return"&where%5B$v%5D%5Bcol%5D=".urlencode($e)."&where%5B$v%5D%5Bop%5D=".urlencode(($Y!==null?$Af:"IS NULL"))."&where%5B$v%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($f,$q,$M=array()){$J="";foreach($f
as$_=>$X){if($M&&!in_array(idf_escape($_),$M))continue;$xa=convert_field($q[$_]);if($xa)$J.=", $xa AS ".idf_escape($_);}return$J;}function
cookie($D,$Y,$_e=2592000){global$ba;return
header("Set-Cookie: $D=".urlencode($Y).($_e?"; expires=".gmdate("D, d M Y H:i:s",time()+$_e)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($_b){parse_str($_COOKIE[$_b],$yh);return$yh;}function
get_setting($_,$_b="adminer_settings"){$yh=get_settings($_b);return$yh[$_];}function
save_settings($yh,$_b="adminer_settings"){return
cookie($_b,http_build_query($yh+get_settings($_b)));}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($cd=false){$aj=ini_bool("session.use_cookies");if(!$aj||$cd){session_write_close();if($aj&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($_){return$_SESSION[$_][DRIVER][SERVER][$_GET["username"]];}function
set_session($_,$X){$_SESSION[$_][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($ij,$N,$V,$l=null){global$bc;$Wi=remove_from_uri(implode("|",array_keys($bc))."|username|ext|".($l!==null?"db|":"").($ij=='mssql'||$ij=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Wi,$C);return"$C[1]?".(sid()?SID."&":"").($ij!="server"||$N!=""?urlencode($ij)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($l!=""?"&db=".urlencode($l):"").($C[2]?"&$C[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Be,$Se=null){if($Se!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Be!==null?$Be:$_SERVER["REQUEST_URI"]))][]=$Se;}if($Be!==null){if($Be=="")$Be=".";header("Location: $Be");exit;}}function
query_redirect($H,$Be,$Se,$Jg=true,$Ec=true,$Nc=false,$pi=""){global$h,$o,$b;if($Ec){$Oh=microtime(true);$Nc=!$h->query($H);$pi=format_time($Oh);}$Ih="";if($H)$Ih=$b->messageQuery($H,$pi,$Nc);if($Nc){$o=error().$Ih.script("messagesPrint();");return
false;}if($Jg)redirect($Be,$Se.$Ih);return
true;}function
queries($H){global$h;static$Eg=array();static$Oh;if(!$Oh)$Oh=microtime(true);if($H===null)return
array(implode("\n",$Eg),format_time($Oh));$Eg[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return$h->query($H);}function
apply_queries($H,$T,$Ac='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Ac($R)))return
false;}return
true;}function
queries_redirect($Be,$Se,$Jg){list($Eg,$pi)=queries(null);return
query_redirect($Eg,$Be,$Se,$Jg,false,!$Jg,$pi);}function
format_time($Oh){return
lang(0,max(0,microtime(true)-$Oh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Xf=""){return
substr(preg_replace("~(?<=[?&])($Xf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($_,$Ob=false,$Sb=""){$Tc=$_FILES[$_];if(!$Tc)return
null;foreach($Tc
as$_=>$X)$Tc[$_]=(array)$X;$J='';foreach($Tc["error"]as$_=>$o){if($o)return$o;$D=$Tc["name"][$_];$xi=$Tc["tmp_name"][$_];$wb=file_get_contents($Ob&&preg_match('~\.gz$~',$D)?"compress.zlib://$xi":$xi);if($Ob){$Oh=substr($wb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Oh))$wb=iconv("utf-16","utf-8",$wb);elseif($Oh=="\xEF\xBB\xBF")$wb=substr($wb,3);}$J.=$wb;if($Sb)$J.=(preg_match("($Sb\\s*\$)",$wb)?"":$Sb)."\n\n";}return$J;}function
upload_error($o){$Ne=($o==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($o?lang(1).($Ne?" ".lang(2,$Ne):""):lang(3));}function
repeat_pattern($hg,$ye){return
str_repeat("$hg{0,65535}",$ye/65535)."$hg{0,".($ye%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($Q,$ye=80,$Uh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$ye).")($)?)u",$Q,$C))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$ye).")($)?)",$Q,$C);return
h($C[1]).$Uh.(isset($C[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Oc=false){$J=table_status($R,$Oc);return($J?:array("Name"=>$R));}function
column_foreign_keys($R){global$b;$J=array();foreach($b->foreignKeys($R)as$s){foreach($s["source"]as$X)$J[$X][]=$s;}return$J;}function
fields_from_edit(){global$n;$J=array();foreach((array)$_POST["field_keys"]as$_=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$_];$_POST["fields"][$X]=$_POST["field_vals"][$_];}}foreach((array)$_POST["fields"]as$_=>$X){$D=bracket_escape($_,1);$J[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($_==$n->primary),);}return$J;}function
dump_headers($Id,$af=false){global$b;$J=$b->dumpHeaders($Id,$af);$Tf=$_POST["output"];if($Tf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Id).".$J".($Tf!="file"&&preg_match('~^[0-9a-z]+$~',$Tf)?".$Tf":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv($K){foreach($K
as$_=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$_]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($u,$e){return($u?($u=="unixepoch"?"DATETIME($e, '$u')":($u=="count distinct"?"COUNT(DISTINCT ":strtoupper("$u("))."$e)"):$e);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$r=@tempnam("","");if(!$r)return
false;$J=dirname($r);unlink($r);}}return$J;}function
file_open_lock($r){if(is_link($r))return;$t=@fopen($r,"c+");if(!$t)return;chmod($r,0660);if(!flock($t,LOCK_EX)){fclose($t);return;}return$t;}function
file_write_unlock($t,$Ib){rewind($t);fwrite($t,$Ib);ftruncate($t,strlen($Ib));file_unlock($t);}function
file_unlock($t){flock($t,LOCK_UN);fclose($t);}function
first($wa){return
reset($wa);}function
password_file($j){$r=get_temp_dir()."/adminer.key";if(!$j&&!file_exists($r))return
false;$t=file_open_lock($r);if(!$t)return
false;$J=stream_get_contents($t);if(!$J){$J=rand_string();file_write_unlock($t,$J);}else
file_unlock($t);return$J;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$B,$p,$oi){global$b;if(is_array($X)){$J="";foreach($X
as$je=>$W)$J.="<tr>".($X!=array_values($X)?"<th>".h($je):"")."<td>".select_value($W,$B,$p,$oi);return"<table>$J</table>";}if(!$B)$B=$b->selectLink($X,$p);if($B===null){if(is_mail($X))$B="mailto:$X";if(is_url($X))$B=$X;}$J=$b->editVal($X,$p);if($J!==null){if(!is_utf8($J))$J="\0";elseif($oi!=""&&is_shortable($p))$J=shorten_utf8($J,max(0,+$oi));else$J=h($J);}return$b->selectVal($J,$B,$p,$X);}function
is_mail($oc){$ya='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ac='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$hg="$ya+(\\.$ya+)*@($ac?\\.)+$ac";return
is_string($oc)&&preg_match("(^$hg(,\\s*$hg)*\$)i",$oc);}function
is_url($Q){$ac='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ac?\\.)+$ac(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable($p){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$p["type"]);}function
count_rows($R,$Z,$de,$qd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($de&&(JUSH=="sql"||count($qd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$qd).")$H":"SELECT COUNT(*)".($de?" FROM (SELECT 1$H GROUP BY ".implode(", ",$qd).") x":$H));}function
slow_query($H){global$b,$yi,$n;$l=$b->database();$qi=$b->queryTimeout();$Bh=$n->slowQuery($H,$qi);$i=null;if(!$Bh&&support("kill")&&is_object($i=connect($b->credentials()))&&($l==""||$i->select_db($l))){$me=$i->result(connection_id());echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$me&token=$yi'); }, 1000 * $qi);");}ob_flush();flush();$J=@get_key_vals(($Bh?:$H),$i,false);if($i){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$Hg=rand(1,1e6);return($Hg^$_SESSION["token"]).":$Hg";}function
verify_token(){list($yi,$Hg)=explode(":",$_POST["token"]);return($Hg^$_SESSION["token"])==$yi;}function
lzw_decompress($Ja){$Wb=256;$Ka=8;$eb=array();$Ug=0;$Vg=0;for($v=0;$v<strlen($Ja);$v++){$Ug=($Ug<<8)+ord($Ja[$v]);$Vg+=8;if($Vg>=$Ka){$Vg-=$Ka;$eb[]=$Ug>>$Vg;$Ug&=(1<<$Vg)-1;$Wb++;if($Wb>>$Ka)$Ka++;}}$Vb=range("\0","\xFF");$J="";foreach($eb
as$v=>$db){$nc=$Vb[$db];if(!isset($nc))$nc=$sj.$sj[0];$J.=$nc;if($v)$Vb[]=$sj.$nc[0];$sj=$nc;}return$J;}function
script($Eh,$Ai="\n"){return"<script".nonce().">$Eh</script>$Ai";}function
script_src($Xi){return"<script src='".h($Xi)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($D,$Y=""){return"<input type='hidden' name='".h($D)."' value='".h($Y)."'>\n";}function
input_token($Gh=""){global$yi;return
input_hidden("token",($Gh?:$yi));}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($D,$Y,$Ya,$oe="",$_f="",$cb="",$pe=""){$J="<input type='checkbox' name='$D' value='".h($Y)."'".($Ya?" checked":"").($pe?" aria-labelledby='$pe'":"").">".($_f?script("qsl('input').onclick = function () { $_f };",""):"");return($oe!=""||$cb?"<label".($cb?" class='$cb'":"").">$J".h($oe)."</label>":$J);}function
optionlist($Ef,$mh=null,$bj=false){$J="";foreach($Ef
as$je=>$W){$Ff=array($je=>$W);if(is_array($W)){$J.='<optgroup label="'.h($je).'">';$Ff=$W;}foreach($Ff
as$_=>$X)$J.='<option'.($bj||is_string($_)?' value="'.h($_).'"':'').($mh!==null&&($bj||is_string($_)?(string)$_:$X)===$mh?' selected':'').'>'.h($X);if(is_array($W))$J.='</optgroup>';}return$J;}function
html_select($D,$Ef,$Y="",$zf="",$pe=""){return"<select name='".h($D)."'".($pe?" aria-labelledby='$pe'":"").">".optionlist($Ef,$Y)."</select>".($zf?script("qsl('select').onchange = function () { $zf };",""):"");}function
html_radios($D,$Ef,$Y=""){$J="";foreach($Ef
as$_=>$X)$J.="<label><input type='radio' name='".h($D)."' value='".h($_)."'".($_==$Y?" checked":"").">".h($X)."</label>";return$J;}function
confirm($Se="",$nh="qsl('input')"){return
script("$nh.onclick = () => confirm('".($Se?js_escape($Se):lang(6))."');","");}function
print_fieldset($w,$xe,$mj=false){echo"<fieldset><legend>","<a href='#fieldset-$w'>$xe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$w');",""),"</legend>","<div id='fieldset-$w'".($mj?"":" class='hidden'").">\n";}function
bold($Ma,$cb=""){return($Ma?" class='active $cb'":($cb?" class='$cb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($F,$Fb){return" ".($F==$Fb?$F+1:'<a href="'.h(remove_from_uri("page").($F?"&page=$F".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($F+1)."</a>");}function
hidden_fields($Ag,$Ld=array(),$tg=''){$J=false;foreach($Ag
as$_=>$X){if(!in_array($_,$Ld)){if(is_array($X))hidden_fields($X,array(),$_);else{$J=true;echo
input_hidden(($tg?$tg."[$_]":$_),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$za,$p,$Y,$rc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Ie);$J=($rc!==null?"<label><input type='$U'$za value='$rc'".((is_array($Y)?in_array($rc,$Y):$Y===$rc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Ie[1]as$v=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ya=(is_array($Y)?in_array($X,$Y):$Y===$X);$J.=" <label><input type='$U'$za value='".h($X)."'".($Ya?' checked':'').'>'.h($b->editVal($X,$p)).'</label>';}return$J;}function
input($p,$Y,$u,$Ca=false){global$n,$b;$D=h(bracket_escape($p["field"]));echo"<td class='function'>";if(is_array($Y)&&!$u){$Y=json_encode($Y,128|64|256);$u="json";}$Tg=(JUSH=="mssql"&&$p["auto_increment"]);if($Tg&&!$_POST["save"])$u=null;$ld=(isset($_GET["select"])||$Tg?array("orig"=>lang(8)):array())+$b->editFunctions($p);$Xb=stripos($p["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$za=" name='fields[$D]'$Xb".($Ca?" autofocus":"");$xc=$n->enumLength($p);if($xc){$p["type"]="enum";$p["length"]=$xc;}echo$n->unconvertFunction($p)." ";if($p["type"]=="enum")echo
h($ld[""])."<td>".$b->editInput($_GET["edit"],$p,$za,$Y);else{$yd=(in_array($u,$ld)||isset($ld[$u]));echo(count($ld)>1?"<select name='function[$D]'$Xb>".optionlist($ld,$u===null||$yd?$u:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($ld))).'<td>';$Xd=$b->editInput($_GET["edit"],$p,$za,$Y);if($Xd!="")echo$Xd;elseif(preg_match('~bool~',$p["type"]))echo"<input type='hidden'$za value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$za value='1'>";elseif($p["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Ie);foreach($Ie[1]as$v=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ya=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$D][$v]' value='".h($X)."'".($Ya?' checked':'').">".h($b->editVal($X,$p)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif($u=="json"||preg_match('~^jsonb?$~',$p["type"]))echo"<textarea$za cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($mi=preg_match('~text|lob|memo~i',$p["type"]))||preg_match("~\n~",$Y)){if($mi&&JUSH!="sqlite")$za.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$za.=" cols='30' rows='$L'";}echo"<textarea$za>".h($Y).'</textarea>';}else{$Mi=$n->types();$Pe=(!preg_match('~int~',$p["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$p["length"],$C)?((preg_match("~binary~",$p["type"])?2:1)*$C[1]+($C[3]?1:0)+($C[2]&&!$p["unsigned"]?1:0)):($Mi[$p["type"]]?$Mi[$p["type"]]+($p["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$p["type"]))$Pe+=7;echo"<input".((!$yd||$u==="")&&preg_match('~(?<!o)int(?!er)~',$p["type"])&&!preg_match('~\[\]~',$p["full_type"])?" type='number'":"")." value='".h($Y)."'".($Pe?" data-maxlength='$Pe'":"").(preg_match('~char|binary~',$p["type"])&&$Pe>20?" size='".($Pe>99?60:40)."'":"")."$za>";}echo$b->editHint($_GET["edit"],$p,$Y);$Vc=0;foreach($ld
as$_=>$X){if($_===""||!$X)break;$Vc++;}if($Vc&&count($ld)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Vc);");}}function
process_input($p){global$b,$n;if(stripos($p["default"],"GENERATED ALWAYS AS ")===0)return
null;$x=bracket_escape($p["field"]);$u=$_POST["function"][$x];$Y=$_POST["fields"][$x];if($p["type"]=="enum"||$n->enumLength($p)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($p["auto_increment"]&&$Y=="")return
null;if($u=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?idf_escape($p["field"]):false);if($u=="NULL")return"NULL";if($p["type"]=="set")$Y=implode(",",(array)$Y);if($u=="json"){$u="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads")){$Tc=get_file("fields-$x");if(!is_string($Tc))return
false;return$n->quoteBinary($Tc);}return$b->processInput($p,$Y,$u);}function
search_tables(){global$b,$h;$_GET["where"][0]["val"]=$_POST["query"];$ph="<ul>\n";foreach(table_status('',true)as$R=>$S){$D=$b->tableName($S);if(isset($S["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=$h->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$xg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$ph<li>".($I?$xg:"<p class='error'>$xg: ".error())."\n";$ph="";}}}echo($ph?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($lb,$_h=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $lb, $_h) }, onmouseout: helpMouseout});","");}function
edit_form($R,$q,$K,$Vi){global$b,$o;$ai=$b->tableName(table_status1($R,true));page_header(($Vi?lang(10):lang(11)),$o,array("select"=>array($R,$ai)),$ai);$b->editRowPrint($R,$q,$K,$Vi);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$q)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Ca=!$_POST;foreach($q
as$D=>$p){echo"<tr><th>".$b->fieldName($p);$m=$_GET["set"][bracket_escape($D)];if($m===null){$m=$p["default"];if($p["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$m,$Qg))$m=$Qg[1];if(JUSH=="sql"&&preg_match('~binary~',$p["type"]))$m=bin2hex($m);}$Y=($K!==null?($K[$D]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$p["type"])&&is_array($K[$D])?implode(",",$K[$D]):(is_bool($K[$D])?+$K[$D]:$K[$D])):(!$Vi&&$p["auto_increment"]?"":(isset($_GET["select"])?false:$m)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$p);$u=($_POST["save"]?(string)$_POST["function"][$D]:($Vi&&preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Vi&&$Y==$p["default"]&&preg_match('~^[\w.]+\(~',$Y))$u="SQL";if(preg_match("~time~",$p["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$u="now";}if($p["type"]=="uuid"&&$Y=="uuid()"){$Y="";$u="uuid";}if($Ca!==false)$Ca=($p["auto_increment"]||$u=="now"||$u=="uuid"?null:true);input($p,$Y,$u,$Ca);if($Ca)$Ca=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($q){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($Vi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Vi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($Vi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}if(isset($_GET["file"])){if(substr($ia,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("b7'o9c`a1#ydC1tFQx\\2\nSn0'#I,\$Mc)c1iXi3ͦn)Tid:FcI[c	Févt2+C,aGF:;Nu)Ǜ!tlF|,`pwS-oQk nEO+,=4mMƋGSZh6. uOMC@M'(b5ҩHa2)qиpe6?t#Z-ox<s;H4\$䥍ۚa4\"(!C,DN;Jj@@!K6jX\r@ 2@b(ZApl8h.=*H4q3AЂ.K!fqr!1Ȏc*+ (\n2j(dYADtϑm*RPQb#J+1N̙>AwKC`P=<@̊c]RrCHZմ\0=P\$@o(0CG-ZAʅt3:tc͵JlcR\nrlΨk9Gp!pj_X]hXfu0̳ҝ0=C6#˞75s,(f#zX>3[n?1m\\XPXeggJ4> \\T?H3y~hxt6%u8Lm\nXiM[,YP9|~O1*5+ӣ1d{o=gx,EPKsкE^4f;*J#j=kt8W1vhԃ3Btȧ.^̀os`?7}?Z]y[iPnW\"zx\"4ؽr?'\"@gf!637QCA\rYTP}@M}ͽ+{!ղݜ4׹ G	I\0^RN}EDY{/>#Ɓ*n:Fphn%w#p΍\\\0P+E\r)sLӱd\r@-\$V]Ã;d0\0X%ܰQ* w]dXya&3MM8rXElQ%ֽB2t!\01,ʈTI-4hee3ņDn.P'3ՆZRsxi8.3FI֒ԚbSii2)+\r+pCc9..ipaIxn԰RjaO)\raĘ@Y\rrNPjBC`d\07̻'@#֩9\"	u\rtqՒ\"ae0Y*`rBMDl597<13geD>Ң{\\Xyr3m̨*.3(7.Y[/!3(sC()fQ'N@*LaŜ\"dA8ݴ\":MI	(*1C)Lyf4S(ƻ\"QۄTWA{&.+6o1:\\Gȣ[Z3CuH	Ɯqؼ	0Ss-&&eCb@(\r(R5bH\rNlҘHe|aÈ1.!x蓂YCH)>JI =AڧɥCTpr +;IOe].5<[vS|̔4݅9UܩQsⴓ-ߘ\nn\$\n[1ʊ'z҂9LVz*XgxT~'E+Y,AKGxsa]5ƨA>TiRLjq=|Y58o<j\rLP0N&|f9b#,[TYu֚c`ֈdOv & VO-j<B7p#x&AChQ5%<y+\$~Tm9?ck!jo cV\ng]4SJIPT_	>~;śOfQ\nwM#uեXo8TK%e\\d-,mSFKEg\0\$4Lٖ㈑M\0P-ꧼÁA)kz5Qz[4de}/ݟh\rWWs<kI*[@icsB@5Gj7	_/-A6\0ЉzZ7ΏhOe4Q]G߾tJyQN	S\\ P\nJOnbOOΐތnNdNTcoF/cΞ]G\nP9ƴ)2!n\ngOM!OB#D0#l^J\0PoFQt\0pp\nFO_,L.,Y#R-Ԓh\0v00\0APOp/P'cڜ\0-\\{PSY.W`PN\njԢhn%p}I{͟b6QQZ)z1|pP邗ZɪǢ`Z C\n\r\0\0fqY1S4M`ZL@`*]@Z\r` >ѼKbeRG&gFn-ўQXKҤ/\r ċq.?\"`J#qi\$Q4Q%HzM&1&k&H'8cR@QJS8\r ڏ*{R)+`r'2*R,@+)-a,,#)6\0/Ư Xr(R0e1J+2؆,-3\0\rWr/r,{2>(xK,0T_Y5334Dfs)2R-^\r7Q7O260S)b\r.٣Q.2r-J3)/-:s;/ҊNY\$,hRK1s(ѩ\$c314sH?Tr^t	6t#;қAW4%T\r+4 8s)J%2W24=7@`E+A3tUE8!6%@At	CBYCS3CD [\$4IHtLr\0:SHTKF9@:R1F4SKF\$ \03A3#iJuEtB	B493H1!4+0	N.\0.JfP4Oԕ44FHԩ\"[9-P4;/?=9Z.A<aTRW,t;\0TG,u4\0VqVOTڞkyV WsXu;rVu,cPeuXՑ-ZuMQLӉ12wI3;C]s\\Nc455:3]2? 2%\\3\"z\rG[7\" u'*Q3Jz-4d &S@j{M6x0/SoX'+5\nZac0`!`iKKn \\SYuy27Xi8,[3֚voEhth_֍Q7i3iMfi6e`e:_#e@Y\$c14C40\rgg+j:\"\\MJ,");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("b7'o9cbFr7MHP`2\r\"'\r\rF#s1p;Ɠe2IY.GFI:4S3㔚Yu(Ìc(`h#%0[LhC!Eb5Úyfbw	z#1P6l2MQde#Qm>5ًn1Se0o#GyGxA׍]]ԻLƓ)s25]68-ļo NZ)[Y#)Pkp8C(\\5w\0C-&\n(:rʖclLtA HR @	xFtB8LBI0\r@3|s s\$)rsI2TF9r:t0;Ar*͔=!ʹ.*r\r.U534h@@1?RQnC4(9#87aՒQOP2LBHK%YTUUe\\E`!ȅn(@M#0Ьb04\noXtӃtXj1sHĢۈʭ+\\	H,@60,9ζʊ٣.2㢩c@565PQ\\!fޯ+@0\rXOdZq\n*y:B£È-gC>Wc[ocJ=e;ۢ)S#W7麭Gà8n3a@`aXqpn׭4ttCʡC/fpOp`AHYXao[\04ەskvɀGT\0٠:9m.~9mCy{㳠zv0ūF1D.H9O\r0	,]Ma6\0d7x͍%ts1GV	m֛Q!AEwhaw\0A<=<pAqWVfx{X\nA,4㘢tǰ'H[Miܾ2M#Dn\"qP*+є8	͂XyC(6W>Z`a(@0Zw1Ċxʥa;tdAhv!:Y \r``V握Jh}#(j`7d\r\0cUr?DH^Pjt8ɉf9&\0");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=g@T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8NPC\r\$nT=\\r9O\"	l<\r\\xI,s\nAel1EƯL][M'=Ke\0lӝә\nivc]EHפHoֽΈ麮쨋6#Ґ\":cz>ߣC2vCX<P*50X97N\"3!!#\nZ%ć#CH!rX&:c7JHp~# A:86&|ˠ3@2<sΆPN]!0M-˲40\0\\ԗ響33d!>H5.,4pX25Mڢ*,(\n,(!apΎn\0RփvmI.\r][H<J8Ѷ5NC<ɠ%mCr#`XDooSL)^B{`wJJZ/XC(>a@OӚ%Dpӣ8a^X2`\\~\$`W!Qcذ!\"#\"iiZnJ\r\$.\$:j]1C{`7ܻ<pA`nS#F3`bA6:u:n8VԃNa2I0*iri%8g/5ܭ,t3Ygr9u=C[ʦ:c@{^˨zXRȺ7!ut0⼸&EBo4k\"#P<9Hg6!bHk\\MAGRPK\"o7*K CAa2(&z2\$+f^\n0zE I\rH<Y!`tR!e]C[2.\\P((2ppMp!YV@\"l&`4(qБ\n,/2)#_\0C8E]/2 W )A	\rϺqLRTˣO=ncI1܍x6p\$!QQ0R`=Kr|Ԋ\n,`c\rq<I~et1y#	4HX NHz&Mi@6%Ƀ6̘DA6\$8h[M=:Ni:'Q\rѝ o\\u0=RX*8hr\$PAB@t\r%AEB[3O!\\X9~\nx\\@3\0<οBa2nwV*\"ETZQVbE\n)\r,9ZduN,Y2eRՂ[䪕нTN21QCŗt,BydRQ \rMdQ\n#WUUjtz,ܫgVLZÂ1Y8\rzl׫!i&Br+8lHe)[[0HrJVYn3baW@ :˨׊` =ɾN@x\nXԅ ;R~@Mu2Yoj|q&T6XZn{fdKwwZTo`d`KjV{L!̙0Yf܉O!InB#+;`CZ\\GFci!z:dIʜAѓHܐX5׼Isa3NK'мBy!(&Qtr	Tz:W(#>[^e:U+A,7~aՁ\"OcfV@|t5_2ֲBsI[}[aȩ9S3dcݷz͘Wqe\n]^dk\0=3za޼~20hw7ap-	܆ۿ\0Gቃa	/gwl^ָCi/t0t	hI}!'fnwic7O9om~L8\rz'UFbVScZ4]s꒿[-iWom5.t=KbcX͞=82iEGQ*)CuEAJt\"p_B\"p &T+H{(2^O,t+hLe͐C7~4dJ3kjA@7sSqpSF(,)ib4@ir\0A\0K;FĊ\r8X\\-I\$%%/<%E.]W bLMF-RM:0	z^cЖGZB:.?iӀ3(+@L&vY `p#nМ`-^qv^ \re^jlBb](X\rFX&%:Pf M@ΐD!&fzK(cU8ob1>@Ч^<1N-m垠lhrvdHrb.?Ce Z@^`^)h^Hd(NƷJ`YёQѠQN֣pMNݍdժﮚ*;Hx@j	PXf;n3G`% \$-t-FjGd f\$FDK!`z a\r##GEP22G\0'T&r\"ml\"(@\rCRn0b!*bX\r\"\"	D#R\rR6F-%NdNkbI#\rE'm\nqHk'R!qD®2β#RV`ķ@l y3(-B\rb53&14h\r\"Dk>`r4@)\$(K!IvNbMDze5B%[63F٭䭢\"fWJ[)S(*7FK7Dr8\r8B`DBV!ED9,\$(@#TuZC29	u#Հ29#@tXt`L\nbtxLqFDd4@n\n'NNSEtZch\0sCC]\$\$RV2[\$bRPDI-?FDӫDĦ#ut0 _FiKޭ24C̮\nK)&\r+62Jޮ4>RtBDEDVPTwGu@DO	YO*D隺qNQ`N䦧\\\n%<rqF޲UTY&2t;hNBlBrԁHRLh([u%f?tGWQtID++땓%Y`Lz#JlMBEU}3Q\"2U-b{eB\$!]UB,jҔ~ً/^BR+6'7Jb ãD;\rO)P\rJqS\0R@CB\$D)CJPhqf9\0&pH5<oSkseC_L\"%`\nd &ezPTVԭn^	\nbnldLk 5Mp}\rE6n'o6!vuIln5|aήœrLEr!u%aub- zp`t(&\rH<eX\0u.3;;,V3 e_,]M]}_h\\1qD |(u)׭W%11/0W8cJb~2ϹA`A1\"Q\"OxV'}@B&@ VwvBeb8&L\"~&^Çf*lWCEWQx*xkÇp?݊\$2#ȶ oS4`A+BXYD̒x_38()Hd?xXę= 8ބ(%Ȥz\n\0\n`*%@Izm7#ksN\$[tAKp%(jDe˔\\F9LjKtsqᙶ 9B8\"ǋ<ǖ'9*qT#R\\`e-i/4U\0ǆm@/1}E@]yyqx]ohX#ۍ dhl%4x}HIH:\nS\\`Q֌8#\"xb\n81˟u31w`z	@	\r8&*!.R<h@уLi2GDjONE4O0CыƾuBC+4݂,\$L\$IpKgkknN˖! \r)*MtKx6֏P(TbERq=N]BIS%M;vT67vtT\r J\n	*\r*7.&hy;V\0Qz(lHzu{5'FBDUE׬#_\0@@K%@rP5*Mj\\Qj8]v[U\0ښ_D|?1ZMUڡ(<ˬ)©D6SXq>	yf@PR=F#Tj\rBkp\0ϗoxœU|`^J(:;tX{\"i,\$[1&5F5-ZTXM\"~T#]`m;R0a\\c;h<̼PD{ib:\0l~/bN2շ`Q5\ncT[HtlD\">/d8MowZ\riBhR槫Z'd@oiR9GAxGWjGybKV}F\\3\"\0@zcϣX\"	Y v6yl<R(R]25_>bB,\$Ŕ8q{Ȍ˛ %NPnP-#s;XLR r\nnr-3^_+6im\0k2|@`\0uI^\\v,=4.*bx7kRԦo	y΂sQv&.#]D\rϭԒ8I\"r((\nt甼̩>UKd/}#0MT&۠\rr{	YÝJ	<aX2:,uQZG]}k_{= ؤ3i~, }488Hr	M2#Pbq'N@ZԞPI	rЩ?Nw)9mMsHŁgN ]p1]:\$t71yFAg!Y8`,oDh\\\0x:?\"+	S:Q#A*޸h@X@V I	>A\0	JPꏋBset\rerR.	rr\nQ}h\0t\rmt0 F#}h`.L`=*z| 5<2AFJ@ȳnhymtbF\02Bޓ5K\\aoZQ	.3TiHVe!^\\T K!FP`W	L3Vi\$Coav[\rn\0d0!C40t4MHj&AlXlC)eM>;mSQCXT\\n2#VR7\"eЕtn|)5`}z~rBto]@X28'N9ǆ~%yO\"bBzDT\0 qE*'0TT\\\"#,Hz}3h!WK\"HEhQ!ZD\$Q	Ҁy@5rظ&.0i(wyn\"E# q뀻c?< ЧHICBpfVATUnqK2dUܮ!w`-]u1I'Rȣ6\rJ5qA\\(.AmpZ\$f\n\0sA)(;\$!#u@51`\0#\0mp[HF8XAܒ~\0o{ yt忐`jM܅b l\"WTX5y/Mi޲69iJl\$;\"H~BɶIN0\$+FDdӦB:B5q3@ZdSjGW\rKE06rQz5\0bH/=o- rY@1/l&-C\032fɕu8['2INJ@ZCrC	՗!xɠi)9X\"҆@w()Ɯ\$)E2T`d,e(pJx!ҩl^R-2my&|\r\0R\0K +pU҈Ce0#X\"H;	(yk6r\$d!nk@u.QH'x.!L#ZABpȔR0ʌj`5b%C0@,i\$HJR;r+Da[H>:ly/&e\n	7'9@+(};s\0S;P>p7nIl(VRtm.(>_DNnIYM\\+K#/XBP(`עt\"M'!~ҹK#axO1%1m\nIr&4GO[W_u]_(	ͼhxs1%!r%llDD)7!j>\rOb| 3A\nHhי~60\0A!෩u䃰2O<&6L覎(!C^6dx'Efd^,cLBK\$Mf^3e@PnTJUH>~ 1īK˫)Hיʱ**(gfFdwK\0\0*%\0\"|H@\0J>*d(&mjeV܂1ʆ)Y\0\0\n5h-#G,UWqjJxP(utR`AJ\"-8\"MA*\"Q%\rhD.nD`-W_W*+m\"9S\na'DF!2Ik՟hXӀ}Yf5:Rai8_\0ouŁ/)U\nHe|/>4b9oǎHRSXM2#b]L8<wy	o9\0Mи=}i\\	i@^\$,|Y.(MZoum5YO}Dy!\$ё\0P\0\n!32\\*jh@R3ݏDF(#;|	%L0˄(|hPhEMY*h+8\"JrO9ܩ\r7pD3J|6aI%NbpޒS&8Bi>u(E0(kJY09UMeWPԒH<O:ZUE<.V']]*%D\n	.W΅(uP5(	2^BClzP`3\0(1Tjb]pN\\:!,Lg`PHHҮ(\n<Etb0G\nؗD[p00Sq Ⱦ6iI	j{\0PKq\"ɯSƺt;>MpScɦЖx6E4N'ΰu}\0_eH!7B\\k!^W\rlq,oXh6=_cS؈#V\$olQb!䋤)1\"<+VZI`KND_<eMoaa93e*Vb Ukc;jb]Vn*JVHHbjdAV#NB6@n0c8dՎgN@Ӯ\0Εq9Z¶gE6KUJնUz mde;I~eTr]m~kn[5Eijq+MYx.\0lÿD+bOŭmHP#_:1\n,(1rFp*:Wא0P|hh9G[K5kLtyBHX.*YKA_7Ja}t2DYtBՀP֏c{/S~F`-T#M\nKECZ+\nȍ&U'8wD0F-qxƔtx>CӓL^la9\$3E;+B%t뭋[(kLPJVWɐl5`iåU^ b2nePtC	!y%b^U>aPTVʶIUׄV!4kj㥤_F;JXW`i`++<X/]=a4LhV!{:;P\"1Ы]HGhd.RhPǈ>\0 iқs`,otk<=`q3DK*)HGG\"to1i-#]FupeB(Zu@,!jO\\*.EgiX轄-]]o87faRpFN!7DRipx\nhὕBCy@Ql\$a*KMXZ:OJmya4Q~bT@E	Ekx	L+%G\n\0'j2[C6\$EtK<}v/OP7>V2	\"W[*ٖDqmʉ*rK'E[A\0\0[ORdiPXXh[g4(:Bg8\\r yEˎs_mr#\08160ȕKDw*`E,a@>2_q~XøJWK<#>X@v;^YBE.]\\dNR͢q,g_b>5eeƈ%-,n]\nx>t%ˀ1F,d62f-՛gF,BWA+Wm\\\$mkC5@@#uA.ڇ6#8dI\\f#98ggmIow!1Ӛd9Vfp\"=q	+IC-o.7<60'@mkzi i.biL:u_4r-ܓQ`,\0\0CSɽNiٙ״pLvΠ@E+!g}Z!۞oX\nXlpJ4\rl\rDۼ%-ƫ0ryX\\g:/;Y {_7H%ƉB0ި~<z,GhywO=y|=YzA7>W̱CG=-2`sD&C݀&r3Ԣ3-&@k3Up^^ϓ\"S%YUO+sKWXc1e\"Ri儳5Y\$TeNo\0Ja+VuL3a\nmO\rMw:DDA,8~Ȁ \$\\\0my/VC-TEP\r%+]L@VJ[v٨\03RQG߉j7`%{98\$2[#T1Jr)S%T\$4\nV  8Kz)ZMsW\0Š5٭Vh)#D57\$'BY4\r<|Lnhy:]R/gSY\nc&kQ\$I	@E2޼㽼0B,ԝz{dN=bL\0fȣEN9\"еzCf6ʥJ S)ZuV	҉5՗b)t_?\"Z@Mh&ۿx*Il\$\$Um)`dKK'L5r'YN9xR.|2SMNBG-rjQ| 'ֹN;HCZ|+Fd/6Cdnp]wB\r)!JB\rsed#>Hm఼WdYP{a3\nc&qystC棵D>'snsy2bb.{B\n=O!;\\*+WXD\\XOhFX]4.#M<jMtS&GUP&tdB0!{>2:Qaf^B`eF*0Z\\|'&hdgx(;G]@\"_%n,jPfCr0oi--K5a{9яܒZ=\0M-a~DMFw!Sk1|G=_@[A˗VHW\\et:0y],Mp\\ﶲ),\$w\$j8%)-*Rq*SHn2VjUh[*8y!jw;Ĵ	f>]͇3*}\n\\/\n;6m@b;h-ȒU:INP}VlnU%.9B@Ip\0\nK7\$`ExD]\nF|!nԄߺ\\Ȼy?,Wͭ:u\\q&4g5H;QǠ\"˒s֝vhInfU(VV#If;:{~r󭜨;O1F\$\\CcV_}I9'VOltn\nBR1m|wK6O ֝鑘\0jO=/i>Fvn;_؁|A9?+cܰ#F\0P\n|!:>/N{Ū;0%>w@N`6;\"/Xg	D:gi##kKrRM:@\$w@\0we<ݕַ{wP2:<⪇\$&:~륽>nDw83<VqZLdS\0,k?A\rfΫ=I\nh<MI:E0@\r2S+\"chI\0d(\n[ϔ:6KA(8#g@ZCP ^UC mx{IBn6\n[DA33JLNIddRq2(7uAfp`zמ@|YGkoOy>%ԄHbNГ02jnr9jШ]c6 ԛsp\\k\rj'D*<>y`prW\$!lG||(qBR0{⏸T*\02GOEI)\r^Eop4\"^P/\0^7h4[.>.];Q:؂ߤ[8-+>綽F46~8]_\0002_JpKP7<XNJ%ţt\nc!Pא3_L_?2EO4a~8X7PT6z3 'M)%a>f|'QnF#_O}]؀q-_HzHpÅ>\rp.|B@QR\0Fh\nJ0\n`K!:)s'*;a^\"-b+fNnd#\n~\0zSgUphG@T`g,HMM\\x!8\0O'\$\$CA&s+?1'7^a >2N,%ʴH+1	2i h@\0M朽	FE7fm\rj\rȏ\"a\$w(-Yla`ZPK!{P BɔށM퀆z0y,TPW4zPL>lN\r4B@\rX@PTYd.A`d.Ajz{w?m<+:j\r\"=5Kbe[U(`P+p YG,e? \rM7\0");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:NpA/# 0D\\'12a@+J.c,1@^.Bь`OK=`BP6>(eK%! ^!ϬBHSs8^93O1.Xj+M	#+F:7S\$0V(FQ\r!I*X/̊67=۪X3݆؇^gf#Wg8ߋh7Ek\rŹG)tWe4V؝&7\0RN!01WyCP!i|gn.\r09Aݸ۶^8vl\"b|yHY290߅.:y6:ؿn\0Q7bk<\0湸-B{;W&/nw2A׵A0yu)kLƹtk\0;d=%m.ŏc5f*@4 cƸ܆|\"맳h\\fPNqsf~PpHp\n~>T_QOQ\$VSpn1ʚ}=LJeucaA|;ȓN-Z@Rͳ 	.2`RE^iP1&ވ(\$CY5؃axh@=Ʋ+>`ע\r!br2p(=!esX4GHhc MS.|YjHzBSV0j\nf\rDo%\\1MI`(:!-3=0SgWe5z(hdrӫKi@Y.\$@sѱEI&DfSR}rڽ?x\"@ngPI\\U<5X\"E0t8Y=`=>Q4Bk+p`(8/NqSKriO*[JRJY&u7#>Xû?APCDD\$Y<X[dd:a\$ΠW/ɂ!+eYIw=9i;q\r\n1x0]Q<zI9~W9RDKI6LCz\"0NWWzH4xgתx&FaӃ\\x=^ԓKHxٓ0EÝ҂ɚXk,R~	̛NySz6\0D	؏hs|.=Ix}/uN'[R`N95\0CXْ6w1PuL\0VʲO9[O>PKtÈu\r|̮RpOUDrf9LcSvnQo@o(ްàpa*^O>Oɹ<e\"ٓP>H^	psTO\r0d{Z\$	2,7C!u}B^?DڃFݱHΙ`'@J3|OܹBMbf1n@1(ղ!oowf)IL\\[8[1)!)u~c-6-y*	>\"m61ӕ.~*x諍qǚG |rlO*%݅AbRAxgDfV\\R5lޤ`5`w|SgOB;Ϯ^LÖW?5 ac}sݏIArݺO0;wxP(bmL'~wh\0c¨pE߲:C{g&ܾ/Ƒ>[ۜ)	a}n͡wN˼x]V^ye&@A	P\" E?P>@|!8 ЊH	\\`@E	Â4\0Da!nr쯜\\8o`Hf&̒<r(jNeN)6EO4.n06\r \$\$ N<|αNjOY\0Rn`omkH*-Ϙw	OzNZ*ʛnO\n#n⏓p[P_bjPPГ\0}\n/ӐП	o}S'`b\nPdp ?Po0sq\n:bLUu\r.L`SP1mq~]%&ʚQ \rDpqpV|f8\$p&ׂF&mOwG	1/elրD\0`~`K\\b&QQ`ʾAVEWn: ؓBƌ\r*l\0NDr뭦[&GhrH4A'bP>VƱM~R%2rm\$\02cMhʇvc}cjgs%lDȺ2D+A9#\$\0\$RHl@Q!%\$RFVNy+F\n	 %fz*ֿMɾR%@ڝ6\"TN kփ~@F@LQBv6OD^hhm|6nL7`zr֍Z@ր@܇3h\$@ѫt7zI P\rkf D\"b`E@\$\0RZ1&\"~0`\nbG)	c>[>ήe\"6N4@dn9ɴD4&2\"/|7u:ӱ;T3 ԓi<TO`ZB؃90S>Qhr\0A28\0W!ttwHOA\0eIFJT4xsAAGJ2i%:=#^ g7cr7s%MsD vsZ5\rb\$@P\r\$=%4nX\\Xd,lpOx9bm\"&g4O\\(ൔ5&rs M8.IY5U5IP3db/M\03y^u^\"UbIgT?U4Nh`5t\r2}5-2W(f7@e/\rJKd7- Sli3qUz\0)\$coF?@]LJbDҿ0s?[gʜ%\rjUn^R5,֪tFE\"xzm\n`-W#S(l	p%CU辚F&T|jbZ8	/4L*nɦyB:(8^98U K{`Z\nF\0Cl\r'(`meR6MBC6vn%#nvDjGo,^:``sl\r_X5CoV-8RZ@y13q GSBtvѢt#bB]#pfZCĲOZN]slԂEL,+Q@Yw~9I\"8!մV5&r\\7W&ܼ[\r\ri\r~L|dܷ,|i@,\0\"g\$B~!)5v0V b|M\$Df\r8;}fficԄV0,Fx\rR`a&nȧQB.# Y>wgE[ƗX~ROY]8]rK}-?8vL@~A*fJMtג-v[#xL'L>l8Pg\n\rQѱ\rM\":xw\$b-=kRXoQ乇9;ˈ過sՃ͋)~geBBt,,Ky-,mӀ+07yC˃IzƍY^GGWuv0#kXRJ\$JP+6x18Yg{?\0X\r	XFWהV/̓dIg9߆іy1-GX@ORy!GuY5ZF\r㕵-\$Oeu-ZFZdi9+쵘`Mz\rҫIyAVp:OJ:V:#::c{klZsWP0#9g@Mczw[9U\\k69Ӆ y,f6n-Zufًc,[o[gd :w#!W\\@n`߱\rɡ\$۟\$%ߡ۷z#\$imYcɂkI_yLϹ\$`V[F2C8\$ؼG[¼=Uυ[qKY݋Q?8aXm*G\\?U\0ϢKĤ|CR͓-|ɜaeRYƺ饘ܒPJE=u\${8X{ŏٓٗՙ\rͰ٬&Yҹ(ټM2)V u7\0S Z_o]\\|٩Ec7S΄[<<;-i }l!,}%-۬=Ӭ=Y8PV|zE.\rbLfƸh*;	ַ;؇Q{9\n_b\$5lUzXnz\0xbkM	2 Z\rc|ג/}%`NA\0*=`F^Q3WX<tR>r`uģ>izNاÝi\$\0rs^C>U5^a)	J+>uB@?J-HOJ'-TʀToUhF{ԏJ[NVoJ&SB\"I^5I2T龽]\0\rkL%}t۷~I0H|PkL5_T<w=<x\"esaK\"JH+Ua'Y~7)W<6=_Nh?6ܘy,aw\rİ#-V@k?ib*%޺p?yЀΆp-p|nCaf8A8+#\rR@npm~ۈ{`H?v*%Ǽv%G``Z.,6zU8|yV/p^פm]zcӞ\$IB0|@pR\nj9 G7읤#p߭?'=6Hlψ.YOY_VGO]I=x\$=|Ϫ{\n<;{:f^L'SA1%8*^p75W\n\0S⟕\02\nX(u[rpB0ڭx:n	ZI3C{[&C(@}rw2闌nt{CɆY!\0He>P\"9t5o!\$@\\7SS\rC P㄄@InhG	IS`x70b+v5^gr%bpU%)<+S/Z@ 4!j8\0vN-6a[>X,e\ned/PX`}kORN+1O\$πF6B-:wڨNTD>xY)n1&7}&xZ\nޖW:U@a⺃@.RhbcT\"x\n E|߈\r-\0\"QAIh\0	 FP\0MHFSB؎@\0*9s\00'	@EtOCx@\"G81`ϾP(G=1ˏ\0\"f>Qꎸ@`'>;l82>zI IG\nRH	c\"\0;1ێn)8B`(V@Q8c\"2E4r\09\rԑ \0'GzH5E!#\rAJЉJ(FC&d I\"IV솣GSAXZ~`'UA@+A\npi%ѿGZ`\$>~?E\0} <Q'Ewئ#\rɂ7rQ }'iMIO0dm% Hʰ\"-h#XFMt\$!Rt,(H88!J5Ixr\nThړ~Pe@&eg\"[hؖ4|2zDlw#9	v{lb/~\0&I8%,IKA\0/GYK*>O/2teھفP93=\$Xd-&|#154LUG.i2`M.B\00036ISJ-~쩦jF\\3	o4u	(@a3A\0c`P( 0\$\\}/d\0-3%b0\ncz`))%*6\"ٖE4FqJd(Ӏ1iLm2A.)&q@\$`L2Lrse .vss\riKQ󤙬 0()|MbtU9!ED	(	`8*pa<80s\r N8O0Ξd0OVx@'<OlJ)	~}\0U=O'Ňd~\0OfXH	LҠ(]'@EPLWE'=\0'\nN\$iIZy	>iOH6f'߁x.\"}@-wa2vӅAL><0/PB͢T\n<sSQ~|ӂPfiOφlq9T\rѕgÄFӧ%O(1h⺶nmv;|gSaFRȤNr9z%&X\0007\"2t-\rh%fŦֽ3!\"(7I\$s/ -7*J\rΕCLxw֗铴(ҪB,+h\nf\rF7Rf*:\"Δ4tPiX*\0P.(#+HoJAGq.57+N	:-m`&HJOUvi\0\nGN:gRn2i)}#	F駩>d`qHƕe5J);HQ\nHϓGRWԞ/Jj)K*URib8za.RG!4ͣ@9c: E.F|T*s<Z]_Oi\r@2qTlVUkCQ\rOe\"\n.TEUZԠ@i^ܪLaMUBV'U+Q VWmGԺu0*PT+!u\\kVy@Ƥj+H䁐\"EP,`<HՔpğ%	l\nK \0\$T!8@@2h4Lŝ+&,|\"TQ霋b#w)umŵ[ޒ)E}[Exd)p	n-AK1}W\\IUnF^\n` \$m)oZ	PDPVD r%R)bұl^w)JB-KD.18\0; le,L(\"mN\nZKgHe\0\0t7]Kk\$yNX\06(Yf\\\rK1y,`0qo\0h\$\n_dRzECh<Yp!\0ro;'g'*!YXv%K4RV\rZ}Z\rompN]N5xUay\rjWkb~+medyٯʰZksO4;Tal@4[]M7n 7>6ϓ=h*0HΫj\$[`,y	>7pD\$u9H ;R~0[DH삕6ܐ>-LxjZkNȢndg;C\\\nPb[h)3McD40uR#bP5:aEqH: :.X?c9%nKa5J`7X\nq=ȿvrE<(~CȷPQxHbKܪ-]\"QCU.aQv& 7]Ĩ媻>.9\0=K=)T _OX5!bUhAP-\r%zPޔ߀<xc7|4qpC<NY5ь)澈}AN_RCTxF*3g.`*B`&T:**7ƷEWR\\cW[Kb\roHru 2~/խ	@aI ,%b \0¡+{[,`_67.@̆)?mmba\nv]`W8!W`:Fpo-`7	\reXXzKI:bD_5>ŗf+<Yvg,%H\\  d\$@q\nA \n68F'|IRT{sm38b)	@LcMF@#Y`NDXCxzYc0y3hDZ6\"t\\7SE;U#R^ީs\0CfbܚrrI\"Y	tå8ZB/.`EK|b\n|_}KC. p1:#Y\nTC	%,,\r#@+dqŁ\${D	\\J\0񒫇-`m!|gdzVIvv&A`MH\\I|EjB0ۊ@ѡnUKތ>]ݸhiX9upra\$7vQCA>1xifR7*;8%\"ɄwPTByH'\n攏bظvT5xcH\$\\ۏXlKa`#tEwgh1 zp4:\nC2HK<X	(!J;㏨,u3ysMC9pwz\0ՠ9ǈxǃ1Bي`r)=hLƂ`?z9E?J1QR<\rL\n8(#rp>LQ|\"4(*8fpiWaQ\nQ*\\0@H;VYΆOZx<F'IA\n<]dP_NT!\r˧@*~ІB=%z;:AB}&lch`TO))\0yIۦ8NyјG\r\0T\"hn5W@}ՆB}ZkVФy=s	zӔ;\r쌚,hTi|jza&ր\$iS°Hi>IB{Z*UӘInO}XMsQ8IЊ	v&! k@#<TZ.jZ:	^B}YvO3BTC6=keS~?]ijOѦm,\0}!mF![J.gUlZP٦O[;&]Oht	`aILAkbkiNvYm:vvkg7)>b&؞p\05I]dp=+:;) Dx@^oѸAL't w&Ug3B`/='d>/dbF\0w\0y9nZ[6TubZ~~\nzd'@Ra\n\n@G0;vS={~\0@_c0ov1~xe\0po>83|pp<Ilo˄O; %8Gx.>oO=^uLG\rN7ݶq8~&n5l]ڀI..4ओ_ۼ=xPI5][\0_\0̓  <:eo By/Eq瑻f'Jw#7NxF(yD7\\'Y2˕?߯)9enGrvQ	./.Yܪ<zkMޠcMB+\"ہ\rgl\0^\0B@-	T61\nP@ \"\"@F0tU\04!_|(B\0Oc<'t\"m)TWF P?f9CMmkDސ|	&3`dΞ\0O8y@\n\0I?@@@/O\n0<d\r\n\0HC>knm_:Gb\$\0ђ|(vI60\"KB JrK`|6FT'9Y9>r@y@%ʄd7<\$p>t\r\0|yr́k9+6#\"97 NڮͪEnp{s^_;\"I\0J <w6ejc%85րL&F{2/w;&CD+p%#BYo:d4#H!A,݃\nsα8#=gjl:UBYX\0eտtmd(v@k\\9vQ2-{&/¶A<%N`EKJPպ,s&8+-1T@W8lDx76@\$v\"tXvj@tH'Ey@5ك<ɏ{vOY{LWr:(,̗\n+:(5䏤02%DQB{x-(*~.CJ\nSў#K|䆮ɨ2C@aBbCqyL7K4OfQ='<!ٙfP+`gNDUҡ!\$\$-/3Az_@d~Q3'>\n\011>J5Tk8;dY^ƥ\0Ӈ(F왕`kQ+I}Zg0>0MW{z_BkП;`(-wJe&ؤ;FA%L\r?!̋\"V_5G3s?-eتQ,Ys?24~l\$߱eؤ޷G\rrHA~O,G@ldϲYlbЂ?#:Sߒknü,3Jy\rgfπv/4ݒkdA}OY|tKAޗ?|ށ-&W`_\0S\"os~Gr\$Dr{#'Eͽg/?<?:0'Zn79h@?b@(3o(.,o>{I\"䑂\"`9ډ^-F7%hҰ*֬@|	\0i@@~C\0XX\r,3\0ZT 6.<;C;2b\0K=1#! 5:T\nꙪMtᵀil@9Sb@(81iA @\r+8KB6~\r8-RL\n*`61wB[Oٻ:t A\n@J\"A8kl[Co<_#AFXnl(W,ꮈZ6ȭXn\0J3Pu>>d!=V{KGecF龪Ɍm/0LXOi*˻\0B/3z(}0+IBPp\nBשIui,)0%f	ShϜ{:P#_'Tk2h Ⱦi¸B\r 0kΐOn#>l	\nB\n2̐VOiаYbs\0dIſ	16B[,\\+2(&\0\0\rp^Z)@<ALzɐU\r\rtdH\rl0DV1 9d0Lt@[5P	P/+<Bzzn;f \"\nxgj`T24X @;7\"ț9hۮ>c<C-a\nD\np9bZk *2Bʡ\\1XC'ɁDD6; 9;+Ȯ`ʃJC\0002oPH>\rc`2A@F`ۂ%\$\"D8+A\\`սy&74x\0ºtѢp iZHeHRD#LZp).bɀ,pB\$%xB&TɈ`E(Rb\0;F1ioTⲀ4/k<U*\0K\rQZe]\0ɑLEK:),Xc(?N,WVGBʯRqhŀih<SoŗYEM_YYE]Q]ųWKŻ45qvzEB^r4.9\nal*+,`SUb/QEkQ5XcmTPT{`%=	P\n\0x{HqB!R5P`]	i>¤hF\nN<<| hOjᝐtڝC)F88(18NRi\0߯i蓀-@'2!K@%X\0Dk(Z\0\0룆#ii(/-\$ػ`t\$[;^ ׃;O/:Θӽ]\nJaL9FRS劣\$TdՃ~`62	jD2\\OGQ8 XE4nlCfA\0@bX	bXd4bk#V\rt~W5ћFEN`m#HFOX\08\$%\n;()0\n:D@@)p	r)0jM\n\08\0(\n#!`QQ\r(8J5R?M(X)(<~QG졀Rѹ6䀑 dmǴ]\"b\rȵʁ &>A\$h?c(\n\0>	}R~\rhH{,G<m(VN\"\0_h7:،2A_>R\$1\"\\27\"z#Gl~rDGml[I-#Srr@u ;d* I/\"1']<\nHwAI 8#	[v\0001^l#27\\}ɒ3#7E&|i9l&v\r9'zC./3'@j+h农*r@hY;'2~(96{A(9HCTD[҅](,0u(}3Q)<R2(RL\rd'\nF2{J|u((SAȱ(o%( °\0[.ʐ3򙆚J1(T2\"jʫ*7ү]*I:0.!H\n+C`(P?ҸLaF+2ʀ9 +σ*AFL60\0+c\$@cP?R# RXy:6pD ,G5(QQԤcP\r+į'JB8,m8-PpMx̥BV}|G,< 6\n\rҲJS 9ZĻ2.E1K8:ՌG*A &5-ĸ!jKAe-9'#/U's0'\nLUJN.mĶ\nK049Lcp\0<L0t2B\$<LBLsLJxhs1ln'|WdLm,\"w*tLo-Yhߤ\"Z1ȥx焨Ĥ /1U9̤ʒK2s.'(̂vI|̇.cS\r\$a3r3\rJ#i<\r 1+΀J4\$N#-4jjM\no/34tHʘlȒ8L/4SN0Q4ҳRM0]K3>%0')L?*Ts|3`̋6|Rͅ3aJ&rMxs92<s+̅6(l͑1>9͟5ۉT6<x\0\\slM/}GJ\0006M7j7;3gM7C+\"K7s#~<ˑ8di\"\$+, 08Y&67xb/}#3\08L	29Mu9K1*-/䲟\n54qKœwD栏o1She~#slr:ӜN|\"4L79?O}\0[KӉ7eE(\raN)3ܳJ.k2BFKL)I2o9%|2fsI'D̒u'pSBy>/|-\0sʖr|O8DH-N<uJm:=X%)0Y32o\nդt	M,lDͣ=K=+ق6OU>I>\0MR\nгOY'ASOM=DSϫ=r;ssO=2?N[.D3ɣ?O=\0\"LO[?u\07@T4v+p+\$9L.1,HJ̎GP7F5>U'A5P?A\\%?Y@MC4LAhd<P'TN?4%̢\roBE\nҁqALLaPDT	T.B\nЯ.422؈)\rP?UT1P@D54\0ԶL9II}'M*3\$`6ɫ'Hrv9\nPP?lP<QUC_QGB悌P4J2|q,}菦>0\$f`)PY(+\00 ޕbWQ0p\0\ne\$rPs\nQQFn0(@#J@&ў3\0*FZ9\"#>	(Qn	FmhEF\n`(N?r;\0\\R&>`'\0x	cꎮ(\n@F&\0n\nƏR/rD#đ(cQG\n>ďTFRGќ%	ѥGxtjѮkTJpArGJ,-Ү(ԁ#!e+HH*4RK04Ar>tGRJ}'QG	rQGE0\0H\0eF6ҍJ9Km)nPGJ8tK,R .tSHT\0L+n((1Gu|G\"H5t!@>S?M5\"4RN4H#`#ԐI5c#I=%4IIl?6RL%0ԂILQ3S@(\nTұN`0kM\0I&'qIT\rI0NR52rE7  G, RoI{Pe(5Ҋe5%#>2`\"UKe?heK\\\0	X*7kTH(#ѻKM2#	R\n%*-!TQ= UT?T1O\r.T\\% ,UR]K!Q%+MQp\ni[\0JJ!SQT^}47JTS5HMSO9KQ`\\WS+\0+%MPaQM`GG?.Q㨉@#p*='RtӬ>USPPrR\$\0%UC0?\\.UuL(u7(\0U7dNIfME\$5K?쎃?0jJ\rT@\"Hx5oUVUW)yS)M]TS\$p>FcOZU.?S5mU8%<(QFuFV\nMTK_U@=\\5qL?\rbusY\r4wgY!1#eXa@U>d4\0\0#p	>\0=  h?	?L.՜Ԩ	@'nX	5`\$J4eK@V-nֱKuV]WիDUZm6hVX[\rVM-DվYui;uU)BU[\$ģsTMG4kH!]uWR}oHOoI\$?EqH; \nTԙG:#\0tTMncT-DVJuق?T%vCʏeG2;y]hh\$W:)CWs^wuuV`M^E\\W^*ՙWRRWVzNן_Jtא>׿WgV5wG\0S}FZUV)ZuhWK	4qHUU7XhUD_y6F\\T`MV\n`}4XS݃e`H\nGpGU&#%}r	eW\"?=1IZe*֞饄ܣT,Xdt	\0&kTbMP-TN`%^BU\0!\0a<&GH?D%eM9=Le}Q6=֤k@R\ne(AWWu WB]oY']8U@єVԢ-L5yb kHWh\rVO\0Vj?UPOhӫQ	#\rmWcb}\$Le?4jVk!Q`'U%^hREN\0Tn휂u\rT_*\0-\$]76mٻY4TmfU&8;p?5RU\"F*?g-x4X쏅IuSRfi[RSb8	4ٽg56g*Yb͠VUE n6t}O5l#M+\"i5+t#yV ] QԆQMZoFե=Zl魥6'Zi͇YZgQucUQ/5sZ T0>&cU@Q!ZMU\0.\$YP8R?}kiցNMITDK#x'TRH7G卵Tގ-p\niUltU|VV0l\0D[+lݎc[ πcM5|\0l:ҤfG6і\r1=m] \\TmQg1ہX᣺>fuebkam ݣkmQ:\0>##sn}'g\0ñZU\"XukT>2URO %\\b\$\0`%78[:mm7mH\\H=vKL\$pKFm\$SHZ=W%c0>cto%X}L\0\"S%Zo7\0#Hw\n{*i	nh?]\rqHT`VmeUꀿKi#v	 \"\0Ű#PM7Ihԝ\n?gT7PEATRPrM5`S\n5x@69hE!6xTZ4\r;Qr(-K;` tUK/VN@S PVm@nvbTt>E5;jC?#rLcT[` yT\0p-W38-IS+T]\"::=N)XOo:9\0q6ݯr@! Waۑ]e#@/?2tT]wUv%mܒQ'o\\շ֑H<4\\YxSaYU\$0XqHŔSb W)! >Yyb-\0>UYKG\0kwדSEy-nck-	؟P@\0WY`\rgtUD1=M޳!u<ĦCר\$t`d9́\0z}cJD@b;\$.{iTP#\\ɑȍxTk|&e<<D,B'|8WBzk-^p!Pf%:\r\r.\\_1z\r\$=0G|BŢ{z|Շ#='ڭ*Rź}._nF7C}kP10ZJ/_eJ 7 <n?-!X],\n`+UQy]6Tr8UfӏNMDRO0&ӑm=5i6׍];@=KTj]5YY]\rwhԑRP0]u2Ӏ#_iG*?	\n_Qn̔}40m 0\0t*: ,7.; UX*\00049e. J	%\nMX>;!Bz@MtHa>1[?\0N\\<,+ЖAv8D	Dv\r(ujƔ2(܃nIjH\$/^!s@a\nv&d/A{lNƠ`'Tn,!<k:݄S@]c`،hTT`^ T?;{p5x4Dx=XkA\nA M\$S Nìo& ȕ:kN[	nҙB߮/Hz:,t0+2;a)vPLz)	{#ڂ63b/};) *Qb,pb&5pPΕY1\rX\r!%a<O\$h\0006/oi{)[*'4Gpa!Vh@-bH? JxJc->*fb&A_\"%-=W{JYb~%;%X/ \$QbG8f,\rxc(\ra:v1`>c&aa%b@qLHkWt\n	7ɤ+V|?NcQ` cgh 6F086xߝA]9\088JՃcη1@ 0ab7x\$?82NS\$J'D\\5A%1v3O3!7Nrh#;7{&%Aw\$:;pK8c5ܘLn,ȔȀ#	\0@:RNEB3˯.hS=.3\"ELscRv)ǭ\$iOFImљn!Jb\rTd|`On;(h5wd;kNʪ73T-78\nUY7Ds7@\n5.	Tsf~kn)	mA7BNdͦ>@E&P@ ツbҝ:ҜAE\0<\"Qk7X:\0atl;\rq\0)|\\S;(Ys_^c&(|Yj^~ZDƸK+\0܄;=ї +A(6\\iBz2mXB_}6߉.}_ӛe [B2e|(fzZcf}ن\0P@2AdbyfbYNmA2×d93f\rvde9dYfnace/fٓf9fe~4?_{f-l~7ں}bYvMLLveш\n9EuUY\\	#\$ngB< ~w\ruCW-d|ǬyTz	1,k9QVpRO,hCB~nY˸QpjY#NXWumZ(g3VL^oygq!gz!]p.:q)	gtJa|u܃a6	/燃4d\$6\n2#1.gsž\\&u+,gwyYK1 09:מۭf6˞xY9Qb\$~tX'6z.m`19s@4̓hDy2☾vqζVD.\06<\"\0綊k>P91vzϏ\rN՟FYV}\$:6`::';OOd\$yF~8\"턚.5y6O,Q!=t%e\0\0yf6}R\nA`Pr,C\0k@SzBQCX!I\0.vN\$@TcFHiZ2֑K\n)]i>77߀MbŸ?ŽC;CޓcI4#0hTMD=zMXCYi@`,yCݑic;zV%,M%~:ENY.NYN/N7h<A j\\\naW-x`ډdi~KP0M*i\$Fz|QAVI=j!,:tB0-zNV?@KAzxDbVK\08KD^;GgjeÝF|oC9un(\0*4A1j\nBf=nQzxb܂D47i,!vJP!XΎxP{ZvUӀjB^!dj\rK:4z4bplCCܢyAo\$)6zQ?A\r`\\zEיִ\r݃s:Ehe>Ќnfnڥ;B管jn~wThoM[(KKɮt!ˤTx4oyƝEKR6:KG#.\$t&7c-@]QQ:ʊ߾Ҩi-,lQnéqO+GH:f:ꓯID_BoMAj9\nW3F~/f9	0>GdD\\A]bK\"\rF~[c\r˸BOs1d!y/Ѕn\r07\r	%h\n2lJבց8\" hBhjJ7-b*K!FCV4SKًF-~2;FKÛ4nZ1vR9\"L:.νdQhkank#9N9ƲdU\0N6OV5+iǢd]{جc	gAM^=U{vl\$P5/(\r):`F_:Ɨ=	!yV9ϟEQ5>:5<cƓz	M1[ndn/F9F#`vX<BFjdN`Q5󞾴K5o	h;#BZ>o@ck*@֓D\\S)pۭsC6pU[G4?.e\na	>W@{.£훭̵\\9ژ>CAץ`0d]fM1I7[\n],qVJۑ?tz]um*p+틽.\0HW;+Bzox;^nEtKhqꟓE!+n=T瓗xkj6{#h#[o}qPDղÝo1xc8D\0񲆜J	v=WFzzmkhOޓ5j\$X}<A>n{~h]\"\rGDxQ)=:5G:PD8p	sH2pzt\\ڀk|)Yt	PE\\D0¾|p1Ɛs=&`hIO\n,M틂>Ae\\}\\>գG7Nl\\L4!5c,T!p}Ĭ<QH艞89!=F1jːA@o6ۏU9Ĺq\nM<_}3q\0\$no>\$z/	+q}1o\0F8?Pr;<NGEc\$*qU}sF8bC6\rkGm 4K<~4H!jm8Nkr	f.Uzh#SrU(	Zsnz!/%\0/&}ں6rxW`5cGObW\$bM]\$?z\rޭ\"qJΘnـA&}#[%ɸ-'gt\$ƕjLwNre\0\$8Z#:;s\0M\\s\nDMeAf4IBԾp`@%Z\00040}O.\"L4]\"'Hfי1nыRetFޮ.MY6ȏlc>h5ӂ}<Ɍ(7FLrm2(%b7C\0[͸Ms#V6Χ5M	&v797@!\0|N6\$ݔvn!TȠ<WD@M؀_(;'hLd+rQˤHiʱ3,)t]+p=<tq1o3	Fe}%\0001R,SO_Iͥҍ)lt8LIt:&\0Ҥ!?_^}0d\0i\r'gA)4?/LtθIE|4W?mi7g	Уu/C1IyI?C{SZMemKP \0~\0A5#.\$sY)|ҊM9yd]ϫA =9	h^rE@SO#>0LHKHE%t.mOfѸR{~F%8sKBYw]/#Qcc)HT_GX\\pr>ՕFlXcVnu@ud85lB -hETV\0h=`-TuvrTg^5Q=b4lZMUYxu'vC^McٓUESU1#d&ven@Rn%?d_vOeŗWiTwf[)?a=_/iVMX]VodeڏfEI'j,mpRcj͍8?^Vg5Zc+}sk\nWueVZ۽vTlU^UU[S=÷kٝ\\ݛ;W7guxҿU86vv(vUOsէ۽ow_U?iY׳\\utyQuVM^]cknW5eYG^%]P_[cWs|Vo=XwuY\$ݕXYq:w]fd=CUd=v=Va]H`\n]w?wiQlOjzguI{Yx4ViHFVl+{FÕ>\\sErVrܟwY}\\uuŮyd<cptq]9]!j=Uc;ybGSREהT?s'ׇQ̅TwF}=Umw-6SC.ag&x{-;߁i^1|\0u	Z^(I7c;VU%h͜Yg\rt\0Qhv9cPHy?8axDg-!3Yg\$Yݯj7P>eeXbshaYD/fnn=	^μﳞ:V[LNax+w9/x>+a\$L;(SFto;lyxs\"	Eߍ-@׿5>~=!\01BUSb\0O8L}ѫ4q8L:.63.YroɀYz[_+Qp?62/xb2ځ~-0+r~mCX!b\0A89&Rh	H?ɖ^WdE梾bϟz?\\<j. Jc;\$);N[yj	_HI:B*ļ3:S.lfPQöhF[6Ý@p\r{ӝe;|VsFNP+kog̝6[>֘{l+7{+f\ncl=ypy;B\nìmǒy%h@L4``{cnF{kz^[OU|\0.dwy(gnJdϼAOQF_:bPPha,	1:']Pg}66XЗŘ/P/-I>Mx1b޷ U#`d3zŔ?6Ctxǻ:L׻#,?0|SmwTi68/˰%*hwç,@`2M}E %oa)_QNM׿\"Yά)PwRMƇ?ա.B\r5TbX\$X/t!)	)I7Ľ[1}n`o`~AΪbtoʒwڟhn/{Iԟ}<v b(>8	\r3\"(\rp\r7ޟ{l:o^.}~ݯ/.m7\0s?T~?><|oMN:ƠyJq\0o\r,<}2	PJL~?;W-i_ݼ\\}:\"PA;5\r @+8~fDߤr\rٟ,t_\"ƿY?'ߣ}cٯ4\"l]efȐy[ILNa2!fPS#	4_J?߽Ġ[~EN箒4*ÂU\0%8ʇQ`SH??h\\@P2 J[xLG?\0ȁ>ü/R\"3HB{<.~܄l}}<|_^w/_J:ަ&whklN[T@(z~M0#h+ܓ6GEThckѝ tS2(q[ŠZ_>Y\nTTE\r\";(Xs-@D kSJ{(p a^\0bZf{#diDL<2lĈ_vP擯	\0%S0*D!ֽgЅ;v4dP'1qZXb.Yfմ[<cS['+Ђ|^p Vbn1(p\n\02*ge G} -/;1^\ntqzP[ 	p\"%Z\0d\"9+.FOL1o}jOPhCDE\\d_j9Lc&9xV75|te16P5B\0}*2Jn=fBQ'rR	}RɎB8>KưMC>Qɪ`P3inկwPa	#c3YHEh1_k0\npeGǟ1eh=\n29t*\0h(!sQV\0{j&+@D[ַ0ula#M;\rtXǁjhQε4CM3SM_w6;A0n{l֠Xxz	zfHBrl	K!dO# n~ps].1jh0!!r0ppd9iD%rf\0P4	3g7>J\rLM2k+8*ZhFߌґ1ZhdFٌ.Aй. mNY\0փKXAx6Q|h8fc/%}帠qcnWA``PBL惁ɂj`+\\f;gݘ,<C;>gS:8\n,۳XA	c}H?òS=*8@7R(č^ˁ7gj߀W8z8Y|CܰAFD}#PxE\n#8P5nMFX 6rݟOzB_`LԐbENMZȁ\nP>Am7PGGx91\09B^kt97P<7VqJN)_u-daG`<oĳ\$'JMM	yp܍B4i(@8Uhb~<(\"Yw4X7fzPA \"āAbTTmT!9.PBLh.UM_ĕ#VpB([e^	zG- 9gtEd?C 2VɈSO'<Zu(ҍ{e=C\0vpO&Ki Cಷ4n|,/'MPU~lxv(֛(NQP۰d\\TsΑڨȢˀ@\0HN\$xNo_)wYxq<8\\9sN͖'HC\"b !RIN \"KG8	\$sKDF!&i @b7;hC{HQ(=5q0TOK4+{pO%\n	m>JWlCRr\$5)VLp JE\rؐԤB8i\\6nb&\r2<8mۇ%\$ࣧ_f!_7\r+63pǴ:V#d'dMt9jJ#CYr䔾L:u~=:t!)A]if%Up)V.J9nyGnn{ȇW\nU;w^G*\n\$ޣLrgixdte:bݎ>\0Ku%S*xݫ7^ ^%)V\\LbrT6T\$M\nD<,cS죉LA?KaDT2 @!.U\$}#ۮUT.6vj巎Cvⵍp֕WK[	\\'p.ߖ;ZbiRKV-_inQ#}nU|ZfrG]v˶ՀU[Yoj8V*w\"y*E+YHZ9Re p#aZ8}Ek+xhMx1L'P	:v_eAփu=Qx@h+ܝ\\I\"\$nC&\0t4@b p[\"KDVMMKY^A?d)X!lIDk~?Kg7\nF (,,l9'Q8DoX j`մhryMn\0<ǵsF6;Bugs׶\0yl|2\r]sj2B+у=p DO~2++!^H{_li\\ˆ`\nK&/j 9ݢcdD'o@cD/?P\n.Y\r%\0(LEDGәҹ|xkA!Ic4Aeoq '9XXxCsWґ\"{Ӏ\rY!u)\"5fFNEPHHl	&Ӭ\"mQtZʑW+Ų\$ .Ǌ-`a	F8oX#ឺ&R>> }\\X9v~.o/#xS,4c>pC4hg\rE1@O|4(e\\6*	d!ҋxMp`\0007D4)cdPZV\nɸ)@\0001\0na\04\0ga\05P@\rF\0l\0XƱ#wxƥ,\0dƱ@FH\01dd(8Zx@F.:1Xhш6\0a2a@\rӂ`\0g2\\ac(F7wepc53LbQ7\0sV2\\b`1cF8\0d\02<eF\0aB4\$b`эM [\0l\03f8Z:hXȱOF4ɑF\0ir5eQ@\0001\0m0iq`+g@\000520kQPF;\0o4dk \0\rcbFna3|kHQciF0{1e#(Fj|\"qFepdj7dqGF7nhQ9B2\\k1#OFM>3Lj5\05gq=݌T\02g1ǣ(FP!5Hhѯ#^<\01\$p@\r@FbI8ccFHۑCG1HѺ\r\0i.2;QclƂI^9Td \rFFe2\$bq7[f8\\lߑqGe񇣧3,exőGAoX \rcFPaϠ#Ƅ5<q QF6lѡcH<,h`ck2/gadȱc;q3lF8j44{qc8O<c-Ƈ~8sьF1F8lfiǌ92lxqc]\0g8aʀ53lQG\$A?mqLNZz6uc=܍G68sıG@D~0QXfGs=|gq\$G}oz?dCFSF6oc<9*9hhvGG]4e\0001G\0c3YэH.!9qIH=U;hbQˣGWAq(\\ B,s(\$ƁlqҤY]2x/%дpaM&7m1GNBt&֏4<e1#O8QOFCR9{1dF~25c,E=LlQ+E\"2|ȱ#AGIaHČDdXбcƍc=4QcL3= 9Tj#*C\"Ffxѡ#3G#\"?͑VG#28}XcB;fy#1GZe2\$^{9c(GCoHDc&73R=b9ңHy=x#v@O R:|Ѳ#&\$\"3܅L#F#3Lñ,G/3eNc=ȭI v4,q(1%HБ*F<|1cIQ?lQ.I\$3<\ncvGu\"*GY<Ԍ(ױdGJ(YFSA\$1dS5#6ܒH(Ix\"Z8q#\$ǯ; Z6LtģGJ\0e\$34n1I\"GHݑ#^qY3|bY3#nH-<>i1#גFY\0QFFDMdc?HLJBbIT3I@T|(U5\0bLJBs	4>ǌm:b@r HAW1̇pcˑu'BTa.#3GzW4ĲG#>>u4&?\\dFK#cI2KJ}r`Ɉ#=bi?q#5m(^:k#R6dVI'3<yҒ_.G4&:x2G\$G{r:pZHmv?c9Cqc\"H!v3wq\$H(KLY	3#4?1)\$ǣ'7k*d\nHWr2X#Ex23e!k(b988<v44u뒓A*6OI%GH	<GI'RKlhcW)<d	?iRǌ%L1)KqZb?fGtz9RcГF=}RKnII!F?<Gqj~%\"3Č(;\$Jō>09*3I؍e\"&St(Ų#ܓM!6Bԡ01УYHVAtpZ]ʤw&\"G2jG#5kNҥdƹ X	,`RdGC3\";zO2#b\r'>mkI_'1<91xc\\t\"%jV,ΣbC@')\ngV݇\$ڻQJ͉hk\rU*`M-<EdBcMUU-<BiY(wؚ娋GeoJŕ^BQKZ\"[b^>(Y`LM?%?% -fTZ<[p Ľ]v-Jmrѫv-an` ,pqs:%PאWb\0hGc%˷%|z0Gސya)4p#\nTO0}2/p?e;W&0ĶE^nT3zc[v%<]Q4A}ԁVT}R<.\$4쿷Fܗ#0NY\ri\0kGZIk\$kNms\n5!KB%K``\0'\n}Df\0֢<,-@ǍiK_,fe/Zu`S0jX5@WDQgp\nubZx=-\"a:\0J\$x1m` \\@!-ZHJ)Ց	4M\neke5zb|@P09ZFf\0\n/=˞dRCK-atlJ-iT\0GDUƬ\n]Gjŕ\n;fGKW!2eX}j%L_2\$+c&U+Xd\nƕ\n_\$N]\$0%z-^2s\0VIKY\$D?Iv?Lt,εRUmJf\\(P#֖L\$cwjg<~bPi>Գ\$s <<fg%~pZf@kKʁ,%Q0d,MT\0(^jvhϐ*ȘVJWY\"hB&k)v.]YC-gU\\C\$4]dYu%W+w&>[M7v-sR)K\$04Zɇ˴\"S8!P\n@!\0tDWe#)Kve[E<C1j\n5MWO.k9#)YR.fk4+Df/3Fl+*lR6%ZE23	i lЇrf͙%-ayZMqQj^seՍΚ-Zekx	5s{c温v`1^ԹJWLx2^%A̳RZ]_UĪ^VMY_kY+UUMjm7)ZBuZDm6:jxf`7d`\nM,HY9J[ȯfmܥrM}XF{W	L&	f;Ηﰍq1L8q!TU&O2Zod \\5qb9'efJVN'wa)UgVM^r3٭fy.?tMsJkk&-5\$\0\nf8m,ɱ&;~wl9Q'3͞%6mOE:	Xz'3A]:![I3\$XֲՆnWͻT:A`aMM^V,s<܉ԫCf<K2]t)Ө&ꉌQedwa3UN:o	 ҪRo4s'.;^s:fӴfm:Rvtsc\0Y.s:8{PN8.vY'V0u&˯g<2xqz;Yh6iNfNMy1wºb3\\4RQ8r4ߪ*KG<5Sc;Y5br\\˖g(OU)9NxÀ*윳;-ewjS0NI4:Sg9<	TIK>O)SBlyѝNxnt3\09\nO<~v{6y2՝M=UTi<'Y|Va<YI=Xb'Ϊ7-eS\0N\0=uuTW!QtiveR=q,sg+\"<o<YygNʚ9ntsNϖ&ty%Cʈ)=MWd+;[igy;&pM,\nCGDӬU%?(:ũ(\0_VH?x	3'GќS<I}*GKT³6Y	gKFJ:zCʤ+O~O9r\0&&y\rZ/*fK1<0+W,˖`H- Yj_gH,*dr-B[өM_#p<Eɓԥ\nT@%g*@)·.]jhP\$\$S%͟Y8h i,ʂz%'I\0(rgFW]aYiE\0)q֣QwDD|3I)[,ftPS(7;/HuYݢ9l:3ԯT*P_Ab:!O֡BQjZgNc#BlZSVО>Gʦ'gPIBqtCJSW)ZҐq!Tղ8Yg5o^#uA*eNkUn-,ЬC.E04(R=y q4LO\rm(W?YRB}8\"kC*`hnP]C*lb9kR*'Cb?Q\0Xgt%vLXTDf,Hȵr*?h_!1Dvl9Ћ(D)Czr)tIX>'.SJ6a&k29uدS5b&,#YPa*i4RrPYE5eKJV<-QTEMHZh)|`\$!kH}J*d(0;X,,EQ}A>奡ԃLCS5?:/.h,^TniZ/y,,1Ewa!Q\0Ef9I41]˪SћDq碼:,\$Vmd&6pjf[Q@iKZeͼ^BB\n ֒wG߼@Tf<`-E*\\X*\0\$Gv* t]Hpz0h?{Vvuq-fHN]rȴL*#\\BJU&4	O]@J0\rTu=bʣu*N<\"EFV\\ϛ\n@E/WR\rhI\" qb?T(YZBՋ2ΩNB;{kLWJeJFJԾ)HJҺGhQr%ZS/+1bʛ\n64whݢ\n_%=''vI~rSi/.ĩabE@ -Y2?Q螰RZUJR^:3`KUѐTHjQ?f\0RXYjl'Y~,Y}Z\n(R8Y)Td\0Qs@H\n\"-DTJJJU4|?O\\]IySUƢe;ɩ\nh-[ʖ(!&/'6JVjVk4gخHvQ#I(Ι:}%u1Dy	nԙ~Ҝ7Jf*1>G\\\r!tRKQe/4YXRo\0Pp(*)\"#\$Si)ra\\/(O\$jF3f挀(t\0`dU	>hecH\rp`gPc[=Lf\0002\0/\05\0b!`&\0]*px)gCZud-<\$k%AzdҾY\0֛5k\0006Қc@@\rx7Zn4@zM5\noiSTtF5\"U8@Ɣd]M]5pg)bMڜ\\r`n/M7Js)SyGN*7t\$ρ\$6ʜjuiӍsN&dZvt#PFvҝ;jqG}N<jxT)SƦNޞ%<\$\r)߀_ME;\nxS=otS!OU>jxiGO2tzyt)ӒMf:==J~#اNR:==xtSPP@juF~eP0@~tiFfOZtSϨM?*S?NB@*~	)Sը-O=:jӔoN\nz}*Gq]N̕Jj!*yMf0Az*\$Q&B-wPRډ\$QMImB*uiT[Q5%j1jQBEZ}*#PE5*!TtMQJkQA0\0CCJT8QKG(˵\$=Sސ#RJE*ITl \"5I0j+ޑQnD`b#Gƒ0j4T[PBF\rJU(8ԸR>kڔ+\$-%'~5Gژ/*\"TS:J*.[F&~L:r`%TRMʕu6ӖSr=ꛕ-iܩ\03Am<c3KQRuOJ5=*4TSҥOJITSƣPz)UT\"uPDő{%[TV-HJ5BS§MuEH#RN5Q8F*UATRHj!;T0\r1cCF9S2ZQcƿWS5RrujsU4\rܭJ\0}USUZ3}UE*X?S<\rUh5X	`S:UV*5E[bT2MV*=?UVeUګ=Qhĵ]	Uګ}Q8]UZ:X=OՈ]S1XuaKoV\"-PXU6UTZ2Yʱ=k՜'VjTug*UZ0[\nAcհGTZ1%[\nkQeV­mTUUEīgTN4=\\JAcīwW\nUHq*UL	%Etr*TR	%\\Œ*ϫ֮St@I*ꁻC\rR:R_0vWE]TͪW֦}_UFU9WlbUj%WE`JU'Wb6maՅD1X&N_}daX^5YXUbXk\n)X֚]ՎUXcjõ\\kGOUֱsJ}GXmbڼ_\$l\0F|EuvB2k\n˕/%cu*8Ye^걵(VrWZ4]55VxAVnY5cV)ZZ5cVWZqmkGۭ'Yޯtcuj8Zz%4kQ֘Z2i4*ɟ	&~2c93CQFۭ[2]3@ɟWP.kڡ5Z[Wj*dVYKk*kV̬W1eھkLYv˵#.ΌgZ3]nׁ֖T b<jKl>+a+<]7\0><s+=LR5S+]\rH2Ȅ[:%cs*OviL<5V@בwC25S'v|i\0^n{jfVJHduBs;W8Yt'y6xBDʤ'WN|ً.P-q@	fsr͟8*í`1C=o5Y%\r5idE&ѻ8B\$5m:k+iƋI&W\r,Jڸq%<k\"!qUf ^\nrYUV^#6Uz9S+)W7*eD)f2v\\f:)On3 \nk\$;piՔˮ8+*\nث}9QSzh\"UاBo;ripPw]vjUkLҥߧ;;eLpzU&]ed5W0=UF@}Wә\$;^uZ:tj݇&(\\?{\rkNН_pSUX͝_>='ikPw;Ey:ja񬮉Y0AE\n浾rh53hWw\ri:i+R@FVx|W1^Njx\\IfGpa,TN|zcs0ELxm5*5ά@Dg(Q\0\"HX:Ɍ4\"1u(.`Ӂ屑y,0R`5A-	~v	+XqMs;[0Bf((&hq_Fڃ8~6Ob8'	Xdfu`42\nؿ|.KuPH3:^/G|<Y(<\nb>	Z;'zc\r3b2\rNL2xU:\r6X-b\0tT%PXSX!kćQua?vg.SS:ldtH\0=/`_3mF%lbуB0 ڦk5ň(PO??Ί<\nЋS=5j\n{*\03b!eTF3<bʃ*	5Fc	N	H=ga6e\r 6;\0&ĚaQe4ЂhYadL	\nդl*G_ׅ	yH1e.XjtY2Mw46J]MȐϽș\n,jxFG@*g\0_ XY	f\rm9yà߇>o(jG;8\"yA3׃f9	LmgQ[{ds(Y~~@@:	Y6Fa\$l)Ob=<VxYuvxč5YYjuh\r/c^x \rA,m*yw\0٫hu7U̫HA{#S{>Lh]Ђ&~fÞѸxm].B&emelH+6ZĿ(\0ǅٝ,:YPZakQ.~	[-a_:ɜbPcA/\rheh'uiӬ\0=m\0i\0JPh-6`rfi=mCR\"'^õTqlSUݐ^Q3T.A=&gvlM3@-T+P ƏQA.!\0jD[\"W,Z'QRݫU&vYX[i0\"՗{Y l{\"{P\"aWZd\0BPV.mm=0kv\r55Zൾh24lOZܵOɖ.,:FZ('`-NBڅխ6,§aal<6ܽ\0000@lM4ZcRՕaloڝ|&GIb3\n\r0(5[/fH\rŮZ`L^d\$LΐU(5-[;(8*v̓~|a64dl\n/Ly*>2?d!|'O(kP6!itx\"I\0A ,7bzJ2EC\nB5@!Fh+-:\0NMCsHہ=nA;so*:qB\0ۨNnnV܄4}k6Zʗ_tv3>w9\nL(Yy-B{G\$6ye̋td]2");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$r=get_temp_dir()."/adminer.version";@unlink($r);$t=file_open_lock($r);if($t)file_write_unlock($t,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$h,$n,$bc,$o,$ba,$ca,$re,$jg,$Ad,$yi,$Di,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Uc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",15);$re=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($x,$nf=null){if(is_string($x)){$og=array_search($x,get_translations("en"));if($og!==false)$x=$og;}global$ca,$Di;$Ci=($Di[$x]?:$x);if(is_array($Ci)){$og=($nf==1?0:($ca=='cs'||$ca=='sk'?($nf&&$nf<5?1:2):($ca=='fr'?(!$nf?0:1):($ca=='pl'?($nf%10>1&&$nf%10<5&&$nf/10%10!=1?1:2):($ca=='sl'?($nf%100==1?0:($nf%100==2?1:($nf%100==3||$nf%100==4?2:3))):($ca=='lt'?($nf%10==1&&$nf%100!=11?0:($nf%10>1&&$nf/10%10!=1?1:2)):($ca=='lv'?($nf%10==1&&$nf%100!=11?0:($nf?1:2)):(in_array($ca,array('bs','ru','sr','uk'))?($nf%10==1&&$nf%100!=11?0:($nf%10>1&&$nf%10<5&&$nf/10%10!=1?1:2)):1))))))));$Ci=$Ci[$og];}$Ci=str_replace("'",'’',$Ci);$d=func_get_args();array_shift($d);$gd=str_replace("%d","%s",$Ci);if($gd!=$Ci)$d[0]=format_number($nf);return
vsprintf($gd,$d);}function
switch_lang(){global$ca,$re;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$re,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(get_token()),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($re[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($re[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$la=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Ie,PREG_SET_ORDER);foreach($Ie
as$C)$la[$C[1]]=(isset($C[3])?$C[3]:1);arsort($la);foreach($la
as$_=>$Dg){if(isset($re[$_])){$ca=$_;break;}$_=preg_replace('~-.*~','',$_);if(!isset($la[$_])&&isset($re[$_])){$ca=$_;break;}}}$Di=$_SESSION["translations"];if($_SESSION["translations_version"]!=4206916610){$Di=array();$_SESSION["translations_version"]=4206916610;}function
get_translations($qe){switch($qe){case"en":$g="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\rQ<ΰC\\~\n2NC(r40`(:Bag8i:&㙔yFY\r2 8Zӣ<'Ha2܌Ҟ0\nb豌n:ZΰUQŭwDmfpQqacqw7PX3to	ZB9Nzs;̑҄/:|<4j'J:0rH1/+7(jDӊc栢0K(25B87\$B/h8'@,-BƎQEP#O7Ct\r`j[z0c|9h\$>\0\r\n҄=Û\0x\r\nC@:t\"~8_)9xDjΘ2(-xx!H㌣.-D;W+863@Ɍ^F+u\0ᠡ*,1,i8cxؒI¤fۣlZ*/cs.00~0YWB07U\":3xuc@#пC`2'3XIl*83ʮ߷ 553#\r9{5Uwxj0B͡.'(ǧh\$FJŋļC.!n(hڂ߉@N*㢺칈05=RtP5&ĻɓEĄ:ew%8beUz+q3dɓ*\r|7([Ӱzʲcw<]0|]G]MvXl̳?wG핷W:*1ngQW 2<1_OlT@PT%PwQG\"p/'!RD[	9Ufi*<&xޫx{ApEh*P*\rBukI)G2zSj/i\rYuLOjPJF\nzS	m!&hbd]IF\",C3DwIBܜlcgAlW\r!+Oz=G\0\n@QXj\n[16\":9\\5reH_qIy9s	Kn4lL|L@FLQH7J12h匳uDX!0O)8kxDI\rF'F8d&e3[#-k^Y+e܋r	9ɠ*ٷ`+QD4ʾwbKL	L*4\0*Vv10K1?R4s	50G]#4o\$DTHSfDe20fFhH)vbz7F\$p \n@\"@Up\"]J\\0PbJ1H&26J <Q樞LT2ЋSd_Nl/Ś !L2r_j#KB%I((+\"	r*3g6yӐ3:p#sP\\#Oѻ01Ri4\\0[`k4W\$DY2MUq#Keh.ivrꉁX+|<c4bZ5\neh9&k#>/``Z)elL1n,EP]d\$LƦUoң:u_ݟNIlSli8ªAa QB7~,5`N8;9y^.i0ak#AB{V,Zy[̋@Ny/><4BmL5vsRhגGVlјSG_ vu˹0 uԏ%)9%2aݞ,x	G(+PŲ,שFʆYˑ;%+#	f8>YQGگL%1dם0r%,&(F`fZdaAo=vM~mlY4!S⌷[aA8e,Զqa^j[dJ605l^d^,BDKH){6quB(q#GCcpN	md\\JԵ\"Wq~ŸoI7!MzݴFIݒR[}rUߎYWhǓM't7;^-*V4:<ޓ_߹	Ó@Pb&mZhz.FHK&y.o|e~\r\n(\$m6mĢ9?,S߶ENfi'`Ճ?Zz~)`n\0l&`\"`b:| n6:B#Y*<㐂\"'v4./20b60gNB;4#%D~Bwf\00B\"\rrHn_LW0GP޶	(/^\\p/bТ3i,e\0,VUc.fduvF0i|Q9os9;BL]\07\r})1P <F&H|7R%Ц \r)K\n#b>mU\nk2όﱖ\"q|[!-YmO&SM\\I>C@j>\r,ZD:vH\r vAZq`\nprc\\.\r&Dќlߑֶ\" ]fֿi..	:\n6.Q\"&quS͆K\"8Hc\n%=%x\"l`rrn.4r\\2+g#bKLRl&ëQpHI<\0@dH+#-B-&=5Њi7'\"?|	0,B@-ι&\n\"-LBĂ[\0#on/So7 Rx(";break;case"ar":$g="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`ӄ\$F`!2\rl'E<>!!%9J*\rrSUTe#}J*d*V́il(nTIdu'c(oFe3Nbp2NSӳ:LZ&\\b\\uZuJ+ωBHdNl#d2ޯR\n)&<:\\%7%aSpl|0~(7\rm87(9\r@\"7N9 4x6x;#\"~2ѰW,\nNlERv9j\nV:Οh\\pO*Xs')ir*&V3J;l1B+l>j\\z1,t*4܅NA/ډH%-=lLHBPG)\n\$R2Et,]4R25 k(3\r1C351A(4.00@9`@Y@2D49Ax^;܁pVT3(ã?x\rKJH\r#x|1mNR*))U8I\"TL\"8I[R3Qӌ>,j\$WB9\r\n0!VPH9CMyRSDBY({*QT:0E\$D)*0)0kZJJI16HRY.\nGKk\$#kch5 05+\$&-k[96]MTlZT=&gNĈX[1r/tّQ!oݏ#ۦRJBǕ{!LP!N}sYth9ki\\C`ā0|f\r!X =h(i_	@4(x7a_0\$x΃RPA:g343`ث)TJm\"ĘE`\n\n/A\0u]\0l\r5H!08&0RaI1cSrHΌ}-CD\rQ%_@pn@H1`4+]l\n\\@`\\jBPp:0`^9aF&#\nHx|2ȋ:S0*U>Hj7qx5Cp\r+]-5#[ˁq.@D]Av.t%\$kj>ΕM!}\rS.ʑFR.d#\r*,p=NrC4C5yD%XPgH s2u	ѩ\nF⼈bDBhOA'`jC@p\0ZI#N A9;5Vra7Ue?a|N&hБٳY\$\r\r1w74Fη˿0Oa@!07\",GE*(qhĭIj %\$ʚ8Rb:F:޼`L6>g,AK-MZ3yI2K(I&}XzAt7k\0fA?͕a`P cHB4:lmhFT\"řj`.\"5>sZA3\"\$({Rd917\\YpD4W. (gn@).uX s2@kV`F\nA39Ƚ7#HqG%VrJXj_yLQpp \n@\"ra&\\ΞKe\$aK6{)¾\\NI\0T̶yjX\$~Ih.T LQ>ԼK[ʹ,#lTDi` r,=ؾzdu-3]O{0lcBցF/+-|c~\0D]Li'g{nD'>v	uomzƥ\n^q,m裊8S\r!SUCHx*if@ԺrkC(we2bifGkf?igL1st(Х\$界A0ABTz7׬B(Icq(КK?˯5;WdŦyNY*hR]l+DIJOǆK6&yI]͗x Q\rûD\"X)H~0Z^),ȇ1ceʻ2~H֜hׯ8j=\$휼./_v1Hֶ̄toC\0RRT(n8OV-,C(-OO#g%IdO\"R0lMV\$\"`0k%dh)AV\"'c\$>wJ&Gt3\"\$!\\xM6DTB6fT!vNSRq``-	!c	p(dO	nm\"]wĕgSĲFb湥48-lKA\n'~\"dOltwzM\r:JE\rdbpMD\0lFFޮ޶0LpHj-pv\rPG!Q.%Bud	o\r`hت\rFDc;1yy1\nq\rG|17Dq*\rk)F1y\reeg\0hHyaQ}ER1<1vH#P~PDՂ/P+/e0p*gMe(I\$d12RbK?H&.l@:I#AL2Pz[\$2o&%Rr\0#\r^rc(Tm쪘b#ѼvpMR\r.!c[Sr	pF\"0R[1Pwr<sKCc,q,`8øcSO3#\rS\r0FZ13_1s+56s0,qb{#%/gc%Ŀ.-8P51@\"h&3c8K\r8;	i;S#9S);-=s\nHhC;2Msw-Ӣm?\"->n4\$ ]cJ&nAf4k4\rB@BAVD`k%`95QSa<E6E):tds2vNpDb14U;bEE_I?PN(BhSfSA&v>b-8mhlC*Oi-	3ϸMEoVg0J&hMΕLOFeon;h\rV@BjYkxȐY@|~KвH&\nZ60=O/\"/]tg!֌Pd; R2&~Ƣv17-SzGr\0E=\"2MZ,mV\r\$\rZ8/5V=\"-,/|n:LJGqP\r00P0IҼ(>SW`hf4CIC\r\\{5u.F)NZm'y9,\$bCGrce҇Hy-M]Ve\nt\rB\$q,1B\$gtI/^_14Q#rtж\$6Hu5cvNJ3*Jn&Dt?f\0	\0t	@\n`";break;case"bg":$g="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9(g+8]*OqJ_\rGiTh~McN\\4P򂞴[1UkINq呺6}rZ״)\"Qr#Y]7O㬸2]f,D5(7'1|F'7QLs*ns0,{ ī(H4ʴ\0\np7\r7I00c(@2\r(D:Q;\">P!\$p9r낏02Pb&٩;BҫC2izꤨRF-\"؅-KAOłJ<\$i؃,ߚJ)(fl ĚhQ̴-r:Hz-;RƵ*4l\nԍK\$6h=?TavW)\n7(OƁ\"OLf\$hii̝;P;l# 4,gw\01qpTgEфd;#7H#\"Ɂ4C(C@:t,6@p_cJ|63ElX4px!\\&Nze7iCT.)>6N8:bztjJh4Sbʰ((B9\rׂ\nO4N%*M)뎕THhpңH1 )<SHd6t,m?\"h&I%.gх\"⊿	qYKo<\"Ups봷4IrA,4K-htz֋ s;j)Ϋ;z%v|kչ(İh925=mdƢZwBgTuZk@T\nsV`Ԅw\$b\n9BA'4T<A;'	<(~ BVP6z!8\n+`6P掘3*a!:Ԉxr!図gC>l3C,mɔ.ʊHsEEPtCŰ!]3*O#\r98RPcy%ɭBޡpaE;;@taHq(sRLD#ihʤSe}1}Ju*p\\U}]ʕ	g-K<TlɘJc{2ynI,J5ʘ'-܉Xr]\"|L h(y\0\"uo\r!q0`@SaA1F,t91BѤё }LYn\$9QXI432>.B)HIIRdZ=>2\"A\\( al5&Xq2E#ntՕ &iQJ>=;'L*=LIU\\TA̰KT8#-]Nw!-DX\"Q@hFKP@`lKChen3Iê]:۠<~_/e  l&fCd 2A'(\$+Vi[)hdJP	B3ХSlzg[\"9: L	#o Qo_#S=d\rTT@\rOYr7_ ?\$\$ɭh\r!4Eí2!0ˉ6)Ti%[WkhEY}T*dMTJ!tQYlHq9;\0j.ohG{8bkhI%cH+eyǥ\r(TL0NuΑJz'J,)S)iPNE9Մ'WFi+崲)CaqB֕-CVKER1t(eFÝ(o^3YW\$M\njڛgVyI)nJi*V\0/3>[h,X q	m2}E;Rno/`QlL ŕ+sk88BP_2.u?ˁ)B!<FO7|G	7t&B[=iAJ:ʩBשFYA#q ﭛŊcZ;JuVfי\r_F>\$Xe6tU]>]?^dĠų	Vb@A~㨿\"\n40&bҍ+`(&3lFnu;'ulG砥Ay3!\ne<Gh'zhו`gt.{ϴׯ\"ݭP/u/-0K L)~(2P(8).Hkd` a\$XFLTx)P<(s-ţ4\"%ngDJuǲ)֣F8<0π挄hWE+\"W\n 	\0@ DFa,BGK]\0\$S\"|kK<<(n^\nÊoFR['\\o2'r}i^oq-R!)\0 \$1%kU6q>HM:>)D.cY'pnQ\"3('QSQ,Б21N@\rQLi^|br;{}G%.Wq։0%ܔT.um+<\"ҾjqG ,x,\$|,/\$~\$0]	Ҋ^-*	lhr4\"\"&Ĩ Jg#6T0\"gƆuO?F\"Jʄ\nۊT+\$R(x(L'j((d+ϲ/m,	\0R\0\$⫒܉.2rc'\0.&kȘ<hM@V(FsBiЈmP2,[`DL\\uIR.(30Ns0cHDs10|>Aq~z)_\"\"7'n\0X%.vSJ	ҊVz\0*:g)>x39^S3N;;p;-3xK<F:RpnU\n2>M=S;)H)X;-f\n4iAC-HXCjBTE2TIIq:rH2N;?#@@GCP:\rBHMԍAAR.NlZT(#DAv<|4KN:Y.(5yBHIMzޑY3fLJѧΛ(PfI/==4),vu49p?nP44O\0J7JR*~jS,Iu^B4/Vs;:B55>7YܰmWDKz;'f41 7uQ\$I\\Kr77>J/^..&4GHE[I2BC`masUrZ`_\nԳ/uvƔ\\&vm?2`C\\tib4	dj?U~cc4o	\"	l<0upQc5|AVvVchW|1:v;=ԽBVv?YbnRh{kki0hXrY6jLm	ӁQutoalY̷UV9[y0@VDMGfa4&PQ@֣`&BFs0rUsDn:-72WJ:`)6\\Pcoqbv-BCIB,Wy\ri+?}wmVRk4L7z~7 ~ Ş>]}WҗYSxRj}2`47Z'w|\\woK\\K.S+TkeIi\ns)1YJNO\nJ)-BqebW.n2,7p'2vr맔'3X,4}	(XA+eET,bK>dl6Dޗd,&MhbN\0@\nZ,uga~\"Yx}DlB: \ry.ҜJ\n\"g؈g]_oVRO'sb6@2`)o	5dY\":=\$<>.E^=\$Rf%d}ŋnxբ,V	/M71.m\r2qRzs+h>99ɚuix6Yőۛ2)ms2Şi3QMEVV6g=1\0e\\=e`SOVTQ)*8P6+4V|C'*QZc6䁠qZoj\rFµ/Jů&rs+4C< 5;ڙC'6J,7mmKn]Xu%`Il;WQl";break;case"bn":$g="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHW΢Jhj_\rmyioCZNr,N%Dn৮еU8O2nŭr`(:NS7]|􆇵82ɼ 4NQ 8'cIg2Oy2#:\rK:#:E3nm ;KB+M	Ь#G.S9h6ԫmTd\nQD\rIlj'@Ep{LDЦ\r#pΝ2*b+\nDNtɨÄ+H*[;\09Cx0o`7/h: AR9C7KOêx߫N%4譖}4k[Ư#mq8	CP{]G:\rQ-R(1T47AMc4	ҚDa*;6Bj(c֍etZ-QElLt}CEX'J]6\nY4]f'1OQa\nB*9z,ilKL6JvP;B6˳AEѯu 9T@0c9ˣ>LRK#4C(C@:t9sAC8^2},9^,A=A\r7^0SeCIxɵ|EY@ BYQM^\$Lp^2be쳕 EcxRCݥm4C.4ˌ'4B9\rJ\nMr>Ǵ-.ϊWk*/zN9]c_u/asIN*k/PDlA: lq/p-S*:r|E\0:*HNL'e喺d؄.\"mUK!C\\@>S2CCB|/&e,FAa\r()QG+Ck6!ABC2eb\\	%;g?]\$XDt.\\Q1\$Y0ˉcʔxPFy*\"A@q'xF'BC<FT.1	iU:5 לa44Ða.9 ɠCq4yf>,.εU	?:U<  `srK-l0rG30f\r2r\"AyoAP7 :V( \r3r!3;^8\r\n\\<+(مF谦3tf\"A,2c8*~8rM!/mN\\t4Ft׏Calm[{q\r97f\\- }^\\R^53Ad̿bf8v\$-[LIQu*Afjᡃrj@Uiִp\r-MֿZ#fm\r6nO๺v?'\0\$}kx|\\O q!©TGUbPYH`M;,prqB'\"Ɖ^` j!*#Y/d0kFi3|RP!\r9A(h<MTU7:.@\$,H<-^%_d=ؖ;VGr'nAۢ|O>0'agD\$zX񃽭 fԳF̩8P)Woet\nEҜ_l{\"Hi)\0C\naH#]IiL\\-H>Fbfp8\\6)˕#BɎPHJ1z\"VZLRZY퀶%Z(ΫHy<~.?M82\rzܳڟC+Q8+3)c:%%JŐ@xS\no~FN8\$qѩ@MV,G5>++řw/.?#smŔ[qiar7FJѫ`\r75-Ѻ\"=j}gAQ%aQ3K>5]yFĬF b*0\\dO#Ɛ4JYtvRg`˃Ruf)<JGq+Gn˾Lea,\r'´=c2yg\$v|q!LIds>°+ȭR\n*{G/4Ӝگ۾s`L黎ظ]bNJ6vÄOM}b[\\Ub\\\"+ZN(*^8\0`Ofc\rɃL !	<̔BLxdHK\n`>̈ɄʤLROܑ;4blO(p\\{#'GXuBZ%6C.|{H2VIwxNT \",L:84OoJ~l` l0\rpT얍ヿD*P<uOŘ~-4p1JP}+iJv>bTfhbPV#/[Ne`	xfj\n 	\0@ܰQ\"@E6'MDx)|B{ ^Ee4{\$5cqCvkNCÚtT\n^)@TŅoXaH(SqWn9_!R,1EvJ!W1\"ŘFʳ!QJ>D<*0\$hFCQ_<Ejo%RJrm'Y')e1c(\$I,Ғbs2n\"䮗f	9Ƿ+,3D#.WcB*J4\"\r]'%Ī2+rt\$(WRW/328h-pYP>/\$,bC.zxDԂ/iE4*0bGPGVp1Bd8Su/)\".9(#.^'TS(}u54#\$X-A3V16x|D_0K^Ӭ皐=0Ea\n\\,r5'P\$exNt\$A\ncUh>>S-GCO#A3A5B\rT\$sHb^'T30Ie;R%	5_\0D56R^V:ԍGQ:4T`0fnӒW:4-A@=J'Bt( ~4E&\"L4<)3N/q(ưHxTPD4Dt%tJ=\"C@5T5Qt;\$v0?RSR5INvRO]Oo(Diis#\"=@rQi6.+:}PRI\"tVSESe#4v\0QK(4@2L)\"\\./Y4<40IէGZϾY/OTc	 TB%\\}Bu7-5O5W^`BbYXR//ţUH~Lz+5	Z!cNNB6F/|N沯c̀\\,u6HDsKLpZ6Ŵd./iVAqIK6Set5`31fr88p֏0B](9XϽ\n!Lu/VkS%nK{YvQ%P_.6b)wV2FuI;V@+(ط-%4vqUarQs8r7Msue7?E2UWc9eueuA<VY\"rhA]k61+w[lX6KZBV\rzsp3|u\rAnS)u|5}wAYWs(dmӦo[m\$qxA`5m8-XhW!wx\\G!/';eB'\rDv\$sp1puQVc'}dYwաu퓆Ulmtda}Vq5UKqtsxP}؛ ؞^Qt(5L73}釕A(Ez}8n/C\0=ϠowF?K퐈lY\ry\r(gL;ԃ;ņO \$aw^{w	YW0?R}UH]\r:|H'~U݀c_ɕ8fUSׂъugv{CYNXۜe9v'Hq\"t|5GU^982{у%\"]qc]R3d6I*yI2ZJ{T]07YU>h.*EDrY:Ew3>Ӳ r@jb\rV ӏjDBjDt\nZ	zK#Ze]º㸕V'pS usږӢ;SD:h(V`E@:2N]yK|MJCg}oF\\s.J@:Wt^!2]Gߴx<Cdpl@[m\$0M<-\\ٰ'\"pE.VtyV84:XE㍮yi@鰶Exˉ8߻QR=D,3עUY{C{8zUpUOT\n?C=y\ngr[	@LTg[4TM|Yg+\rhDI{RJ]OktԏR310Փ{C4SS䜆 \nƈ\r3{HQf;:42+@}\0/Bt&;OORbo19\\ȅ۾r|юG\r@\\x`t\\:6y	\0t	@\n`";break;case"bs":$g="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4* A\"PCIrGn7+,lbdѶ.e)zCy\n,΢AJ -e3Nw|d\r]ŧ3cXݣw1@ay2Go7X搳\$eiMpVtbM Uk{Cn59.jc(4:\nX:4N@;c\"@&H\ro4n\r#8@@H;*\0ߨ\rò腱P.\"k\$b#{:Gshl5ϪҠϠ6J9>0Fî,&%iJ3*5'-I)#U.AЀ1mPS<P(@;C5IB#'\n\0xC@:tt4:p˘x	BJ\0|6hbp3.cj4px!=/;=ʃC ɋ8?C;N2^w|6'2LQ9\nL ,MNC!>ãdvCH4r4# kkҿG(0d c	pP:\rpb^p58ɤ&!\"V:5;#'֜M5T5HChӱfӠJHJnz]_^:=3w\"9|kwjĆF)A1<zsખO*X#\n/<]GkCMg\0@6PWg2WKhm۩93,gEmZqm1%|g#(\rԽ9dfC2fQ\r3BH{SP7լ~J)`K\0o9CM|o(TA@s\$*zI%PfXC:~\rZQDiLo4V\nZ+epW%`%L1>ef貵\$Yu\nj)#	5RQcn.rXdgʩVDbժW*^\0bnX?i\$^InƝGRDA㧕r :!rC,ĝ.4JKEF\rCARql*\0J?\"`̂=*/;4w^K*O	'r*2&`H\nԒPPI0䨦Hn)!3Xh4)jj;\"BLL;05lcS\r\r*UNsue2fldjB/aL)g\0\0;SGC*kf`u\$\r)k9FkRX6f*S% 4r&lޝ48I a؊Tqfՙ MR\r~dz9ͳhMM[2D`TNC\$)'XRvb\$1NS\\\0n{%\n4?0oWiP@ {Ғ'ۂMDث/Cg7)Ph	 =aLbiA	8PT2hQ s\$1B\n@U\"~=Jl\r	z4ҒpvB%)Ҽمv!V!2u%s#]8 GeŎLdmtѹ3.slͼ#υ+;xU4v^ɩ'9\0ql\rW4.{aq/d#j>P`IfP\"~AWD3;\$0P\0RpWL1AB~^eQ\n7xvȿyAwΒF7MлtLiC(wƫɤ'tHn;/:~ˎn\0i_cBo1/k7kLXs\0q6={whpS#'\$pR6m!()2~Wѻj?HLMGy@BHq `Z\r.dI\$(QQAy1@^\0SL`N '1R5 \\05	US̴]N3m\\B<Bhz\$sợnll&u.!WdLs?:upG^uӁe1Dܯ~a{O	U=cjK'EO!\0)\$4Lk|Б́<(3\n/}9Px:N\nٸorQZfqK?'\\ˠ\r:G\$Cæ	H}cͦH=e|Lo^+.\nbTxlX2F0o\r؆#\0@f<\r\r~i|hG&+\0-PD0`.0b!fLC\nPT=mCʣ\n`FdMHPPpNx@uJ`\nD\0ɐp'4tMho\nE\rA`ʶ%n\"ƢY^*.ޜPg,q'\"1B& 颡gY.cC(2mC&%-cΑZP3oB.b:%c>!O6i8BdQ\r'1SJَ:Roq麞l	'\$\"^܍\na`^O؄Mur\r0r\n_qj)m i8!22vur0r\"b@M%RJkE\"XFkrcOE#Q\$dc<h	!.2E)2\$5%E\"*CE+	)U%rm+_2b *-F#p\$sw.C#%.,v2^0&C`Kҡr+d'\0=\$dM3#!Z#Jm3V0>.I3@4<MRfݓ\\-7qq/c/t1Vӌ&9sPx0\$d76-5zK)d;<9\0	/)LTuj=`)`),VĹ iZ'T*@t?l]4&1F7(`@BQ9F¤h`QTJh<U(\ngM\nZ\rȆ0\$ jT@p1Pԣj>x43kPxFxLgsE0&=p>z/c6 dH3j;~\0)`=,N`OeL)ed f\";C(R Lnk7RD?OIS̭TԎ\r>\r>M:: iK]l7@YR'\"pL#DC\r	Jvuhx@\$\0g&\"hRpr(n-z2L|C34\0,̺rU01b]bL.\$\$'9ؠ(rPH\"";break;case"ca":$g="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(TPfS9?Qi3M`(Q4D9pEΦ\r\$0ֳX~`6#+yedya;D*i+p4(8\$\"M<kXXēYNT^y=E\n)joM|*u4r9]֡횠: 9@9Ȓ\nl`6=:*z2\n&4욊9*Zz\rI<H4H*̈;I!/HȈ+2\"*\r#&!<&:Oh\"D׌06r0.Pʯ<\".(r\"\n\$H4bfQM&P2%434C|	7<0c7>44Y8ʌD49Ax^;r%LAr3_!uJ0|6Ȃ3.ɓxBR j:`Nʣ:-̍ǣ5ꓵ7\nLc0]I+\rP @1*x9ڽRĴx/8+\"0З=22ш}\"2+A((3%Ei\$6-cގ\r`ߝ	0ܝ9aV474#KK]Pl,H 0l#*\nbZ%81Oj\"WxWӀзHϲo=+?Y`x2sr06dh!.C7vK7G,J2Q	ʹ߃I\"/<ܷ:Ia7#k+[(ir/|'Q\$LCi\$	qPؕ@Q4`81&Ҹo*\$7*-zdU3+S(h2\n`sIO\"*CPBgx)u;!茫XKc,zY=h^KFwd\$嬅3NTiGetT\n#\0ISOU#+Q *Y]ȲVX%e\"G;P5]*}E`ƃ!o \"ȱ\$Hdq^DT%\$t #P U1hI6cA3HH\\#l\\n8&pʶ_&bC1`х0'JP	A%AF%\roQ2Xpldw	<D[oF]Nӵ Ĺ/3]h)SC	\\rZA*GsA(/\nngkZ`FT@#'FAב4R	IH@_Œ^LS!3f	; <ZƐmfꎙWHUM:ONu(lݭ	L*E}\$AIW@\$ZW^a?^\".UZ\rqE/~5^UH>ٱ%TÌq@RLh#5PԒ4䅢BARd\nXm	8PT\"@-MsµL\\#(9ZeI)PŰîvNriI<&dy/TPR+T1]-bQfSCS5DSHŜPHHE`rW%qآP*QDcHT:riHGކY\"LA2t3F*,Jy]s̐@	C~I1\"a}UAѝ[8LZdI\ng0A5SHriR#mj)RO\n\nHj1PjH<22\r\n!@yOg}I1~i&~dY\0/E<BXw\\]4TZ\"W \\JAnkKMȉY.؋xb9R;%I>-&e9r^I會~s9^RèloUb!ur:q	ƴӈ\"IIuF<|@Klr2갲g%I#\"2Mޑ.ثW~\$JYճ~\\Ju\\+#BIʁ-(:Bcb+hHyE9hq}/f#1!ߊ{.l,>9_9^?%|Vqʶ'~nz/ԋrX|ضKM}@?#(fr@#l(\r\0.\n@@6Z(K)`'C.lEP#фp/j̊vK<#R,nvl`0v0~0onЌ\nƏum%\ngt3nZՐ:&JJДfM΀݂44W	p?a\n7bP06boP̀4ȒRPp,H/p1BJ6h*dN\0N.sE2%\r0Ced1d`^/kҎtF^}Pcb0c*\rQdfqsp䆫l(k20v&\npfiްJީ\rEpe\nmq ލ&\$t00NNF#&Lʕ_1\roЯ\$N8Gs@LTẽ%'-&\"ģeD{\nP-`;a%(`)y)\$R[)r)ҠRX'c)*2}*P<'q^Br&M[.W,.&Xؠ4ℚq@T.s0JS1c	0`#M\02m-	\$?Q+s@.o4-rO5Fd&Rt,侬sKN\05L8\"\$?ɜэ\$\"RNki	C_dj(X04\"/;;?%L!bPT4b\"/;8p<ʾN_<LcpdI\0Jk PETƂ\$`@grzk`\nZUp|SE?QDEyn\$N!BpǅګxB6jP('~=c\r1M)@# °/H(d[V@\"CeV(e%<DjRGnІuHt0 fagN/BINO3ƂOyP1?DD(C53>=Rӕ 1lU\nNF'+ZO\rTJnXnB8npVnCACl -ƈndS:2t,/d9IC\"2\"3 ִ\"lRGoZNOgP껠.Q+HH\$.[h*	\0@	t\n`";break;case"cs":$g="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8d:VH+TتX\nbc7eHa1M̈dNA^/J{HLlPDܮZe2bclu:Do\rbʻP.7Dn[6j1F7761T7r{āE3iǓ^0b穦p@c4{2\"&\0cr!*\r(\$B%k:CP艨z=	1c((R99*^F!Ac~()LH=c(!\r)<iaRB874BB`5k<<񌣒n99ZBDFo\0B4B9*MCI l4HhL\rx[f!\02ÐLb~0z\r8a^\\04Bx9r9\0J8|;%A\"1^00n=EC{P#57CkH77L^w޶l:[\\d+0}P(S0bc*:.o :(\n\0%	F P\"\"L>9Ŋz^d\rzW@:\\HWQCX&#H4!#A*CFMBbNȈ@WZt.z' LB&%̹[@V23:-{4;#Ӝ(^?6<\rЕ/-C;O0@6X<w/wJvbWr=\n8@6WZC x@o\\	9pH:пDBƆпڧ#`6~xvPQĵ '\"1?\"D\"OE=)ZNNh˘ )?(L'~CVRA`Id &SaL+!ja4\"F'́!B 	'.%C\0{цdF)XtM1\"}\"!s(,0ߐ(nZi:\\²V\\+xXabp^yP\0|Hs=6g5%	6LF«%B}!tGd +PmA:4Rz%%UKtY%UH5jʻW_&*\\7Kܴɝ\"+z=!E\0It!E2e-x<Г{&RHvTխbn	]JHv1LX\"XRQ>KqTH{\0\n\04u\raRSH\n\0\0h((3hH5C=UgԨ74\$i/Ci\\ç\r\n1PʃcBA'DCBJNdM(~L5ĿfS\nA0N2~d9=Z&aE!8c8Jz&V:&wmO,?b1Гs\r\"_tF1\0\"%*O%92)aK|4'ͦÇ\0et3xS\n&t_LHH[1C|KMK8^\rz?\0N	<Sl`؊r3Dho #Jo;8n0Y\$a\"a=Vp]TF:W4=CˑkP > :xN˄#m-ĘzufeHa#x0H:ɰT\$Ő|QxUT]=F943Ӫ4L1(n9(/rx_pt\nj/JQiGFFpQo	}1T'u1nJ&=\$Gaa8'DŅ;#Ia1a?S\\=_42\"a\$D5\r+\"_D2/662fl<g:Eቈ-DPC/AnE%xFW(Wq1LKߺt;xl`tӜ8]4\nw\nq16P/O(= @\rfiBSr4t|QHvɒ3hǬC	:ڤk'@_c\01[2r? kd1Þi}9'5YQvZq><<GayXX3xGu\0HW\",c@PSr\"7i,\$Lc9=/}G(>y_?=~_Rm[\$7\"ѡbb`ޯ%\$R\rDB&PL^BP~#u~MfP\$N~\$r%ʣ=]%sJ&},N)R6\$j8j2#,7a#~~lɫ@sc~|c^\"*Abr&yЌ&p&k@haP@%o\\40ètC4f0dĤxg~Dhl Kz(\nEH'*&MdN&hb044e%>B`fq2\rжv@M<\0gPg`PynixDKy1毑u0P,b=\rX+\rQO*|jQ0<	Q\r`2h,f ѿ2Ȍq%R,l#/1!̤4=.H#Qxg,\rc|>Bdl%P|B`g`DKU*ornZdTdǤ% T%bHZjC̮BjG*Sw\$/%A2<0 #*&Jd8j5/GvYR\\\r1\\e\ns0\"\"	1 7Z*#j94y13-ed~d<Ƅ<K\r0s/8r\rΝ91.n i㓮`X#{;&9x:\02z[(eH\rbnC|+Im>fZя5>s?9ЬEDT<YA3CR5?2:e0@> 5U6RӍDNc:RI?NNgtSsFA:N\\&.fJ`Q032LyG/ԅGe)\$tc%FwI<]IxEG.5D2''G	KnK2MIT1PH\r5_ Ӣ^g2'K2=z7- 3AHOb#PGOBD	b Gol@g#O#OhT:o\"@P)Tbr4O_\"2\"5uZv5Q\"]c'Fŉ\n&20'eX^Ҫ{'A\0D)* g6i@ۆ\nZyrTcU Pwےoi]ui]tەs Og\"R! i'&	F\n/FI\"	uKhK&B,9aZ/6!Z㰨dm(PM`b!\$5bq(fo\0W`gf-2\$PpV*xK}vXa̛6h79Qi{k>c'0^hՊjV&\\9##AP#PBwdso.#+d &*'z\r1pPrv`lgCGr\"YlcvVBi-<:\"rW*3rs`A\n1^p ";break;case"da":$g="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9gC9GCyo9Lq\n\$	)36Me#)76遹NXZQ6DL7+dtD 0\\AΗk6G2ٶCy@f0as܁[1Z7bm8rGS8(n5z߯47cNo2-\"p܈ә2#nӸ\0ص%0h&i'#z(!BrFOKB7L2B.C+02b5,h.ۀ:#<0-܃\r5c	2\n	\$\r&6@>O#1)4\\H4\rD0O9`@PBd3t4\"B-8^xDjЅ\$x|(X+(\$V:cd3JH;Vmx<M\n&(J227=uXމ P אL7\0 Q\"1W\"0:uzSWPY#Ml7ځu;-ͦraCcPBbC?^Z64>h\$2c\$b\"k,5ڤ*'v24+V懲@PF&0ʏbk;`+	#k9%Ql>x!E;]I@A4eXp\\#q]#|u03c/6B<*ǨԭW\\ݏ2	PܐVlD8lB,-L760\n|I/!Ns͆9Q_0\n]2R-/ʔ:#bɣbSLxCI'\n0(TtR]L:U\0rTJ5jP>r:r6;L<x.@܁)Kd0đ:Q\\K.Qj5G(q3\\U wBV6%tѤB+#@h9/k!+3'!:uI88[\"1!a͞\nVgɛ4w?DYЃo{*PS\$(9a\r%\"\"JȳBȖ0g\0P	@dJ@('@R3E2-1К	*\$:R	X0_HU\"I\"9>J9\rA(UN@w\r1Z5R):a4A) K!(0OSPD5pDI3ᘙXoI-6fa8A\$荄^)~]	Iqb(\$3rI\0ģ.|sԶ`ɫ8|+Мzj\rk֓/I24X˄l7̛\"DR\\BZBN9J@PD12CIƱf%XT2MO	*\0BEl\"Pn\nP^𠸥3}I<&Wv\$[Ș3Jl[20j&>NՀ4^P):d,5}{5l͠WoN\0]:&e.cNP:u+EBL)1LB438u<YPmDR~a{:3LAB:7VCY\$iHзְ:N}[]co5дV8l,Gk/\"FYMb\"df%lmD3aLh*JQlB:\"p\0R]Ɂ1p_\r4,X+@A K<z^p/C	\0[]LN\0001`VG8G\"-j5wLRj4[|<%cykD9B^֖dmͽHآrnjJQ_mC]AmBX. mpɻ6	 ɚsDuù'|2*Ů6BfUC	=\$բCI6nE%8?JSz>A~ih!ؗj_@+!-q!#aDRpÃ^(o[8K;Z#R~kO/_i{cqdD()bK-\n+{@qqh>`<AϿ5	q̷9KcbumzĿGN39W,]\nG`2{I{n=xv_]gս2ϿiC\n7ŽN\0'PoQ0iޯnT9d/Q&=\0o	lf8͆bli\0d\n ::\n4%QH>FL4Kft`؈0@\r8 7(d>C=(yP\$B#pJfl,-ΐ>VžX.oo[fZEԏNkϣ omKJ\rK\rm1	-E,b0I%:+=aBpq8kcL{c4ìBtT14QbNYF\rd\nwqE(qONYwQ^ϸHOjot#qHBJh=\$.ױ#.naqTנ pЍ8\nY/2#\"CU#dC\"K\$LE\\Ir/դYo%ch\03c\\?F'D-\n1\r.m(d`̐Nd)* )bȦ@2[p\0,q,E``@>h&CNn60bVx\n\n@J%#m)Bp.S12kM\"+堿T킁\\/PB7ΠG5C./B/hCXOD\nlB9&bhK&4D&+,()4FA;3;n.<n4N\$\$@\$3>F2de\"ph	F| #f\\b\\\0>úl-0\0Dp\"ڼL/&DC,0;4 (,l^[=\0ҼtA8\$i`@-jpP!@";break;case"de":$g="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9& >9M(e)V\n%⡄e6[`rbQfa\$Wn9ԇCіIg/* )jFQ`M94x 0·Y]rgxLSڸ@wŎBx(6nBh:KC%-|iz9#A:W7/X7=p@##kx䣩*P@ȳL9Cx䩰Rfʡk1Cˆ:)J\0ߨHЉ\$6(R[74ã!,l	+8CX#x-.+	ƣ3,q=#(,6)p츰th@;Co&\r:PQF;O[ j9.^C-sH-3 cꁴ\$\rBhx0.\0CD8a^H\\SKz	5LcC\$4DGh|\r\":Ct:p:;K`%&K(2*=B?\r̘JC,a: BV`r1Losƃx[p\rn[C\nփG.(H҂lA}H\$kt4ԸΜ:+/n8ⱘ:1&ժK~,>76\n2ف#,/5N/33N-&^Y~ô\"4\\	QSXNϭ}\n\\-*T5-X\$\n߽(D}:- VF#kWvۀݻþu\$h3/(cj;\r#|T~@ק(tQ.pfrIb:=zZNpoUM@l!1R[hr\\A3lAQgNX.dH7	q4y2K4'ZXPl&\0Ot#BayņIQ)CP\r\rqbD!17D-\0dpp)Ի50P1\"OFڽ`5HwYjeMHh/r!%Ag<4p!||6\"@4k\\G`}D ZVBGF1KUU-ᔉ[-`, 2YK2J&*m8ݠp->xkKHԎK_QD#l	SX\$OC#+ɑ:a@\$\0Z3\0rr6%GCøiMQh\$v;` Bf6HjYKe1U2:y\$/*l?\0t,eBe*#S	C(uF:0	@PQI?(-9&`\"\r &2ͻ\r/Š&+e@B`L201~SyY\\ru@q2%	H1dѭUMl}OT-IKAz4bHR*Lwl-IO2-5.ӌÊb!%F\0II+ʨGАcA̳\"Qt.4bKA:-f+ͅѽWńш|!\r t_(\0 -hP@p251=F}i99'dX?t%z^&Pq˄+	kV6/3N\\O.Q2HٗxɃ2#/ef iBD!P\"bhB`E͇ewDƧ[pL<8.V<L'RUa!kf0\"rtpv\r2Qq&Btx/-U]AR|΢(xPV0᤿k .>thC4ըkyD>vܐر_J\r2dPةj[r7fB36zl\rw\r3\n|ulLWSH(ANs>Mܴ-rSq+WfYNtNxZ`M(aGF2^29̉e1RxN Bˏ>&t;a0c\nK^t1pgv))?V6:|'aP 0K-.J>(-UD RBɸ^UYbl4Oq#PMoQH#%	~Mwozύ~<辪C!86#Y+4qN38CP-^ʃKOJOWđ~]cӏ3~s:ꉶVvt3CȉrZQ#9IlrțIS߰좒zDC	@g(lGDD-ZR:o&9H\0'D|/7FMP@s]F0N!Db\r,I}+T\"=\r`xh\$Lg\nLB9IҨVLrv)|gj'}ML-Gm~DR\r=j\rj+.x#D(mZ\nT	,px7dH@c@NBЕ4UgtyC3~\$H\nqSUc\nNGeg*o|A[`\$`λ0>ONW1~϶'ц\\ˢ@jiB[cnS,qaqQ00@a\0>΢\r4\"IJ=CH2E/CZD@G0pr)HW̲ðH\$\r!Q\rD0\rDNd4.^e_2y1n(rDr~Ҝ(*n+)=@DѨ~oNkN0qIq/0'TD/+iMf\n\rhP,J)13:s,e TG\nC\"榤/x#&m{F35BR3a6SY*6W6\$q6;S?Ņ\r0m3a	.x1p汸ċSBsu6hsw~蒠߲N:s=S<f=\$\r2SD1 M3I@5bLAs0\$H	>-`.@J=\0\r\$T^nFC3\rj<\r\nD#E4V/LlBk\n;B'z4Yo@F^`6Đ0S@\\dG}@\np4GDQ%,GY	\0tI. 2A+\$LRk#\r(\0!NdU:H(yJ<\$#dV]=\0ۄ\"KJLb@:NЊu1T!j\rASN!(nF|>!NUV1=jwYMEX`ТSY5J|C=0٦2Sn'\r'mdRJT\r31#ЄvSM1#D*Z%dޣRZVr\"REC,ue^|keW\\ qՐ˿c7?@d\$#!FI,`";break;case"el":$g="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqck[)>Hj!uq*?#BWe<\$]b^2n>z< TM5'Q+^rJU)qs+4,er5-3J7g?g+1]_CFx|-UtLꢻ)9n?O+;)IjtP#0\nQ!s'\n|W+IHsH<?5RP9~%3ٞG(-4COT\np7\r7I00c(@2\r(K:9@;\"P#K[Dr())JNO1~+LR0=8*ªqt.:Mcδizbm\n:ĺQnIr\"MUqљĤ E>FH	>!dhӷkAFv%PQwKjOzިOT:gE[4L]DӃhTAr,֍	z]jh2N)uw.Jb6#t5ͳ|9γ@0c9#>g5̓45H4\r0=ϡ`@i@2D49Ax^;pÓ2]0x7V9xDl5e#46̃H7x6+]|\"ᇬ1A^œEz/{&DTFͼ|/t^'<	C[j3W(1;r|PH+#ݜ(C2>7Mإ\$^d=b\$}Vv5ʍæ)v6ޥ۔F̊\"\$ap\n'|he]y(AM):E\"32vfE'/hL0GM*2.\n78!\\,\\=J\$Ԓu`i[!°1(fP{L(\r~Kd@QuGϠgBȳ	YՕXUGĆIA{RL#af5ZH%҅q(\"FqHr9#~Dx BzQwW9d:4S34Ca.i`Co4yhe>TTCf\rU&MZUPs8ob8lɄsg:&+\\Ϝňsu5:6PL%}*ȕ8c@)qr5*zӜїcI]jOQ1L.Q	r.\" bhڋzȧ\$u}ƞzDE!VRJE-#bY!RJtWSo\"Cɂ&P4rLPriqڀ jMQ5`퉲WKklF>7yYĺ!؄,O)i\"I\0I\"W0zb!Ijq	IiEVZ]k텱׆SlӂqY\$(jQǡ|1Q*=Lv5ET=\n5?fɓ^xν<a65Z2bB4&ie h!6<q\rs՛`C`o50@T`1:a\rg, D	nkQR|*BWsY=e\0\0(,RQM^%P(.-ɴ\r̨1k;{IA;cINh'\0\"YŎ5\$b )H*]zN޺3Éu&6o k0њJzODcc;#)4P̹S<03\nd&,\$\$%km8.@TI	vSp,1-gAp;l(Zr=ԚҬBAp8<kS0\0\\ƥV|))3z*\"GUC*sZ\0¦څJD!me!G3xb|FF).d>!gcVwБ䘨,0RxDG[=?U0&)LI\0F\n#=D'6P:^{ȍcTwߕ{+\0U|črZ9'\nNbF_p\$}Pδ1Lth(}<!\$<o_'rN2cp/|)ʑ^se5-t9}ݛ~Nt+	\$)<~bAXEؑ<>h*ܧ̐ML\$.Wg}qJKE	22B|P85	RˎCp9\"Dn\",\"6OLbx2utϠAzD*zL,q\$W	\r \ri<Gl@\rrve'@ @㒿+hEzHÆ͚r|mEʎ0JrooQ\$P>òZè趌DQAnt`G&\0W]P&\\HuG\$O>pYbD::ªl:` jdMMb8\\iQz5./f8f>,b&YNw\"#gg\ra%9<0@&E,_О\$ \n`\0\r\$ffFbGOǤH-0X47g@Gb)!Xy&u\"%d%,Sé%5-4\nx%.?'%D(lQ%B]'((ۇ?().&0s*.c&̾b+3+2+HT{+&\0_g2,,R*q(3	(0&2)+(쪵\n]E\0H(+0^pb#>|-!krrQF=~*\"d5F\$\$OCb+ԥo@Cy3bY/o\$.X3X:@\\'o+\0\"Q*\"\"B\$Ǩ 2RNZC2ɤK\0i\0B6l*M\"INW,wdӬE2lwACD#WbE©DN~4RHҥeF9#&cn\rI>o#E0%1b1G:8<(F#IeB8S 8DFBe擔jT(rx~t*+-:J0Wo8ʩNT\$1D\"/:J*uQ\0 \n^OPEp9DW-TҾe\"RU/t \\jKEtVUIVIk7u)Wc]0S+T'VEQ\rV!3RD1XqZԸ(>'<(0#()c(g*rܫc\\ȹ]]R2\n5uқ^r^)/XO3`-TBeBwY[68[b1b'X@ՇRԏc-c F6B+ZI1ZeQszuȞ\n>8DH,#[Qc9&(BR>\\\"f=32Wh/,!gd&3eh6/ccFM7e9dA_4JҥUbq,8Qrv\nCH<.U#'ID'Ns4c\\5=vejUssU էK0BLt'Q\r!b#U7*-w4/XWYYxS4W\rWVlqJdwH^]fwa!WF\$\"2L&|}@bhw5^\$tAkrU(UTEwSVux\\xrVJ_uxwBQZXiv\$8sHkd77pl,!	77{MlX(2B2NGjm>q4*BCw5xzlyx8׽X%6RXMRPeUYxvo~sksx=dzj>I-7ueQ\rkMLmdNlQ\$%*M0L`qy(ADȠ2H)eq ]WyDxapGչIz6TYa{fsɃ\r%O1ۑwul1Úfw(8=v3R_]#S[-d׏w˜fͣu .5r8J4\nbqp@Y,*Tx7T.?\nb'*pM`6PS!::5Y4F8@JuN/A%o,u)H5Mv1F,,^:})-ig}ahr:1``\rR~{ds\$y(s:Q!-kKO6`iz\0\np&I*VGtG6tr\$\rF#?.s/0EtJwНo4r^yB89%8MVQ2i\$/\\BBXƼqz˧6,M8<@B-\$Z'n@*]Bb,&Nh3R@ϵjԂiB\rL/R&\rg/I0֡u[ER)6Q[,uYq8\\!{,rKxحHzS)rJՅAb%l\"\\A%BR&OSQ;уU1.6zv1*Gu4(25A^zu\n |]O:Z?^3EToN*85|Sm@ĺyh%qcϨjnzsB<fAAd^%Լ3B@&r";break;case"es":$g="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AL%\0/LS~\n7M:8(r4FdJx#&̆1*rL+Z	oX˕.ifS {4gCcpt:\r'*O{0dd}ɎE!(o7-[NNn2\\AjH}C2f5Hl\\S9㈧+/js1\r3OFF&5~:5L7Z8/Ø3ȷ\0s[ B'@+Z,F'e2P2k4-!)DOP\nL2(9el*\r(jK<9x'D,<QLnDr0  `޹\rΛzH@202\rTx!\\ی#ƅ##DN%\rD R),:5C3:xaM27Gr3_p(I|+SiN6\"Cx!F+F81:L,ڲë^H°Lެ#+J*s(K.\$/PJΌCʘuF,Hx:\\ےMBH14B\\PO\"6ht3 S)\$Γ\r&gF.&{|1ϽGJ`&=;-;Zgi3r >.)\"`ܮB1׵|sW:qW8xr|r*SB\$C΂JӬRz\n\$<uG.2;\"\$:\0絥60o<\nGa¬lgE]]#^#>\nPCʅ\nIC1_.y<l>Fkв	#hIܔhM^I.XU\nA`BKXć0ڑzL&\"&( @YaGuujq V\\z\nL)䲈\rwU9E@ȢI^I\$0ʆ	!LЫ\"3d\"&ز\0T!tXKcD蠳s2H)WeׄB\nN!*x%<od۔ӶB)(2PZ~%RPԐdP80TD᱌>'7GBQ+!<xHԔXgxi.\$q\$*dFD藄,(Aao\$x\ne`0s0%\0Q1ip0Sj! uɦrdm'4@y 1HQ-G\$NHCD\$4x07vTECg0o\rr!0nļH CcꡆHP\$#p9<4J\\	\$\njގQ3̘\nE]mU.q#B,l>\0T@@rqJAmD1CC+Eg7jeG\n<)D|ݜGDMAp J!:*9)%d!CPϑ.!{yآ&aTZڴ0o2`=yAʞ{Fw-\n\$D%BT\n\$MA<)+]hb12AN@@v.Mߑ1f4Gmh8܆t)DF!\$ia5N)X/&r5t#lnwVe\rݎrQ<kSS8O(''dKX~IfaAɼEcn|EHvÇ&kbCόsUFZW\"E0hS2/(a֟\n`,8֋|%,.CJđXtxhu)c7FM,D϶5hS̕jp[Kot*9)\"V%vtNBQ\rP*_bTȄX\"71D#1^S˽24hgc9ou<lj\\p	i܈M>*,ܭ^Ѽ6G%<ZDkO%1=҂؅p='̬s1c=<uz7㾲I:QjePFI}(dx^De8\$l9[Kyh'oqeOwuS|_tX'bn%h^rM{{	m9\n}:`\0q	\"߰v!QyQa}xZ[fdFG*13MzcDZ\"PK?fČHuJ?l\rխl!g\\fZKh\"mj0eFIPm8IDqB0q~5C(\"P>\"1̡OPLs6ldsZ0lPqDRvCHP@@.\\cPrF2}\n:HLC\$p5=vTʎ@	BD\n-r/C>^/CP6S &c@!:&^2|\ng\$LLLq8	Vx&PFx8rR\r\rdONCl׭ck8?-PPrP<.k֨0W_bN\$ei-щ񦤐V'\"`A\r3eOGH1\"6	2J2oGS1֭-֭qC	Qƌ1_#Hݒ;vb3\"V248+ RmG}\0G@ʱ(>Mp:Z`;]&\nj\"b2(2rb̀҂B\$aR0`0(qO`-*+V2ِ+\"P2#ҶJC\0IC .M,o{'É.2.qv\0A/ͨۄsID)01[){2*b`b.m\r13\$*RP3HAi4̑4C:[gd#G=0DteU73\0JjJ0:}RPڃ6b9CD:C@\0\np\$p*T.a8D{5'K(!\"jH@vr̂O.3#+<@ݮ5iHs,uC\rl\$2I(l^-XFx&D!N(fp/|b	Ϧ4x	0)?(tDG-T[Jة^9E2+IdL8Ѡb CoHf`mp40)LA\"(\nk1G`@àJPZ,\$EBJ-1`VSi~OCO1\0a.\r\$Li 2MNg8J	\0@	t\n`";break;case"et":$g="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(aLA0d2ࣤ4iF<b&l&+\r\nBQ(ԉDa'89\rfupNI9du'hѸ&S<@@tϝNhgP9NI9;|)@jjC,@m\"ٳq|F=ZqF̶`*y㹸@e9Rr!eX\rl#8+/H:Zh,\$4k§C|7[־Hēè1-i5N;:*-\"#HKp9BB9\ra\0P<B87走\n0)xQ >\"xHH.1>H2:\n&\rjP¹*+2;@?[8@/1hX\rX\04p|4C(C@:t㽄\"-C8_\n#Wv\rR4P\r#x|țR'8j+|ܦZ-j2h\"죷͒䚭`P5P!΂>8A@ˊ\n*41\rhB\"V뜣^*%L\0^IdՌzHBxL}jDk#,r\nH90ycH5J;nX64<9lc(h@Pvf-h(7-b\r3z\$^xm\08Zm=<5chabq#lB*Wݭ8@+\"LGH&'n;X6jOsP#p\\I=eivV\0}2b\r5O3}2\rhӟ'aeC#A3bF`!dRÀ\\SQ1fhe	?`a >Dv8eC\$R\$0Z2nI'\nN *@`,,jʻW`5V:Ya2VљnmT[9΃\n:@BBi^u0!BRNJMʒYY[UZ+epX;HFc	֌k-X\0V=G\rpA`P[delGIXt(	rolCU+3بM!M6BUL\r<riT5jXi\$iޔ2^BމI#DPQ\\\n (O(IID,ω28FiL{`'&BxwNԭZi[sD3@u^q@jFrA-jN4]\rm`@R8L4j@9Jb%j\nC\r!4s;V6?9Hy2MRU,al養8*\$mR}IS)TpTXS#\nMWjG[k`H<uL\"Vj,7Ʉ3\0	#`CWCwM\\\"A'H#jr(3Rem\0\0U\n @oD0\"\"!^\nNɺUIJ;bx!@5;{8ʶa.(1HLfLXVQ\$?TPI]O:Lnqh>M^8[[<#̊3')-tUNsի,g'fBQ\rPUU_:]r	*]1>g\rSd7a\rg֬4h(wHbLj<LNlx{nEc:+\\NNRBh[d+SSPkmWF9%oY%@B8GI(8qxK ~HT5cB6RMf~/LCS++PPsk&pWO1*DXft+p␵D\"nc-@\nk\\CF\"\0sVZBA2ȾLGCĝnIrhv*2	quWz[Eȉ\"S5\\8q6:^ÑrN!!삐4g,LD/ka?iMS9zb'?VLӕ.s\"wO߲%أ=y>Ǣ}=d3Yq%>:(MS:JVJǹ6j䝉eW0|,iᒵyNj@B\0l\"\rM`,D5φ&rpCNeaxe nf	l+.0,?Ee\$/\\0`\$\$o\$tEt\nox#jygKo+f	ξ/\nm\nƈBnLߨNnTnzbGΆ'BHj!o	mjMkn-pKb5ZFXWC8>I.D\$J[djfDc|eV.2:϶o.iF؟\rl2TDG΁82q<%@-eW@ZV0\r#P;_D_\0101_\nMWqȂ.n#Q`# \0Qp.cX1+0+-h \0vLG\"brH@\$)7@f\$9o8C]4 m\n	lrjl^'&~r#\"`iis;'x,D=R[*(HV1S\"})1`--9)2r\"˱2eD\n/\0\n<2!\"2ʒ1-\$)B&	/#32L-3!3k.[rRJ1ͦmd-S'/3g5)r\"ͫ5j]2-*y5\r\r݄GR!cKc/X\$QO6/҈\$Nb	\r,\0+,Og2`r11pns1S?\0	p\r]N#sP?\$b|m5\"9O2J`\$F'˥ #.z Z*;ND(dNd/f!Hv\"P`߀nHD',Q#9m\r(\"V'Bl\"	kn!ûvbNhl_q\rP:bl	Tu\"\rD!URS'ooL3C92#RJ\"LU9:4*s㘕IXB\0gXBdEW*d>\"j`MVujTP-\0[Į#ObIưOmPd4 G<ǬAR]R\r5/04\r:8yȟ辇`.\0	\0t	@\n`";break;case"fa":$g="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6Ѷmkvᶹ![vM@2ka>\nl+2H#0\n]SPU!uxd)cZ\"%zB1C2o\r*u\\o1g{-PsW㤵>--#JK<֋TsFT/\nS0&>l`Q\r{US!\\8(7\rcp;\09Cx䗈0C2 2a: 8AP	c2)d\"rԢŒ>_%,r6N\"|%mT\$͊S%楨J>BM[&%ES<HPW;'ﲲZ%nS,+>'.r%!R@ȩbҥҡ',2Ϣ8N\$#F0ҒЪ@XO,P2\r\\\n7@0c09c=o\nЄ%\nH4\r80`@Y@2D49Ax^;܁pVU\\3(ր2d\rT(P\r#x})ǒCHIAhHS,sH3\$̻8~Ƒ	#\0Q%<^\n7W(J2<nTSB?9+2KʨLZ)3TD%D2嶘HQ,O/,kJ,/EM\r/,.j\n+bMyjV.2E˭<8ڟy2oA*(p(*Ll3#u-'NXdK--'⭦0Н߇S1sa%3wY̐P!x7ǸZ &A\0:p{.dy`p3\0F# ЀlB ``2軕H\$B@PrDC \$4T`0q&4WQ&8@r(J5&yHEel&TTB{cɵ:g5* 2X yjDl8AVhW{ab1׺4;)!ѐc(\n\n02C ~*Z:p4E^[in- w\\ˢP.p/B|:0`37Ib~KeУ%QQ&^2\"!3Vp|Z!IDHTXGRU-V\\ksZ]S/׻Y%5#;{LbtVB0x%HOaFELVόQdK	.A\n+z\r\$(<\r	s]`O`oQbp@Ф`1yLa\r'fdcjG\"*N+tQ\n (L>J@Fd\nd9QIYX S/!P9z{*oY44\"D(f޲MJ6଍eDK_hef4F8,2!40bܧR0-\naH#YֻQ<.βW;Y%!PPR\"u(IEԲ]F)&6828U5\r3!I adYKi\rcUCC;-}X@:s#\$6\rb=G%0ldR`=wfnE:t.Ck_ɢFhr\"M&HуA>)\$JfB\$li|NRަCKwѥBO^hE6!)[*I,qQ\0PO	*\0BE:L\"Ptֆ|Q,VgWLUMɅ2\\E\"Ձ➥ɌdRSL7iţ{|5`DNi뫅%\rPSqG\$-#?GWWG/n;d1oTT l㘁QL< \0=::s) HcM}kD^vGC)|]6V}E κ`e1a!7O3Z!}ObEK/8;=ۙ>`G%'db4a5,9hKݨm!B{w5%U	}yus~ZY`* @+u VǚsMrq*\"?pU45G#o.q,SDMzu_1?mϚjN3ߓ,oT/yͅ6F<̮k#\0,>%O*O?Dc͹lJ!<hϰ\0000Ol .f:p@S8xN'/{.Iemm90leP82IL\0~2Rԏp<Pv1fHr磒87w0݋	s.#\$EI|pǐkbBkA H~Le\n2CMD Feb+p xbte.+\"qq­0Xvcpu4ypc7%8.e\nQ2Sî̎Q`&.^x1v6}xlp!{,bP2oxk\n@\"fQbϦk\"ѻ	e5ފMqF_	:qb*2jsG'FP#jVLДlF_Q#BJN:3f\"o7q0\n0q2pRZ42eл&̉\nq	(=w2v3қ*#dF1b>RdN+j?A\nN)[c8r(n.1'2c)xnҎ\n8E D/*q\\IyO`:n312ަS3Rv^17%E1R5&1A2%3a4]6ST3[1.`֕\$\$kܨPSzsC*|\nĩi93~ ة\n@_8eC4_=.44Ss sĿ+~Ȁ37#e0F4'2m@),̈́LلfEAt:gJ{&zޭN15!TL(q\"zR1+z(³DmzԃcQTwz.LOu+\rVŋ7ࣰGth3\"1\nZ	,#1MMPvlvH@\$\$_6|{*.7]O9({ԝ\0(qJ26/.RHMZ4(Ժ#u.4HND6+h*0||R#Uj\$Nm{\0y\$nN&3poFu5\$zUwZPKKMXmVFhvZgʍc{STJ\"dr5^k3΂D\"UR.MUg sKS?SqWC0a\"XTʍ=-Xi c*]bN#N\r@OU&83אMgQ3`";break;case"fi":$g="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 |=NFt<\rL5 *>k:+dnbQéj0IYa\r';eHmjIIN_}\"F=\0k2f۩4Ʃ&ånap0i݈*mMqza͸C^m6>㞄;n7F,px(Ea\\\"F\n%:iPn:lنhA7*bn%#\rCz8\nZ#Sl:c٨&0p*R'(BJm@0@L7E^ԥ+G	#zJ:%#`#N	K`!\nBKJI ҕ#\$;<`2PI<c\\53D C93I\rM'&Hز&,	!`@~M\0G4C(CBh8a^\\Q˘\\7C8^J; ^(aض\r`x!R+#;#l@'λ@݌S!r52^ر\r&\\[O:x:8fMU*2II++-æ`\nH	p7hiX =j3LY=ݬ3?B#P\nN9+Mb*q?`Ұvidd5XT(j{!s#cm%2Nl=ݼ6İ;?s1{>Sܠ\"	* [ÁNfqV#\rZ`c<vSYZ3\r#:Z2#\nRu=[!r׳w5[d<,<˻E;\03L(Z@3B/[4=\nZ7h:E7(EMNB%šELOM@D7`ĔsyBCdI!\0\$\r S_,<5\0{ <\"&vX<Pl!4PcfCa\$AH`u\r(!{z(ŊKb\"Ԃhº_,rX%e^B6kP\rq-DTj\$x\$\$œOn?H/_6ػ\$H|C-TIDD\"mq\"hպWj_lyk)fP|Cr(+MjDhHx`%DSjŵV\0v^hjJIb#L![!CRsaFk3	T2<Ɇ@]!Q`eO( &/Oa&qb9)/@\n=fxqHţH\nM!z+IAC*FW\r2% (,\\&T'B LЦ%DLɩ[iU\":E'\$*e3g2!mM@rZE;j#\rճNc&) ZyEH\0[죌?IHnAݒIw\$ůdk3|aƄHvW-!ρ,½G,ぇH/e)Z\rhGM=bP4%H(jJPͱ\\=`l}!<x3S(x #(8Ԗ+R`cﬤ`00T2.A,Ix\"HH[.l.l8@BD!P\"P@(LfA9sqjEdf@e-\\rm \"va\ry8 Q<Tܚ`ۊhk37ZΪ%SmptL̠tM+ǆ+%[49C1\$9_9/ YBH*1665\$f/&fԎb̒T?ӣ#4^.qIq6 (\$EXR!gS&bl_cv,jH:v#BcC (!S\ro4\${!RgAL\r()D^WH@K	6M;@CnIF^IZP<Mg~?Fāx al4Ȇ#.hi1/׸LA!LKGD,N_U頃ۀo7dwǹM)bKө\n;_EPFXJ1\rIn8_pc8_G:OɋVb6l\"I1k'̤𴈫ILW[l؁A@mkF;t<}jaA SpZh'øfS0G%5T9f^{(dlj_܄G4lgA% e\"ˊnB(b	\"KdF|&tM`dX٭R( @8jmɼ426Jjk@LOdrSpvKVƾͯPwL\0>ܰxШnpR&K\nD\nTΔbN@ᰶ\"BU0η\r4l:or6ʞԑ!\nKd'@ԃ&JbQ\"3\$\n,q\$NzBj\$@ڐ^FKT\rP8SL=c1B6qLr/O-1L&&,^mOѺG\nQ6\$1P qH1n)	O0G\00051 (`\n	<\n	D%Bh\r#\"̝0p\nR:	\0fl9RN!+2'RU&e)%lx#%!bc`jB&(`(\$)CC]C.1p:(c4\"R\nЏ(\"%OϦ-RsRݍH\0\0Epd!\"R\0RF2.r.\rs/pm> %2\0@3ލ)Q\$7ApSBQr#@߱ -4\nF n(=cU,\nr-A~U-O`?\0#]'\$n_).P!hCB1!sA(&dhG)s<\$odIJ&(sQ#IcnWt0D8F;I\n	0t~P%\$A41	rdR(&&f^̒8c\no̲TdBnP]\n\"5@¿sY+1+STJdZUnblz-6W\0#D\$44JbgLC})񚪐Pp䉤e`@KljM%\0N,#_QbXqn1̠\"\"hU#neTMfNϟKwST!Io=Mi#&*RCF\$jsdЭ3M\"";break;case"fr":$g="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AL4T`-;T&8̦(2DQ4E&zdA:Φ脦\$&̆fn9',vnG3RtBpv262S'I\$6N\r@ 5T#VMKxrrB@c7iXȃ%:{=_SL\n|Tns\r<36΄3P\"Ln7;N15h#s\$88!(V֣p7FP2Z\$\r;C(2 (\n)`Ep6L\n\"(ê(c@a\"\n!/L\nL0PI쒜B8CVʲ).qT7326l9ϴKdXPT2C0\n˴J\r@-Z20hʿj \"ҵ\$A`B9}42OH\"N420z\r\r9Ax^;܁pXn,3(C,2`\"cp̋%@|/pŔTa;^ılj51Hؓx'*#(#c\$Pv6h @7h 6C5|<K~hKbL9A6}B8\"e-Dh?Q!:3;4Ϭ)M*)y\\ΣlH!vnj&\"^&;02D|/)vlUƨN8~eT)\"bN>vI#p-dS8A2h' E]]a׌\nR>\"8ֹM^!V6ۚ\0ھ^Q#0\n	!0bI\0>iK!6)dC6~7,\0n}wPϙfFx%w\rX	L0BTBGDvT&0<oqP5	lU#\0`J'u\\U5FEC\$^H0-)ꗃpk&\nnQhF [m-żI5ֻWzoKTxO\$N)\$2Z!Eb\rdv:EZ3EiNX:fMպ\\ksLb]%C2k+._rh]<f2حVgaFBhDV1!	JS<<DjXxukA2Ml4JMk7&r!ɜTj28\\H\n\n\\u\n\nr4(Ň2i\$*jɵ|D6i9JWmpZ&Ѷ(1HYxyk`SX[\"C%-HՌuJkX\r4ՃoD͝}պUBo\rk02*HD^IdVe*TE:(y\$Nq2KHYhh(uTae64++i)JQC|63x9-Be꫊Ihii6\n<)BQwY?*\\5NZ}Kz*\rn\\KIۛ'=XӲG`HBhͱF7wf\n&@A\0F\nBb˃W't]H\"KT2uDRShgPic4A<'\0 A\n%ЈB`El'n\\qR*\r%s'qDu6՞ԼS\0T+nk^mY>BN?)GM&EաǶl4&d*FaSRͶ7'R!D5SD\"E\$4\njEʟv\$SC1`ʣS;(JJm;dՇG4Oj&\n9jau;2.#[1ͽ\r\nS&=gS,ޔ4;m'2.@!Rbh\0Sapqtpb\\,lL3s쮊#4DCUuȧҳa<Rɷ%C=sQ.R'7SW)ѹt:\" DeayՏWriuBݠC	tiWQ&:(%Ou;ch\0C9h&\$nVGX:QIXS iCq!ubo4*zrR=ތ ;V!x\$zd<%FO<\n=ʼoY̏G*a5R/9?Ol7\nB[e%n\$`s\$@\nO6'\$3J_2AC1+;3kF \"l^ϣ\$jOB:f&fR!R(pfF\$q\rKj)fAҚJu~VW\$Ф#\nrfPu	2OFLe^YlBLPqfPw\0B\n<-N=h|6h\rI\$Xgp؃RfBƘ?:\r-2{9w\r0YqHijQPxJQDX0&%V[lPyGzP~O1FD\\%k@B6#B0)o1Əq\$M.N[.^.e\nup_*R0b6:Ő'e0l^̊RCr%bVCCN\rz.:Gl/\$R@\rVJO8k\0ΒYrF5\rd:d!2\"0.\"NN,>00dR%q\$d-!,p\"S\r.b\r_-2Nѡѕ?/',{.S/21Ҵ/S>'1fjB\\ZUeK2t#Fj@!	a-K0yC3ds\r-`Vr.2'V_s;4ղkO8E2=9DT\n#70s/k,;7S3&* %;C:S>AS>.0[70X11Δjz4di4D(6(O\0ȡ\rt\"&&d݀C3D:X)(OH#<;tX~B5/i@,Β4o04iG@+@b~tqkG+HnO,n0L	t0ArєKQGH0ODLԋ\"s?qUjoҲo#1mh3Gd!hn	5lx;#hkR!POa	M/CQmE5-v`)l\r0P5C9.AclGO,F\$8\"H2L1J\npog~J7XZg!B\nd.='m~N3'KfdUx:L#\nO^ Nq@㮡!VK|4M1(K2kq2dM63>8~UӲަvHmc[Pq6:Sd̌bdaU0d}gc\$C1h<%d)f,B\noo5LLkk'4Ai|:*ϤM2Mi\n\n(lr\$E(\0P#1dc:\rdk_Ek*'n`>sQ`	,BD洣G>g; ";break;case"gl":$g="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9k38!uF#N\n73Sue7[ƃfb7eS%\n6\n\$s-]BNFS z;bsX|670·[VpL>&PG1\n9llhE]PӒq^k0&uQT*uC&&9JӐ: @9c2%#&:¸M22CIYJP#\n*4*\r?hҬ\r!)!:C*p(V҇4@7(j6#ç#B`%*~ԨJ0\\6<Z(Co9+dǊ	[@i@1@#\"@M:64L0ȠG8As\n43c0z\r8a^] i\\{\0UlJX|6.3/)jx%ʉcүn ڏz8J#d=hƧMRW\rB=<,\"q?B7.0((J28+T6jJv='#7O\rU'j\nˬ&)(G<ws!x\r\\\$#;631lzqjRzp9.~R2BdbxDN\\8\"y`lNOC☢&U\"7j\r78!OYu \$܎#4l۪9صto-Rn(5\rT_(6ǈ#.޽ u/c'b\r	YZLf9!/\rB9<ͻoP	aL*[T	먒)~\\>\"DOXgqnF(jҐ0h4p鈃Q4uғQ{JVQnE\n0))6fHD	>@A`\$zM I\"\r`S'Q#z!\$-vHa[q*\"C@dW*^:d,)}[qS%	\0002/(KlH\rd*JC7dQS/ӝûU0:b\nWJ_,#Y-o~>R:Z~m-t(S>(\ri;tD1B5n b5F9H	\\S)3fSFP0bqגaμUlj8ap6?\nxD4aOe`\r\0PRI`E!^DH{!\n VG\"a%7ԸoSx7tɀ\\QdĜJ/@\"FNv&a.Oα)D赃U5Њ`i劑@6D50F}(PB(nB=H#ӈ'IoM#ipM	jPlBDrC!b8YcDˆFj	7DLzإW%Y|Hu̾q`BO\naQ\"qky\$nGŔDZ8fvq)/F_P\nBM}(BJ<#&9ki	-%zP(veZGrM=@_7x>y(ɽ@)i 0BL	!h *,p \n@\"pA%A' q>)&\\_<oY<_A\0P#d(fuIa<8]^Z;G*z.{^ELǹC<:f,uə&;\n*Xbjy\rɹTй@#sjM)\ryXjQ\$L9<(T@qIDzH[\$Zii\$3\rT-}El\rGAB%PaSsBPYX洊CuU&P?Pڛs\$x\0(aӞHX`q)u<dEd=IH'.`}NOC\$a5W{_\rh⎚ۦxVZ^zZzZaͮeu\0)trV*N@B@ t\0#4ܴabٞ#@)@X^PlvW]iaVk~(Pth;\$-P?\r:%_@{%k!z{)\n4UFyKOn;AeF%J9S*g?FrSpFI`G)bDާ2v]Q]%<}Ԃ7nABBgDe雹BI`+4%㖜px9xa(*%\"\$d,Ro`^\"\$0\"7I7g4FPr\0`ZMrL\r\$͂ \$D+ZЊ\\Mp\$* BozېRZ\n#>'B(51<Įl۬0XI\"F/\r\rwbѧ;\ru8K}\r3egLM\$0.-n5NΎ1Z .\r\"/N92BPqbi\r@dOvkJ!,G3%pV	9d4!AZ@\nGk\0\0@V\rw&{cc\rdp2q*\rwBxȥu\r#C p3rd_M	r(#2,j#067v KO\rͪ#\"7KH		P\$vf5!Rs(P[(>؀@h̙Lcq'R\$.*4'*zdr˵FzB>\r&te-N-|=rsҟ.r\$.RF;R/.u \n(b-0ȝ.91RLE\rdx`,B2s*Ϡʄb2N)3ʄf\\wµ3|QBvo1\n1H	*1Y(F1j7ts`8NM16/&HsM\$\"xW)sd8%:Ӷ@AbFm]'dI\$,5*#bp(cB5*&<Lkh4OU&4R,\$A+4`J `ƩƢ@3io,fv1Ev'\0t47*FހT\npq&B*j,!(xy+?g1l\\cb:D&TM묩RD/r䧙/r^)CH\0qڴķށt3mIQbfy	l)!lMODD5\nPGR(.UQPϕ&tGr @4NmmUV\$\"Q&A@&:\r>~RUʕ.6xobL.)'XJM\$^ʐNUZ~dj;0*w9\n#!\nB\r";break;case"he":$g="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r;*bJu<UBk0i]?F'1eTk&G~_&0EAd4U¤MBi~ŕ\"U hn2\\+][vGbҥE(ŷMƳqnNG#y\\\n\"Ne\rStN/c2<\$\rC6\"iJ\$\"k'*V*Z9гw3rk(@s5K%L-LRk{0ͬ<Z\$\$3iH/4v-ry0b>%zZHiR[!1S3i|ľ# 4\01o<=s;#7?\0yK3:xW<<As3(42z\r+<(\r#x}z6\"ݡRT#Ap+\$4ɲ#J9\rB\nr!MrO!B&hBHJ9f9/s4(%z	|dkw!S#\$),\$ˋ5E\nH0P,ȢZL]JJdlN]6ͧ7R,H(L7mJ{\"#\rs[c78R!\$2Kf\"z^2_8q9CjI[t\rI@6Ou:{ChZO?@93\r#?H22O\"\r#6><gp+,:\rk\$f#ۿT飏,|*\"9Z8\$e:Q%(d\"'.		0hBp!\$4Ȋ	GI\$dradTjSVUxwV*`/>O\$:,v!,F0NX%F\$2M3@PZ3mNSʁQ*ELRUC̭ʻyD7=8~i1)7rDI}\$ԉ3rXMKkkcQ:d).VlGQ%@|=YHd WaF00f6T\nH<)^LqvTk3`E|(A=2%`ryp7(r\r!4@,>-)@̛_\$<x9RWxx&%\nUL  h\r!49jA!0ʁ_(@8_N,t\$E4CN8 x fZ48 2(@tLqbAT7zb-N='nIy\"hNLC\\%ҎIam-	?\\\$\n<)JDf12\"`|DJfi2`38d\"}	\"a8:\$8KHCnoq|%t95HfHQ!MJ395ceI+6	P7TZ0NB&3N jHRa1#Br!o)۲A]˛xL\"240DQ!7UԔm35n\"`QJrXA3|g2}QỀd3nf꛳~Ғ_, 07)`u8!\"!Ҍ+rG0e+ޒ%%Y.aMu8	\"\ru#)\"\"E9h4@Kja\$>+Okr|1\n>2~Ҝ|	_dNIL9MłtcH\n,;'.2\\!.\rg`5s8DT\n!U8%Dy)8EGh5ifv!60E,~HI;2dIµS\"D\n9NQ~ݥ1%;ACJkT&yJ\n.jv[>!crID3\\~!*y	bM]*Q	(Տ^0{,JM0&iKבFB6% .w/,[z4I#p%,Ɋܷsh]w;-3e\$RG%hͱy-=Ǆqn?Mxm\$K<G2Igc-xq}ۿX`kw2Fk[k_ȗgei+.{^[`~yGldp|>'@RJ83W`7A9Hٛҷ48LTG(r^g\"njk%pL\$(D4Jˑ\"V)&&@LB.\r\\ĊNlrOefq8n+f\$o3	^\\0\n\"-	ie|]\$j諢\nl\"\$1`lp|88]m~Ng&HnXcldx^BB,:l\\J/\$\"Dep3lqSr8^9	#k/nԬ\"#рօ#ܥ%t>/\0d	m+S)c Q ؖ@nfFd(fA oq%@ Ȕ\nIz\"Kn:p!\rw!qtd:r͐⯨6\ncBB0DZi`#Ps-G!:G%^0D:`Vk8А|7*b(*\0KRq&\r0q\rgC({)>`%,\$M3D\$	21FTnK!CKvDDK0*`CEJb\0<a,'#3.¹n2cOP4Br`TɌr0v&NeКq2N,bjG2ې&h~lD67l+&Npf<֧.V\"F(k³&s%5/o/@z&q3Bȯl!?";break;case"hu":$g="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n!OGC| L5\nLL<n1c*))`k56Lԁ:'Td2ɼ 4NZ9@p9NƓfKNC\r:&hD7, *msw&kLxtl<7cVAgb=U\n*GNTT<;16B5x73Ð7IP޸oX6*z9C;\"TʑR&XҧLlR*\nh\" Ȣ\$\r##9EV/BحCacz*.6.51*e,\$HZ8x-\nձ2RYBR4{{93\"=A\0 mk\rI1l(\$t 1BA\0\r5L\02\0x\r	C@:t㽜4ґ8^!xDl.46H7x%BR#b/5c')zh˯n/&	aaCR'@Py#pη#ΓNC.OD\rC'װsk28>]6V- 3#6ר2B[dì12֕:v3>9V\0V@zl %pbP5+ktr80&W0LEL󛃇\njeЂK1GH_#-juD:=(6-3#ű#mHkx<zxZGJjw ܕ7@g\$ڞvPG0CvWC]a4pN>EMh0\"kl}<ܪXs%A0Fi4H%MYF(r4@!P3N)AAzC#NK?9\0T[` E/RɪPU@W8BXd,ZD0-Uy	u} K'dJA=6*Uze\rRjT1t?\\-tȠp\r\$+*Y+-fc~[rB	\0HH̉!&Hd:96H	e@hEETr+\$ðS\\Z#HL|#r+0؎dQȲ \$>U+n ȉU7@a\r+yFMhE̔I#E1:^K,\0(0gTVȉ*AO5XY\r{6ّ=2jpU^ܹ\"C&IFz>\nhjIU01bW(Y\0\$XǜVjiNJTRČ=.ZŘ.,ȏ#Ɵ0+%3 S+2tSk\0p886:(\$0iI5]NËSd3 %c 1jqoţhP	L*UszA\0C`پ?<zYEssRݹ0tP76IjP`#J`0zs<eB.s)	g5g8\\Rhݹp&4ct1[/f!8pj:b1pPze6&щ3%Je>(&4L]TJe}שᨒhPNzsCȵ&N̹=PF:Gڲ,(Y1 g\r-?W(i0p5z{*\\xld1 EgXCfS,MR=(̬.Y`\"^	ٯʅJ\$aDədF2r\\{gx\$&մq0[R!cw;[	8lE>M]Z!xC'fV˿ρl3YNo\$#ztU&ah LR0\n\nLpN\ryxMq252c @BHo-ڡC(n]ڤw2yTd 92fE:ASrX-֩6g|YkQWN\nRBS8.9T5xYh#;Q>vx{]W}߰w\ngf5=0q䪏{-5\$pY?Ezb6׺EtH]*^6&䔍bܲrCyKX\$k)&ag\0WU8Q\n1?k\r[ֵNֶd/ak5~>8AklC}oC.:\rVF\n#L*`}=L\0n\$4ذ2%a`Ɯ0Agw({PD?R?+H`/42&'H9#l`Alj'\nhF]f&0DJ\r,Ѭs\n0p| RtG&M;D|ۭbjaKr\"V,xϙ8\$Н̌8,Wlb\0wP2v'wdv'q1(vgXCRf\r.?.FhDtQD.\nN1JQqXg%1VQ\\61`-6:\",8آ;5Q\$lM9iFd(,k\n@2`tB)\rez\$\$sλzjgQW0eLN\"ԞU\rѦ1\"\rQƎbGp%``QLhS%P;P%Ub;&.w\$*NS?'P2W(&X.N\"2;ҟ(1\n|	b<F	s-@##(o,V8BE҅&r%m.\$)Zkl/K*Ka@\r(Jc%rr2'03R\0;9%.9BE\$&10?2#oSJrAsM/5@Rw+>0-7sP37Q0;ӄh~ߍʮ!dDM?~>u9cQ;ު 	:pj@N7	=9?=nS >6O?SO7\rIA\"QnT(nZL=On\\J5AS'q?C3RcCo-2U	Fd;\r\n@ʾ\"/Emh1F0ft[FF(fO\nB:ABp҆EsvFOI3J.Jts_ k\nK]eZj-Tr! ȒET\0\np%QZCcGTU&U	T \"B(\"\$},g0\$BI#;MNDaC\n`0HOH:8A8/.l ~mLdEī;WC7\0g`\0o:PR`f~;nhbBB-G/Bp4b![o\\SE8(.T5AhhHK{u<RR&+B \\!B\re`s n	Hr܅jT\$V6\nNu^?찓2D\"4H	CTaX\rcd\\]e`-ag4Fˆ\rb)5b8)Db,3-afF@\r";break;case"id":$g="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n 2T~\n5f*@l4цa\$E8S4'	ldu'c(oFe3htƝ\ry/s4aUU/l'Q!7nS>S/W95&n/x\n\$NX)\n3 Щx(6ǝӑ\"\"CiߚyӇ!9c\$9:A*7;#I0X\r|iR(ڑ+#:>%:068!\0AmhɬjBS;87QZ%\"m N}kZ(H)\"8m	\05Rڗj6>1`3XƎKDâs?`@-@2D49Ax^;ru4\r\\z&o2~\r34ƣ^0\r(	Er%\n5+Ldtt+sx\"7?9X6Gzį%	)w\$H@'B%0b ;@%׃@#\":Z1q,MXJ(Q\n:}i#.#ㄖ4)\"`1Knb׵4J\rr+!mni%~(2l/=BKTZs%jh6_C'苨Q]c\rO\05po|!0Ҋ|0}		&/+/<'1; ,3]V%0BNƍ0̴SP7r\"Ϝ:AtCEcrrܵaJKID*1IYXx3<9PRMTCEѴ}\"ԪS*mU@7*}rE̒cʆ|H%^i\"Kƀ*SvQgCRYLu4T\nWNK\"Um8u䜢9\rq/0\\#CЖiOhH1XHf|Ɔ1DpȑDau'CYoy>\" a\"@1¸P::bRdHE{\0\n0JA,\0POL/@8ܧc;Hc0Wk&C8yFIDc#/B84J73H\"Dƌ1ԁ)41{Q') (L%&^!7\\êya+P@ c1S?JD̚y\n\r!v@ɇ&+7'\",C<MS,5О,!d@xS\n9JI1睌dNRL\$r9,!9E6utr@	W*[0T	EʶpD&G\$)Ȱc^ԲxxNT(@(\n \"Pl@\n	Wd\$2D\rRe*H%]\r9vH02X:gUzʏ/I(V+5Q\"R1V]0OQ#jAky<lc\\*!R\$OӔ\02%?Kh/\r	K\"c\nf`_%n=0wjG2Xw[^I\"F\\FT2t@M Zkiɮ%SڂV\$7WrC5C;K145iCmGm62O#jbL&x\n\nFؚCkJWK\rta Aa R6xf\r8Vt:XdA@&1%!e1ق_Im,TLYI?裏ni\$Q-DwV\nh\";S%l00tY+&*ΉkrI(T͒Q4Bh=c(HT5lT9eQTGBiDp2tZϽ=֪3H\0Եx\r-ĤpޣEЧfW% 겟>84BHnm('k\$Dt\"P'{2;yGas)Ze?Q%7[@YyI#ۅ-J3Tc-zuSɢZVFqj]Ff{q1	x=,YƳ-fW@RDZ8.-\"i!&[:^cZ;_wWỿ}]=s>y%5\r]:E\"ֽR뷴&@9@l\$G8v:mh.ןXYx\$\$dOlF\rS_/ٵ\$,5\"o\0O\\bDi\"L`+ZBK(gj:@Ƭf2-/rPEpLK#G\"i\$,I`d0\"aP|\$|H0B扆f0T_^_\0io:]N\0n	BYnO@.0_tx1\"#lGP%0@H!q\nZA`DԚozvɐ¬\r1-\rN*[Pq<[E\0\$I@.B\\H1adlʨUٌ9\rmJ&`zJM/+JE`j],`4'zD\$@줨r\npsk(\$M 0p\nbb7\$LDoxz4	Fj^>m,@*2L-(.xp\"N[x^jUV'C:\"xx@4dg,fqRe(DLwBS\0 \r(\r\$Ol܏lV	*5N6T#-fR&Hi몌E+D/9L+-b\\҈CúWr\$\"2\$ˠI 2cA\nF@DdDT E#";break;case"it":$g="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AE8QoS|@o&dN&(fLM7\r1xX(-2dF}(uG&s4M\"vZgZ-(J.WCa[;fʒ 1Ņƭg<	 gJerKDSd׳&ZQT\"H&9:oS!W3G#sѩ8Lg{AL%,BRP%&J\"tjh@e:H\"=@7c4PBʦB87f*\r#&rI`Nb(?\rã2#^7D`޵#Ll2\r[: #1Ȍ*\"=%/i(`@%#CH3:xK7Ar3 _A?o^'laL3-	x\$³޺\0=%tíM|:+͚/K0Y.5Kى 숢,7/ġ(CʚWeܥ x؎Th^jXK(\\1+-B4֒\\Y\"30@1J!+ޱ4J'N\$Hr'5;3lX&1<IcME ^Z9%-]~#pȈb,ﶶl={YĒ0Yl,I̻2	#k9.NˢMkf\"J#8(٧\0ڐ8T`i,05nQHIWt0.hH35=#\\LJLȀS9HL	ޓ7l\\3YTȗ%A2P{K-=xͣs\"g(}-~ŗZ	cɾbl!k'˭|wL3\"MH0<`dCpkt9\\8 *m0%yq (&TzRjUKu3\nJ[\rT#P	3&T0aKF셇'^yd@fHn\$g1SC\$W:pRaM>؂t<\$:n!4!)\".0&͘АJq'#G)n8֝W(IAc\$!(Pe;nr߁F괸30eM&i0α^bDw80È)4@D	A\0P	A86{('क7t˱'3r4OmdNGtL׷^,AntfoPUf)EU5'Y!5P7S\nAL@*-f`كIoɐ	o0_KH(ș:vOqqxPVhȍB	Cd|:*OS%CѬ:y8BxS\n曕\r3=I8^ՀЬf\0PPF%rC;DiDh+\$h#ILG{+*&u~4)o'@BD!P\"z E	a3[>V4VsY(f052e1XL9[椵PZ0qSZs>\$ՃX_mw魷!4S!27tHww'b-nHniMZS!cFɛ7?nBo*x\rpbD	`\"u\nn\nmN0%\$ɡՆp\r0҈QkEWFVѼ8HLY\"@3dBM?V3\r7htva\rsV@PFV:`)I`c-\n!@ɈIJA̎\$'C<L*7^iÖ|^ \0ZC\n]e7`ì@sX@Z,*LM./7gNfl)8P&12e㺊Tz\rX8[˽x><3Gi1qƒiaL.j~RpJArKFVȀpN%']LVEBgW<*D)GUf5\\d\$o3\$F>I8.Q~yO8jWƂ5IfieaXE3;pD B~XR{tX\nY	UΒg3Orn5\"%3\"Pn!Rsz#QzoKlڻ{1{wlFӺ~f[L7nUpv`7Yb'yA{I?kۇp@t)D%\rֈn\"b:P\\	<IփTCn\$iN@*#C`tG¢`6GQjL\r0L% ͅ  vcfM06e5/Z0		タ^5/ŦnFκy\"0ν=Nk\$\\mob\r2Mˌ2\"ҽ<\$\r\nȐ5MϚ/\0c_\rR.1\$&1'a0aV+<3dm\n5%N	AcOGF=ZGPol)f |iHw&aGMM#ѷϭ\rhj&e^ad2'N.^L?#9c:Ѐ@3gKK\0q!'&IFP2=RG rNI֌`&dHJqI<ͱH[^'4v.]rv0ʬI\0\0]h\"-hb1M,B'ݥ`(r\n+e+2J`9`:0逡o0ac;%+Xr>3jZ\r%mpͶS1BbL[0~B@&qH5˿%( ۢ*:#%*o<L)\"K*kVU fC>eR%cg*#\"#,M0	4։RZ\$b,s\0mj ^ :s3:ӛ;#rFӹ9,w<0J˳;	,vMʛ5>d,;@\0g\\q&:E/&\r16	>s+&~X˸(7Ӣn;gPz@Z<րhDmW\n\nGLbnI.4 B8";break;case"ja":$g="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp99UB[Hi[x9+AFCw@~UM^_PPU! F^!UМR<I'2mhK,/P[PtRW^XEvu:kL[&|	W~G*)Am4TO;%~sC\\10G\$%ReK8myCd~\\#%{A	Vr_L(Ce\$\$i	\\se	^1Re&r@I	Fd		\n@ư'HFĺ-:´@򘱜ĩ`y.R\\DNK,U1	)dDK)<EpAF%U%J!1<AMSOG\rp<A'9PW%\0'H1f[Du_5l3XVPNAiy`\\<g95Hk'VȂ2\rH2QMD-KM]Y@@GC1R1l_͒x2\n@4C(C@:tL7Evx3(9pJ(|t%Z^0MW9tze,2I&dKzZ1\rnܧI7QP97{ҁ8sV)\"EA(ȤW'JhM7ѻ1\0Q2U9@?GN\0sPKSa3.sQ;%vs}+'WF[hd\"^KOi/?*[KJOHMeH)\0P(gO!<E2w9\"zηJNO}[,IW=n;\nPn+nspX!>􍻚re0@Cs2r\r0°a-	C>a7`HeAa9\"cB\$aLO 2HII0^TtWBL!J,Jr^-6@TB0sl9+)I8EEC@)qxǓ4|R\nb'9EEbFLiJVK	i!i D;xFƹJID*P\"k90@ D!1KV& b`1V.Xc셑VNe,et\r0`HIm(.C &	>Eܖ%#cj5fKz\ndJd\0DP)DLĶk14 dLvPʥ-eřPsl͞ÐP\\_S\$M&0sp(h͹+M@AOe>Lr3DW\r䱬S!5%'(D9jSaF.:\"j5*+[N	#:lĘl@耠B6-z_AE/fzu9\\j+@%Ut\rq.\$\\d%!!`)\r0j:@=F~æebEH+ZAD)Oi)W`]q2LDyTĆ9Dpn6dmGI*S\nAF)-CiwNU]ĳ4\"hSc6IICv:ؔn(#B	pVՆ|`<*8\\.wWZ:\";؃GʍK,fQ,T_K>JqIdV(!|OI(8XFE\0VwӛkَJ=k{\$بvKF\n@sQI\"Wՙs¾9eB`Y.aLİo>\n)P*P\0D0\"\01q	,U:^ЊҞ{ϛx>jP^0>kUQ_s,춎;\roEfDaa5\\(\"LFZZ3)9qlnx\0\n*C*^}=&LV\\(YclEZkSJ*hsP\\\"<Y=4_A'\$\rkEJ	wp[dDȜsЃGQI,KS!-XZ1qӤq*`ElW?CRY+Mye^5w@!Ԍ!_}PX^1r@G/dw\$%RH[K\\Eu9_z'TuHi`K=l[0*\nGU\$X #o[ LR&M.l0I0{gD9Bb\0/Vk.%\0B!4쒃dvr1*FkRJ1Box\rNLn܌ꐎD\0@W\r*L.u\n1qE*By&Pp!~.PH0\$lb%;43<lmm?N3mCf7f8,bq	@hk7Fb!Q8CqF6Ƥ-O.pMhyb\"л,{JrG(1\rpL/b/DD*yRZWћqprn/\rfa\ngpmx.% >GV'EQ'BJ\$,g͑&J !n* 5}\nI}j\$Otg#,~3}\"<!x+cŃn\n`\$)Ƒ\0@	R;'rh/\0q(Pr%RYO()/:ToXdRPИ.y\0* CE>Y#!.9:R!,0,U\$5\nBr\$|*C.C.P6k)θͮ\"rJ\0o3**4j]4/!44R%*'O4aO161671c4-50!jAC<^@L	D;GoRST*o;-7&'Q;l932VnXSت\"mU>NV!35TTmBg9*AegArK5T(!-\";CSCt3-+Ds\\T/T\\UU-gB3?aXBTl^Rs0;lTYEVRtKFWG4Z?E!AF1=s*u%IW84JKTpDSiBR#MMR;C4NOG6s^ޏEEF!JBԃQSQQ!	l\r\0jDpdCTyp<#*Ho9iRP\0\\E|['D(9Vm9S&x7!4l)4~HkPx7`\np)3;ьG.vpv3(6ᢔ<s:e;cb(I\n/'/VW#+} rHC\rnc.~#cO>s%bӬ< <M^Ȭg\"5\nax@{B/WQk2AMd2nJrVh֝B#CqtOaqsAX[2fNL\nL&*>0^gOj!ja,G\0`XT0#+\0p.r`wgs'pk7XMDT2R1w5V3EDF\\";break;case"ka":$g="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fIɥ	'\"1UdJ	.eiJ\"|:\r]GR1tYg0<SWµK{!feMs'Im&K=e\"r'Q+˿}-<^}nnZ,:K<թ;SV\"zq=o۳*#\0LDζS:-JsL\"4Mi(N\".@9Z7BŴϻ&Vl7RRrF\nKt-Y(˰KpDLΣ*x#	Sj2S!RL,*ʐiDO/ۊj\r1ЧK(N#VJsR(TOTS)HHE:1	%iRՎM%jtfG,>C*^͵LYP\\t6\$\$5;b6#p9J:'TtYRoe\\]J[@4C(C@:tD7{x3(9PJ|(W||MQjxTӧ dwmN	=kRzM;cڮ@CMHh<McJrө*m\"+q(!1lmNQ/O.U/]03a\$?VͭsDj6j7ZNC-]%:o;먿yoGں(Ḩt=I,	Bh!f ĥiEJV{5fоꚋtzܥBb-<u:ގ!?<+\$L\$j(6TUs샇jfnYVS^!+q5|I2#%	^7&	[Z-,̦!8mFX0eD 7\nQ4dBT\0m:1\0Θt7\0CrA<LX:a7`e1ꘒI4Q<%mi+L>CX]¢+EeV`tNбh}d(](G1 !4xfH&D^1>R8\"N+K%gܕe T\n6|CWƄ*fW *N	Dā+\nro)an}\n8i)vJ{Q^K{/3l?ӭ`JNDM\n>LEV.Xc셑YS,e2G@Ltg· mm6=c%b-Q4MSiz،vB+pޥ!4,%zSz4h\$\"F(Lގ\061F,ćvHɧ)elPps,:HީC=b&Rby-ԙZ鳒SYgfI@IũBCT4˧g&E&dN#xYqX,-)xPxv=\$LIM\$3H	4Gt㐶F`2O\0L_bmۻCN뙪V\"+M׼uwj.\ninzs\0L'[H?`[VOv܉QI>&jiAC\naH#/T {#6H܋'A7W^%iڒx)U15ymE\"K?v2X7P[PGB@%{R-Yp\$0^xʽ&l{	Ph\$ַs? ¢4(\0ɭjUt,bKtSWdJ_MQ@e%Oe+sձTS`a^mD9:\\?JD3M<&B5oM7MA(`ޫֹ\\Sa%lIKcc+zI4nQkQw ʽ뮮2oHS>E	2Y\"p'%\$x2.~DJК)>t<0KְiU#XZE|P6@>0SH'2Xu;^઄w5Qqߖ0uBHo;nV]B+j](epA6PνH,ᙫwZů^&(ܐ4Sq8@Ga>3Rm+2W\nCɻyq<x])Zi6QzN~ rt|t{oI߀Nl!YlVP@7&\\|O4g؛)\0 4.	ΜFթF&P`zo\nTp`a|uX(Ī%ئ@\n 	´CVyIĤnZ+n;ֲ	G@DhG\0^-Em֐8@Z:2)J&Sp7,'T2h~koK>AS@'lR|i=|hlh|BNnb<LV6dz4D)Zf¸!Cht\$&-78Qjq&hͦ(Fla 䰘r&΁ȆD&Dqݏx!\rdрl04'b4(-C\rr@F0\$jr<Nr m#.UL%gfUl#u+:Ƣx`1ڗ0G K\r\"i#I&p:tq)-tR0M4φNش#rD~/#Tb=4.\rZ&.;ƈ+,.qd	,F,b.O-n(*+,uO`	XM)'!1oD-M`VW2\0,nr:.!00̚Q\0r{/o%6	6B/6OB-7u)31n,6ajOB`Q7Qx\$B#2zl}nP+):?:\");lꥒ̂*жTONhp\nmSxo=:e=:b}ѿ6rʰq.22#L)Dǰ/\r8sZTHmDE3LR%B˲TMsF+>G`a@g6X&TH>aS1W5MJp<MԚsIKKQt'̦?Ep@m&S&NozqZ1kDI4t\$45]48SsRS@:QӁ\"1b?}C0qS>-U(pp|:HwfVNeUuU@s\$:Z0ys2Sp%/\0L4I0Bv5?.PvYu//52[L%uR䵾Z(ENU+rFi,(Q[STu0Uq;#S`9`\rf&f@@@e@\r&6 &v+bГ%c6\$\r)b0oد\0& e\0X(QZtk\\<94US4ևH[uKXV\n֋T2s]W`uTr+%pVrrj7X,5i֑\"PVTiӖ4`:h5U8EZ1lBK=ĽZ/U(4ǷM\"~^	OK_PC)6U&5aT{*&La@qklzb.q_㌩uI:KE>*pGĀ\n\rrM4O\"\" rbol)A]>	r,P~S]眻&KvZ&sFiKMskW]sZ/jX&zx֪l%m|WDV1OZ@aK|GOpp|7Fs\"\"5F鐶#yW/ ~l mǦON&J-E{-:w WrD^X荈?IlDNΑ,?vl:R;NP*͕&YF/\\)~{qǥ]ٌe8(l6lSRrסr,\$»oE#*\\.̹T*U\r*]Y%/%jE!at	4`";break;case"ko":$g="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4)؋R;RȘVN:J\n\\ZKRSȈb2̛H:kBuY\r֯h!a/\"]dێri؆&XQ]n:[##i.-(Y\nRO)igC#cYNw	NL-\0S0&>yZP',l<VR\np7\r7IX00c(@2\r(A@9DC09Ƞ\$aHHAGE)xPv	RX3bW#gaUD̸=\"V3d bSYa6'0JI`SA\0<7D!`uj*FRO+9:e/T-M4[Di0t#ZvBk*u:I	Zv(d# ;1KQ1p\0\r1\rH4\r㭤ECY\0ym3:x\rdB0p_tcI|63Bl(4px!WR5=S !@vdE\$:aB/i;<\0kh:eeiU/!NF\"\$:n@#X6ewZ-E:BQG(!LNpy#:WQ+1NHpdJUY@V,ĻD?OÈJ\\Lb@VS*δ`P\r,6CC0x&<R&P<\\年KU4MXEQVgiRe97{UCOVo:.;!Z^̓RjM\0-/]qʙb'6P戗{^A:\$!史WC>lt3C,%4hHsvj	4L2VlEÑfI#JAQ5G%`_؃AP7( -E \r30Cr!3m\r>k2\nYV02E.hw X7 Pi%wת_+~X`Ƀ^\"\0tc(Ϥ2%p<͈Rk`mPH/%J%Gu\"/f/ܕ1E9W/]y/E_JD3aQ#ɆI\r!4ˌ7kbȥJ4ܘ͢@HB*m1nL46;PĆr9:tn]Q8\nO᥿DNi5dDRiSX(jʁ*iP°)C>3\0Oᕯ-\0 \rJ2:Bu	\\b%red>Ú*Z6,]uHc\r3pAOwpX2ً5g, aL)b4!X7\"xp]7\$h&@Aԑf9HȘ>>\"#\$Țb7Gqf/\$|dR:@HS axRI+	\$<T7*\"C![>3 (ɵ,143T*d(\"yAJa\"]vHɹ9'x\nBkGPP@(/!XN<B. \nnذM0T\n2ia\"dTĈ%LREK5#y`3bc861f\"ukssxo 0<	: u)ڰ\"	i!aER=:Q:#u,r+R#]W(ͮݝXT>V:73\">i#/h[8@|̛clګf(L\nzN 1QP|k=iRB7uzWTNoDbo<9RQr%ʹcbdBP\$[pbv=Dǵ\nӢݞ8ޢ'>Yf-҄=zzBhb5@=Z!`'\0PC^HRvB\r':O;S=vURb,(sgQQ\"vIRmiZY0C	\0҇\nY\".Y\$\0d/\rp22Z=hْZ>Fլ`O#ޓDZ9|ዚ~[]_L~k}ARizgE~ͬj)Nt cOvoR-ˤ%JVidn҈{>B4gIL49n?'&r\"=;pj6M#Fi0#\"epVpRR@LӃ%\nV6lhO	oIP2'k090i4R.2dN1cHAF(O.7)IqAbӍP\"FNVd[<ٍǟEMyol7\rgی4%\nXܱJ̏z|\"P1PڑcIg,!FCO,	TC6Ѱ44Эפ0Nzqn|\$1G&\$\"\")!:&\"\\8lc%Q0\"\r`qzrgR΢	eg!6|\n))*HO Q\nQz'1NP5rNͣ!gҝan'#2+2*QW ұ\r6/6lnt\$:D\"iH\"b#A66:/))0Q-q#g҂Kc9rp.\$H94(\n/`\$%#4\09#.a6Q&661y!D83)7-4bVNp23P2s*Ns:.G0ZG4ޕ0a\$7EC=o<ΓS=lHh>\0oeS3jS*4Qr(4 r:pB3C.(O8?LT148e,@F)2EUFTY*ƫ,n@C\nl18K<#Aohֳ3sfGFC T)16Tz1Aj<OGKKKM/w! lJ \nt[fo4(\\BVw(Dl\nZ~\0[E7NB#'-6meϾԣLjh,>s:unsG#]Wq)VJg\"=I\0/\r[ oWL܁({'\$i*c~Lh|6OycȻ/\rb6.U^p60!6h4H3+U:1BƇd>@CSA`	X>=k<`b܇G 0)[-R5fLxko,d>nkTm/aj}u)\$_M)f%,\0=#bn]l&ƓG7tCt!*JM\$";break;case"lt":$g="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 rT&*4AFi7IgPf\"^ 6MHC	1Պ\0NE\r:Y7DQ@n,h(:C@t4L4:I'S9P춛hb&NqQ}H؈PVuof,k49`\$gYnfQ.JbfM(n5rGHt=. 9c2#P;\r389aPCbڊ˱fir'5*?o4ߍ`*B 2C+&\n5((2lP0MB5.8҄2!,,\")#bz_ r.\nH5\0('MTkX2\rC\r1p4#ϤN@?#AxXD49Ax^;pJRÐ\\zu2h\r#,\"Hpx!: \$S]bc/x2_>.+&͚1c\nB(=t239&?\rKX(O갂#B	#pOC\"`(2We(1c~x3F*#*:9B4\"I:-RF(BbGG#K<2ÚH`յ1#s(\0:Id?J9:T6罸ϸ8h4Lا}d1k\"uS?Gg2,T.+8խ9l,b*Cq.Ly%	@6Msmr507=Ҏ|(f,2|&!-.6Ct\rĉrSraDQ\$o6)e	\0*Ipyrl:%HYp\r\ruAh\$͏Pσ((`J1PhCLhC(|	B7䜴p@qV.LWa,EYg-y-+D }\"߀ȸϵP!iDR\$ǊAp yQhWL#yDuCIkaUV\\qh81[a%BR5	r@K2PHbHJ9*ÚwrE8B\$\0cV@ejJL|0bo>Aő=q)^a\rxd\"7,e#\r%J]\n (!>(&P@\0O'm5^R%Mü F,fmԳs1[`GB\r+4,w5.e=Qr2TN:) 5HiD!9Z\\r\"v\$]q5S,:H\"HIAqsаԺىuKa	B	y/L,s\rN&>j\rQ-<sc|R26Q!4._\r	L*Xcm%k#\rdAglo)!uVND3ma5~N5r\\%d-i)qLוȒ\$	N\$Q:\"\\i]|6`̤ʳ`4:Yi!Ü3<F;wY9+r+*\"(Ed.ID1xZxYt'~xe˜dP>,jnb5Y2~|\n70i,ش* Bȱ>C:jQR]u&GEJ_Z&P(--*yf'ȅ&=2ASzjE\\g{y_暛^H#\$t\$vSB+0bAv+'47F37p1E%D	\$XSmՎz<xaX]l!@Hi?ˇY3y<>z~~{op˔3_1Hn.%RAtb\"v!d=ݒD;a*@@ |eBxCةA.q,'(AXl;	g9dD9-?k'@^Ix&J.bf_9\0tsKDˤu-Ɣ7/zΏ/\0)lEzoCc0ѓEC_7*Owq%nE'i.bk(\ni6!(VXmr\"}Ƞ2緂ZR[T,FႆB'Pl0HBld<I0#L\0}E:Ч.2Vm.bo--f#.a.@(p<LLxȦ*Z *ºwǊVi0*2nG|9?\0DE|8ebJ;@D(E	D#2!LD,ݍ\$,B!0D\"^ނBnj I%mO\rGVl;80@P&[&:DPOa@J.L!E+ort.b/k/\"C1>eOy>0ACQBtҜpB%bp#ĸ,FQ4=Dx|Dp~\"eilp5G	\"~!\"*@B*@pδ&\$dΕ\$&M-6J7\0ONy'm:1-mlQɢe<\$\rF`M*S\$\\,`H;nl!%8r;'U&0\0+--)B Յ?,C ~kQF6c#[M'p;qsU-R(:uk.@]_Ù).&,qY/\rDLa,K%)2r2#(B;/Uk0RvD|;bAs)-\n\rq-&CK4d&@'fD p297s8\$.\"(R.w\n;R\n;3R=6<>Ң	t-rMD&&BpMs!\n.R-@ܤKj.<\0/-°{L/LTb}&>3R Px+3&KC(]g/NDrOD#365?JDj:	}FQ56x&/\$12e\rV9Tiv[^t;\"nظv`\npH@#f(\",/kMNB)\"pJ%d?\"/\n	Am +48@,/*8`cBw3(\$98[J,Ț[P?[#\nNN\$Am\ndԁic{0J@줳rҬXZL40-rMsYʰ2\rom f\$Dl&`tMpdI1G\r\nh2pI3&%/Z`@]e+X#Q\"҅5GgB\nD>է)B3^vYO]J=M\0,2G1*GNN0\$M\nB=\0";break;case"lv":$g="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(#Y9\"F3It9GCF\"67C8'ab:ǥ%#)DdHobٸuN21	i@ S0Mө_ni2|9q#{o5Mat5_6̆Q32b)V,HC%À9\rRR\$I7Lsu		jCj\$6C\"\nbf*\r40mZ 	d\r#֥ Pbc\\7(轶O5Lh׷r.7\"LL(	²l:& H̢H`7Gb)CAЂL#Nb\\4C(C@:t\\4Zڒp_	cxDò89!Z\"7j@ x!.=!(PNP+(#/p于(U/\n	ݲ%.RrK!YPa(A؂8:\r8!\n%ʞ@c]C,07C̡9)\\x[0%NPhsPv|)C(5˻-!P3A	CV*FLp@3qx90(#UȶaJ~(8Mvn3_qGxCW4LC@I4 <ѐ#h`*e睥~B ϢК\"=bT+ď6c|!`3/E\\[}5AsA>猣IEİTv@H1\\fkm?7B=9Crihܸ)Z4rڇ8e	p	46C|/A(HD'\"FJ^1lV/Dў\rND'!^\$!4T,pDEcm^\n Is&Dj;(A\"a\0Әl2ltz\n)FE8K:\";\nTTZՌJ9+ur	caePb}d)@Ҵ	&DEG)`%sS!\r%̧JW\$\$Sh[	n\0ND2UJWu`l\0U|NVa5PZ}d7dZ	>sLDI9#dϙiy/\nlH!k|3ځPuAa)IPR\\J>7ٙ!\"Q3rk\n%(0 \n (uF4\"DL*+\0c&a<R!J!wKQ}yUUc\0`&8xBѴKP#`h4(܋oҧ\rY`/\n\ru23\0F77yÜ7C49B4\r}P/\rm5MͣhG@ޥ(&rHC%,Z*18tXݰ8a,6 #C{谡<)J	E]eq,RX*Eu&@OC3k+B_ۤWP@b1H \nn>HI%\$jlɍ\rbCG]#%bF\\DM9%{2c.9ܬ1KN&efk\0PGn9'L6\$L3wEFp6M(p:zD!2ha.XGzQ}0PB9,BH*/(V\$\"tc5KZՄx\n\"w. u	XRGaP(5*ӰN7R!@WJIza nqM76{A\$ӵABKLddd͓v4nN3PZrEA!CT&\r>=q{PdW,͓ͦjA|OsqzrfUw7Ԁ6gc/\rc#08Aa\"n+L-Um\0@GujISƍ'6}g~~}\"ݩȃ\"PC-ۯep'=&|S=,TǓQxiD<cCpkKӒ+>gPb=hhsa<Ǹ]>H/\".\nGSjA:31!e_wĲ*/<(\r}\n:}9N=w#\$l F@fnE&\nEr,@0-\"zĚffza#42,LN;Jv4,BB\"ڐJOR\r' OTf&%h%^Pp\n~A~) \"0U,fn#zgdZ.C>b(rfxJz캸L\nШvF,J^d%К ]l0'2A\nXʃ*GA0`bzc\nuQӱ0vpp\ng9FML3ospͮ̼1+(J/R[ n\$kzHu!Vˑwz~xbg#H%!pǬऐLΣbR	LIE<2*Ee8T 2*\0Bg\"Z.s&VYpEq-̆_o~rͮ\\NDm	x8?##\r'. tP,u2Dr\\N]4f'2Peh%'ft@Y&OȍtR|r#O.'\$1\n@PQ]?&+wTs4)~tR_g+n+҅\rƏ-r%2+ib\$B3H+S,Hs1;zKc0Ρ(c2ĜdRfBU1RO'КtQ?%3JN:\rRr\\D(\02S5n@\\\"`{\$m5NO5^)cnF% 7X'<\$22l% ;q42M2n1/.a:bc&LM\rSMΪ2u=u0V8	\rf\r+RP\ned!/cja,AcOB\"fq,·C&>\"#\rhh&/N1;7E,mn3,gb7@K`\0V,&u\"*9*B\nZ.R<D.#\\E&gLyM=Mn3~DE\$&ECc1D<gvB>X2#BOP<L,rh-8\$\$HcK\np\"N&!0.]UHUoHcM3N\00ECWU`ƍcj,rxc\"/'>#C7JI&bKCLi\"=̵ޔH`/O-U8jܓJ0͵dMG>U#Up:%1'\$feĤqɄk\"";break;case"ms":$g="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7ADt@p0Qs7VaT4\"TLS5ki9k-@e6Q@k2()6ɝ/fBk4S%A4Jr[gNMC	œofs6!e9NyCdy`#h(<H>Tk7r!&.7Np|+8zc*v<vhH7lH\"p=xÍit<(íBSV3#ÁBRd+3*BʝLޮc\"!P	؄;QjiꉃzZT3{1/c Ժ?ì&\$bn>o;#7T@X90z\r8a^(\\Ncs=8^%\"9xDk#3ސHx!2(\r+lL#\n&5CtF'@P0\nT (C˞ׅJ|R\n%L!`FPdt6HI\$H0lI|P)L\rë		Ĭ2X9K|rZ9<\rئ(S~I#p/Vka\rB!{K<ǙI+:ϰY9P{\\[m\"HJŪݦ<v*3aLLr|=>c=1u]A(\"ģX&\rZot0̶HhE*:&|9n,Cɩj*i\$xp')PwSD1-w]IQzrރHo!FrRolͽn	RK6TTj;x UBBCIiVCH]	?FXka6>7iJ鍇?0,=[l@\\SJqO*D2*9*`ú̞2`] kmA*_0'P\$9%\\\\ViC7j 62c!r30c uO\0003R&3Q\n((LrS7RtrB@{/\n (fA?2GZcI Ce1cy~٘+ی(Dg#܂F9tx?w+U[(IHc'3+dtr'H2(L\0C\naH#N;bAa9@|>|FQr`&=*(bbfZ.9]hVBNbG88BRɱPN_U=Q0M=\n>Q0(%k'O\\\"894'Ot9=1WL*\r\nGM;iA#(2*LTNm呭fY)\$Wq&3ƾܒA<'\0 A\nЈB`El)(uIJHq5Fkqd,%ޛO#HM=1[4f{3!%Jv`P2h0oKj-ohD蹰!ڏ7;tctT(V:efٖ\0L9OSMbe'w˽\"ܕ\0/HzJVV=QkO:ځV13#XeԪ	ugI]\$OhlΙA:ǭƸ=\rv@rpcgA\rL@.z@%h-)C㤳Ti6MBwFW\$%jXz, jU\n!nNr2J+V /wc^\0vHY\"%jMzc'Pe.TVRv=?D9lH.\r;xmv*0 bb1!D3K*>( 2GaI5SY9##Z`j|N=&bku%iļ:Wԇ`j\rQ!RG\roFFz:ߐ2+E\\9[P0wIXyn7⠇2vۢ&{ͪ\n?b\$}>a\\{XUud%w׮_\$9GO;bk>\"_&}ɾބtCw6Uvx53?_o?:>Ɔζh|C'B9T&g2zJ&5/&9z.b)b)IJϲ,5B,;egxLl*PE:ڜ0XIMD(u\rF{pr:O	P L:bB\nl\rJ~CuBF:`B\$l*|Z=0tNh\",-В,XeýJ]	5_\nMC\n\\/1:&:R̥F߱2czvO	%b\r\r!8?bb\0=\0ł3d 'I?p1`,'\0ϣA x\$\rЭ:PCM1\$hQ ߱\"B-C	f0%wɫ\rlSbi<GLl~^,@(^fzKcm&BN\$V\rVbp!o)j4o\0@C+3PhM,,N\nZ2ڭ0nNk7n\"kn\$:x8IL%D%R+T\"pK*b\n\"pmŸ\$J\0Z˒m\"ǣ#%2LkL|\nx{.\"y0qB1N\r3bO2.Djxc7h\rTKL*BVfZLԨ0@\n 	2-ppt1\r;-}/j '/@zK;Rd86y\r:\00!/l|Y~>~n";break;case"nl":$g="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7AEs->8 4YFSY?,pQi3MS`(ebF˔I;ۍ`0߰\n*͍\nmm0K`-Z&.O8Qh6w5m9[Mֿ5!uYqoEkqȕ5u4.T@f7NR\$Y8C)6,ûBю)ϛ\$=b6h9ØtjBȣ^K(HȾX8- 21b(ïC,7 r1kN,+rt2C24e[Qkc2P8cs_2Ѥ1?\0P\rbDHhԁ=jԜ?ʂ:,3ʀO\0@=Q4Np0´D0z4crx[\rAr3^ٶ,J(}>ы94\r |FːƍD[ o+)û\\X!xx\"r:J585_Ӱ8B#˂Xޏ̢%m<37rY>r)YZD	p#?dLK0p2\"̏h2nLj5\n3Sm.f#V1.H \nbF 9.K\"7tN?mUP2;\r{;80BR2\"H8hks\"\"^mkEͻ4\0Pי(VTKIaͩk\$Hc#t3VC\nj¶Ш.ް/#zүI(?Xs3ט3hZKOdw)􌜂\$u@\"TfgW/EᑅvO	\nXⴟOك?@{8}\0PȘs:&3(gIB\rBgN\0AQ*,9*UU*4*^UV\\õxXA0U@>2gfL`#[AV\0q6.?rNrN3(I\"XºB)傅W%۸<	-|JCh\rӠM*dm^	)Hc{\rF\"SU-rhq\"_2d18M\n!S~qԚ	;/`f=-\$B@[MI_~o(\$@zI\0((ȼ&|Ci.E䲠sdA(fvURE)&!uĘ[f>[d\"dDLсfi<)LTʡmMN&^D\n\0F%(	EI-%AgÄp\$ZsTg}G\"S|qnD)>pPìח]U\\:Wj0%\$r&/čd_SfeO\naP+D;'^h1𴆒1e[֏LIx]QX2S2́D6g)#xL0TW\rwV54Je/Զ \$V*'\0 A\n\0B`ElzB+2_p	TIFiPКX1Xk0m7e7j!rucH}'\nC[m?7r<\n	fW^}\"Tܟ,ӶȇҗVABeJ\\6W2,f#Y5RY[L*wܖu7zLux!Pn8'9rxr!//{Ew3ІZCPA\r@ݵ	.ᜅ-T^5n2!@J2Fl33Ǧ\n!GzAB*?/&]\n!@Cy3\$EUX\"^[\nan0eXn!D(f tT0*1;to2λ%,D:	ll༸L܂L'\n_x}옸'Kit,)o2jDk=)(>HL;e<VtkkzlIcCp+Ka4cIA aR)	B,eKVPȒDqgIBO|P3x{>Rӈ^CA^4_K`\$a㗛њ(u\$dL`_gmN,D <eBroi|&--.ߡ<X|\n?}>E7OWp-%{v()-دzT2l܊\r~Pp )-o\rdM`m\$\rk\r6p\"^ 6\n-`؛K\n>ψKe>!UB2bήFش\"BֻW^Ë.#4C!-+b:\"]D\rEC0sl^픦P⤐90)3Qэ,rpzehЮD@KMÄbn\r`̈́GđJ؏G	qW\0Q\\PBAFh\rjY7M/rO\0001[gupQ6a*anqbF-Q#oQ\"&lJKB-h&{\$\rjmJ#N`@1`mc/##`Q^r=\$irDՒPұv\\RN8\$<\"TIQ3m#ʣZ1a'&RSF@1\$n-za0z\"؁2_+.|\r(P-ܥ\"i2_\rHa\r\$\n\\k<=&ȥ\"jH5	n1C.	A*\0\nq~8pN\"9\$!#a^.ͲCI5TO\" bke([ҍqBdi҅0\" \r`NQ5SKB\$\nV/Bd}m(kG\"Dc;f&.L42&/83J\"&>c-=<K838GT0d?`0s@b+bTh5%>C w)l@LjOIM\rjN\n*q.l]\$*!m-r\\&MLT1\0;	?ff5XIT7m\rD2~L\$i.Cz	##B\$`";break;case"no":$g="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8!	\r࣡\n7&sIlMzb'ґkfY\\2qNF%DL7;g+0Y'qH16:]40gۈHr:Mqt醡B傽JG\n!n7S:D0LQ(Ye93^;#\":+(#pصa\0\rmH@0j&i#M|:	((@\$H-L܉ ;'2\"B	<<;9Gp7B7Nc|p!Cs69h jڤ@ c\$K&ϚlH4\r㫞0`@RBf3ЕtL19H!}%JC ^'aڴkh̴I@7x@|2KP :52հ6Cb'.+\n7-:\np7 X65P\$2WS z5x ǌ0:x췎6P\$#U%#n	b&;-,&x5R0Xc&\"'h\$2c\$\\Ah1l&^SN8!@R\"[[B̂\rcPBz.˿{n0˯9ۀ[K#l0\"*Ci!gvgI/jL&#͋cv43ڣ/NC48˺ڴtqZs(7\$VF&(ȣy`Z4&r,ѽ*3Z0\rxA4\\C?P6(MgKF7+n0쪔peЪ7qT\rѫrT	N\n)`qIS\0M1:âTjSr\r>v2:0k986\0sh z)&t\r\$j@SpP*%HN0V%^^+y0\\P^q8vhISoݬ4Ơ3`kj\0LLXt&ӈo2/iODBHrȝxRo6?DPJ\$9R4\r%\"Pr1Հb\riBJG-0f!PNL\\Eq]5ጔ(\$TwKOFoMܿ@`CaPI*ȓ\"\r҄FOEr@HZCh}fd痉w/ؙ6Fz`TPoX0B!MV(3bӃ14e(P&>/BsZˉ/tZ8i&p ƛ=b4ht1JD*6,O .bR̜r^LI݊&\\Z֭	yE)`Ly^\rntVEЕx'!M5-VҐP(\"Ĉ.PB3\rPgAjea<'\0 A\nЈB`El	~&WTyY,_Vqoc4~\rRӇ}R/͹u?	kP7\\'!PvHUck-f܅zlY\n˪aĔlVD9Рtm fm̵N!t9鐂l_`o1H(GX8Vw£B86vqiLָhzXKkw#}L4׊[9mЩA\$.%ola1h4ӗrgzf.\nYpfh1əS(R\r։ĵ4D~Ov)(^VP uT!\$\nN5}=3ǃ)!IbM9{ȽW0!.}9	-Kmdr!@FH {p2s'.dvg&ɚI85htu]0o,A117DESAIl\"vS9b)%n\rJ+PaX%skцLkƤhϙ\$<Ҷ0\$`	`!K!sՠ솺qdx#˩IR*vAlvk-~/7+VZQI]A(QcKG\0P%E^WA\nmr[W&\0د;F	}ᲅv\r?xB{]~)ʘ{y'93E_}<72t)zsĊv~;AKsq-ӿ44\nNo\r\r-me.pѠ\"p&\$#GЫ,PbdNc`,0N5	0Fn(B'kPT\r,E4&d8\")f4m(&b}-<УrM`+MEl%['02@PBׄ[/l\"#0pO\rlXr0\"8Q	Ÿk\"PbҜPMmoN>~C\"=l`'n2di|;</vZI#(CQI\rњ\rqRpϢmGG!1_0_\\mqyN&*\$5l.ӑ\0ʙ*)\rr.4 r1ӭJ)\rÑ1_=#QϭH!%\$f\n\\hC&Jb\r&Ѻdc4aD` \r1n\"pc\n:B'>f^ш*pPB_^ʨ2ô0n1\0.+@db\rV\rd!~.+)	8ܚ*c?蔓*\npz<ޥ;-\$g2f8\\(1aJî8'#65\n5^oX#lANb:0HB` ДP05\$6QEƴq	:]O;2qE3N2\"[;fCp#<\n&=B,%\$.:k 4p<	,n0\$4cllN&/?(ĔmMܾm\0/:;C\nc'l4XaZ-Ծ1E\"\"\$8ؒZE\r ";break;case"pl":$g="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AD35/8Nxp:L =M0Q\nkm!y:M@!aݤhr20gy&*u8Blp*@do3Qxe5^of!hp[73qiy7pB\rHL>\ry\r+ry;¡\\b@t0.\"D)*a=KS拎;A*7N@@n) 2Mt'5B:p6n3޵藴򂊌r7KҗP)#|h:K*#\n0	65 P?-H6FN?.Ȉ[\$AH޺\rP7H4¹92cU\n 69?;+CMpAcXxƌD49Ax^;ׁpH\\7C8^P;؃ ^'bmB7\"V\r!^00#)ʃ-Pʈ6J,#n\n-^L6Pt1x	LH\\\0:8\$⸌ωC%dfJ?)a#z̫z#zb@6[0B07\rm\" çIcC8=!ؘ]iX>&\r+@yrɹ2V3)\rètH9#_K;Hh(P:V/]38	?s 9;4}Va%Q@0̌,sx/NX\$.tB*Qlo2YW\n!9>~\rKMV#92CGc 1}|)0ҁ~2aI W\"	ȃ0>bވC#.2X\"@Sl)&6%C£<R37CP\$B\\gС#aҪC2d2HiUH~,h(^Ŕ.9\0pO<Tg#r^\$D\n1EF(;r2E:˜b4;.	ő-!\"5ÐDc@\nǂ#UZՂV\\+xeK\rbp.3|h0&Køyp\nUdpiE>N0r.\\!3X\nV\\{*VXdPCrAC)K~yq|D\$OYzKe%޾0CIqGd\\ByL)*Y7^a@\$HWB#0M!)4ZJt;DM%1?Cr)2A4j\r\nYA	>HK4|l5YP(A?*VE6/C@ЧރBtp*5u?2ΌHc&!;%CjIs3JDD`ad4BKݩ/T/OQ>[\$l\$q@R8jf\nBd9>PK|w:9%d!AAe\"\$2H-\"\nV`ɻE!SuPIR3&'LE?!5ROT\r\rqFM\\v|;\nY8L[pWи/&@\$1yAІ\"iL|zb B\n49&fxF\nq1=`!EY,l#iI;\n~N͚{ ٱ,&ZZ\\5}Ʉ'#6r\$n	TÃT0Ԓ8u\rPp|y.'yi\",ȹԂF\\v{'q[e\"/<*yIo9'^\$[%!`޵Cs5sAB#8!}'/kYb[	PM3!6[4-i8ОJ>9GĔwt歷jYR^052!K[^ߝ6\$_w\"B6M\$~cy+ع;5י95ހq'7=g[`&h[Y&pԯZ8+и\"a+iih^4Ҙy:\$a#%_L&8Aa P\"6׹V	<<(i)Ř*c&0,	FLjnbi2RL#?}r!{LZC^,<ĵwǴDcfS:jƧ\\|_M\$W\$/~D3`#mL|\"B!BtK*BMi4|lDH;?c\\J%kΌvC(x\"h>Hl	\rXKro/&t\".LBc!e\n\nB.X\r.@ObHиCtH%riĤmt\"]\r[%\\Y+x^~%q@pgBj}Ü\nB~,g&br.OgQNq*qePlK%KѰ\$D.w-\nqіlOC1Bg0XMq\ngjѕбN2v\rQ\n@	`JQo  r!b2#\n.Z+P!23!9#2l\nzİƱ\rQ6c'rg'C\$4@Z\r\"|\"l~8#*F\n7Uf&\"6\r\\)D'lHB9ҤH*X|tkق6B!`DfƬn)t6]eՍ&:.R1K\$sPs0oO2(\0uΞ!P\nNh\r\"3|nC:~5NhӠ85z9|><@#`<z8fM\0AC:k\nf͊De\$O7\$r\r3Q7A\$G%>Hs䛳.6uit33e:\r@A`z?_gjd Ic\$@4qQ1CDDE?24_E4%:'aEBĆJ>Gk,Nz;nDsIMIΙJIWHA<.6;.6RkHP᲍(4LbYM@1FAcNBAN<6M*xi/MH\nx#M;PQj49EQ!g:)?øRJ _03UFL-DMb;\"h2&5eUkU\nxf:0'Gb<; f&+\r%\0Ś;%MZ5R`+d\rV\"a\"*C\n8z;\"nˣL{XRPb(Bp-\$v&+-\np\$Y,̊\n2il\ra5;a\n8bvkx(ȴNTfB/ȶ^.y&Hv8]q!BC-:ZRؠݐ;eAI\nR<ЃP+;sl~+ވk(\r\"{6JlV h6l.[lv!&ԥnnQo`7V9^B#7F=	vTVjd!^DĂg1rFB\rGb-fG[o<Њgok瘹4te_Gϫ%ukUb6C@Z6LBط36d`y\\;CoGN, `w+HG;b6";break;case"pt":$g="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTe6\"P=Gࣱi7#In0 Ը:a:LQc	RM7\r2tI7k&i#-ڟMQHٳ:e9al])#cs+Î,qX̸q9W|=:IE==\n\"&|q'o<qTk7N9%\"#p0(@\rH6z·0H3O@:;\nZ*\n'\0ԙRCj̈P&cȒ錮0\n8\r({c!#pҜ#,9RҜCfHa\03o.<k272 ҄#Lƹ)|6M3|p\"ʰ.sӒS j@|ccƲ/20#;#`:Ӱ#	C XD49Ax^;؁tI\r0\\z2`2&@˚Z9^0HMp)21xՃ|1Sj||i<7'\r%͘+3(Cʠ4Hx:l1pe-@ Տfk2CsS#ӥ(w8CfJ\r{	2Hy{`h	RX&dZH؋ԭrƍB\\&L_hP7r`Ha\"過|~\"#<7rV4b	#l(۱8T\$r!=/N3lpl;ֶ8:^\\?q\\O9(\r,}y1oߊ=nuVֿ+?80f=K\$B̲I\"'\\*bK2!O\0 kȫ3Cg/Ր((`sAT6,@A*4ح<UYY\"Ԣ4]+|H4\0pn.d7X&ehp\$04PۚP԰aa®BHP#8U^*ǋ,9,՞byZ]ڇ\\_;yD1vdKCZU\$:2	HA60H5EKQg8ШIcT70rً a?^P>زHy^Gc X4#	0DN#!:G9a\n ( xm͈(( yD`bKDT6LTLջ\0k9!q0X:dMQwxIѼQDPn\nA-9n.c͒PQ%ATFԌPRP!9\$o3:\\#,(#&DЛ:c]TSK)K!r<QDmMKh(Ln͉ke=r?ToB<)EIYk]3ܐKԴzKIy\n5gPI,7>FH+ڵԄup\rT\0F\n҃Xf9T\0\r16,QAY{g0P*[{ E	YK\$G\"`GFFǄ`L/hpj\r44eCdԛ>,]!0i	)D]ꓺ}DjVR꒻K`C\rZ*98ʧ}:GVנ8\n\\S0L	9AXNPAԢ7t%z>]m9&XX^TQ|A0`!\ni&'mE*\$o#xԜq84c#a;0txCFrD#OW*](mG,bcv9!kK2؋5W<Mg\$5qDC}¹	mrj9SDͻy[ี<b\"5 ,:yOg@@ kekgo?Gt6:Lc_s8;)VGEg!S9(\\h?!,R9O,A2\r:<pf6	KȂ/<t9g^_ҹ>02ϧi\r9+kRH,r'T1wϡNM=̣֤}%t@\$(4QI}n^Cnw]z+,&6 'rx)ANABGEќlc)SJdEYxӾ<Loa'^:XRmU=`_;IG>vu\0ny.h\$դq'rH8a2u#׼k8 X֤&#@dp@h¤./DLv|*C6#\$P(r'>̉o@'LD00N\\x5\0Tmm.\$΢6Nz匲%aDPyCc,͊(0AcP'R_o^-^\0.dL\">29N94;F&dJVd\$>,00b\rF/z9BdW#%Դq\n\nΎoq\$?,=\0f#d\"\rmL_yO1q\r0\0@_=\rPcb)^!Q|m~#DZ\"fo\"lHuNEZf:bmr-mhh2&SB<1w3 #Qah\$0M'\0(N&aTe9#?q\$\$Aq1mk%7!(#%`#Z &!E\"2d9O!(\rcJDc`DBْ62z2m*f22Җ=%-2+\n]5k0QD1%3LS.R	\n\r\r*\rG-8; ̢nj(6\"*`kF;f0\"cR3PӳW7\"n{ < k(\r& D\0[B\"\n0@Efy0j\\\0Zg#bnT	GԺB'jF	 `/jЏ8&ы\\r.C\"/(p#R	buC<\\&hHGF~&XGQ\"C0b`\\\0@l164Dh%|Nl~\\60+#NOF2.tuHI25\r9%:RH+1djG6]w\0AL<,bu\$\"x:m`3y>j@,.\"Q2It,8ddĥ(<E,]?A>mK'2N#+OE\0004MaJ";break;case"pt-br":$g="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rQXcach>#Qz4Fi7MjblLQc	NE2PcI>41e!',΢A+O_cfkNC\rZhbL[I9OvqŸnD,\\(ǵGM7k]3c/_4Iț`&U7094ÒN\"7S`: 9A9ȓ@35˄V72k(RRbγ:]\r @j\\9. \0Ф2(#ھ\"҇h(h7#\$/.<H\"|12KPĐ@+ 3B`޿~#* \0ܟD|Ʒ/@@0Đ(<\n\\:(t'\nC X\0D49Ax^;tG'r3_	\"5`J8|N3/Z燁x8`Ƽ(y>Bj :T6*\0@HMzݭ-y	z%\"+t @1*lcx:)Dc1ˡ2/LdC bkt\\n{&#cOb`ӡh(w&0I 6,'ը'&IbhJV<eT^}hb.n1!B&LS>[& މ;mCtq<jO*rc+ sd=]ZH4b#m0Ɉ^r=1Ps	q\\\rXMxe?\0#ͻo@c6x|xl=L|h&L5r|ƁW4Եh0f\r\0c2Jy/%`Ͱs5Ey䁁3U0RqC	7< dM'\nuGQ9*beV&Z+epXa(:\r>=DL)Se=^#Y@~˳)4ƯUTPfeUWj_0rY)єҎC.a̩wJ\n_P<St_\r2kq5\"oASQ\\*V%7G,80h옠d^>%K&Mv%GuӠGc p4#9yNP\"S@\$0((ऌTfdC*Pw'PmXr6J)a'>\n\$4QQ.VHHiR<sC/`IP\nOFZlPL:*a3VHl#DuwI2&伡BO:\$zG'Dy5HFd6扩T6il;D6\$BA\0¢:䕿4B:@\r4r#%>QRSJsgib[qjJ߂b܎\0'q;ywDU1ZEQ1%22Vbܢ	8PT^@- IP6X\n9O31E&+f%+TYg1fLɪ`JAMU%u\r!%&f\\zQJP .;`T<=\";v-<b.A_qAvG\$T;vB>_\$(oR)ePM;'qGJ\nFbMrbPI&7[0A;F5\nZ%&,6?s!*)Z^23NϪKQR'lhF(w,xFaN/Gԭ`Իzr:Ll;uv븼Ά\rdˆS{5%c\rd{+FgQ!|>l&\n\rqRAdޤt_E\"AEюod,*@@ jE?쥔w\0`AbCDM3a=3msE*zTFU_Í\$p\\^ˡsy!4zbTmU\$\rH'b@EMʁK?Cw59gJߦYL,PKsqݴ- K(I#ta|QhCHw{K'DlΌki?u]<ғ`h\$&|_Yc&j`}L\rm9q&jˈTloN.RݰND0;cAgY=}T9~}-R_p5eFk\$5CDmАdM\$`ˠP#[*b̾\0/O/.	n-TAHn%OqNncmRD:J/OQlTǬr`,dpqCD?drpA,ZfN#QPU&H\n<-4@PLLp~Do=0OMr%C&\nM0V^|b>r~Pz6j'Ц5xM/Qkʌq0yJpNcF81/Z?F*bO\"*-rbj-f>U䚖D!a[0OukX9fh'2\\k/ú*d3)p^OC\"Mn\0Ӄ9Q	10)spi9PNP}O}Q1plEH:1݃(fz@&0!LΒnJ#̈6p=\n\r\"pmQ#&*ȂIi \rCf%rg%e\"J.qyBoMBD- Q#rC(RI@A)ґ)Q\$\$(Rvһ)H/c'lϞc2rQ<!چ>̈́51b2D'//\r/Co/35\nk0-f#`Ov\n-bO,2R33R43MTP4 f-N\"3pĩC6-	\r\0#:{(^%&4bp϶^\$^\"0V/%:бja&T:\0a-b2jH\rl~\rVjB\rZ'4:\$}\nq&b2-|POn֖i46!B! \"I\".Ʀ|τj*31 `=(O?#2R\$ǈ\ro27aŨOC`OcbPat^hîT\"#oU;cDN/\"-jMGAQ	0ÜnNv1-:61\r(BNNC,D?Jr)NL\$m=DVo5-HI:BF!FEH0,4Dj4΃&\"X0(>4It3S1N&]L1AKN]BqFc H>Ѐ++d~Ă";break;case"ro":$g="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9Φ㡕4\r&sQFsyo9Z&\rن7Fh&2lAH:LFSaVE2lH(n9Lf;̄+,o^NƜ :nN,h2YYYN)Xy3XAK׬eNZ>A#\ry۳qLYN[Q2lBz2B5x#𕈌S\$0!\07J;\"V#.x掭/qp6JҠDR`*	0P.B,Դ?JD229#\nH/q),#x2h2J`¸+#j\$-4.ύ/\0P!03@ΉxÂB*Έ)y\r <9)\n9oBL*;CCe\\H9`@#CC3:xouTAr3P_זXJ\0|6	23/	퇁x91:d#*:E1-7(*c=UOɇ#N&2cbF/XKҊܽ(J2~:9k,H!#H럼hƍ(t3 3j#b;/)X##,c{#;Qy,T?[ƴ3cѳ-	\r#\"1G-^\"`@8Ðo#n\r8cuVP	Ixu*=t&|\$ǝ`O&J|4vSBO@&Cg7ƇLS\0~]yhr8<|O1H	@L:/RڪEgl9Q#Z@(ؐHC0fOʤGhT\rT\\hcWa3بzN04c\0!0RP \$`3O1+\nS30\nqv)@-&V[kuou«\"?k7._u@;`V&&4|ʀpKF)g Av:сfL*%a5\nQ*:zIhVh[in-z\\tyyʧ22Nײ T	\nu`u/'BSi;`b9IWNl0i<cC9ECI}AE-(,o/eA{5wa\0уr*c1`n4yYrPTQL	F K!5B3jhwxQ<#AX`N:\r5,BC&Eky%a) p|0)Y%2lNiԒQ\$DRȓ&5蝡_[1_?	M'Qx1&M\r,Z1NA<<nrB䱫1t*qJ!7lLBO\naR,቙PZIi!TNzE)^`l5+4x	)Gݗp8W>G72RQɻ#A*gSC(kNIÑ)\\\"P!ڧE,c}a~mj8UK>IҞ]dYLpn\0ƔP	X&i.cZ\\rGD0ùxŗ%E4)B,YHiĆ `ˮSPf[K)Hi3beVi&I4\\< (PI/i^l	8<1Ob\n_jlZ0l)2L	Ab|2sHOSwX\$ڜ/%?3vCkF5v3<|XCg5.\r1SM*j8BA_iop1\nb^݁(0:|n;j0o\nq{:ʙViR^\rB(g%26[99\"_/O̎'qT\n!6IJu[!dh4a+H44-襳aqP`m:,u9&[y5AOW\$=d<u#IR5].a-Ff1œ7Zݼ;q;^+HAKHlW)b85zb7Q/GMR٭`\nGneYG/,Y阮J2`)e2f×0?=A5ۣ ̊M&/\0C\0B6oN\$`çzDdF|JKbjL.M0l\\ÉHfgg&L<m/\$rj0|Ob/m\0dCp,LdE.,б0LSK\n̲0`6#Pc{gjWdnMd{gPp\0p\n%L20n4<Mp1lq&.\\8l\nl\$&=0ҨxQ\\?QcЅ1nlp#\rql\nhìL&!L;\nt<qþ*#uZc\\\rc;^\$>%R[\n1^#JBcۍܑ\r3؆1!&/!g\ro4qj cF\r1p:+\"-mJUG\n,*#.R!!1}N3%p'T`q|;`zu(db@䉏j`f9(8|eJm28Ly,RR!rR#ь@-(#2vB=(j\"q!,q\$-b/&|AV4 !r\02\$s)2ъɓ513?2U=374T25I23^b-6D0.r]6cLnmLӁngnݨBUD-LD``9x2s/:ӛ;#i;`:Q\0Dhݤ/.\0Hs{%2uS>g8Q-dy)@Q>7A_BP-rAnR40	({[-3To\\c	?EѦu/H+F4TQ\"ˠR:&J\"\$fNvUi!ìc-GCT{5~NkZcӲ#pL,DWY&G |2j\0\npC\0hKfW0P.;Pn2!B! {*0̬@{bs|C3FʛL#3&oB\"H)4rh- Ȃ^pf\$BFJfN]5Xcdq`PG'Ή=5)Qp\rY[,>QWC[7̻*'h6Ӹ0-X{:՚G1\$r4c+g梣ly9\0hDQpx;Qb>,\$CdLPL*@c\$.:\";!\$nS6p!Ί}ƴul\n^y\\G\r3:e+!O8-P\$c 	\0@	t\n`";break;case"ru":$g="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4%Gf\nb֬{R\r%m5!s,kPtv_hn]#Pօ'[\$!&chK'FAIE\$e6jllѬ2\"\\횩mKV7ťs6PhNCh@zP<l:\n,c;jA0p9m#)Đ~ZĎc(1^Ӕ07Ϛ8ŪGHE *8C`*c	..80	9\"\\ҫZH8M\"?>jRʴvȚkKLd ģEQc*\$|z2qR*JC<h|5J~͑o\"ء(SςZ9Ԫ#A	 Y*Wzi8(vI>6\r.רOOJ/=N9w#П4# 4(B5'k֢D_ERs/C\rS,[ӅG\0x0@2D49Ax^;pÇb\\7C8^2x0cxDMF*+~%H2~\\x-|%H&RũD	pv,Q׊zֳ9@7&IK.QiP/U(ɑ	0v\nKb=՟-OzhKb?IxNp&RӋ3yRRFrhq̷\$J+d)#;R\$Iz{>uYfj[9漱J(nd<JK\\J\$P+l\rR6`Q[01#Yd+]\"pv؋AL(Zu\\I\"zHDZK')9U[A/J8pLDhMstrm4jSiLK-7g\r3Yv 0I\0IE.^l\$@)yYe:0̃\\f: !9[y9fmp!HgX塀Dh'@)y\n\$*\n&Q=sA3l#BRq0\$&J\$̥wP IU8\n&RE\"cb&\$E;M[#P\0E<2|7[>eLqJݞ:i?\rf\0d7຅qRJ{OЏYdw0xQHP#|r?QǠ1Җ\rLhHwNY1KFj%S.R2VUV&e3U?R*hX|S\raD93EɔyVac*=6j;g6[Ji9-t\r2٭5].^!AZ|39V'9P]3f%4!]]y-D#A|Z	\\ig8gL4Fi1֞C(x@96Û]7ZXL%!|N\"}J Q\">9x}(P٣ h*&h~eB7\rdvF}2:;Laf12cURFKFE;TZ\"4\r<CNq>IQSrɢkq\nKD\0!heeyaL2\$rjmo)}CX(8Ĺ'J)vxWs5ɦǤ5UTDrmH-\\zZOf\\f,s00-hչNn+Ċ#x3+ZC'k.!nc4Rdk|>	XfvIi͏rCM)@O Pg#'7qf OF~IQ\0¤?^fvkQ(́E\"K\$I	s8AtrD`Rߧ>d-~2\\pXɐ-|ٔ؝y})nV!>\$&0T\n\n갭%N'l n14Jfv-@)Wwj.==gk{Ҭry{Iz\rRHG}-ycC;lib8(si3SZuT\nxX8nAZa\0i\$T^O/2I)0qꏾA)ohފLjB(mK&GzVrrJ36|E2\n\0\n\rlDvʜjatI~@\r^\0b\n<kzFeN(LqXŔ?g20+H	AnG쮁(D0>AZ*'EGz\$7O\n/e\\Upr-P\\B^uhJ(PF*6\"G\"GqŪ\nfTϤ/߯D`\rb\nfn \01g'-Q5tEcq\$\$Îs\"\"fpbR-mL J:*pp,NEo~)G\rPTȱj~\$g<Շ \n`>BC-.L[\\\$.o+@ Ghv\\[b wnI%Jo{í!O06*.04GB.>A&\rcN`PD*B'Y|#a(;(\$2(sdtGH)*##٦6fLJթus,R)--r(Bf|#a--\0l#/s!(j2ǈ)0ID*D 9RV2^#\$B8RC\"sB\"3F!9#SN&=R;/4+8)5'5Re#6LNI\"dG6{3r)\"\$_	-餲xzī#~ǲY&\0L.Cq:\"#5D9f/JB*Ҁ\nzqķ>\"H,+>1+}\":504.E(Lyps=T'02tǔC4 mT8*}18t0\"Fq?4x%yF5FSBM;\rP|؂WЯЎO#\"3!7*bICTXIROE%eeӈp)vxELc,!BwELLLQA+\rB^Ot(h\\KOPt:.h(C0/RL=T?+POQqR'mD?\"J@#Ss!V(qn\"c/P=+KjCV02WH]+WOWaX3*HEu;XY5q-05y5Zұ@c|)UU=1%G3'ЍѫTD)o;^O>QXЧ_\r[_2^`'Rt@e0ģ.P.AD̄g򎋜`VBǶS5HBȻ_- \"˝S\"f\\ )O2ŚSzMV:aU`-\r&V\$EeE3eFGϣ׭tLq;[2MlqAa}HlQ	lߕb/Kb3n@lM2sn(\np\rYvЋquKp_o4Qodm3M1,ro-spobx&a\rub:uQ;A&QdL}(\$ZGBUpwCZ5@vSD7B\$7xtKYu%s4Usw%3BS;44znЌwCs{\"}V}D||o\"I#4@WAV)֓\$f<a@1}4T.J\nď(݁\rbs=xuX1|QH%*/R#}C8^cg:tFqT{R?#WMWe{d\rfjj@@j\0@\r|'8x\0F%_\rNqn`' 'xŏuBu(v-1Y8S`-E2	#q'|qїtBP͒VP3\nt ]33obk	#HYovPOk{\\-K2QC=wyo30*xPYOt7q&Zrkvw)2Yʟ2Y|=xjE&oc9\", >q\\6\rB'GM[Z)[	!r#Մ}ri\rVS%q%X\"lbOGP,Nʟd`RPc,>6i>5b\n qsh%Ba\$<V9\\ZqZ	3M\nC#g=zٹݤb%3=gFIְᰰr78MyԚIQwWV\"G5'&d\$gV@Ay34W\$oq({<pBGԇD}v4[\n\$SfdOAbsLOC\"eK%(D[ho)rO74 [+p0]؛`mÎhd	}*%gOt/*o1dF,-:ЀEC3Gh;ZpH[\r5j\\\$\rн9]Oа걛ƭyY>u\rd,'Wy8d88XoIj>d [IET0ˡ";break;case"sk":$g="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8yj)AB&sLR\nbM&}a1f̄k01QZ0_bԷ  _0qN:Q\rA n4%b	a6OR5#7\n\n*8	!\"Fo;GA#v8.D8ܞ1*͗ə\n-L6la+y5O&(3:=.ϐ@1xȂ\$2\"J\r(\$\"<jhBz=	1\rH֢jJ|)J	F<\"%\n<9\n\n)1P),`2h:3. -\nn9fR<ʣ3\r4B@P7[0\$Be\n;\"@ؔnC\nEXEQR# ں*lRVR\"(C,Q\n`@!3:xc>Ar30;c ^(0a3!ljx\$\"UdC{,:BKMBx\r	SIx'&h5*-C\0ĳN9dEˠ!t8!5B\\8:A\0LqDDr`B7x107\rm /o\n_/5*r.5##\$IҤ8.bL4\\bB櫮YЉc*`5M S<r,&.Z-t=`4t	8aw2'VTp]Ķ͂{HP\$\"3n wxwvn0ۺ\n)5sX9#u5ź!p̹F̣\$\"ZJ#{f2ty7Dhl=SMADd?YIXmM.2D1\"'E0(TiCG؞RhI`o\ra9\0@FT'jh2dB\n~#(QXg\0V+ah8jR.C|EAM\rCJM16'\"4Dwb@Dl\"FhRGhx(eQDf,!!<FDr\$E`c&)ՖCWQ|X!e*zdV>R͘4bkC\0­vDgS!ZNǬ:4vtQ&BáEwPr=HX+\rbpTYh- ^Ɍ\rmn@L	R-PJ20M.FIZ\\Rac:\"{нCGLĄ 25*b\$f 3S\$VC0t	Ze~-Ni:>HK̏22\n tBrT#e\"(Td-!z)\r<Xp@\n\n0)C\$X8\"Ա&:rBL*Lhf0ժ]MG&63Jq9DBih2*:q&dZaIΙ8AUfa\0FQ rvpMB|9\$Fz	!&%#;Fաy_Ed=k/d܂Gq1l\$&NYv|ɟd{!B\"b.)S\0P	L*/#@\rǖbk C7PQS0wۚ\nOtRdP\0SrD<0(KfRCz,(!*I3'DfCvNnB.jɴQ5يjTEJu͌r[aQe1\$i44t	6f(xOl92^gh:ThwDKu^;LCA)(j(Bҳwjևr5NAT%!L̰ĘB)FO&\"2uTu^	\\q';L\0%Ժ\nem\rG78<u\n;l&vA8MFhLl=0`ȝ{_`S}(xMh^S\"\r@(!n1gOrG9KcsG!tpÔsFmgi(\"i\"nX5R2H*#\$U#G8\$.](i16\nP 0Cs!f<b9cRZ^/*̌@ď0ΓܴV.6If.Gv mԖ=qr{Mjm&'{Uɑ\nHa\r\r\"#|t*/PVj(j錵70>q6_J#AYjO\0n ]\0lFS#4eb#'_\"ðᢈP*R#(vRI@ f!5`CJNh#H1F\"D^x\r/&@MFrd]X:Kbr&!`,C\"^&cdCP{p;⭰#zψ!dKiBB^0q\$>yǞ'!LhȻJDpLM.\$`- ,ʅ\rqD'nOig^ml\nNRaPMPmtA=Leը|`0e]'5PѵOkni1+gQzƌlD4_,.l%/wQc2Rl! rIB;!%r\"֪r(/|΂D\$,T%&RRl9]'c \rF Ljo)+de!'/U l%f;)}+jF^Ϫ{тxl挬\\)c毤l/*JJFBA%i'΄jO Qbpn^2fdNDeg 2],\r&.A3R(M3(v2M:p36Wqysbby\r}(bP0Ш'6IL7>š/ct?&l&d	b<\$n@Ud~.@0o2.5]	<23#p'Sz1!suxƦpf>RCs#Mz>k??r?:p+\rbjEjK53l\"64H!=CcCSi\"PtRv4ABT	8wBB6fUR<=dÑAJyfB_=Cq=sj\$47?DRԔs7H̘pK%C'30R!C7sGKaT8mD Gd53DODgK<NOdO]=tOa}(4C#C/<M\nNmL18U;r\nc%_TB\$T\rE\0u\\I1.dd\rrN T3WIclψ##x*@dKc\r 5F5ka'+@7BLIGG>FP+*RֵLf@\nZ6q!\0_E/\05T0\\G_\0RHc!D\"b*j?D&\n6M7th2B6eLJidҀ0òER#y0\"9^)&ABizA[j^=&\"K2-j(ec7G~-kpі8gl#}\"(i/tiv 4pl>N5b/!n9.:l\0 2hq;4b߂q6vqr)ZJDS,7@\nOEp\n6:-鴕08%`0lG}gF]ֺ-B,ӰV^U)wcfަ=E44mhc#\$ \"";break;case"sl":$g="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n)Ǆep(0#Upz7PI6AC	laCH(H;_Iуdi1ȋ&aCl2̧1p@u8FGCA9t1f\$E3A}kB|<6?&Ʒ_7K08ʱDы*PIFSԼU8Bҩi;L#.}Np!7c2\$B9#hXϿ2:V7(@	T<ˌ R~:sj Kx9,@P\"Ȏ2h:IDr<C\rk86\r2<+1|\rn%\r2c'T~9QJT\rH)52H2\r{>Ki1l7V>/@;CA+p9Xx(C@:tT6ʈ9X{90^'a926cH7x\$NʫpBޡ\"3 ĵ\nj#!6mB	|5qO+ĒM_R_\0ӄ`#`2`P'B\\.,ɼ)2P2\nsS6&yH:6s־ë1S2CnPi%4+n\r8&A(R\"\re9(*FXy630k7&-c\"n4spb1Wr B\nSho<;|:+;\rF|HŮk\\}\r.n'hHzEpdid93-8ÑSM'LBz}h<#tcm[O Va1lln2\\\$Bx5,7v <0fe缂#(Hڼ*S*[bg` c1XAϨuqAaC	َ!}P5JJUX+%hy\"]c}*yrJl)@Y-!ش\"	ȏBEnT	@b!TJS*Tbx9+5j߈\n!#H\$B4ޒ\"a DkՃE8rTg`!(Faє?\n hHC;+aH@18HF0SDH1FBa\nCHhB]yIب 0\r+Nf\\̆Y^YO)?%G*HXXECND!8A*1\$S1:kdpFX,B%/F pt\$v8i\"HZx8	'І2('T@^,\"N#XY<3m\rTQBYǴByFHc\"J:f0%hD4XP	L*FQح5P7\"+BD澚XrM6T1@܂` x'IaB\$2-nmDX1cvFYVʓ	^Z!K*:<^	B	]\r̳kqEMuDҹ1\"̍RM\rI9Nǐ3<`LT1ȦrD=2v@tU,!#vFP7nj_Y݉=uc&%vBsΒv`G\$L{`o68ABxs\$djlXTtF`:<L!LB<BѐH΅S jČDm0eVS.R:ul{!\ro͐j]Mr_HgM &iw!fjt/RK_,{VlKVK9zY:I\nF^]\nKmhiy1*4	%,'`C	\03s3Pbu\$oc0E0\0002-7_z'zޑI=U\\O\\JޓnCyƫ?RЮ1qxZ[~#C\rsY/5Kr8B8w602r-0\rWgۄȜyyԹ&E.xyq<.i`}ê[^ku2j;V}\$ 'vIHfB3=M^Fݏ@M_[XSrH\\G	dIy`nL;1tMn (ɑ\r϶FpKl\"Ho\r%z8xnCH[ñp{1ÀbnU\0Jsne̅X2+C\n=yBZ\\FB%ŢАK,\$ږ\n	-gn,H<IILF;L̈\0L.L\\Db\0l1	0!	\0Xr	}0XuPpԉB\\%9(8b`Nm!q#	fh1n\0\rpNbbANWnQN߈<-Fan7r%\r~KNw\r0G06x71*b&&b<Chў0(ID\"\"5І9l2KbFxCj(%Q̔ 2hf=d HH!%p&E,`o<7\\Q!;\"#qt\"k#-\00020'LBM\"Q#I%S'm6,%m%#LBJK,dc/Vbg&i'\rc\rf{%-20#Ŭ[#k#pgdpNK'=\$\rfy2xZ?B5]0̀\$mO\nS/ i#1!1+1Đ~)0\"bC	ү#9\rp,4>Iff&@LbR18.ɶ\"(ݳS6W6ʛi6@fhmbB^@#-`\$r_:9104;'<d>M&Dۓ):N/\$;;3>\r#,&6B+i/|4=~,B7EC{BlZ3q3B\"18\$PX@)7( \$oTR2Hnk,5ET~.CCt4|䞄\rV3nIxDDʤ!\0\rT6\npz4//'1\0TzN0WfQP\\'Qj\n_cX\$¾@.M@4/5j+Tl`\$9*b-P3`hj줁>Vn:& 6L6E .A٭ͱJ \$4mu]l\n!Zn&RΉ[0323p91@\"e[J2\\hBdZpaRu8\rb`v@Zf_K\"9ZD2ŋ)lP`E	]SF/ȹ\"cfZ0\"Y24t%mh\0p/ercUJ@2=0L\"d4#Oz`L\$";break;case"sr":$g="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9WhtuO`J\re;ьF\rgKB`X42]nG<^PdeCRFtɼ 4NQ 8'cIg2N9d08CAt0ոD1%Co-'3Do8eAZA)@{b0*;p&\0\r#p΃4\rY] s(>X7\rn07(9\r\\\";/9 踣x:Äk!;ƣ\"N\"\\:C*	zE<E-¶-н\"#JҐ+d*{^@51DK0jF9AhuPڬXD**L@2^@-8R6U45z'QƎT8ЧVG3RD=Oi1 l+Hc#1#*3ݷ,r1Gn 40T9`@`@2D49Ax^;ppqj3(#&\r\nѨ#x|2\rGYA,¯*77ҰeýM:	+YJ\"oVˡMƦۢZS:'Oږx0Cu悄\"\"ѽHiѻM=5(T2_Mz01 *jSO1a=b&0d;#`26fH#IKCDj?3N%Ѱib\"ˢpOI2k+Cf\$L4#L[/_bE-Fu2٣פ6D*zk0Z&JS/k*n\nTFyY9j))I\$/L*/#O ПhM`k!pt^ck&jǶvԂ B ЉB-S]:E`el,:VڻQlA<tKs\r`eD+C7;ǄG\0@Qn&GC\rɛG~\0\nsfq<D\n0A\0uawA\0l\r\n6!0nh0RV(%F&O.\n&b\nBpKd\r!r0kb,Mv2L}5d`NhY[ycE5HlKeW\$Brji?kJ\$vv%dXZN`&p0 Ęcݍ1܌sd,@H)	<XI\rD#\\vHC[/IOSVidSiDblZ\niuh!(4E<Y _a6\0q2F\$dҞʩX:u|!emZC.jz_FL,	@\$dR\0e99in̒xc3NsNxenI9Cw\n;\"L\n2gRs!\rZdFL0\0W q.&`m;\"lgb@#WI F)bkb!\0\$xFE _*Н#M	\n6M=k#u@(4!*J\$(uW\$& ӤË\03#@5)r伈1ʤy`BI:UJTGP	L*Yc1JJ;5y,q&-(&DԂn/	cE\"Q#\r2`,p%t`uS^3\0e1`innA2vCG\r*q&]<(^H܄P*[WB^4M\nm0*Lg! +c\0B`Eٻ>Tdmn\nXdba4\r!N-Ւ5aY\n`k-w:TBc/f]nxflFJAjLfsMǋrmNo,=7<OgO˄\r-Mΰ^Gubn W4OΑhO\n\rIp2ZlOV-CJ!:\"\09Q'{zl32g0\$dr0s{!S1HEN2S7#CЪ(Z8o&QC#!%|F)fRWmG	>ᠨvI8\nu1\n_5i/!IJ8OT7F\$s/,0TTJ\" @rxϰwbKPSZlm\n`Dm];Dzdn&@fj60vfʂ0dJ*LBh.Whb`j(?[\0\"+\nc\r		20	/Q\ncK0)P,RF0\r1)K+2.XD-ïh*ȟ]\n+hK0W-neq9	q=	E1.m3\0QWT%GLXh!\n',%Wtk0%?MXhVqZ*M#b#AbV5C|N.\"P,xexN@x0QGL<C'ox̀>f1	lk27n#\nq AC>DމV7,|tj2F&ŬI'HN0]&|{CD (U)gAA\$4%`xwޢmK\0h1rho\"/\$c^Βx%,.g(YPTW*h hXeQ&Rr')+U\$ܮE,LL^6D!(R'Y52sM(!0Z+oP9'16Ȇd|F6A82'cP?U(.'ĢK6F\$R>q%FЯ3,bƣ;0<Gl<1_==S*>0=3s2^w6o)2U3)yA{:QBBW)wzH\0Q/\n(\rm,Nfx\r>R!>p`n4}>,TbrM4H,TO=g.\"Hqyk7**ET|t'It*x Ϥ\$4X{'/G#\$=gpg.kC6[DO8nkB4-|dD3h4-Q2?PR>5/7%Rb)UDSPu*yƇ\rh#sSL6D@\$\rʼ[X#'i\02tS5\0Y?CSAZT=rQt(R\"uez7	6ua]ΉDo5֓lN/#Sq^3՞V\r%^OaBwYAU&>cd_QcbhpR@T]HO`ХJrUOGkdE-jofpt*0gghnʏB\\'<\\iP-jbUP)vdӗQR\$\0vOmD k\n+YSDV1buk2HK¶DO īpdGl5akTZ5>;BtƖUsU_N\$2oaBPwthݓ4hK]tWS?XPB=_iuF[%w7~LuK>\r\n&@<n`\rVV\0A10D̖F\0\np)-P10\r7WutmAB\".0fY(և	\06CSpMK/q\"1|R+&b0`#Q+9*u}BX),(~4+)GuoYQ+)RQ(.B.sD282yd2Kk8'C;42%'XuUNW{x{yM#bJa++@tҺ{\${n4SK\$T1@-4f,%p ]st=rĉAJNȃvzxfF';%\rz#ΫS0W`ր9C:L\\YX+ՉHx";break;case"sv":$g="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7AL4\$8uOMfSt7ASI a6&<b2\$)9Hd7#qu]D(ND0(r4\$U0!1n%(Ɖ:]xId3O\r3Dpt9tQN!ݾr#-+/5&d~hI':4Td5gb(ī7'\"N+<c7\"#̋죦E#μj(\n\$Crů\nL	è63C7M@=9<˫!\"\rh8C*҄3	#c<H<*)C&p&?,5ñH(,lD(4\r̫2\r:/I8LD9]!>JU\r?\0\0x\r0CCD8a^(\\#szJ;!xDlSr`7^0z6\rMK\nHFc:¸򭐖.\"p/-7`Aw\"H(7в&WO8]B\r6rvF :R\\c\$95Ve5B07ZcM#8.)O\nU+.dv)3X2o0<d(腧F4E6c\\E9BkL,mn[Tʂ\0 M4m%9t3I#8	#hᘹ\"(Yz!9[,Z6m,05A(6`\$C=20\"f:FQMv}ϐDKre '3@RN&M\r\0چ.Y\rǩ5J\\gXÓ['p;t6Rp	υWr}O\$C}ւKCX\rh uvC~P)=AA4\$,lVgM		RLU6TTj;xhUEVZ(bl*c d-?ޚPB\$ :`#:b\"\"5#a\"q#Tʢ褫)1[+	\"()1ؼRAo@>G\rQ	I7fi\r+ 93;R77/RviA\re(aJƝE ȫȉ~T9B9'.mzȌIAƤ\0l-82}d)@kH.0sơ3<Q\r0˙6LqBD0\"AГˋl\rѽM?7	u҃#!*ca#,d% nQ\$QFL)C\naH#OX0 qahzP!^9Xšdʍ!x&)t'+51*TBPՒOK\\&l+RT9aD3U&tPAOMI`>HL(eDa@'0Tb3 <*HQX-s1}G Rd=?`I\nmX \rIP(\"Ӝ%=\"Y\$3	N@2v1dő;`\0U\n@\"BI	f^p@xR\nP p|_(x0PD[R,.vL?cGL1hp˾\"FF#|9dB񕦖おRƭ'g[= @9h2w\$1+<X/gtXdH4gmʹu/&n))|ҿWfay:L݄aq%?RKxnCy΢0meqs5ACPD4Xd\\V0xb<Cv\r,YgGvFp,ɆT9jAhd֛ei	hG*E|18W()(hj*>\"-8^)a!gҟwhS\ny#xTDȸ/\0őUEd=|~b1\rPs~k˄`s0XN34K0cxi	Jz߭[!`\nzrPIYlᄔ9p~m#1Fi-CY6̮亩X%Rq5529qqY=yJql0emÎC4r\\qJЖ\"wY8rijcPӍ'\r3\$|3zhoy=1F'0F8!%\0&L3n-^%yylv=縌lYS	4<MIЃ9\"\\.>(W>\\w1?y~ߢ{#ߛ7\$@:R	nۢ`jKH4LG~0vi(,N\"j\"mf}mƏc0HN,oDϔNMig~`ZibA	p?\$lBIؼ\$L.9@=ÌaJ*X\\'svԭN5#Ռ5ϒ%T\\oF[MBo1N\0N1/\"0#\rENРPv\\?,\r\"5Ji4\"mX1cqO%g\0001,[Tf8d:5.¾;#cf:X6nQbZhĪAjJIlDJBPK0i~lLigB\n\nj\$(.Ep^`Ql#\$nT2O!.O\"r\"#\"mx\"HN&\\3~< @؃1m%jRc\0t2m%\"rR\nr}'\r&\r\n=\$dr̚oyKR!Ҫ3BRNH[(@>c\$=x;\"b&dH*Dld/@Nf-\\%1^0eY+W,Ns0-*2U\"f\rV\rd\nO^\"kH/*Ǐ	\"&> p4\"O.ƀҺ6z򳊢c1x\0rq/(\08fR<A;%(^8o!DP+Ŗ	R0ij%Q;D@\\v3<^s.P@k\$15ǎƇď@B \n!9&&2g\$*&B43[De0wJBpnϠD&fK	͸'6=(8dMH<bJd/í<7>P\\AAl@,q@odrG1AF\0U@";break;case"ta":$g="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8U_\\dj?&JGFMSIXrJ΢_'JuC^ʽp i4=xS/Q*Adu'c(oFe3NbNd0;CAt0l,WKɨNCR,H\0k7S*RޢjMY`,#esrʢ\rBB4;2)(|\nD@\0P7\rn7(9\r㒐\">/9 ;x\$9X;̣#wI@k6G\"I uW(R0,d\rØ7j*+]!1%n,Lk\n.uHY3V7drڱĪ\\)Kz0\\W+q1ezwv櫖J)ӮdBH=Ͷ\nZ̫kF87-8l2=u@)uLWbDh:a	;@@<orR\nh)R_9dMtFa@6f\nMilƪl\"֫\n@ۓa۷J*4I+qj8Jښ#A5kEy# \"LA8;:\01oU=\"t1Mn4039`@q@2D49Ax^;rW]2x7=ϡxDlȃ464}?MV=*bZv±SXUU+c0_Y䀫F@2x2y.lP*V-	VdҐW!7\$@AA(dE͍v#޸zi4W[U5\"jW`=sͅKDav!:WƵ\"8/8WunaT4̉` p;TAAe+`:i-qlRH'oƵ\r]t]R}KU\$x{l9b\0a<1ܐBL%z3YHFF\"HsP2ƞB*GP+\"N~ZCꗏ_FygF:c\0rq	GdL+Y03|.cCW)xuHt+402VP(	&;Hi3!ѡtAO-_RMו\\,A!4Ltŝ3V#zHL\\xavL:XݓA<Rj3O-FŬJϴ;e2V d2V\0s7pb\nco66vfD@@xn (6ރ4?3@v5ZAwHO(`',[rn(Тm6ҵi	H\ni.tc{Di\r!ܫs.mιBbfu&yޤZ\$f,3b4ץ\0ٕE@-\$+54UUW!\nyH	\\\\ba44Nn{ra9<mWeӇ'RUfS;JJ\rJh w'bq\"ekqeVy&\n;Bzsva\"A{o!K쌘YCٗ a` 1ldbj3%j[\n+*gDW(bCz:F.Kq,iQ\na8{<X\$ti.þ?5r(2>\rG5961;yo Gpq. }ChU9f3\$7 !0qU9@xf\$k/U).Qʿ,Fh\$p{	WNI&yAq5Kȝˎŧ:Ԫ{Fxi{񲍤+9Z*N\\錒)*_6Z}-QZ<eHy:=nL8Zp m\r)M8n<F!UH%O\naQV8ՇAJJ4lgg~ȋe~k	hRhE\r6<;Few:Diru0rRJb)ASdq*i=M;q9\0Asr(*ŧz%ţSUWO	*\0BE_@/HB=a<nRا(vpbabꀍ\nFLM\"f摥p_/ҧ|knxGD*X/^[C>!Za.)jRjnJ^0:ㄘhj	fȮpx潃y̢biHtc	%o4<wԌlG\0iқ\n<hd)\nb(Z+K޵/g m\0?CdVj\$\ny<?\nz`鍖 t#L2*wʨ`fɹ%b@%K舲:Î9NV(\"J\nG(r`\rHp'p ,	 \r ʖ4k@Ίmm)P6\0jV\ny,J\rȄ\$\nm4@´l\n(\$<)qP7i5gL-\$\r˘[\"P.Щ\"m6dI')\"i%2N)0Z\"70J^`ˀ\rb\ng&>#rV1 7'/@Dj\nRf`3(bc7+g\nD)!AFm\r%frv>&HQ9)Ҽ1(b	rQ`P,am\0PDj:F#2bO\n`L@N\n\rp>Dh:O1*\"B2\$la\$!%00I0\0]0O1\$nе.L'RtG|жz- \\-_99E:S:~d<92НӣS9pURB\\2=r2Sn,3-5\r-oBs>H43Cs`I\"DT@.OE,gD3nQ#	p@L\$ViJ(&u#IRE\nOz}`\$%`Rxo%,G)\\bߴ}\$#7\r)k\$S\"U6`3dZ1UMn\\bv|`\\M-L'R\nS=KnfU\$|Sb;iH\"`Pc΁fH&Ady\$79\0+jrKGIK@dIOtN.QSMuBu7s&RXFDԨiUsH4vxռtu;E5cE~VE__TU_w:\0Tu>@TwU9OPVrЉ&/(x|XuG\nFLઃ0AR+U|tv6e0u848*v6l\r+_I]?\0,'h䰩\$Sb[v;ij.5m#26\0,2LGt3t=q0\n]՟buo,vi62,?lpu<W꒣DZYpV_yopqs&s`'tw-4ab5`acTY(#vbW+ZWvԚ5<Tb(	/cbl*N!zp5TmN78>u?3kN6OU<#{\nYwk,EtY=82]}_?T+KrT*lt|er`&Q+vrXb贯J17&MpaJsӌ8+vիw3yTЪ])7v&aO6##4^5rQs\$V5_p\\ͪMl-\"+I֤	]TT&b_)uB!\\3Piы\r=I?)lSxs}5@jc3V \"xkAA_z5QYMS/yn؁+Rw+G]'!\r!Nk[z6\r|]oՕpcx[)!7ۙUsgySly{yJCbjAR\$&P\r5krudC0y՝e\$LXwI\$P9h9#\\92ل;+K%ʔd:3V7VupFՑ\\d-I㏦5NIiEmVU].xyuq/ZuW#8Q)?tYpOO=G3y2SYJZA:IDk!ZsRMk:Ԑl{^|?8WfGZŰ%u	39Y;;3\$[K#AjIX%\$cKn85xm;yn\0ˤ٭9:ϛ\$UV{;J-m[s( (cMmuff5;=lɼR\r{ý˼5 )@)S~M:yV3Gk|GҫM[q{;)<-hE;]yXNěl}[7__VyADdk a\\=^*Jѡ+1\$ka1sPl\\B	ˀ):2z5x`%0YiEEGWx8Vq}3eqQ/\nZ|)NBB7aQ\\pTD#g(,(9:	=HsDmuN[.u~0[[Ųh97W֒ޅ\rV Ӽq`@phJnNlۄ\nZ\n=HEkgɽH\\^|>]s;/7סZ9Gjܥ״]zcʚ\\-\r0UxC&	Zwg1\rSɥpwOWRUO|{f\$x{w&T[|;E)rlrf?qH܉nI~sL~m-Ch{O;]\nJ\\(QV}5\r6{¹S#,SKU\"x̤|>a|e=c;L\04 %^~?qBIQ/l>\"𜌯)(dH،5ϰ7PDvج5jFM @&W׸Q`ZwCUZɉJ	Hmqf=)\0e\\XN[' fHd*H#zȗY)uB&!΢&s`\$oKx06Ɂ\r)hR50%z	j&r!j]·\$\rh\0&4@S";break;case"th":$g="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=UW	8{#+&\\K#[[=-O5,%&ݶ\\&TJ}'[AC\\k%'TLWȽg+!'MbC ɼ 4NQ 8'cI3@:>2#:\rL:#-ڀ EM˘a9~NsL^\\.-R\\\"CCEÚΩMR:()E<)CH3srR7!pbLB5ø7I#|@9ÄC;\$(θ(34#mSAJsت,pA\0b)>֪m/:\$JR\n;~&uU*9l\\S,?#NDN\\MGR\\Ə6\nH#\nj&4ŵ̝{8R!*L1	pNY52-SR<+/օ\\f)i_H.!؜ϊ8؅P'VŶeJ)7z)zx4/cWzF7ȢR2\rP4CQ9P1#3>S;0cݶu 9`@n@2D49Ax^;pðlS3(ѣH\r-#x|:RJ3+|ΩɃX\\铎TKS{a2I7=nzfLÑnW쳺\\;`P0Cv9A(A\r!씂#ȗF1H%	#ʜ#.IGgu/4∅*d!hO	݄ GClP0W]>[iLd&h4bh#2IN9ZdAҬ0WEᄣv|(MJ~D׼P(gtJX')2@\nI(#C؀ЉP0 A`ND0ߍmDGoedd[k__;f^S\"Q\"@evd.%aJ\\5`x-	<YxBB\"tQS;Ch}*\$^hBsa1tt:5[Ta.Cv4yh >X@-,\$II:3D(oGdan,cbBUSC*py֓VC417t0tU(0pEhih:PM;t)BP~/\$ŚR)'PCKnIl5t4Fq=ȹ7*˛9B\rт }h][\$)H FtW>+pRr?MjѪI)s7it:\\Zp&8 䜣s9烓tN:*Oi]XI\rD(IC[Q֤_u]Ya0<̩䭮v\\Phݰ oC#0ksptFCJ@xT9پҒv)Cm*jȱ#\\+<eTvd@@P\0`V%N2yeQ(Pb0s@g+ma po\nL~l;\$HƠlzuu	5(sA7\n]3J܀ H]n8=cJ\0C\naH#@\rj[@3џKrZ.0\\LNINF [я@[,[\nBKBd69#; -ja\$MDEA\$d,nPÌ73'pao3ci1D@<DeD;\$f=\nE-\r4\n2\$K(\0ުdAkPrDtsq'恪nY/3 ?#L#_ij.(nzG<a2E~{ ŉU&p \n@\"|?&_YA<@/Qu</xތ#6hYl\"W~ɓxdd'vlCYg-?047ZZl#j^)mZ<lO'ߗfRz̏Fh&6/|e5)jEjiTD@MGa2NawD\"~(XI4h*ȴc'@\r6#^RWƜ͞\0FD/\n`HpK欨pKx@昉͞JMGM*+A\$Ǌs?POȾ\"\")`|IF^dCO\rv-n_DdH|讏tdNx0ͩr`qp.\rbz+3V&2,@c\0dT\"JHog,xhPZ*1xb:ͺirZHeeEE4 	\0@0Pg>QmΔڎ7mDHp;eDd&QڒgV.g:()\0>9OFN /4a1dDeaJ';\"\"BlZd)\$JF	o@NfC'E6[5D4.~/!b&WvB~9c4NdN	i,D*D{#\$yR+H;hd\$pG*H7I'(00''c^dOE#%z7ض)6I)FO6&Ԍ&G4XJ2k5zX}KhѣVST87U3xU3nS:bBd'48-0p87:BO0\$g;#d]Q2.xg\0NX@~'+Hc.'甍̑jaG1<C6\0gW)B/Ue@XӼZ=0\r @==As=orZяB;.;2-e/gqD\$(et٥~sDQ\nTz|KԕHOI}lp*o5e7\0\nLSI4LnԏctM> DlQVƀA8#sN21!\0003MKd&jZBb%FGHOtBYPCCR̛/]m<J;Uc0%<lDNnF	:Y-IXPTKyT{:d_31CCncSFI:IW\0HYéENO*EJudT7Vu_X3W3F8D<{OZ4H4UU\rNKUr5{'RT4cE5-uyHIRu\rSe72dCW\\\0h)+Ntc6-KDagd2udv}vq^/h1V+gR(8{U1Vc)ֳ0T:p^Mbgdp^\0e(/Ή֮VS\nFlS%ӏWN,VCopFe69TVJ[N	\n\rvw]sc\rkSssrc?tS6& +X/\\4󰢵sd\neWr5?iWtM1q5tW5Vzsj73hTJ\${{֘_|lcsyqeWޏ{}i;a~!UM,i1bR4Fbq>>@tF>@RQ,1(x@׃%r\0F\n0@_yġfUjhuX|{W+DXuR9Wr~A_o8hN'eȏ֏o6C'Q8|71e\\5Ed FY)	\raȴͺ\"`ļTyQrR*{׃i6M/dpa=,CpqLW4C#EJ95R2\"*~Wѥj\rVӃor_/4E]x!xj*\nZ\n:n\0KrQ!Q-%Koi.NLE`3&L@\r\0EB<;éY|L7{hOU9uA63ay|t*E'ZGZBYٮK~&mg܉x35g}<D,W[\rY\\-L'hN:-H=OKU6ofדj\$>#\rfLi:fFF5bOe=We\\u\0%H0)^V<ݜ{?YVP3\r@meh7}TgafCť\\cBX3>/04b^NթfFC<Oߨ:E@\rAW{ZrgĽ{S#T3<4B\0	\0t	@\n`";break;case"tr":$g="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9b(Bi=R*|4&`(a1\rɮ|^ZɮK0fK\n!Lx7̦ȭ 4k|\"tit3-z7eLlDa63ڜI7FӺAE=FqH7PuMn7Q#j|aŘ'=sx03=g3hȎ'a\0=;Ch6)j2;I`҉\0A	j%H\\:\$&0@A#H :#\04B\n(ޡS\n;IƜB9Ãk:ê!0XB7\0P{GxҲ	;4=	 \$σ>#\$9p!pc:\rzT#9`@!c@2D49Ax^;Ձp:(\\zNүI|6MjB3#Qx4!^0Ɖ+4#Dym(\"Q92ڼ(*5<O31,U7BL!PTL\"XM-@08+tj#C'4PH{DmnvN֯#-L,b43%8Ô)fd &\r(P&&:X,Pܽ+@Ÿqx9b	Gh0c[Y=B-xQO\"x];纄\0x>ӫ)b,.#cn z,Jsrbp8!n[^=660b9\$Pl6USH|>vIc[\0Myꌣ87+h\ra&6>qp}	|;a \"y^.YbpNWr#ɡ#A3PPy]hGvzM,M3Fq8Q\"\$L)@TT*XrmZ+`KX^\rŉea^*B8nCJ=Tl/3!9IMQ-t.^)AObEE⟁Q;@`bF')jg\"4HT*RuRjJ9+Un^݊9Vs|wJ	\$F)\"+qs>g\$l&8Eсm6s.`g\$NN'бD,7)k1r>f<\"S\$Py\n7 g]H1V Ƞ&>A;1u)]-P//+?1hJc),pOR.Ffj=rAȯ)5tٛa@DDn\\u٠cEd\\3BXkj 2u<i`) DQ8!K2P ԀzdM	-zO@}#Qt@#}\$HJPLAA11\nP *9zCH|C(G<<Ìh2ca~/1^P	L*&W5#s9@&@D8<2DIČhLpG0T5@z/-)P,U9&l3~}EAӈЭ6>\"	_m9X:I	8PT@\$A90`\".fQ +\r.\"Ę3b.\"NF\\f˓v>2\\J:ȉ<[\$ Yrʳadrce}s!#̱ZMp\"Jc+˩dn@8w@\\ΤX#uWoᬽЉ0W^t'-OԞq6oM'! b%π7TOqpƻ'<Y/5davG*{\"	:ߍIKpm8(.!6̞uм+ؔm#ۈDh0BGl5?+\nQhQʓi\n\"\"O 	\"q\"JmD\"|BC	V0'@\"9fLّ#`zu2b\0C+/^1'Ϡ's޵8!O]}t{جv!QtWpL!u@8g f0]c`S5~5!ܼvYzrӎıG~JFtHem{/Y\r*%nw>`Zˋ el7fPH\\̲6QI\"558Rj']6qB.PT\\Q*o;>{CcY2dԬFN.j6)\0'<j;	+\0BUX\"pF4c*n\$|lyˌM:/|pRL70(KZ)0:r`mNo)\0-\" L/\0@liŠТ:	p؇>\"MЛ\n6ʇC\n\nLpг	\0000֜paoN07\$b\"h\npArt_0\$ТO*\nkϏ\r@5mP#C~lD&D# \"-VE(SQdTh8\$LqX;r7Kl/(3G,ߑjn\0D8.2[qI\0ܭ\\Q:jHWp#Nc0p҄nYY2'0v^R!\r@j-a,Jz\\FE7akJL\\K\0002S\"CHdYe!\"%i&cer!&Z!vӄb8NyA&*zP\0 hC'*I# 1*y'z n>\0:>Ü#..vʩ%.C900Rn1*b%\0ⅎ2&S<\r)3n/3R<;rKr|SM \\KPoبZrR^i8C@c]*8~S\"#	9*FR\r!Db-7%賞2Ws\n g++12t3bD5.5H i/8O^!`\npl\0A	:Apbq:3:1:v+CgE&^9\r?in,D_D4QEd_⒤rb&NK/\n:\$NDgu,e,|1Ql1l,ӹKg;MSc\0:\"*!.Ql7QN[ 	:GCc	>i~{,:P	#\rm/0e\nÈa	X55Z\0/!o7qU52s'1&t&LE`gΦ\"d9*'-ƊFR2˦fc";break;case"uk":$g="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9\$&;dH5}Q\$C˩ZB	D8(iyA~Gt(ygY1~Қ(BdׯKmJI\r.(VV1>#\$:-r%CǴ)/tp^\r>[73'6SP5dZ{h>/Ѡz0)28?v(P|\"oKB\"i{* 5ϲ:㹉вH8ޣ\"JBZ薉(F)ZY(\$&Y6,X\\Nz#DZ9)ĵ+;DLh1(3 (1@ݷlhQɠMH>K X Ě!аqQ&1d3WH\\C%PnTxH\$D-hU͋^5OR\"\"9#:hƁGQ8mn#NO*# 4(&Ԥ!rްX_ܥ0\\kUsɐ;(~\r3:x\r`Ap9x79cv2Fn=,@Mn;GB^0jXƐ/Q Ѭ+\rbe^V8<\nvxZnz	\nO[D_qNliRI!7`PJ2biZBʫ\rs5hZ~H(5h|\$`K ąDUDΐ':)Y:%<N3u^j\"Se#Yj/pf<Ǒr\rAS\0Zޖ|)zP8FFVTz\$,bdÛV.5'EJ,4V@PS\n!11hA>&IF_:НnB\\1%!DBIUġ35b<NX+x[*S]HaM2[\n׍*o\$+\$-hj\"((k@Cs4Lr\r0Ȱa-i\nC\r3\"C,0K ia1) gWK(x96{L6@)4*^N䙉:6ڦ#9\$Ђ](0\\F!'O<wUXRn@18̲+P		s^E͉=oBN;:Dg5=~O4|a&ͲoB\rN*Cb8e7QŠ(sّK8'؝hY%Wfo	j&3ORS6,(D¿WIfi\"Iө2&HəC*e3&hͫK9gl&t\04,`3gEyb/c	M2\$Q1j;bRXUztIbQ*\n0e\rT1N+ha:`WTϒXfޓX2,=vdZً3՛֦t@27K6ZX4*еWWNDWj8ND>O<Ռ,9vRe:q,ҫwGdj\$#%FoOCqyPPɦj:܅m;RlŲr=gEPϒG+eN*}\\@ \n\rTH\n\05	 hy(\nah#\n \04_L^A\\G`;@')}<]1,JhyԆ9bj90x[+Jҋ4V	Ih6:-CwBPR) z[;d\"i\nmaSZZ5FjC&5qH&.@1fvv2:0\"tLH2jZ+¾4_Э\rT 4&\$5B3f\"<v&MGnNd-)^j<^\0T~q]tQ8g7~_\\l=5wc`ԲGk\\<6je\";( Dθ9т<\$wR>0RfR`BI愓F\nBh#bYBFJ\nTsn]2\nodۢ3}KpӉ0uI_!R0^MdoͻW5Ʈ|e\\r/o)r3%} QVnZϹ%ǓQnD]5XCY1YꤽJ%<@8^:66(X|tM0:h}*JTh+@t\$,ɬBO7:+I5<Su\0p	fs\0\r\0 FJ4	X.#y\\=H><,)*\0eDl8df\nn\n)g#b&〼#LD';\"zSVp\\CHVH,|^B(5\$HBhfoЄObC/22[@\r\0` duȴ|JShIBk¢ƿMYN҄,,3h֤^!G&jn4cPJ|ORI&Ȉ̍:%t2%P \n`~nqf\$`JGfHGJr0ڤob~GB7QSQVX\$#,.z>pf>1a|&eb Krr\re2!d	GW?\".\"g\"bQpX@a<QL7b\\s!-#\$,C#q%'ri \$Б'2`tf'ҕ\$m\rqS1\rQH+dCޡeJG -:!F&Z!o(*>Ȁ8V%JNdW)E4~VA<Rk`6ʼoA%e-)*\$%7x)7lQhcBpR;оpn9rovC#sHHP[;yLo8#;\nS=m>A甞lzJ!@zpA8Jp@0KTB0bOzEo2S[5Ab>\$w\r3k<Y:s `/B\$v\"VFo=PY6osRGsGLc3~:cK!G-Tz!Htԧ\$:gHG9sJ=4MTCMMy%D!.nF(g7D()ܤ<\0p{u\ntRKӽ:O'u\$ORS\n)a* uK\0000Q[SH:hkPp2uQTФ~5sKJՏD^(#)Lj\ndPǢq\\bIj<1<ZW2C)\rt\\2Ula,sګ5ѶxZ ѥ\n-D(kYqA]7=^}P#R^N/4F'Vout3E4o0;YH5ZOLuWeh+UhtUH6Pfg5{eK2pwN[tZjJuC1ërxxT|?Pe֏ooSe4oo1tVgfV6{}'q25.*\$&W(6y^W3R}`EJq@QWWtiHbjW;J30svx5_pd+j{ya,tAGD^0MEBo)f7uY֧qr\\7Q6V\rfHh`@@g@\r6%Ww)7W\rq`%F7¥NvahpfAE˃|ׇXԍ8襡}<8fo%Lyi%du*WUQ'HsXԃEaxч}Op;tSF2?cMrmQӒOrOUu(DΟ0 ql#BixݏAHNvJPfEpC\r-8,4QiSUXT\"/P|Y;yQSK~)\rV#2\0r4)Ô8Cme,.QmJꕄB\nq&#vVoIjڌD_I盓A~:%1UmZb h'3c7+jɠ\"74S@BDU6Ht}Bj8`3ث嘘Bq3C7,0,FyOZSPhaCPJxlS3[7r0pV>XH:ڑe%B9Gowv8n!6{=pgHQY[2c^Rl;\\eѯDd6>x&(RT%\n`0aosyMHySpxg+SXMژ\"j=	om;\\ ڧjN1=5x3CKul/0@";break;case"uz":$g="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8'3Ac4MsI@k7#**''3`(;M6,q&ƙ}ģ+77:B:\rW.3b\r4q/|\0(a8ۍ :`*{VvN-o)dgxiw7MX('b%Iyawu:D50K82cz(\n2#ؗCX:\$VL[<&{♺\nn*2M47csX߯#%ct\$n5L P2)s\n</s&c\$+*F6ј1Lr4BCc7+@S ޑ#;Ȟ\rhAPsS@t\rAID3Њ.P\"07c2D49cx_)6̈ġ|9c\"2|-8L4x@/O2l%:2=&KZTȳ\n,=&Cw;˸ȼ~눲!(2,'xa8&L<N:D\09=9+C,#79;Wи:CF`3C*d:\$R(('#j2FRn9L\r!(:!* 7@]m;f	\$	\r67H&J(<8O<\rJ:?9%!;'!`=F/S	)s6%##}.K.u<!uHsQcii\0004۶I@Ea9Øݴ|а:*D́reYcG(`S,3Y#R\rb1M\\jM39¸_#5l8fAc{BL}0NnD+,CRa}Ƣk\r\$DzxRJ ='R:},¢bϑ2%bhC@V\nɦUnUڽW`2ı2\r2VJ4zW{t\$3PNHS2KҐjze&J@;8*T{TS* \nEϏ\\40é3lW`,)(rX\$2IZOY,~RQXBʰsL#g\"mI?dm9L!Т\$#sv)bȉ#-(kjhIT*/	\r4( (i.r|\nMhe,\$£tR]L+NF\n(Ю*\"NJIYM\":}Y'qH\0a>2Ql#2J9-\$@vu_PZFDwLNH{\$4:Y@(^g*E\\W_Ep43) 	(|bm,ɸq'ہ~7-@kKa]!\r\$P-b!%r((k{@:dd?z@n3n%Ie]5ēb\0F\nXCx9q#^FR)b0'Erch,HL@y8C	\$)bXp\nd줚'bxLKO;ݏ\n\nhHuTZ0^di!\"ǥP\\yA<3M`|VUT\n\\5ӷKe\"Ip	Pg#ˉwlUt2	\rOӒtXR\0HAĭ`H֛*MN|A:/N'(,ZȉdѺц`LLB\r4-nb>ff#j9x㽯bx\00ۋtC#J&0Ү:,TTM<sC,ć=6#L}e\" ('H6{\n\neP{t]'=NAVLb)bt׳p}05dFs#92\"̊@(ME!Ta@lz/yR\nD{E\$vnc.q'^\\I΁2pѮ٢/vG囁0yL3B(UCn7E	e,	YnxrmEy(2K:\0MyA`>9>%Sw/RR\r!ὠtӵ\\؈n%!'=/fzMp/;'\"_\0pȌ~`l\nfts.&H`A@'FF\"e͡\n\r?L|O`eݫko:Cv\$\$MIL>~l/Ф l|;	PvN{\0pPPt@vQPCup}\rh6'&|ˮX^lOnmu.VP콰J,8^>p\r\rp1-,<'X&d7X#-#CHe{JbJ1l%Dj:DqPVǂ}\"ݐHZG-66I:\"\\J(=*J\r\rN|oqtv4zʎ87^lЛ-ɕlB6%P\rR\0q D;!GI\rR\rB=`i0x\rqZD04G(7QRS\r%](&0jl\0'q8yF\rƎKB^i%rQhP\\# Z qu*]*o*R* r2@(Q12-2\"\nLұ ..~x2.D!.oqSᲛ0T(cN30&Re2(R3,S3+üd\$Kp%;5s#6Nsa1	FcRDO0'J\"2,(yFF+À\"ϱ/<)3уd::	`ش\rCBz :9ʐ3b8[=\0pnh!	4\\&b*; F\nZj\"Ѱ^nIZw91=*T37eЯD\$#\"6S\$;4`\"Pryp3;?o?CG?8#NBbD\$hmZƻ%\0,H<c6&\r03x|LK@Pxd0Cƶc\nHܑ6Tؐz@/CE,Mj:q_M!SBgƬy@.akb'\"vvU,]Uf7<] OBGO1sF0c\$=c'mSr^-ϐslX	ɟN%ҊfwG+R,LeF4#@䊵 ";break;case"vi":$g="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn8QE\r Y\$Eyt9D0Q(Vh<&b-[no\n(U`+~daH8iD\\Pnpu<4k{C3	2Rum]/tUږ[]7;qqwN(a;m{\rB\n'ٻ_2[aTk7)o9HH0c+767 88@@ \\j L+@ƻl7)vOIvL:I枧fakjc]/P!\0d! K P k<M\0\r@h4AN!c3(7\$Xb,(R-2j]2<!iJ NA1[(Rf1B\"\rAZ8B<&u=SI#qtI>(0P2\r<9ph#n\0@C҇\r㭘B%\n\0x3:x{\ra?/p_pcI|63?k4^02T.́BED\",9e9):&Y^\";\n7ZH(J2/C2S)cs2R̩JVJ\"!7\"]q:V6qJćeJZ7k,2 JGV\n5Hƈ3Q7tWcéVI~;U6Ê4J4YfBΓF\n#TĮ@-џR|[46'h(PCcn\r)+uߢ\$\n)C4{au!FTz~ص%WhUH*]RTs/5ux %JaK:V~>91C>h3,t~J6A@	8nZ(C)\r\$\0`\r3*Ih;\\F BnEP.)],\\ Qz^Qfi.Hn2T	3ŕx3@ @WK1@u޼W^|4\0`A4N\rL¢B&~KQAC:G4ċY3oČEғKuK\$t.ػ^|/2}er_D	&BIfmOd9SCNa\"[ȹ{Hq1B@X-IfhMd, \r'C:FԘ.@fԡ*.]Sצ8u['p&i	wD	%|D\"xw8 vag hb>TycHMCY\\E	j:(뾐Ӓč	!KitA5zaH#X)f1&4Ыec6i\0(;(v(Msrsj-DȚ6BI>腦mRu\$\$0\$74B]Q@\$3s&9+\0դ+2| M/\n<)Hws\$LpjĘ\\XK݀:M+C3\$<R3~Gr\"RH(!p*ζ3dҜE2ti-b^f,+N ^EGB\$yQ+ jgF\$X\rE)w8I)>12Y;'zzdqv\"m(YhDӱ^h?#taL_(#/L\00*:G04Uzm(bz\rPM=5 0\$\\NPT'řȆmQn>F%_ԹmDil=W3Cfڞ[5(ⲳ\\8+>p!\$Kf|7>]jO1CoLS:556>p\rs	_L4忓LAIn֔\n}#*\"eUDn5\n5GC	V|Y(:;R鑅a/\0*\$Z\$=S#+8\$Ġ\"	H8(,Aa<By/(	!_I)c)Q؄;rLWYk~ҰPIdKb-Ź\\\$ԮTb~u#7a%#vo)x#V]e/>*2KrNJ\09Zlbp\"KT K#lЛ IcbL#>06{H.!J&klX+<o6A~#-*s,1Nn#btz!D+@5(\"ؘ)TCPLj]\$dmn6EÍ\\`C6d\"Fk2GKp@.;4H0RLӱdq!QH-T|ge%\")UK/\"O>XE<{B.c\"coNQqjq0^8\\\$\"̸P'¡f\"9|pqNRQ鶶Ed:jDŋ4GF<\$mB0(nHяɭYRq^z.БBifBeJbfpPG '!qNDx|*!!Q'l&GO@9Q%fe%nbkrpvN78\$JR!w\0L֛n:T\\~KTU \"/+%&F.+\0{'zW8F2'Re7MQ*9T<+pF\"\$ 0Z-I-sI.G2,'lD,3w&\\)'sv\riF@\nB`#	jFBTZ@`lV朗5so56le{x1++s\$,33SO;yWNfxR}9E:&ZO:Q	%>nFméQoMd645chA%z6:w!Oq#c:UtwCh-KHCJ)\0-\n@GIF\"SG9.S\nHJ,)\0\nq0.\0JOʊG\".\$x/JLg2nS/Ѹ/kG1-tm.3bn6cГJdJWd+X\"m*K vp.(W0-P#FA/V\$5!:F8v`Z!u0#& @6J/F_#%p4TDPݬJlPx7j<E,JOOlXXV%;Dp35ĎHLnm\\!roUcvMKL\00\n4jPa^0Rd~%P#SZD!_4K#S@h1)n\nf:WWm&mƺ`4B";break;case"zh":$g="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4usUUt w:t\nrU:.:PǑ.\r7d^%u)cxU`Fjrs'PnA̛ZEf]EvitUλSծ{Pg5	EPN1	V\nW]\n!zsΟRRVI:(s#.UzΠ@:w'_T\$pVLD')bJ\$pŢ[MZ\n.>sKAZKaLHAtF3D!zHC*re^K#sXg)<v׬hE')2Anrj\n:1'+ֲ2izJsͲ h7]	9HN_esK?	RY4=DF@4C(C@:tT3>x3(9I|1B:LΝ\$=0!tIE'5(RMy&s#SE͒CH]K:KC%um0KV)\"EA(CGAFpܗ&fTYCG)\0DGSW)\0^cTewa D#8s*.]\"h^9zW#s\0]c9a Dj<V]2gC\$CCm8)\"entI4}|=3Q''1Q,g^nKsSL̋&eȜ:ϿC34;.Ml`#@6S6::=9CZ\\u|!p4Z)M=?pA\$_Kz<O66ҙt_No-6MHX:+3.~ɻFbt\"\$r!bJՄP~T]'@Gr[\0 @\$\$C1v+ʛS}P5JJUX+%hxdx:2°_:X%PQ'Ea/1ir\"&B\rBoM ~pOrTJS*Tb*YUnCtV'+uABV2>,E\$\$W1,\"r,E4H=I>ŊH9kdvd\$?M#9# 9t,Ǩ4zZ) @@Pz\"MQ-DV':HIAØG\nTf,8o&Hs_;0hDM#bʹ{mR NAr@a(3WT&(8LZ((-I\0PP\n\"\0C\naH#.)(#g8/I\$V&.FR:E=9)%hhs\nj;?ca@+\\p ZлНW*RdȱQ4G4\\р\0£RAOXcHUt*!Y?l 	EL#@CȈ&	8E@OIy\"9+1dϣR	c(YP*[s E	a/WE`LSA/DMBsFQB.QwEߢ)0t7gʅ2Ş\rna#/-/)&dF@&g@DCOA^|\n|JIaޫC+:t3DtP\\39Pq\\' `ܡpNN\\i mNtᜈM@!6%\0C\r1xL1)hAttΛKeM&HQ(9}DC\raƐN	s8M9]@BHǀ\n#~qrǈLhE6&\\\n)v]!0fmt\n&\"f)ȗf;Cm	Xj/2\\-*ޚs;F,NV&*XӀ(+Pm!|ЎQa k`fB6-9vZ9Ĳeƺ:D,b\0003kg,뢹_΋ôd*\"5m#)#PL`]1pikS&Bk;ʜG<a~6+`AhL\$Xyߗ.I/R\$__gۻm2M~?Z;[ͮ/wx{C\\i~yHSC>\"7dd%(ٙ3%v[ͤ.(a\"&pQ6;jCv!!(Ik\07D.+so-6Oψc|o4lҏ/rPat\"2oj^\rp'\\^~#fAu	mJv\\a:J^o\\h.L\"4Ψb֌6Ͼ^-LώЌ'*eN֭zem<p3\"a<Oh\rϝxK'=0αmрSet\0l\0@\0'GM^'OlQq qxv`)\$~1~M(n\nӐ]1QmD4FG!N.FFDQ:o,?	t`i	#\$-t>F-j^.tFʈ,w! 8m֟>,g\rv~p 3F) PC\nZho0lC!d*H.!6ì6-VNdgʳT3\n-Rˋ䊪#\\JΐQ1\$\npX-4*2fL.nҽ+,NAt,FE \r!(,#G/El\$\$039{1#\nJ::9L>784Co50\0>(+DD";break;case"zh-tw":$g="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/TuʮM9Rz?Tא9>SNeI̜Dhw2Y2PcмW*=s7B9J\"XQ2M/J2@\"WrTD{utspS\\=\0Vp\"R )ЪOHΔT\\ӊ:}JF+JV*rEZs!ZyV꽯yPA.yZ6YI)\ns	Z̢[2̒KdJ12A\$&Y+;ZY+\$j[GAn%Jst)P)<?\0Uw*x].2ft+<Kd(A2]*X!rB\n# 4(tE\rl	Tr{:OpbJBO:F@4C(C@:t㽄4)Kx3(9PI|t(B1֯B|\$	q/9H]D̸et\\K6?஋LQ\\1H@PJ2:@ea	&s2So1Qd0ם3Mewd:<C)xGdrBHreBi^1I@\"ZP@fg1pM	j^B<JLf*83(ڰ:s (&^)Dr\n淘1(\\մ	_ܾ7&]>Tt734ҥr</hCHHs,o7|u+wxbØ@6XU:Cp@09#uW97H}U1	~1KTNFQ8)HTKPs3cM#& )FGpXa*%)FG4B',a\na\$\n0Cո)Ȉ%)(pfD N*R:a\0(&D	`\$UV\\z\nXId,xd|:ζV\"@XCt	e/0ʴE#Ȫ髃dpO­WJ_,\"Ɗk%e՞nrEl-b(f\0CG@e}!]>]w/U\$fEhC51QB'!!&Ѱ9sa\"CQ>-0d\$TD2(2xDv\0 \r\$BGu\"#䄑Fօ*DM?!PD*\$G@&d͘tl!E*U)\r\$8lG9i^*hЃL\nf#@A\n/8F[(4ZjI\0C\naH#\0Z')E\$&ra\\E^0\nG0\\Ck=&ȵ4tXEP,S!'BbS*r?QXʼW~9KĂ\"G4N\"xS\nVEFLIfdΜ;&/Uiਪ\r@50T\n;&8L%DޜG*sp,96ԹBLpO	*\0BEX@.	d,^1 #G9##=V0sn黳ba:XVAEX/OD堔qhTػޛE\0*0H P\"`\$ӣR\"\0\0R]aeP\0ֈYEhD4nAj07PlJ5&LY*>`9&\$͢*j+Ģ]h\\uYk:xnֺ(8\"EL`eK1T30/'0Q-BKm΋oE滿#]	Ñ rYI}`(!^j:P@<\\W2aܛ9u2<A/D9`]4H2uEضֆU:T!2S`BHn[/O*+\01f1@H<c\0\"&b:D3&FӉ.%P\0`8<7ly`Kyx!yuq)(=|9\$DNM/i((\rNs+Ee<k\"Q徽?'qbuE\\%ra1#t7*{\rOy:05Ű_0aB{07Egȇ\rk__ʛl~cX_ts6SBV:yP?<-FLGY.qu5ƺKb&#ϨGVo^π>uobn\rG<!W\nNx02Ԣ0\$s\rFu<h-lFZ#..N2^pOlrAkrx+n\rp|ب\$9\r^Bʛ0>\$fNU풁\nɴpJ-8\"tLUzK,m1JpB`&6,1--d6\nw<pjm\r{.5F0pCQ2A\\rB.GB^h+B^~(7p/(!.溓!h\re0%^hqcyL\"'\$-߱21pt({ 1ڭ\refZF2\0@\0!!R\${(R4ڍ!\"A\"`ۆ82FM\$Vܡ20rv'-C(ݰR'Hq]rK}*\r+\$#*\n)@ZMM.aLwAD<L,i	+N?H^!Fb:!k/D:V.r3!z\0:6:èb^6&rIj\$YP+@\np9'POvB!gJ0Fe涡@9dÔ1\ru{5E\nh\\^S\r8Ht:Ӽq/Bl-/#Nl/qTa`F'	{%uai#͂/Ă\rdnO, &ʨ\n`ڑS++@\\N0k>xRw3>,nD0Hlj0c&rqBM#*\0L";break;}$Di=array();foreach(explode("\n",lzw_decompress($g))as$X)$Di[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Di;}if(!$Di){$Di=get_translations($ca);$_SESSION["translations"]=$Di;}if(extension_loaded('pdo')){abstract
class
PdoDb{var$flavor='',$server_info,$affected_rows,$errno,$error;protected$pdo;private$result;function
dsn($hc,$V,$G,$Ef=array()){$Ef[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$Ef[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoDbStatement');try{$this->pdo=new
\PDO($hc,$V,$G,$Ef);}catch(\Exception$Cc){auth_error(h($Cc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);}abstract
function
select_db($Kb);function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$Ni=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
multi_query($H){return$this->result=$this->query($H);}function
store_result($I=null){if(!$I){$I=$this->result;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){if(!$this->result)return
false;$this->result->_offset=0;return@$this->result->nextRowset();}function
result($H,$p=0){$I=$this->query($H);if(!$I)return
false;$K=$I->fetch();return$K?$K[$p]:false;}}class
PdoDbStatement
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(\PDO::FETCH_NUM);}function
fetch_column($p){return$this->fetchColumn($p);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($E){for($v=0;$v<$E;$v++)$this->fetch();}}}$bc=array();function
add_driver($w,$D){global$bc;$bc[$w]=$D;}function
get_driver($w){global$bc;return$bc[$w];}abstract
class
SqlDriver{static$rg=array();static$ie;protected$conn;protected$types=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();function
__construct($h){$this->conn=$h;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength($p){}function
unconvertFunction($p){}function
select($R,$M,$Z,$qd,$Gf=array(),$A=1,$F=0,$xg=false){global$b;$de=(count($qd)<count($M));$H=$b->selectQueryBuild($M,$Z,$qd,$Gf,$A,$F);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$A!=""&&$qd&&$de&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($qd&&$de?"\nGROUP BY ".implode(", ",$qd):"").($Gf?"\nORDER BY ".implode(", ",$Gf):""),($A!=""?+$A:null),($F?$A*$F:0),"\n");$Oh=microtime(true);$J=$this->conn->query($H);if($xg)echo$b->selectQuery($H,$Oh,!$J);return$J;}function
delete($R,$Fg,$A=0){$H="FROM ".table($R);return
queries("DELETE".($A?limit1($R,$H,$Fg):" $H$Fg"));}function
update($R,$O,$Fg,$A=0,$qh="\n"){$gj=array();foreach($O
as$_=>$X)$gj[]="$_ = $X";$H=table($R)." SET$qh".implode(",$qh",$gj);return
queries("UPDATE".($A?limit1($R,$H,$Fg,$qh):" $H$Fg"));}function
insert($R,$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,$L,$vg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$qi){}function
convertSearch($x,$X,$p){return$x;}function
convertOperator($Af){return$Af;}function
value($X,$p){return(method_exists($this->conn,'value')?$this->conn->value($X,$p):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($eh){return
q($eh);}function
warnings(){return'';}function
tableHelp($D,$ge=false){}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex($S){return!is_view($S);}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'");}}$bc["sqlite"]="SQLite";if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){class
SqliteDb{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error;private$link;function
__construct($r){$this->link=new
\SQLite3($r);$jj=$this->link->version();$this->server_info=$jj["versionString"];}function
query($H){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}function
store_result(){return$this->result;}function
result($H,$p=0){$I=$this->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return$K?$K[$p]:false;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$e=$this->offset++;$U=$this->result->columnType($e);return(object)array("name"=>$this->result->columnName($e),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){return$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
__construct($r){$this->dsn(DRIVER.":$r","","");}function
select_db($l){return
false;}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{var$flavor='';function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($r){if(is_readable($r)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$r)?$r:dirname($_SERVER["SCRIPT_FILENAME"])."/$r")." AS a")){parent::__construct($r);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}}}class
Driver
extends
SqlDriver{static$rg=array("SQLite3","PDO_SQLite");static$ie="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$editFunctions=array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",));var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");function
__construct($h){parent::__construct($h);if(min_version(3.31,0,$h))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,$L,$vg){$gj=array();foreach($L
as$O)$gj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$gj));}function
tableHelp($D,$ge=false){if($D=="sqlite_sequence")return"fileformat2.html#seqtab";if($D=="sqlite_master")return"fileformat2.html#$D";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',$this->conn->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R)),$Ie);return
array_combine($Ie[2],$Ie[2]);}}function
idf_escape($x){return'"'.str_replace('"','""',$x).'"';}function
table($x){return
idf_escape($x);}function
connect($Cb){list(,,$G)=$Cb;if($G!="")return
lang(22);return
new
Db;}function
get_databases(){return
array();}function
limit($H,$Z,$A,$E=0,$qh=" "){return" $H$Z".($A!==null?$qh."LIMIT $A".($E?" OFFSET $E":""):"");}function
limit1($R,$H,$Z,$qh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$qh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$qh."LIMIT 1)");}function
db_collation($l,$ib){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($k){return
array();}function
table_status($D=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return($D!=""?$J[$D]:$J);}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$vg="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$D=$K["name"];$U=strtolower($K["type"]);$m=$K["dflt_value"];$J[$D]=array("field"=>$D,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$m,$C)?str_replace("''","'",$C[1]):($m=="NULL"?null:$m)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($vg!="")$J[$vg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$D]["auto_increment"]=true;$vg=$D;}}$Ih=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$x='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$x.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Ih,$Ie,PREG_SET_ORDER);foreach($Ie
as$C){$D=str_replace('""','"',preg_replace('~^"|"$~','',$C[1]));if($J[$D])$J[$D]["collation"]=trim($C[3],"'");}preg_match_all('~'.$x.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$Ih,$Ie,PREG_SET_ORDER);foreach($Ie
as$C){$D=str_replace('""','"',preg_replace('~^"|"$~','',$C[1]));$J[$D]["default"]=$C[3];$J[$D]["generated"]=strtoupper($C[4]);}return$J;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$J=array();$Ih=$i->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Ih,$C)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$C[1],$Ie,PREG_SET_ORDER);foreach($Ie
as$C){$J[""]["columns"][]=idf_unescape($C[2]).$C[4];$J[""]["descs"][]=(preg_match('~DESC~i',$C[5])?'1':null);}}if(!$J){foreach(fields($R)as$D=>$p){if($p["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($D),"lengths"=>array(),"descs"=>array(null));}}$Mh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$i);foreach(get_rows("PRAGMA index_list(".table($R).")",$i)as$K){$D=$K["name"];$y=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$y["lengths"]=array();$y["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($D).")",$i)as$dh){$y["columns"][]=$dh["name"];$y["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($D).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$Mh[$D],$Qg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Qg[2],$Ie);foreach($Ie[2]as$_=>$X){if($X)$y["descs"][$_]='1';}}if(!$J[""]||$y["type"]!="UNIQUE"||$y["columns"]!=$J[""]["columns"]||$y["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$D))$J[$D]=$y;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$s=&$J[$K["id"]];if(!$s)$s=$K;$s["source"][]=$K["from"];$s["target"][]=$K["to"];}return$J;}function
view($D){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($D))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($l){return
false;}function
error(){global$h;return
h($h->error);}function
check_sqlite_name($D){global$h;$Kc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Kc)\$~",$D)){$h->error=lang(23,str_replace("|",", ",$Kc));return
false;}return
true;}function
create_database($l,$hb){global$h;if(file_exists($l)){$h->error=lang(24);return
false;}if(!check_sqlite_name($l))return
false;try{$B=new
SqliteDb($l);}catch(\Exception$Cc){$h->error=$Cc->getMessage();return
false;}$B->query('PRAGMA encoding = "UTF-8"');$B->query('CREATE TABLE adminer (i)');$B->query('DROP TABLE adminer');return
true;}function
drop_databases($k){global$h;$h->__construct(":memory:");foreach($k
as$l){if(!@unlink($l)){$h->error=lang(24);return
false;}}return
true;}function
rename_database($D,$hb){global$h;if(!check_sqlite_name($D))return
false;$h->__construct(":memory:");$h->error=lang(24);return@rename(DB,$D);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$D,$q,$dd,$nb,$sc,$hb,$Aa,$dg){global$h;$Zi=($R==""||$dd);foreach($q
as$p){if($p[0]!=""||!$p[1]||$p[2]){$Zi=true;break;}}$c=array();$Rf=array();foreach($q
as$p){if($p[1]){$c[]=($Zi?$p[1]:"ADD ".implode($p[1]));if($p[0]!="")$Rf[$p[0]]=$p[1][0];}}if(!$Zi){foreach($c
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$D&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($D)))return
false;}elseif(!recreate_table($R,$D,$c,$Rf,$dd,$Aa))return
false;if($Aa){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Aa WHERE name = ".q($D));if(!$h->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($D).", $Aa)");queries("COMMIT");}return
true;}function
recreate_table($R,$D,$q,$Rf,$dd,$Aa=0,$z=array(),$dc="",$na=""){global$n;if($R!=""){if(!$q){foreach(fields($R)as$_=>$p){if($z)$p["auto_increment"]=0;$q[]=process_field($p,$p);$Rf[$_]=idf_escape($_);}}$wg=false;foreach($q
as$p){if($p[6])$wg=true;}$fc=array();foreach($z
as$_=>$X){if($X[2]=="DROP"){$fc[$X[1]]=true;unset($z[$_]);}}foreach(indexes($R)as$ke=>$y){$f=array();foreach($y["columns"]as$_=>$e){if(!$Rf[$e])continue
2;$f[]=$Rf[$e].($y["descs"][$_]?" DESC":"");}if(!$fc[$ke]){if($y["type"]!="PRIMARY"||!$wg)$z[]=array($y["type"],$ke,$f);}}foreach($z
as$_=>$X){if($X[0]=="PRIMARY"){unset($z[$_]);$dd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$ke=>$s){foreach($s["source"]as$_=>$e){if(!$Rf[$e])continue
2;$s["source"][$_]=idf_unescape($Rf[$e]);}if(!isset($dd[" $ke"]))$dd[]=" ".format_foreign_key($s);}queries("BEGIN");}foreach($q
as$_=>$p){if(preg_match('~GENERATED~',$p[3]))unset($Rf[array_search($p[0],$Rf)]);$q[$_]="  ".implode($p);}$q=array_merge($q,array_filter($dd));foreach($n->checkConstraints($R)as$Va){if($Va!=$dc)$q[]="  CHECK ($Va)";}if($na)$q[]="  CHECK ($na)";$ki=($R==$D?"adminer_$D":$D);if(!queries("CREATE TABLE ".table($ki)." (\n".implode(",\n",$q)."\n)"))return
false;if($R!=""){if($Rf&&!queries("INSERT INTO ".table($ki)." (".implode(", ",$Rf).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($Rf)))." FROM ".table($R)))return
false;$Ji=array();foreach(triggers($R)as$Hi=>$ri){$Gi=trigger($Hi);$Ji[]="CREATE TRIGGER ".idf_escape($Hi)." ".implode(" ",$ri)." ON ".table($D)."\n$Gi[Statement]";}$Aa=$Aa?0:get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$D&&!queries("ALTER TABLE ".table($ki)." RENAME TO ".table($D)))||!alter_indexes($D,$z))return
false;if($Aa)queries("UPDATE sqlite_sequence SET seq = $Aa WHERE name = ".q($D));foreach($Ji
as$Gi){if(!queries($Gi))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$D,$f){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($D!=""?$D:uniqid($R."_"))." ON ".table($R)." $f";}function
alter_indexes($R,$c){foreach($c
as$vg){if($vg[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($lj){return
apply_queries("DROP VIEW",$lj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$lj,$ii){return
false;}function
trigger($D){if($D=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$x='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Ii=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$x\\s*(".implode("|",$Ii["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($x))?\\s+ON\\s*$x\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($D)),$C);$pf=$C[3];return
array("Timing"=>strtoupper($C[1]),"Event"=>strtoupper($C[2]).($pf?" OF":""),"Of"=>idf_unescape($pf),"Trigger"=>$D,"Statement"=>$C[4],);}function
triggers($R){$J=array();$Ii=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Ii["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$C);$J[$K["name"]]=array($C[1],$C[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($h,$H){return$h->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Aa,$Sh){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$D=>$y){if($D=='')continue;$J.=";\n\n".index_sql($R,$y['type'],$D,"(".implode(", ",array_map('Adminer\idf_escape',$y['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Kb){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$D=$K["name"];if($D!="pragma_list"&&$D!="compile_options"){$J[$D]=array($D,'');foreach(get_rows("PRAGMA $D")as$K)$J[$D][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$Df)$J[]=explode("=",$Df,2);return$J;}function
convert_field($p){}function
unconvert_field($p,$J){return$J;}function
support($Pc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Pc);}}$bc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
Db{var$extension="PgSQL",$flavor='',$server_info,$affected_rows,$error,$timeout;private$link,$result,$string,$database=true;function
_error($yc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$G){global$b;$l=$b->database();set_error_handler(array($this,'_error'));$this->string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($G,"'\\")."'";$Nh=$b->connectSsl();if(isset($Nh["mode"]))$this->string.=" sslmode='".$Nh["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$l!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return(bool)$this->link;}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,$p){return($p["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Kb){global$b;if($Kb==$b->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Kb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$Ni=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
multi_query($H){return$this->result=$this->query($H);}function
store_result(){return$this->result;}function
next_result(){return
false;}function
result($H,$p=0){$I=$this->query($H);return($I?$I->fetch_column($p):false);}function
warnings(){return
h(pg_last_notice($this->link));}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_column($p){return($this->num_rows?pg_fetch_result($this->result,0,$p):false);}function
fetch_field(){$e=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$e);$J->name=pg_field_name($this->result,$e);$J->type=pg_field_type($this->result,$e);$J->charsetnr=($J->type=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
Db
extends
PdoDb{var$extension="PDO_PgSQL",$timeout;function
connect($N,$V,$G){global$b;$l=$b->database();$hc="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'";$Nh=$b->connectSsl();if(isset($Nh["mode"]))$hc.=" sslmode='".$Nh["mode"]."'";$this->dsn($hc,$V,$G);return
true;}function
select_db($Kb){global$b;return($b->database()==$Kb);}function
query($H,$Ni=false){$J=parent::query($H,$Ni);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){return'';}function
close(){}}}class
Driver
extends
SqlDriver{static$rg=array("PgSQL","PDO_PgSQL");static$ie="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct($h){parent::__construct($h);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$h)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$h))$this->types[lang(27)]["jsonb"]=4294967295;}$this->editFunctions=array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",));if(min_version(12,0,$h))$this->generated=array("STORED");}function
enumLength($p){$uc=$this->types[lang(31)][$p["type"]];return($uc?type_values($uc):"");}function
setUserTypes($Mi){$this->types[lang(31)]=array_flip($Mi);}function
insertReturning($R){$Aa=array_filter(fields($R),function($p){return$p['auto_increment'];});return(count($Aa)==1?" RETURNING ".idf_escape(key($Aa)):"");}function
insertUpdate($R,$L,$vg){global$h;foreach($L
as$O){$Vi=array();$Z=array();foreach($O
as$_=>$X){$Vi[]="$_ = $X";if(isset($vg[idf_unescape($_)]))$Z[]="$_ = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Vi)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$qi){$this->conn->query("SET statement_timeout = ".(1000*$qi));$this->conn->timeout=1000*$qi;return$H;}function
convertSearch($x,$X,$p){$ni="char|text";if(strpos($X["op"],"LIKE")===false)$ni.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$ni~",$p["type"])?$x:"CAST($x AS text)");}function
quoteBinary($eh){return"'\\x".bin2hex($eh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($D,$ge=false){$Ae=array("information_schema"=>"infoschema","pg_catalog"=>($ge?"view":"catalog"),);$B=$Ae[$_GET["ns"]];if($B)return"$B-".str_replace("_","-",$D).".html";}function
supportsIndex($S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Qa;if($Qa===null)$Qa=($this->conn->result("SHOW standard_conforming_strings")=="off");return$Qa;}}function
idf_escape($x){return'"'.str_replace('"','""',$x).'"';}function
table($x){return
idf_escape($x);}function
connect($Cb){global$bc;$h=new
Db;if($h->connect($Cb[0],$Cb[1],$Cb[2])){if(min_version(9,0,$h))$h->query("SET application_name = 'Adminer'");$jj=$h->result("SELECT version()");$h->flavor=(preg_match('~CockroachDB~',$jj)?'cockroach':'');$h->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$jj);if($h->flavor=='cockroach')$bc[DRIVER]="CockroachDB";return$h;}return$h->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$A,$E=0,$qh=" "){return" $H$Z".($A!==null?$qh."LIMIT $A".($E?" OFFSET $E":""):"");}function
limit1($R,$H,$Z,$qh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$qh):" $H".(is_view(table_status1($R))?$Z:$qh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$qh."LIMIT 1)"));}function
db_collation($l,$ib){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($l));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($k){global$h;$J=array();foreach($k
as$l){if($h->select_db($l))$J[$l]=count(tables_list());}return$J;}function
table_status($D=""){static$_d;if($_d===null)$_d=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	c.relname AS \"Name\",
	CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\"".($_d?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	c.reltuples as \"Rows\",
	n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($D!=""?"AND relname = ".q($D):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return($D!=""?$J[$D]:$J);}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ua=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(c.oid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$C);list(,$U,$ye,$K["length"],$oa,$wa)=$C;$K["length"].=$wa;$Xa=$U.$oa;if(isset($ua[$Xa])){$K["type"]=$ua[$Xa];$K["full_type"]=$K["type"].$ye.$wa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$ye.$oa.$wa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$C))$K["default"]=($C[1]=="NULL"?null:idf_unescape($C[1]).$C[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$J=array();$bi=$i->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R));$f=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $bi AND attnum > 0",$i);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial
FROM pg_index i, pg_class ci
WHERE i.indrelid = $bi AND ci.oid = i.indexrelid
ORDER BY indisprimary DESC, indisunique DESC",$i)as$K){$Rg=$K["relname"];$J[$Rg]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$Rg]["columns"]=array();$J[$Rg]["descs"]=array();if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$Sd)$J[$Rg]["columns"][]=$f[$Sd];foreach(explode(" ",$K["indoption"])as$Td)$J[$Rg]["descs"][]=($Td&1?'1':null);}$J[$Rg]["lengths"]=array();}return$J;}function
foreign_keys($R){global$n;$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$C)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$C[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$C[2],$Ge)){$K['ns']=idf_unescape($Ge[2]);$K['table']=idf_unescape($Ge[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$C[3])));$K['on_delete']=(preg_match("~ON DELETE ($n->onActions)~",$C[4],$Ge)?$Ge[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE ($n->onActions)~",$C[4],$Ge)?$Ge[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($D){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".get_val("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($D)).")")));}function
collations(){return
array();}function
information_schema($l){return
get_schema()=="information_schema";}function
error(){global$h;$J=h($h->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$C))$J=$C[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($C[3]).'})(.*)~','\1<b>\2</b>',$C[2]).$C[4];return
nl_br($J);}function
create_database($l,$hb){return
queries("CREATE DATABASE ".idf_escape($l).($hb?" ENCODING ".idf_escape($hb):""));}function
drop_databases($k){global$h;$h->close();return
apply_queries("DROP DATABASE",$k,'Adminer\idf_escape');}function
rename_database($D,$hb){global$h;$h->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($D));}function
auto_increment(){return"";}function
alter_table($R,$D,$q,$dd,$nb,$sc,$hb,$Aa,$dg){$c=array();$Eg=array();if($R!=""&&$R!=$D)$Eg[]="ALTER TABLE ".table($R)." RENAME TO ".table($D);$rh="";foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c[]="DROP $e";else{$fj=$X[5];unset($X[5]);if($p[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($e!=$X[0])$Eg[]="ALTER TABLE ".table($D)." RENAME $e TO $X[0]";$c[]="ALTER $e TYPE$X[1]";$sh=$R."_".idf_unescape($X[0])."_seq";$c[]="ALTER $e ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($sh).")":"DROP DEFAULT"));if(isset($X[6]))$rh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($sh)." OWNED BY ".idf_escape($R).".$X[0]";$c[]="ALTER $e ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($p[0]!=""||$fj!="")$Eg[]="COMMENT ON COLUMN ".table($D).".$X[0] IS ".($fj!=""?substr($fj,9):"''");}}$c=array_merge($c,$dd);if($R=="")array_unshift($Eg,"CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($Eg,"ALTER TABLE ".table($R)."\n".implode(",\n",$c));if($rh)array_unshift($Eg,$rh);if($nb!==null)$Eg[]="COMMENT ON TABLE ".table($D)." IS ".q($nb);foreach($Eg
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$c){$j=array();$cc=array();$Eg=array();foreach($c
as$X){if($X[0]!="INDEX")$j[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$cc[]=idf_escape($X[1]);else$Eg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($j)array_unshift($Eg,"ALTER TABLE ".table($R).implode(",",$j));if($cc)array_unshift($Eg,"DROP INDEX ".implode(", ",$cc));foreach($Eg
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($lj){return
drop_tables($lj);}function
drop_tables($T){foreach($T
as$R){$P=table_status($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$lj,$ii){foreach(array_merge($T,$lj)as$R){$P=table_status($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($ii)))return
false;}return
true;}function
trigger($D,$R){if($D=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$f=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($D);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$f[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($f&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$f);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$Gi=trigger($K["trigger_name"],$R);$J[$Gi["Trigger"]]=array($Gi["Timing"],$Gi["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($D,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($D));$J=$L[0];$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($D).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($D,$K){$J=array();foreach($K["fields"]as$p){$ye=$p["length"];$J[]=$p["type"].($ye?"($ye)":"");}return
idf_escape($D)."(".implode(", ",$J).")";}function
last_id($I){return(is_object($I)&&$I->num_rows?$I->fetch_column(0):0);}function
explain($h,$H){return$h->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Qg))return$Qg[1];return
false;}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($w){$xc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $w ORDER BY enumsortorder");return($xc?"'".implode("', '",array_map('addslashes',$xc))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($gh,$i=null){global$h,$n;if(!$i)$i=$h;$J=$i->query("SET search_path TO ".idf_escape($gh));$n->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status($R);$Zc=foreign_keys($R);ksort($Zc);foreach($Zc
as$Yc=>$Xc)$J.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($Yc)." $Xc[definition] ".($Xc['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Aa,$Sh){global$n;$Wg=array();$th=array();$P=table_status($R);if(is_view($P)){$kj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $kj[select]",";");}$q=fields($R);if(!$P||empty($q))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($q
as$p){$ag=idf_escape($p['field']).' '.$p['full_type'].default_value($p).($p['attnotnull']?" NOT NULL":"");$Wg[]=$ag;if(preg_match('~nextval\(\'([^\']+)\'\)~',$p['default'],$Ie)){$sh=$Ie[1];$Hh=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($sh)):"SELECT * FROM $sh"),null,"-- "));$th[]=($Sh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $sh;\n":"")."CREATE SEQUENCE $sh INCREMENT $Hh[increment_by] MINVALUE $Hh[min_value] MAXVALUE $Hh[max_value]".($Aa&&$Hh['last_value']?" START ".($Hh["last_value"]+1):"")." CACHE $Hh[cache_value];";}}if(!empty($th))$J=implode("\n\n",$th)."\n\n$J";$vg="";foreach(indexes($R)as$Qd=>$y){if($y['type']=='PRIMARY'){$vg=$Qd;$Wg[]="CONSTRAINT ".idf_escape($Qd)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$y['columns'])).")";}}foreach($n->checkConstraints($R)as$sb=>$ub)$Wg[]="CONSTRAINT ".idf_escape($sb)." CHECK $ub";$J.=implode(",\n    ",$Wg)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($q
as$Rc=>$p){if($p['comment'])$J.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Rc)." IS ".q($p['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($vg?" AND indexname != ".q($vg):""),null,"-- ")as$K)$J.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status($R);$J="";foreach(triggers($R)as$Fi=>$Ei){$Gi=trigger($Fi,$P['Name']);$J.="\nCREATE TRIGGER ".idf_escape($Gi['Trigger'])." $Gi[Timing] $Gi[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $Gi[Type] $Gi[Statement];;\n";}return$J;}function
use_sql($Kb){return"\connect ".idf_escape($Kb);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($p){}function
unconvert_field($p,$J){return$J;}function
support($Pc){global$h;return
preg_match('~^(check|database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|'.(min_version(11)?'procedure|':'').'routine|sequence|trigger|type|variables|drop_col'.($h->flavor=='cockroach'?'':'|processlist').'|kill|dump)$~',$Pc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}$bc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db{var$extension="oci8",$flavor='',$server_info,$affected_rows,$errno,$error;var$_current_db;private$link,$result;function
_error($yc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$G){$this->link=@oci_new_connect($V,$G,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return
true;}$o=oci_error();$this->error=$o["message"];return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Kb){$this->_current_db=$Kb;return
true;}function
query($H,$Ni=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$o=oci_error($this->link);$this->errno=$o["code"];$this->error=$o["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}function
multi_query($H){return$this->result=$this->query($H);}function
store_result(){return$this->result;}function
next_result(){return
false;}function
result($H,$p=0){$I=$this->query($H);return(is_object($I)?$I->fetch_column($p):false);}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$_=>$X){if(is_a($X,'OCI-Lob'))$K[$_]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_column($p){return(oci_fetch($this->result)?oci_result($this->result,$p+1):false);}function
fetch_field(){$e=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$e);$J->type=oci_field_type($this->result,$e);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
connect($N,$V,$G){$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$G);return
true;}function
select_db($Kb){$this->_current_db=$Kb;return
true;}}}class
Driver
extends
SqlDriver{static$rg=array("OCI8","PDO_OCI");static$ie="oracle";var$editFunctions=array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",));var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct($h){parent::__construct($h);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,$L,$vg){global$h;foreach($L
as$O){$Vi=array();$Z=array();foreach($O
as$_=>$X){$Vi[]="$_ = $X";if(isset($vg[idf_unescape($_)]))$Z[]="$_ = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Vi)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($x){return'"'.str_replace('"','""',$x).'"';}function
table($x){return
idf_escape($x);}function
connect($Cb){$h=new
Db;if($h->connect($Cb[0],$Cb[1],$Cb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$A,$E=0,$qh=" "){return($E?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($A+$E).") WHERE rnum > $E":($A!==null?" * FROM (SELECT $H$Z) WHERE rownum <= ".($A+$E):" $H$Z"));}function
limit1($R,$H,$Z,$qh="\n"){return" $H$Z";}function
db_collation($l,$ib){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){global$h;$l=$h->_current_db?:DB;unset($h->_current_db);return$l;}function
where_owner($tg,$Uf="owner"){if(!$_GET["ns"])return'';return"$tg$Uf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($f){$Uf=where_owner('');return"(SELECT $f FROM all_views WHERE ".($Uf?:"rownum < 0").")";}function
tables_list(){$kj=views_table("view_name");$Uf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Uf
UNION SELECT view_name, 'view' FROM $kj
ORDER BY 1");}function
count_tables($k){$J=array();foreach($k
as$l)$J[$l]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($l));return$J;}function
table_status($D=""){$J=array();$jh=q($D);$l=get_current_db();$kj=views_table("view_name");$Uf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($l).$Uf.($D!=""?" AND table_name = $jh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $kj".($D!=""?" WHERE view_name = $jh":"")."
ORDER BY 1")as$K){if($D!="")return$K;$J[$K["Name"]]=$K;}return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$Uf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$Uf ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$ye="$K[DATA_PRECISION],$K[DATA_SCALE]";if($ye==",")$ye=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($ye?"($ye)":""),"type"=>strtolower($U),"length"=>$ye,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$i=null){$J=array();$Uf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$Uf
ORDER BY ac.constraint_type, aic.column_position",$i)as$K){$Qd=$K["INDEX_NAME"];$kb=$K["DATA_DEFAULT"];$kb=($kb?trim($kb,'"'):$K["COLUMN_NAME"]);$J[$Qd]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$Qd]["columns"][]=$kb;$J[$Qd]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$Qd]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($D){$kj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$kj.' WHERE view_name = '.q($D));return
reset($L);}function
collations(){return
array();}function
information_schema($l){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){global$h;return
h($h->error);}function
explain($h,$H){$h->query("EXPLAIN PLAN FOR $H");return$h->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$D,$q,$dd,$nb,$sc,$hb,$Aa,$dg){$c=$cc=array();$Nf=($R?fields($R):array());foreach($q
as$p){$X=$p[1];if($X&&$p[0]!=""&&idf_escape($p[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($p[0])." TO $X[0]");$Mf=$Nf[$p[0]];if($X&&$Mf){$rf=process_field($Mf,$Mf);if($X[2]==$rf[2])$X[2]="";}if($X)$c[]=($R!=""?($p[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$cc[]=idf_escape($p[0]);}if($R=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($R)."\n".implode("\n",$c)))&&(!$cc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$cc).")"))&&($R==$D||queries("ALTER TABLE ".table($R)." RENAME TO ".table($D)));}function
alter_indexes($R,$c){$cc=array();$Eg=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$j=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Eg,"ALTER TABLE ".table($R).$j);}elseif($X[2]=="DROP")$cc[]=idf_escape($X[1]);else$Eg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($cc)array_unshift($Eg,"DROP INDEX ".implode(", ",$cc));foreach($Eg
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($lj){return
apply_queries("DROP VIEW",$lj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($ih,$i=null){global$h;if(!$i)$i=$h;return$i->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($ih));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$_=>$X)$J[]=array($_,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($p){}function
unconvert_field($p,$J){return$J;}function
support($Pc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Pc);}}$bc["mssql"]="MS SQL";if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db{var$extension="sqlsrv",$flavor='',$server_info,$affected_rows,$errno,$error;private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$o){$this->errno=$o["code"];$this->error.="$o[message]\n";}$this->error=rtrim($this->error);}function
connect($N,$V,$G){global$b;$tb=array("UID"=>$V,"PWD"=>$G,"CharacterSet"=>"UTF-8");$Nh=$b->connectSsl();if(isset($Nh["Encrypt"]))$tb["Encrypt"]=$Nh["Encrypt"];if(isset($Nh["TrustServerCertificate"]))$tb["TrustServerCertificate"]=$Nh["TrustServerCertificate"];$l=$b->database();if($l!="")$tb["Database"]=$l;$this->link=@sqlsrv_connect(preg_replace('~:~',',',$N),$tb);if($this->link){$Ud=sqlsrv_server_info($this->link);$this->server_info=$Ud['SQLServerVersion'];}else$this->get_error();return(bool)$this->link;}function
quote($Q){$Oi=strlen($Q)!=strlen(utf8_decode($Q));return($Oi?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Kb){return$this->query(use_sql($Kb));}function
query($H,$Ni=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?sqlsrv_next_result($this->result):null;}function
result($H,$p=0){$I=$this->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return$K[$p];}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$_=>$X){if(is_a($X,'DateTime'))$K[$_]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$p=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$p["Name"];$J->type=($p["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($E){for($v=0;$v<$E;$v++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($h,$H){$h->query("SET SHOWPLAN_ALL ON");$J=$h->query($H);$h->query("SET SHOWPLAN_ALL OFF");return$J;}}else{class
MssqlDb
extends
PdoDb{function
select_db($Kb){return$this->query(use_sql($Kb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){global$h;return$h->lastInsertId();}function
explain($h,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
connect($N,$V,$G){$this->dsn("sqlsrv:Server=".str_replace(":",",",$N),$V,$G);return
true;}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
connect($N,$V,$G){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$G);return
true;}}}}class
Driver
extends
SqlDriver{static$rg=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$ie="mssql";var$editFunctions=array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",));var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$generated=array("PERSISTED","VIRTUAL");function
__construct($h){parent::__construct($h);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,$L,$vg){$q=fields($R);$Vi=array();$Z=array();$O=reset($L);$f="c".implode(", c",range(1,count($O)));$Pa=0;$Yd=array();foreach($O
as$_=>$X){$Pa++;$D=idf_unescape($_);if(!$q[$D]["auto_increment"])$Yd[$_]="c$Pa";if(isset($vg[$D]))$Z[]="$_ = c$Pa";else$Vi[]="$_ = c$Pa";}$gj=array();foreach($L
as$O)$gj[]="(".implode(", ",$O).")";if($Z){$Jd=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$gj)."\n) AS source ($f) ON ".implode(" AND ",$Z).($Vi?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$Vi):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Jd?$O:$Yd)).") VALUES (".($Jd?$f:implode(", ",$Yd)).");");if($Jd)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$gj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($D,$ge=false){$Ae=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$B=$Ae[get_schema()];if($B)return"relational-databases/system-$B".preg_replace('~_~','-',strtolower($D))."-transact-sql";}}function
idf_escape($x){return"[".str_replace("]","]]",$x)."]";}function
table($x){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($x);}function
connect($Cb){$h=new
Db;if($Cb[0]=="")$Cb[0]="localhost:1433";if($h->connect($Cb[0],$Cb[1],$Cb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$A,$E=0,$qh=" "){return($A!==null?" TOP (".($A+$E).")":"")." $H$Z";}function
limit1($R,$H,$Z,$qh="\n"){return
limit($H,$Z,1,0,$qh);}function
db_collation($l,$ib){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($l));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($k){global$h;$J=array();foreach($k
as$l){$h->select_db($l);$J[$l]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($D=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$K){if($D!="")return$K;$J[$K["Name"]]=$K;}return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$pb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$Zh=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($Zh))as$K){$U=$K["type"];$ye=(preg_match("~char|binary~",$U)?$K["max_length"]/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($ye?"($ye)":""),"type"=>$U,"length"=>$ye,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$C)?str_replace("''","'",$C[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$pb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($Zh))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$i=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$i)as$K){$D=$K["name"];$J[$D]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$D]["lengths"]=array();$J[$D]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$D]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($D){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($D))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$hb)$J[preg_replace('~_.*~','',$hb)][]=$hb;return$J;}function
information_schema($l){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){global$h;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$h->error)));}function
create_database($l,$hb){return
queries("CREATE DATABASE ".idf_escape($l).(preg_match('~^[a-z0-9_]+$~i',$hb)?" COLLATE $hb":""));}function
drop_databases($k){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$k)));}function
rename_database($D,$hb){if(preg_match('~^[a-z0-9_]+$~i',$hb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $hb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($D));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$D,$q,$dd,$nb,$sc,$hb,$Aa,$dg){$c=array();$pb=array();$Nf=fields($R);foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c["DROP"][]=" COLUMN $e";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$pb[$p[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($p[0]=="")$c["ADD"][]="\n  ".implode("",$X).($R==""?substr($dd[$X[0]],16+strlen($X[0])):"");else{$m=$X[3];unset($X[3]);unset($X[6]);if($e!=$X[0])queries("EXEC sp_rename ".q(table($R).".$e").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";$Mf=$Nf[$p[0]];if(default_value($Mf)!=$m){if($Mf["default"]!==null)$c["DROP"][]=" ".idf_escape($Mf["default_constraint"]);if($m)$c["ADD"][]="\n $m FOR $e";}}}}if($R=="")return
queries("CREATE TABLE ".table($D)." (".implode(",",(array)$c["ADD"])."\n)");if($R!=$D)queries("EXEC sp_rename ".q(table($R)).", ".q($D));if($dd)$c[""]=$dd;foreach($c
as$_=>$X){if(!queries("ALTER TABLE ".table($D)." $_".implode(",",$X)))return
false;}foreach($pb
as$_=>$X){$nb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($D).", @level2type = N'Column', @level2name = ".q($_));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $nb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($D).",
@level2type = N'Column',
@level2name = ".q($_));}return
true;}function
alter_indexes($R,$c){$y=array();$cc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$cc[]=idf_escape($X[1]);else$y[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$y||queries("DROP INDEX ".implode(", ",$y)))&&(!$cc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$cc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$yf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$s=&$J[$K["FK_NAME"]];$s["db"]=$K["PKTABLE_QUALIFIER"];$s["ns"]=$K["PKTABLE_OWNER"];$s["table"]=$K["PKTABLE_NAME"];$s["on_update"]=$yf[$K["UPDATE_RULE"]];$s["on_delete"]=$yf[$K["DELETE_RULE"]];$s["source"][]=$K["FKCOLUMN_NAME"];$s["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($lj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$lj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$lj,$ii){return
apply_queries("ALTER SCHEMA ".idf_escape($ii)." TRANSFER",array_merge($T,$lj));}function
trigger($D){if($D=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($D));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($gh){$_GET["ns"]=$gh;return
true;}function
create_sql($R,$Aa,$Sh){global$n;if(is_view(table_status($R))){$kj=view($R);return"CREATE VIEW ".table($R)." AS $kj[select]";}$q=array();$vg=false;foreach(fields($R)as$D=>$p){$X=process_field($p,$p);if($X[6])$vg=true;$q[]=implode("",$X);}foreach(indexes($R)as$D=>$y){if(!$vg||$y["type"]!="PRIMARY"){$f=array();foreach($y["columns"]as$_=>$X)$f[]=idf_escape($X).($y["descs"][$_]?" DESC":"");$D=idf_escape($D);$q[]=($y["type"]=="INDEX"?"INDEX $D":"CONSTRAINT $D ".($y["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$f).")";}}foreach($n->checkConstraints($R)as$D=>$Va)$q[]="CONSTRAINT ".idf_escape($D)." CHECK ($Va)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$q)."\n)";}function
foreign_keys_sql($R){$q=array();foreach(foreign_keys($R)as$dd)$q[]=ltrim(format_foreign_key($dd));return($q?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$q).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Kb){return"USE ".idf_escape($Kb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$D=>$Gi)$J.=create_trigger(" ON ".table($R),trigger($D)).";";return$J;}function
convert_field($p){}function
unconvert_field($p,$J){return$J;}function
support($Pc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Pc);}}class
Adminer{var$operators;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($j=false){return
password_file($j);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($bd=true){return
get_databases($bd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head($Hb=null){return
true;}function
css(){$J=array();foreach(array("","-dark")as$Ze){$r="adminer$Ze.css";if(file_exists($r))$J[]="$r?v=".crc32(file_get_contents($r));}return$J;}function
loginForm(){global$bc;echo"<table class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(32).'<td>',html_select("auth[driver]",$bc,DRIVER,"loginDriver(this);")),$this->loginFormField('server','<tr><th>'.lang(33).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),$this->loginFormField('username','<tr><th>'.lang(34).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),$this->loginFormField('db','<tr><th>'.lang(36).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(37)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(38))."\n";}function
loginFormField($D,$Cd,$Y){return$Cd.$Y."\n";}function
login($Ce,$G){if($G=="")return
lang(39,target_blank());return
true;}function
tableName($Yh){return
h($Yh["Name"]);}function
fieldName($p,$Gf=0){$U=$p["full_type"];$nb=$p["comment"];return'<span title="'.h($U.($nb!=""?($U?": ":"").$nb:'')).'">'.h($p["field"]).'</span>';}function
selectLinks($Yh,$O=""){global$n;echo'<p class="links">';$Ae=array("select"=>lang(40));if(support("table")||support("indexes"))$Ae["table"]=lang(41);$ge=false;if(support("table")){$ge=is_view($Yh);if($ge)$Ae["view"]=lang(42);else$Ae["create"]=lang(43);}if($O!==null)$Ae["edit"]=lang(44);$D=$Yh["Name"];foreach($Ae
as$_=>$X)echo" <a href='".h(ME)."$_=".urlencode($D).($_=="edit"?$O:"")."'".bold(isset($_GET[$_])).">$X</a>";echo
doc_link(array(JUSH=>$n->tableHelp($D,$ge)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Xh){return
array();}function
backwardKeysPrint($Ea,$K){}function
selectQuery($H,$Oh,$Nc=false){global$n;$J="</p>\n";if(!$Nc&&($oj=$n->warnings())){$w="warnings";$J=", <a href='#$w'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$w');","")."$J<div id='$w' class='hidden'>\n$oj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($Oh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions($L,$ed){return$L;}function
selectLink($X,$p){}function
selectVal($X,$B,$p,$Qf){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$p["type"])&&!preg_match("~var~",$p["type"])?"<code>$X</code>":(preg_match('~json~',$p["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$p["type"])&&!is_utf8($X))$J="<i>".lang(46,strlen($Qf))."</i>";return($B?"<a href='".h($B)."'".(is_url($B)?target_blank():"").">$J</a>":$J);}function
editVal($X,$p){return$X;}function
tableStructurePrint($q,$Yh=null){global$n;echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(47)."<td>".lang(48).(support("comment")?"<td>".lang(49):"")."</thead>\n";$Rh=$n->structuredTypes();foreach($q
as$p){echo"<tr><th>".h($p["field"]);$U=h($p["full_type"]);$hb=h($p["collation"]);echo"<td><span title='$hb'>".(in_array($U,(array)$Rh[lang(31)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($hb&&isset($Yh["Collation"])&&$hb!=$Yh["Collation"]?" $hb":""))."</span>",($p["null"]?" <i>NULL</i>":""),($p["auto_increment"]?" <i>".lang(50)."</i>":"");$m=h($p["default"]);echo(isset($p["default"])?" <span title='".lang(51)."'>[<b>".($p["generated"]?"<code class='jush-".JUSH."'>$m</code>":$m)."</b>]</span>":""),(support("comment")?"<td>".h($p["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($z){echo"<table>\n";foreach($z
as$D=>$y){ksort($y["columns"]);$xg=array();foreach($y["columns"]as$_=>$X)$xg[]="<i>".h($X)."</i>".($y["lengths"][$_]?"(".$y["lengths"][$_].")":"").($y["descs"][$_]?" DESC":"");echo"<tr title='".h($D)."'><th>$y[type]<td>".implode(", ",$xg)."\n";}echo"</table>\n";}function
selectColumnsPrint($M,$f){global$n;print_fieldset("select",lang(52),$M);$v=0;$M[""]=array();foreach($M
as$_=>$X){$X=$_GET["columns"][$_];$e=select_input(" name='columns[$v][col]'",$f,$X["col"],($_!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($n->functions||$n->grouping?html_select("columns[$v][fun]",array(-1=>"")+array_filter(array(lang(53)=>$n->functions,lang(54)=>$n->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($_!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($e)":$e)."</div>\n";$v++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$f,$z){print_fieldset("search",lang(55),$Z);foreach($z
as$v=>$y){if($y["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$y["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$v]' value='".h($_GET["fulltext"][$v])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$v]",1,isset($_GET["boolean"][$v]),"BOOL"),"</div>\n";}$Ta="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$v=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)))echo"<div>".select_input(" name='where[$v][col]'",$f,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(56).")"),html_select("where[$v][op]",$this->operators,$X["op"],$Ta),"<input type='search' name='where[$v][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Ta }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint($Gf,$f,$z){print_fieldset("sort",lang(57),$Gf);$v=0;foreach((array)$_GET["order"]as$_=>$X){if($X!=""){echo"<div>".select_input(" name='order[$v]'",$f,$X,"selectFieldChange"),checkbox("desc[$v]",1,isset($_GET["desc"][$_]),lang(58))."</div>\n";$v++;}}echo"<div>".select_input(" name='order[$v]'",$f,"","selectAddRow"),checkbox("desc[$v]",1,false,lang(58))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($A){echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='limit' class='size' value='".h($A)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($oi){if($oi!==null)echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($oi)."'>","</div></fieldset>\n";}function
selectActionPrint($z){echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='submit' value='".lang(52)."'>"," <span id='noindex' title='".lang(62)."'></span>","<script".nonce().">\n","const indexColumns = ";$f=array();foreach($z
as$y){$Gb=reset($y["columns"]);if($y["type"]!="FULLTEXT"&&$Gb)$f[$Gb]=1;}$f[""]=1;foreach($f
as$_=>$X)json_row($_);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($pc,$f){}function
selectColumnsProcess($f,$z){global$n;$M=array();$qd=array();foreach((array)$_GET["columns"]as$_=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$n->functions)||in_array($X["fun"],$n->grouping)))){$M[$_]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$n->grouping))$qd[]=$M[$_];}}return
array($M,$qd);}function
selectSearchProcess($q,$z){global$h,$n;$J=array();foreach($z
as$v=>$y){if($y["type"]=="FULLTEXT"&&$_GET["fulltext"][$v]!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$y["columns"])).") AGAINST (".q($_GET["fulltext"][$v]).(isset($_GET["boolean"][$v])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$_=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$tg="";$qb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Nd=process_length($X["val"]);$qb.=" ".($Nd!=""?$Nd:"(NULL)");}elseif($X["op"]=="SQL")$qb=" $X[val]";elseif($X["op"]=="LIKE %%")$qb=" LIKE ".$this->processInput($q[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$qb=" ILIKE ".$this->processInput($q[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$tg="$X[op](".q($X["val"]).", ";$qb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$qb.=" ".$this->processInput($q[$X["col"]],$X["val"]);if($X["col"]!="")$J[]=$tg.$n->convertSearch(idf_escape($X["col"]),$X,$q[$X["col"]]).$qb;else{$jb=array();foreach($q
as$D=>$p){if(isset($p["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$p["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$p["type"]))&&(!preg_match('~date|timestamp~',$p["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$jb[]=$tg.$n->convertSearch(idf_escape($D),$X,$p).$qb;}$J[]=($jb?"(".implode(" OR ",$jb).")":"1 = 0");}}}return$J;}function
selectOrderProcess($q,$z){$J=array();foreach((array)$_GET["order"]as$_=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$_])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$ed){return
false;}function
selectQueryBuild($M,$Z,$qd,$Gf,$A,$F){return"";}function
messageQuery($H,$pi,$Nc=false){global$n;restart_session();$Ed=&get_session("queries");if(!$Ed[$_GET["db"]])$Ed[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ed[$_GET["db"]][]=array($H,time(),$pi);$Kh="sql-".count($Ed[$_GET["db"]]);$J="<a href='#$Kh' class='toggle'>".lang(63)."</a>\n";if(!$Nc&&($oj=$n->warnings())){$w="warnings-".count($Ed[$_GET["db"]]);$J="<a href='#$w' class='toggle'>".lang(45)."</a>, $J<div id='$w' class='hidden'>\n$oj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$Kh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($pi?" <span class='time'>($pi)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ed[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,$q,$K,$Vi){}function
editFunctions($p){global$n;$J=($p["null"]?"NULL/":"");$Vi=isset($_GET["select"])||where($_GET);foreach($n->editFunctions
as$_=>$ld){if(!$_||(!isset($_GET["call"])&&$Vi)){foreach($ld
as$hg=>$X){if(!$hg||preg_match("~$hg~",$p["type"]))$J.="/$X";}}if($_&&!preg_match('~set|blob|bytea|raw|file|bool~',$p["type"]))$J.="/SQL";}if($p["auto_increment"]&&!$Vi)$J=lang(50);return
explode("/",$J);}function
editInput($R,$p,$za,$Y){if($p["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$za value='-1' checked><i>".lang(8)."</i></label> ":"").($p["null"]?"<label><input type='radio'$za value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$za,$p,$Y,$Y===0?0:null);return"";}function
editHint($R,$p,$Y){return"";}function
processInput($p,$Y,$u=""){if($u=="SQL")return$Y;$D=$p["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$u))$J="$u()";elseif(preg_match('~^current_(date|timestamp)$~',$u))$J=$u;elseif(preg_match('~^([+-]|\|\|)$~',$u))$J=idf_escape($D)." $u $J";elseif(preg_match('~^[+-] interval$~',$u))$J=idf_escape($D)." $u ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$u))$J="$u(".idf_escape($D).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$u))$J="$u($J)";return
unconvert_field($p,$J);}function
dumpOutput(){$J=array('text'=>lang(64),'file'=>lang(65));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($l){}function
dumpTable($R,$Sh,$ge=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Sh)dump_csv(array_keys(fields($R)));}else{if($ge==2){$q=array();foreach(fields($R)as$D=>$p)$q[]=idf_escape($D)." $p[full_type]";$j="CREATE TABLE ".table($R)." (".implode(", ",$q).")";}else$j=create_sql($R,$_POST["auto_increment"],$Sh);set_utf8mb4($j);if($Sh&&$j){if($Sh=="DROP+CREATE"||$ge==1)echo"DROP ".($ge==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($ge==1)$j=remove_definer($j);echo"$j;\n\n";}}}function
dumpData($R,$Sh,$H){global$h;if($Sh){$Ke=(JUSH=="sqlite"?0:1048576);$q=array();$Kd=false;if($_POST["format"]=="sql"){if($Sh=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$q=fields($R);if(JUSH=="mssql"){foreach($q
as$p){if($p["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Kd=true;break;}}}}$I=$h->query($H,1);if($I){$Yd="";$Oa="";$le=array();$md=array();$Uh="";$Qc=($R!=''?'fetch_assoc':'fetch_row');while($K=$I->$Qc()){if(!$le){$gj=array();foreach($K
as$X){$p=$I->fetch_field();if($q[$p->name]['generated']){$md[$p->name]=true;continue;}$le[]=$p->name;$_=idf_escape($p->name);$gj[]="$_ = VALUES($_)";}$Uh=($Sh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$gj):"").";\n";}if($_POST["format"]!="sql"){if($Sh=="table"){dump_csv($le);$Sh="INSERT";}dump_csv($K);}else{if(!$Yd)$Yd="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$le)).") VALUES";foreach($K
as$_=>$X){if($md[$_]){unset($K[$_]);continue;}$p=$q[$_];$K[$_]=($X!==null?unconvert_field($p,preg_match(number_type(),$p["type"])&&!preg_match('~\[~',$p["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$eh=($Ke?"\n":" ")."(".implode(",\t",$K).")";if(!$Oa)$Oa=$Yd.$eh;elseif(strlen($Oa)+4+strlen($eh)+strlen($Uh)<$Ke)$Oa.=",$eh";else{echo$Oa.$Uh;$Oa=$Yd.$eh;}}}if($Oa)echo$Oa.$Uh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$h->error)."\n";if($Kd)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Id){return
friendly_url($Id!=""?$Id:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Id,$af=false){$Tf=$_POST["output"];$Ic=(preg_match('~sql~',$_POST["format"])?"sql":($af?"tar":"csv"));header("Content-Type: ".($Tf=="gz"?"application/x-gzip":($Ic=="tar"?"application/x-tar":($Ic=="sql"||$Tf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Tf=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Ic;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(66)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(67):lang(68))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(69)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(70)."</a>\n":"");return
true;}function
navigation($Ye){global$ia,$bc,$h;echo"<h1>".$this->name()." <span class='version'>$ia";$if=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare($ia,$if)<0?h($if):"")."</a>","</span></h1>\n";switch_lang();if($Ye=="auth"){$Tf="";foreach((array)$_SESSION["pwds"]as$ij=>$vh){foreach($vh
as$N=>$dj){$D=h(get_setting("vendor-$ij-$N")?:$bc[$ij]);foreach($dj
as$V=>$G){if($G!==null){$Nb=$_SESSION["db"][$ij][$N][$V];foreach(($Nb?array_keys($Nb):array(""))as$l)$Tf.="<li><a href='".h(auth_url($ij,$N,$V,$l))."'>($D) ".h($V.($N!=""?"@".$this->serverName($N):"").($l!=""?" - $l":""))."</a>\n";}}}}if($Tf)echo"<ul id='logins'>\n$Tf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$Ye&&DB!=""){$h->select_db(DB);$T=table_status('',true);}$this->syntaxHighlighting($T);$this->databasesPrint($Ye);$ma=array();if(DB==""||!$Ye){if(support("sql")){$ma[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(63)."</a>";$ma[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(71)."</a>";}$ma[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(72)."</a>";}$Od=$_GET["ns"]!==""&&!$Ye&&DB!="";if($Od)$ma[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(73)."</a>";echo($ma?"<p class='links'>\n".implode("\n",$ma)."\n":"");if($Od){if($T)$this->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting($T){global$h;echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.1.0");if(support("sql")){echo"<script".nonce().">\n";if($T){$Ae=array();foreach($T
as$R=>$U)$Ae[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$Ae).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";}echo"</script>\n";}echo
script("syntaxHighlighting('".(is_object($h)?preg_replace('~^(\d\.?\d).*~s','\1',$h->server_info):"")."'".($h->flavor=='maria'?", 'maria'":($h->flavor=='cockroach'?", 'cockroach'":"")).");");}function
databasesPrint($Ye){global$b,$h;$k=$this->databases();if(DB&&$k&&!in_array(DB,$k))array_unshift($k,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Lb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(36)."'>".lang(74).":</span> ".($k?html_select("db",array(""=>"")+$k,DB).$Lb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n"),"<input type='submit' value='".lang(20)."'".($k?" class='hidden'":"").">\n";if(support("scheme")){if($Ye!="db"&&DB!=""&&$h->select_db(DB)){echo"<br><span>".lang(75).":</span> ".html_select("ns",array(""=>"")+$b->schemas(),$_GET["ns"]).$Lb;if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint($T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$D=$this->tableName($P);if($D!="")echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(40)."'>".lang(76)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($P)?"view":"structure"))." title='".lang(41)."'>$D</a>":"<span>$D</span>")."\n";}echo"</ul>\n";}}class
Plugins
extends
Adminer{var$plugins;function
__construct($mg){if($mg===null){$mg=array();$Ia="adminer-plugins";if(is_dir($Ia)){foreach(glob("$Ia/*.php")as$r)$Pd=include_once"./$r";}$Dd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ia.php")){$Pd=include_once"./$Ia.php";if(is_array($Pd)){foreach($Pd
as$lg)$mg[get_class($lg)]=$lg;}else$this->error.=lang(77,"<b>$Ia.php</b>",$Dd)."<br>";}foreach(get_declared_classes()as$cb){if(!$mg[$cb]&&preg_match('~^Adminer\w~i',$cb)){$Og=new
\ReflectionClass($cb);$vb=$Og->getConstructor();if($vb&&$vb->getNumberOfRequiredParameters())$this->error.=lang(78,$Dd,"<b>$cb</b>","<b>$Ia.php</b>")."<br>";else$mg[$cb]=new$cb;}}}$this->plugins=$mg;}private
function
callParent($u,$d){return
call_user_func_array(array('parent',$u),$d);}private
function
applyPlugin($u,$Yf){$d=array();foreach($Yf
as$_=>$X)$d[]=&$Yf[$_];foreach($this->plugins
as$lg){if(method_exists($lg,$u)){$J=call_user_func_array(array($lg,$u),$d);if($J!==null)return$J;}}return$this->callParent($u,$d);}private
function
appendPlugin($u,$d){$J=$this->callParent($u,$d);foreach($this->plugins
as$lg){if(method_exists($lg,$u)){$Y=call_user_func_array(array($lg,$u),$d);if($Y)$J+=$Y;}}return$J;}function
dumpFormat(){$d=func_get_args();return$this->appendPlugin(__FUNCTION__,$d);}function
dumpOutput(){$d=func_get_args();return$this->appendPlugin(__FUNCTION__,$d);}function
editRowPrint($R,$q,$K,$Vi){$d=func_get_args();return$this->appendPlugin(__FUNCTION__,$d);}function
editFunctions($p){$d=func_get_args();return$this->appendPlugin(__FUNCTION__,$d);}function
name(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
credentials(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
connectSsl(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
permanentLogin($j=false){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
bruteForceKey(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
serverName($N){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
database(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
schemas(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
databases($bd=true){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
queryTimeout(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
headers(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
csp(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
head($Hb=null){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
css(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
loginForm(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
loginFormField($D,$Cd,$Y){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
login($Ce,$G){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
tableName($Yh){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
fieldName($p,$Gf=0){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLinks($Yh,$O=""){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
foreignKeys($R){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
backwardKeys($R,$Xh){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
backwardKeysPrint($Ea,$K){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectQuery($H,$Oh,$Nc=false){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
sqlCommandQuery($H){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
sqlPrintAfter(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
rowDescription($R){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
rowDescriptions($L,$ed){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLink($X,$p){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectVal($X,$B,$p,$Qf){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
editVal($X,$p){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
tableStructurePrint($q,$Yh=null){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
tableIndexesPrint($z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectColumnsPrint($M,$f){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectSearchPrint($Z,$f,$z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectOrderPrint($Gf,$f,$z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLimitPrint($A){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLengthPrint($oi){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectActionPrint($z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectCommandPrint(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectImportPrint(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectEmailPrint($pc,$f){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectColumnsProcess($f,$z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectSearchProcess($q,$z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectOrderProcess($q,$z){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLimitProcess(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectLengthProcess(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectEmailProcess($Z,$ed){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
selectQueryBuild($M,$Z,$qd,$Gf,$A,$F){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
messageQuery($H,$pi,$Nc=false){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
editInput($R,$p,$za,$Y){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
editHint($R,$p,$Y){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
processInput($p,$Y,$u=""){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpDatabase($l){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpTable($R,$Sh,$ge=0){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpData($R,$Sh,$H){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpFilename($Id){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpHeaders($Id,$af=false){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
dumpFooter(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
importServerPath(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
homepage(){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
navigation($Ye){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
syntaxHighlighting($T){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
databasesPrint($Ye){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}function
tablesPrint($T){$d=func_get_args();return$this->applyPlugin(__FUNCTION__,$d);}}if(function_exists('adminer_object'))$b=adminer_object();elseif(is_dir("adminer-plugins")||file_exists("adminer-plugins.php"))$b=new
Plugins(null);else$b=new
Adminer;$bc=array("server"=>"MySQL / MariaDB")+$bc;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
connect($N="",$V="",$G="",$Kb=null,$ng=null,$Ch=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Gd,$ng)=explode(":",$N,2);$Nh=$b->connectSsl();if($Nh)$this->ssl_set($Nh['key'],$Nh['cert'],$Nh['ca'],'','');$J=@$this->real_connect(($N!=""?$Gd:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$G!=""?$G:ini_get("mysqli.default_pw")),$Kb,(is_numeric($ng)?$ng:ini_get("mysqli.default_port")),(!is_numeric($ng)?$ng:$Ch),($Nh?($Nh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$J;}function
set_charset($Ua){if(parent::set_charset($Ua))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ua");}function
result($H,$p=0){$I=$this->query($H);if(!$I)return
false;$K=$I->fetch_array();return($K?$K[$p]:false);}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db{var$extension="MySQL",$flavor='',$server_info,$affected_rows,$info,$errno,$error;private$link,$result;function
connect($N,$V,$G){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(79,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$G"!=""?$G:ini_get("mysql.default_password")),true,131072);if($this->link)$this->server_info=mysql_get_server_info($this->link);else$this->error=mysql_error();return(bool)$this->link;}function
set_charset($Ua){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ua,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Ua");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Kb){return
mysql_select_db($Kb,$this->link);}function
query($H,$Ni=false){$I=@($Ni?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}function
multi_query($H){return$this->result=$this->query($H);}function
store_result(){return$this->result;}function
next_result(){return
false;}function
result($H,$p=0){$I=$this->query($H);return($I?$I->fetch_column($p):false);}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_column($p){return($this->num_rows?mysql_result($this->result,0,$p):false);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
connect($N,$V,$G){global$b;$Ef=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Nh=$b->connectSsl();if($Nh){if($Nh['key'])$Ef[\PDO::MYSQL_ATTR_SSL_KEY]=$Nh['key'];if($Nh['cert'])$Ef[\PDO::MYSQL_ATTR_SSL_CERT]=$Nh['cert'];if($Nh['ca'])$Ef[\PDO::MYSQL_ATTR_SSL_CA]=$Nh['ca'];if(isset($Nh['verify']))$Ef[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$Nh['verify'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$G,$Ef);return
true;}function
set_charset($Ua){$this->query("SET NAMES $Ua");}function
select_db($Kb){return$this->query("USE ".idf_escape($Kb));}function
query($H,$Ni=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Ni);return
parent::query($H,$Ni);}}}class
Driver
extends
SqlDriver{static$rg=array("MySQLi","MySQL","PDO_MySQL");static$ie="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");function
__construct($h){parent::__construct($h);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(80)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->editFunctions=array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",));if(min_version('5.7.8',10.2,$h))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$h)){$this->types[lang(27)]["uuid"]=128;$this->editFunctions[0]['uuid']='uuid';}if(min_version(9,'',$h)){$this->types[lang(25)]["vector"]=16383;$this->editFunctions[0]['vector']='string_to_vector';}if(min_version(5.7,10.2,$h))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction($p){return(preg_match("~binary~",$p["type"])?"<code class='jush-sql'>UNHEX</code>":($p["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$p["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,$L,$vg){$f=array_keys(reset($L));$tg="INSERT INTO ".table($R)." (".implode(", ",$f).") VALUES\n";$gj=array();foreach($f
as$_)$gj[$_]="$_ = VALUES($_)";$Uh="\nON DUPLICATE KEY UPDATE ".implode(", ",$gj);$gj=array();$ye=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($gj&&(strlen($tg)+$ye+strlen($Y)+strlen($Uh)>1e6)){if(!queries($tg.implode(",\n",$gj).$Uh))return
false;$gj=array();$ye=0;}$gj[]=$Y;$ye+=strlen($Y)+2;}return
queries($tg.implode(",\n",$gj).$Uh);}function
slowQuery($H,$qi){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$qi FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$C))return"$C[1] /*+ MAX_EXECUTION_TIME(".($qi*1000).") */ $C[2]";}}function
convertSearch($x,$X,$p){return(preg_match('~char|text|enum|set~',$p["type"])&&!preg_match("~^utf8~",$p["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($x USING ".charset($this->conn).")":$x);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();select($I);return
ob_get_clean();}}function
tableHelp($D,$ge=false){$Ee=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ee?"$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($Ee?"mysql$D-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Qa;if($Qa===null){$Lh=$this->conn->result("SHOW VARIABLES LIKE 'sql_mode'",1);$Qa=(strpos($Lh,'NO_BACKSLASH_ESCAPES')===false);}return$Qa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}}function
idf_escape($x){return"`".str_replace("`","``",$x)."`";}function
table($x){return
idf_escape($x);}function
connect($Cb){global$bc;$h=new
Db;if($h->connect($Cb[0],$Cb[1],$Cb[2])){$h->set_charset(charset($h));$h->query("SET sql_quote_show_create = 1, autocommit = 1");$h->flavor=(preg_match('~MariaDB~',$h->server_info)?'maria':'');$bc[DRIVER]=($h->flavor=='maria'?"MariaDB":"MySQL");return$h;}$J=$h->error;if(function_exists('iconv')&&!is_utf8($J)&&strlen($eh=iconv("windows-1250","utf-8",$J))>strlen($J))$J=$eh;return$J;}function
get_databases($bd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($bd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$A,$E=0,$qh=" "){return" $H$Z".($A!==null?$qh."LIMIT $A".($E?" OFFSET $E":""):"");}function
limit1($R,$H,$Z,$qh="\n"){return
limit($H,$Z,1,0,$qh);}function
db_collation($l,$ib){$J=null;$j=get_val("SHOW CREATE DATABASE ".idf_escape($l),1);if(preg_match('~ COLLATE ([^ ]+)~',$j,$C))$J=$C[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$j,$C))$J=$ib[$C[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables($k){$J=array();foreach($k
as$l)$J[$l]=count(get_vals("SHOW TABLES IN ".idf_escape($l)));return$J;}function
table_status($D="",$Oc=false){$J=array();foreach(get_rows($Oc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($D!=""){$K["Name"]=$D;return$K;}$J[$K["Name"]]=$K;}return$J;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&min_version(5.6));}function
fields($R){global$h;$Ee=($h->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$p=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$nd=$K["GENERATION_EXPRESSION"];$Lc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Lc,$md);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$He);$m=$K["COLUMN_DEFAULT"];if($m!=""){$fe=preg_match('~text|json~',$He[1]);if(!$Ee&&$fe)$m=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($m));if($Ee||$fe){$m=($m=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($C){return
stripslashes(str_replace("''","'",$C[1]));},$m));}if(!$Ee&&preg_match('~binary~',$He[1])&&preg_match('~^0x(\w*)$~',$m,$C))$m=pack("H*",$C[1]);}$J[$p]=array("field"=>$p,"full_type"=>$U,"type"=>$He[1],"length"=>$He[2],"unsigned"=>ltrim($He[3].$He[4]),"default"=>($md?($Ee?$nd:stripslashes($nd)):$m),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Lc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Lc,$C)?$C[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($md[1]=="PERSISTENT"?"STORED":$md[1]),);}return$J;}function
indexes($R,$i=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$i)as$K){$D=$K["Key_name"];$J[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$D]["columns"][]=$K["Column_name"];$J[$D]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$D]["descs"][]=null;}return$J;}function
foreign_keys($R){global$n;static$hg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Ab=get_val("SHOW CREATE TABLE ".table($R),1);if($Ab){preg_match_all("~CONSTRAINT ($hg) FOREIGN KEY ?\\(((?:$hg,? ?)+)\\) REFERENCES ($hg)(?:\\.($hg))? \\(((?:$hg,? ?)+)\\)(?: ON DELETE ($n->onActions))?(?: ON UPDATE ($n->onActions))?~",$Ab,$Ie,PREG_SET_ORDER);foreach($Ie
as$C){preg_match_all("~$hg~",$C[2],$Eh);preg_match_all("~$hg~",$C[5],$ii);$J[idf_unescape($C[1])]=array("db"=>idf_unescape($C[4]!=""?$C[3]:$C[4]),"table"=>idf_unescape($C[4]!=""?$C[4]:$C[3]),"source"=>array_map('Adminer\idf_unescape',$Eh[0]),"target"=>array_map('Adminer\idf_unescape',$ii[0]),"on_delete"=>($C[6]?:"RESTRICT"),"on_update"=>($C[7]?:"RESTRICT"),);}}return$J;}function
view($D){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$_=>$X)asort($J[$_]);return$J;}function
information_schema($l){return($l=="information_schema")||(min_version(5.5)&&$l=="performance_schema");}function
error(){global$h;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$h->error));}function
create_database($l,$hb){return
queries("CREATE DATABASE ".idf_escape($l).($hb?" COLLATE ".q($hb):""));}function
drop_databases($k){$J=apply_queries("DROP DATABASE",$k,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($D,$hb){$J=false;if(create_database($D,$hb)){$T=array();$lj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$lj[]=$R;else$T[]=$R;}$J=(!$T&&!$lj)||move_tables($T,$lj,$D);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ba=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$y){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$y["columns"],true)){$Ba="";break;}if($y["type"]=="PRIMARY")$Ba=" UNIQUE";}}return" AUTO_INCREMENT$Ba";}function
alter_table($R,$D,$q,$dd,$nb,$sc,$hb,$Aa,$dg){global$h;$c=array();foreach($q
as$p){if($p[1]){$m=$p[1][3];if(preg_match('~ GENERATED~',$m)){$p[1][3]=($h->flavor=='maria'?"":$p[1][2]);$p[1][2]=$m;}$c[]=($R!=""?($p[0]!=""?"CHANGE ".idf_escape($p[0]):"ADD"):" ")." ".implode($p[1]).($R!=""?$p[2]:"");}else$c[]="DROP ".idf_escape($p[0]);}$c=array_merge($c,$dd);$P=($nb!==null?" COMMENT=".q($nb):"").($sc?" ENGINE=".q($sc):"").($hb?" COLLATE ".q($hb):"").($Aa!=""?" AUTO_INCREMENT=$Aa":"");if($R=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)$P$dg");if($R!=$D)$c[]="RENAME TO ".table($D);if($P)$c[]=ltrim($P);return($c||$dg?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$dg):true);}function
alter_indexes($R,$c){foreach($c
as$_=>$X)$c[$_]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$c));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($lj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$lj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$lj,$ii){global$h;$Sg=array();foreach($T
as$R)$Sg[]=table($R)." TO ".idf_escape($ii).".".table($R);if(!$Sg||queries("RENAME TABLE ".implode(", ",$Sg))){$Rb=array();foreach($lj
as$R)$Rb[table($R)]=view($R);$h->select_db($ii);$l=idf_escape(DB);foreach($Rb
as$D=>$kj){if(!queries("CREATE VIEW $D AS ".str_replace(" $l."," ",$kj["select"]))||!queries("DROP VIEW $l.$D"))return
false;}return
true;}return
false;}function
copy_tables($T,$lj,$ii){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$D=($ii==DB?table("copy_$R"):idf_escape($ii).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($R))||!queries("INSERT INTO $D SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$Gi=$K["Trigger"];if(!queries("CREATE TRIGGER ".($ii==DB?idf_escape("copy_$Gi"):idf_escape($ii).".".idf_escape($Gi))." $K[Timing] $K[Event] ON $D FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($lj
as$R){$D=($ii==DB?table("copy_$R"):idf_escape($ii).".".table($R));$kj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $kj[select]"))return
false;}return
true;}function
trigger($D){if($D=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$U){global$n;$ua=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Fh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$uc=$n->enumLength;$Li="((".implode("|",array_merge(array_keys($n->types()),$ua)).")\\b(?:\\s*\\(((?:[^'\")]|$uc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$hg="$Fh*(".($U=="FUNCTION"?"":$n->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Li";$j=get_val("SHOW CREATE $U ".idf_escape($D),2);preg_match("~\\(((?:$hg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Li\\s+":"")."(.*)~is",$j,$C);$q=array();preg_match_all("~$hg\\s*,?~is",$C[1],$Ie,PREG_SET_ORDER);foreach($Ie
as$Xf)$q[]=array("field"=>str_replace("``","`",$Xf[2]).$Xf[3],"type"=>strtolower($Xf[5]),"length"=>preg_replace_callback("~$uc~s",'Adminer\normalize_enum',$Xf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Xf[8] $Xf[7]"))),"null"=>1,"full_type"=>$Xf[4],"inout"=>strtoupper($Xf[1]),"collation"=>strtolower($Xf[9]),);return
array("fields"=>$q,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($D)),)+($U!="FUNCTION"?array("definition"=>$C[11]):array("returns"=>array("type"=>$C[12],"length"=>$C[13],"unsigned"=>$C[15],"collation"=>$C[16]),"definition"=>$C[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($D,$K){return
idf_escape($D);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain($h,$H){return$h->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Aa,$Sh){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Aa)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Kb){return"USE ".idf_escape($Kb);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field($p){if(preg_match("~binary~",$p["type"]))return"HEX(".idf_escape($p["field"]).")";if($p["type"]=="bit")return"BIN(".idf_escape($p["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$p["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($p["field"]).")";}function
unconvert_field($p,$J){if(preg_match("~binary~",$p["type"]))$J="UNHEX($J)";if($p["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$p["type"])){$tg=(min_version(8)?"ST_":"");$J=$tg."GeomFromText($J, $tg"."SRID($p[field]))";}return$J;}function
support($Pc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning")).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Pc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}}define('Adminer\JUSH',Driver::$ie);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($si,$o="",$Na=array(),$ti=""){global$ca,$ia,$b,$bc;page_headers();if(is_ajax()&&$o){page_messages($o);exit;}if(!ob_get_level())ob_start(null,4096);$ui=$si.($ti!=""?": $ti":"");$vi=strip_tags($ui.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$vi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.1.0"),'">
';$Eb=$b->css();$zd=false;$xd=false;foreach($Eb
as$r){if(strpos($r,"adminer.css")!==false)$zd=true;if(strpos($r,"adminer-dark.css")!==false)$xd=true;}$Hb=($zd?($xd?null:false):($xd?:null));$Qe=" media='(prefers-color-scheme: dark)'";if($Hb!==false)echo"<link rel='stylesheet'".($Hb?"":$Qe)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.1.0")."'>\n";echo"<meta name='color-scheme' content='".($Hb===null?"light dark":($Hb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.1.0");if($b->head($Hb))echo"<link rel='shortcut icon' type='image/x-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.0")."'>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=5.1.0")."'>\n";foreach($Eb
as$X)echo"<link rel='stylesheet'".(preg_match('~-dark~',$X)&&!$Hb?$Qe:"")." href='".h($X)."'>\n";echo"\n<body class='".lang(81)." nojs'>\n";$r=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($r)&&filemtime($r)+86400>time()){$jj=unserialize(file_get_contents($r));$Cg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($jj["version"],base64_decode($jj["signature"]),$Cg)==1)$_COOKIE["adminer_version"]=$jj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(82))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n";if($Na!==null){$B=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($B?:".").'">'.$bc[DRIVER].'</a> » ';$B=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=$b->serverName(SERVER);$N=($N!=""?$N:lang(33));if($Na===false)echo"$N\n";else{echo"<a href='".h($B)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Na)))echo'<a href="'.h($B."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Na)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Na
as$_=>$X){$Tb=(is_array($X)?$X[1]:h($X));if($Tb!="")echo"<a href='".h(ME."$_=").urlencode(is_array($X)?$X[0]:$X)."'>$Tb</a> » ";}}echo"$si\n";}}echo"<h2>$ui</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($o);$k=&get_session("dbs");if(DB!=""&&$k&&!in_array(DB,$k,true))$k=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Db){$Bd=array();foreach($Db
as$_=>$X)$Bd[]="$_ $X";header("Content-Security-Policy: ".implode("; ",$Bd));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$kf;if(!$kf)$kf=base64_encode(rand_string());return$kf;}function
page_messages($o){global$b;$Wi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$We=$_SESSION["messages"][$Wi];if($We){echo"<div class='message'>".implode("</div>\n<div class='message'>",$We)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Wi]);}if($o)echo"<div class='error'>$o</div>\n";if($b->error)echo"<div class='error'>$b->error</div>\n";}function
page_footer($Ye=""){global$b;echo"</div>\n\n<div id='menu'>\n";$b->navigation($Ye);echo"</div>\n\n";if($Ye!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(83),'" id="logout">
',input_token(),'</p>
</form>
';echo
script("setupSubmitHighlight(document);");}function
int32($cf){while($cf>=2147483648)$cf-=4294967296;while($cf<=-2147483649)$cf+=4294967296;return(int)$cf;}function
long2str($W,$nj){$eh='';foreach($W
as$X)$eh.=pack('V',$X);if($nj)return
substr($eh,0,end($W));return$eh;}function
str2long($eh,$nj){$W=array_values(unpack('V*',str_pad($eh,4*ceil(strlen($eh)/4),"\0")));if($nj)$W[]=strlen($eh);return$W;}function
xxtea_mx($uj,$tj,$Vh,$je){return
int32((($uj>>5&0x7FFFFFF)^$tj<<2)+(($tj>>3&0x1FFFFFFF)^$uj<<4))^int32(($Vh^$tj)+($je^$uj));}function
encrypt_string($Qh,$_){if($Qh=="")return"";$_=array_values(unpack("V*",pack("H*",md5($_))));$W=str2long($Qh,true);$cf=count($W)-1;$uj=$W[$cf];$tj=$W[0];$Dg=floor(6+52/($cf+1));$Vh=0;while($Dg-->0){$Vh=int32($Vh+0x9E3779B9);$jc=$Vh>>2&3;for($Vf=0;$Vf<$cf;$Vf++){$tj=$W[$Vf+1];$bf=xxtea_mx($uj,$tj,$Vh,$_[$Vf&3^$jc]);$uj=int32($W[$Vf]+$bf);$W[$Vf]=$uj;}$tj=$W[0];$bf=xxtea_mx($uj,$tj,$Vh,$_[$Vf&3^$jc]);$uj=int32($W[$cf]+$bf);$W[$cf]=$uj;}return
long2str($W,false);}function
decrypt_string($Qh,$_){if($Qh=="")return"";if(!$_)return
false;$_=array_values(unpack("V*",pack("H*",md5($_))));$W=str2long($Qh,false);$cf=count($W)-1;$uj=$W[$cf];$tj=$W[0];$Dg=floor(6+52/($cf+1));$Vh=int32($Dg*0x9E3779B9);while($Vh){$jc=$Vh>>2&3;for($Vf=$cf;$Vf>0;$Vf--){$uj=$W[$Vf-1];$bf=xxtea_mx($uj,$tj,$Vh,$_[$Vf&3^$jc]);$tj=int32($W[$Vf]-$bf);$W[$Vf]=$tj;}$uj=$W[$cf];$bf=xxtea_mx($uj,$tj,$Vh,$_[$Vf&3^$jc]);$tj=int32($W[0]-$bf);$W[0]=$tj;$Vh=int32($Vh-0x9E3779B9);}return
long2str($W,true);}$h='';$Ad=$_SESSION["token"];if(!$Ad)$_SESSION["token"]=rand(1,1e6);$yi=get_token();$jg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($_)=explode(":",$X);$jg[$_]=$X;}}function
add_invalid_login(){global$b;$Ga=get_temp_dir()."/adminer.invalid";foreach(glob("$Ga*")?:array($Ga)as$r){$t=file_open_lock($r);if($t)break;}if(!$t)$t=file_open_lock("$Ga-".rand_string());if(!$t)return;$be=unserialize(stream_get_contents($t));$pi=time();if($be){foreach($be
as$ce=>$X){if($X[0]<$pi)unset($be[$ce]);}}$ae=&$be[$b->bruteForceKey()];if(!$ae)$ae=array($pi+30*60,0);$ae[1]++;file_write_unlock($t,serialize($be));}function
check_invalid_login(){global$b;$be=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$r){$t=file_open_lock($r);if($t){$be=unserialize(stream_get_contents($t));file_unlock($t);break;}}$ae=($be?$be[$b->bruteForceKey()]:array());$jf=($ae[1]>29?$ae[0]-time():0);if($jf>0)auth_error(lang(84,ceil($jf/60)));}$_a=$_POST["auth"];if($_a){session_regenerate_id();$ij=$_a["driver"];$N=$_a["server"];$V=$_a["username"];$G=(string)$_a["password"];$l=$_a["db"];set_password($ij,$N,$V,$G);$_SESSION["db"][$ij][$N][$V][$l]=true;if($_a["permanent"]){$_=implode("-",array_map('base64_encode',array($ij,$N,$V,$l)));$yg=$b->permanentLogin(true);$jg[$_]="$_:".base64_encode($yg?encrypt_string($G,$yg):"");cookie("adminer_permanent",implode(" ",$jg));}if(count($_POST)==1||DRIVER!=$ij||SERVER!=$N||$_GET["username"]!==$V||DB!=$l)redirect(auth_url($ij,$N,$V,$l));}elseif($_POST["logout"]&&(!$Ad||verify_token())){foreach(array("pwds","db","dbs","queries")as$_)set_session($_,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($jg&&!$_SESSION["pwds"]){session_regenerate_id();$yg=$b->permanentLogin();foreach($jg
as$_=>$X){list(,$bb)=explode(":",$X);list($ij,$N,$V,$l)=array_map('base64_decode',explode("-",$_));set_password($ij,$N,$V,decrypt_string(base64_decode($bb),$yg));$_SESSION["db"][$ij][$N][$V][$l]=true;}}function
unset_permanent(){global$jg;foreach($jg
as$_=>$X){list($ij,$N,$V,$l)=array_map('base64_decode',explode("-",$_));if($ij==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$l==DB)unset($jg[$_]);}cookie("adminer_permanent",implode(" ",$jg));}function
auth_error($o){global$b,$Ad;$wh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$wh]||$_GET[$wh])&&!$Ad)$o=lang(87);else{restart_session();add_invalid_login();$G=get_password();if($G!==null){if($G===false)$o.=($o?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$wh]&&$_GET[$wh]&&ini_bool("session.use_only_cookies"))$o=lang(89);$Yf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$Yf["lifetime"]);page_header(lang(37),$o,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(91),lang(92,implode(", ",Driver::$rg)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Gd,$ng)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$ng,$C)&&($C[1]<1024||$C[1]>65535))auth_error(lang(93));check_invalid_login();$h=connect($b->credentials());if(is_object($h)){$n=new
Driver($h);if($b->operators===null)$b->operators=$n->operators;if(Driver::$ie=='sql'||$h->flavor=='cockroach')save_settings(array("vendor-".DRIVER."-".SERVER=>$bc[DRIVER]));}}$Ce=null;if(!is_object($h)||($Ce=$b->login($_GET["username"],get_password()))!==true){$o=(is_string($h)?nl_br(h($h)):(is_string($Ce)?$Ce:lang(94)));auth_error($o.(preg_match('~^ | $~',get_password())?'<br>'.lang(95):''));}if($_POST["logout"]&&$Ad&&!verify_token()){page_header(lang(83),lang(96));page_footer("db");exit;}if($_a&&$_POST["token"])$_POST["token"]=$yi;$o='';if($_POST){if(!verify_token()){$Vd="max_input_vars";$Oe=ini_get($Vd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$_){$X=ini_get($_);if($X&&(!$Oe||$X<$Oe)){$Vd=$_;$Oe=$X;}}}$o=(!$_POST["token"]&&$Oe?lang(97,"'$Vd'"):lang(96).' '.lang(98));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$o=lang(99,"'post_max_size'");if(isset($_GET["sql"]))$o.=' '.lang(100);}function
select($I,$i=null,$Kf=array(),$A=0){$Ae=array();$z=array();$f=array();$La=array();$Mi=array();$J=array();for($v=0;(!$A||$v<$A)&&($K=$I->fetch_row());$v++){if(!$v){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($he=0;$he<count($K);$he++){$p=$I->fetch_field();$D=$p->name;$Jf=(isset($p->orgtable)?$p->orgtable:"");$If=(isset($p->orgname)?$p->orgname:$D);if($Kf&&JUSH=="sql")$Ae[$he]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($Jf!=""){if(isset($p->table))$J[$p->table]=$Jf;if(!isset($z[$Jf])){$z[$Jf]=array();foreach(indexes($Jf,$i)as$y){if($y["type"]=="PRIMARY"){$z[$Jf]=array_flip($y["columns"]);break;}}$f[$Jf]=$z[$Jf];}if(isset($f[$Jf][$If])){unset($f[$Jf][$If]);$z[$Jf][$If]=$he;$Ae[$he]=$Jf;}}if($p->charsetnr==63)$La[$he]=true;$Mi[$he]=$p->type;echo"<th".($Jf!=""||$p->name!=$If?" title='".h(($Jf!=""?"$Jf.":"").$If)."'":"").">".h($D).($Kf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$_=>$X){$B="";if(isset($Ae[$_])&&!$f[$Ae[$_]]){if($Kf&&JUSH=="sql"){$R=$K[array_search("table=",$Ae)];$B=ME.$Ae[$_].urlencode($Kf[$R]!=""?$Kf[$R]:$R);}else{$B=ME."edit=".urlencode($Ae[$_]);foreach($z[$Ae[$_]]as$fb=>$he)$B.="&where".urlencode("[".bracket_escape($fb)."]")."=".urlencode($K[$he]);}}elseif(is_url($X))$B=$X;if($X===null)$X="<i>NULL</i>";elseif($La[$_]&&!is_utf8($X))$X="<i>".lang(46,strlen($X))."</i>";else{$X=h($X);if($Mi[$_]==254)$X="<code>$X</code>";}if($B)$X="<a href='".h($B)."'".(is_url($B)?target_blank():'').">$X</a>";echo"<td".($Mi[$_]<=9||$Mi[$_]==246?" class='number'":"").">$X";}}echo($v?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($oh){$J=array();foreach(table_status('',true)as$ai=>$R){if($ai!=$oh&&fk_support($R)){foreach(fields($ai)as$p){if($p["primary"]){if($J[$ai]){unset($J[$ai]);break;}$J[$ai]=$p;}}}}return$J;}function
textarea($D,$Y,$L=10,$jb=80){echo"<textarea name='".h($D)."' rows='$L' cols='$jb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($za,$Ef,$Y="",$zf="",$kg=""){$hi=($Ef?"select":"input");return"<$hi$za".($Ef?"><option value=''>$kg".optionlist($Ef,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$kg'>").($zf?script("qsl('$hi').onchange = $zf;",""):"");}function
json_row($_,$X=null){static$Vc=true;if($Vc)echo"{";if($_!=""){echo($Vc?"":",")."\n\t\"".addcslashes($_,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Vc=false;}else{echo"\n}\n";$Vc=true;}}function
edit_type($_,$p,$ib,$fd=array(),$Mc=array()){global$n;$U=$p["type"];echo"<td><select name='".h($_)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,$n->types())&&!isset($fd[$U])&&!in_array($U,$Mc))$Mc[]=$U;$Rh=$n->structuredTypes();if($fd)$Rh[lang(101)]=$fd;echo
optionlist(array_merge($Mc,$Rh),$U),"</select><td>","<input name='".h($_)."[length]' value='".h($p["length"])."' size='3'".(!$p["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($ib?"<input list='collations' name='".h($_)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($p["collation"])."' placeholder='(".lang(102).")'>":''),($n->unsigned?"<select name='".h($_)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($n->unsigned,$p["unsigned"]).'</select>':''),(isset($p['on_update'])?"<select name='".h($_)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(103).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?"CURRENT_TIMESTAMP":$p["on_update"])).'</select>':''),($fd?"<select name='".h($_)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(104).")".optionlist(explode("|",$n->onActions),$p["on_delete"])."</select> ":" ");}function
get_partitions_info($R){global$h;$jd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=$h->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $jd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$eg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $jd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($eg);$J["partition_values"]=array_values($eg);return$J;}function
process_length($ye){global$n;$wc=$n->enumLength;return(preg_match("~^\\s*\\(?\\s*$wc(?:\\s*,\\s*$wc)*+\\s*\\)?\\s*\$~",$ye)&&preg_match_all("~$wc~",$ye,$Ie)?"(".implode(",",$Ie[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$ye)));}function
process_type($p,$gb="COLLATE"){global$n;return" $p[type]".process_length($p["length"]).(preg_match(number_type(),$p["type"])&&in_array($p["unsigned"],$n->unsigned)?" $p[unsigned]":"").(preg_match('~char|text|enum|set~',$p["type"])&&$p["collation"]?" $gb ".(JUSH=="mssql"?$p["collation"]:q($p["collation"])):"");}function
process_field($p,$Ki){if($p["on_update"])$p["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$p["on_update"]);return
array(idf_escape(trim($p["field"])),process_type($Ki),($p["null"]?" NULL":" NOT NULL"),default_value($p),(preg_match('~timestamp|datetime~',$p["type"])&&$p["on_update"]?" ON UPDATE $p[on_update]":""),(support("comment")&&$p["comment"]!=""?" COMMENT ".q($p["comment"]):""),($p["auto_increment"]?auto_increment():null),);}function
default_value($p){global$n;$m=$p["default"];$md=$p["generated"];return($m===null?"":(in_array($md,$n->generated)?(JUSH=="mssql"?" AS ($m)".($md=="VIRTUAL"?"":" $md")."":" GENERATED ALWAYS AS ($m) $md"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$m)&&(preg_match('~char|binary|text|json|enum|set~',$p["type"])||preg_match('~^(?![a-z])~i',$m))?(JUSH=="sql"&&preg_match('~text|json~',$p["type"])?"(".q($m).")":q($m)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($m)":$m)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$_=>$X){if(preg_match("~$_|$X~",$U))return" class='$_'";}}function
edit_fields($q,$ib,$U="TABLE",$fd=array()){global$n;$q=array_values($q);$Pb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$ob=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(105):lang(106)),"<td id='label-type'>".lang(48)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(107),"<td>".lang(108);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(50)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Pb>".lang(51),(support("comment")?"<td id='label-comment'$ob>".lang(49):"");echo"<td><input type='image' class='icon' name='add[".(support("move_col")?0:count($q))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".lang(109)."'>".script("row_count = ".count($q).";"),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($q
as$v=>$p){$v++;$Lf=$p[($_POST?"orig":"field")];$Yb=(isset($_POST["add"][$v-1])||(isset($p["field"])&&!$_POST["drop_col"][$v]))&&(support("drop_col")||$Lf=="");echo"<tr".($Yb?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$v][inout]",explode("|",$n->inout),$p["inout"]):"")."<th>";if($Yb)echo"<input name='fields[$v][field]' value='".h($p["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$v][orig]",$Lf);edit_type("fields[$v]",$p,$ib,$fd);if($U=="TABLE")echo"<td>".checkbox("fields[$v][null]",1,$p["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$v'".($p["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Pb>".($n->generated?html_select("fields[$v][generated]",array_merge(array("","DEFAULT"),$n->generated),$p["generated"])." ":checkbox("fields[$v][generated]",1,$p["generated"],"","","","label-default")),"<input name='fields[$v][default]' value='".h($p["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$ob><input name='fields[$v][comment]' value='".h($p["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$v]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".lang(109)."'> "."<input type='image' class='icon' name='up[$v]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=5.1.0")."' alt='↑' title='".lang(110)."'> "."<input type='image' class='icon' name='down[$v]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=5.1.0")."' alt='↓' title='".lang(111)."'> ":""),($Lf==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$v]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=5.1.0")."' alt='x' title='".lang(112)."'>":"");}}function
process_fields(&$q){$E=0;if($_POST["up"]){$se=0;foreach($q
as$_=>$p){if(key($_POST["up"])==$_){unset($q[$_]);array_splice($q,$se,0,array($p));break;}if(isset($p["field"]))$se=$E;$E++;}}elseif($_POST["down"]){$hd=false;foreach($q
as$_=>$p){if(isset($p["field"])&&$hd){unset($q[key($_POST["down"])]);array_splice($q,$E,0,array($hd));break;}if(key($_POST["down"])==$_)$hd=$p;$E++;}}elseif($_POST["add"]){$q=array_values($q);array_splice($q,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($C){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($C[0][0].$C[0][0],$C[0][0],substr($C[0],1,-1))),'\\'))."'";}function
grant($od,$_g,$f,$wf){if(!$_g)return
true;if($_g==array("ALL PRIVILEGES","GRANT OPTION"))return($od=="GRANT"?queries("$od ALL PRIVILEGES$wf WITH GRANT OPTION"):queries("$od ALL PRIVILEGES$wf")&&queries("$od GRANT OPTION$wf"));return
queries("$od ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$f, ",$_g).$f).$wf);}function
drop_create($cc,$j,$ec,$li,$gc,$Be,$Ve,$Te,$Ue,$tf,$gf){if($_POST["drop"])query_redirect($cc,$Be,$Ve);elseif($tf=="")query_redirect($j,$Be,$Ue);elseif($tf!=$gf){$Bb=queries($j);queries_redirect($Be,$Te,$Bb&&queries($cc));if($Bb)queries($ec);}else
queries_redirect($Be,$Te,queries($li)&&queries($gc)&&queries($cc)&&queries($j));}function
create_trigger($wf,$K){$ri=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$wf.$ri:$ri.$wf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($ah,$K){global$n;$O=array();$q=(array)$K["fields"];ksort($q);foreach($q
as$p){if($p["field"]!="")$O[]=(preg_match("~^($n->inout)\$~",$p["inout"])?"$p[inout] ":"").idf_escape($p["field"]).process_type($p,"CHARACTER SET");}$Qb=rtrim($K["definition"],";");return"CREATE $ah ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($ah=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Qb):"\n$Qb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key($s){global$n;$l=$s["db"];$lf=$s["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$s["source"])).") REFERENCES ".($l!=""&&$l!=$_GET["db"]?idf_escape($l).".":"").($lf!=""&&$lf!=$_GET["ns"]?idf_escape($lf).".":"").idf_escape($s["table"])." (".implode(", ",array_map('Adminer\idf_escape',$s["target"])).")".(preg_match("~^($n->onActions)\$~",$s["on_delete"])?" ON DELETE $s[on_delete]":"").(preg_match("~^($n->onActions)\$~",$s["on_update"])?" ON UPDATE $s[on_update]":"");}function
tar_file($r,$wi){$J=pack("a100a8a8a8a12a12",$r,644,0,0,decoct($wi->size),decoct(time()));$ab=8*32;for($v=0;$v<strlen($J);$v++)$ab+=ord($J[$v]);$J.=sprintf("%06o",$ab)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$wi->send();echo
str_repeat("\0",511-($wi->size+511)%512);}function
ini_bytes($Vd){$X=ini_get($Vd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link($gg,$mi="<sup>?</sup>"){global$h;$uh=$h->server_info;$jj=preg_replace('~^(\d\.?\d).*~s','\1',$uh);$Yi=array('sql'=>"https://dev.mysql.com/doc/refman/$jj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".($h->flavor=='cockroach'?"current":$jj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$uh)."&id=",);if($h->flavor=='maria'){$Yi['sql']="https://mariadb.com/kb/en/";$gg['sql']=(isset($gg['mariadb'])?$gg['mariadb']:str_replace(".html","/",$gg['sql']));}return($gg[JUSH]?"<a href='".h($Yi[JUSH].$gg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$jj":""))."'".target_blank().">$mi</a>":"");}function
db_size($l){global$h;if(!$h->select_db($l))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($j){global$h;static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$j)){$O=true;echo"SET NAMES ".charset($h).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$h->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(36).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$o)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$o,false);echo"<p class='links'>\n";foreach(array('database'=>lang(116),'privileges'=>lang(70),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),)as$_=>$X){if(support($_))echo"<a href='".h(ME)."$_='>$X</a>\n";}echo"<p>".lang(120,$bc[DRIVER],"<b>".h($h->server_info)."</b>","<b>$h->extension</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";if(isset($b->plugins)&&is_array($b->plugins)){echo"<p>".lang(122).":\n<ul>\n";foreach($b->plugins
as$lg){$Og=new
\ReflectionObject($lg);echo"<li><b>".get_class($lg)."</b>".h(preg_match('~^/[\s*]+(.+)~',$Og->getDocComment(),$C)?": $C[1]":"")."\n";}echo"</ul>\n";}$k=$b->databases();if($k){$ih=support("scheme");$ib=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(36).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(123)."</a>":"")."<td>".lang(124)."<td>".lang(125)."<td>".lang(126)." - <a href='".h(ME)."dbsize=1'>".lang(127)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$k=($_GET["dbsize"]?count_tables($k):array_flip($k));foreach($k
as$l=>$T){$Zg=h(ME)."db=".urlencode($l);$w=h("Db-".$l);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$l,in_array($l,(array)$_POST["db"]),"","","",$w):""),"<th><a href='$Zg' id='$w'>".h($l)."</a>";$hb=h(db_collation($l,$ib));echo"<td>".(support("database")?"<a href='$Zg".($ih?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$hb</a>":$hb),"<td align='right'><a href='$Zg&amp;schema=' id='tables-".h($l)."' title='".lang(69)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($l)."'>".($_GET["dbsize"]?db_size($l):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(128)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(129)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(75).": ".h($_GET["ns"]),lang(130),true);page_footer("ns");exit;}}}class
TmpFile{private$handler,$size;function
__construct(){$this->handler=tmpfile();}function
write($xb){$this->size+=strlen($xb);fwrite($this->handler,$xb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$q=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=$n->select($a,$M,array(where($_GET,$q)),$M);$K=($I?$I->fetch_row():array());echo$n->value($K[0],$q[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$q=fields($a);if(!$q)$o=error();$S=table_status1($a);$D=$b->tableName($S);page_header(($q&&is_view($S)?$S['Engine']=='materialized view'?lang(131):lang(132):lang(133)).": ".($D!=""?$D:h($a)),$o);$Yg=array();foreach($q
as$_=>$p)$Yg+=$p["privileges"];$b->selectLinks($S,(isset($Yg["insert"])||!support("table")?"":null));$nb=$S["Comment"];if($nb!="")echo"<p class='nowrap'>".lang(49).": ".h($nb)."\n";if($q)$b->tableStructurePrint($q,$S);if(support("indexes")&&$n->supportsIndex($S)){echo"<h3 id='indexes'>".lang(134)."</h3>\n";$z=indexes($a);if($z)$b->tableIndexesPrint($z);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(135)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(101)."</h3>\n";$fd=foreign_keys($a);if($fd){echo"<table>\n","<thead><tr><th>".lang(136)."<td>".lang(137)."<td>".lang(104)."<td>".lang(103)."<td></thead>\n";foreach($fd
as$D=>$s){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$s["source"]))."</i>";$B=($s["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($s["db"]),ME):($s["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($s["ns"]),ME):ME));echo"<td><a href='".h($B."table=".urlencode($s["table"]))."'>".($s["db"]!=""&&$s["db"]!=DB?"<b>".h($s["db"])."</b>.":"").($s["ns"]!=""&&$s["ns"]!=$_GET["ns"]?"<b>".h($s["ns"])."</b>.":"").h($s["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$s["target"]))."</i>)","<td>".h($s["on_delete"]),"<td>".h($s["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.lang(138).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(139)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(140)."</h3>\n";$Wa=$n->checkConstraints($a);if($Wa){echo"<table>\n";foreach($Wa
as$_=>$X)echo"<tr title='".h($_)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($_))."'>".lang(138)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(141)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(142)."</h3>\n";$Ji=triggers($a);if($Ji){echo"<table>\n";foreach($Ji
as$_=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($_)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($_))."'>".lang(138)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(143)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(69),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$ci=array();$di=array();$ea=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Ie,PREG_SET_ORDER);foreach($Ie
as$v=>$C){$ci[$C[1]]=array($C[2],$C[3]);$di[]="\n\t'".js_escape($C[1])."': [ $C[2], $C[3] ]";}$zi=0;$Ha=-1;$gh=array();$Ng=array();$we=array();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$og=0;$gh[$R]["fields"]=array();foreach(fields($R)as$D=>$p){$og+=1.25;$p["pos"]=$og;$gh[$R]["fields"][$D]=$p;}$gh[$R]["pos"]=($ci[$R]?:array($zi,0));foreach($b->foreignKeys($R)as$X){if(!$X["db"]){$ue=$Ha;if($ci[$R][1]||$ci[$X["table"]][1])$ue=min(floatval($ci[$R][1]),floatval($ci[$X["table"]][1]))-1;else$Ha-=.1;while($we[(string)$ue])$ue-=.0001;$gh[$R]["references"][$X["table"]][(string)$ue]=array($X["source"],$X["target"]);$Ng[$X["table"]][$R][(string)$ue]=$X["target"];$we[(string)$ue]=true;}}$zi=max($zi,$gh[$R]["pos"][0]+2.5+$og);}echo'<div id="schema" style="height: ',$zi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$di)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$zi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($gh
as$D=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$p){$X='<span'.type_class($p["type"]).' title="'.h($p["full_type"].($p["null"]?" NULL":'')).'">'.h($p["field"]).'</span>';echo"<br>".($p["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$ji=>$Pg){foreach($Pg
as$ue=>$Kg){$ve=$ue-$ci[$D][1];$v=0;foreach($Kg[0]as$Eh)echo"\n<div class='references' title='".h($ji)."' id='refs$ue-".($v++)."' style='left: $ve"."em; top: ".$R["fields"][$Eh]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$ve)."em;'></div></div>";}}foreach((array)$Ng[$D]as$ji=>$Pg){foreach($Pg
as$ue=>$f){$ve=$ue-$ci[$D][1];$v=0;foreach($f
as$ii)echo"\n<div class='references' title='".h($ji)."' id='refd$ue-".($v++)."'"." style='left: $ve"."em; top: ".$R["fields"][$ii]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=5.1.0")."'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$ve)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($gh
as$D=>$R){foreach((array)$R["references"]as$ji=>$Pg){foreach($Pg
as$ue=>$Kg){$Xe=$zi;$Me=-10;foreach($Kg[0]as$_=>$Eh){$pg=$R["pos"][0]+$R["fields"][$Eh]["pos"];$qg=$gh[$ji]["pos"][0]+$gh[$ji]["fields"][$Kg[1][$_]]["pos"];$Xe=min($Xe,$pg,$qg);$Me=max($Me,$pg,$qg);}echo"<div class='references' id='refl$ue' style='left: $ue"."em; top: $Xe"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($Me-$Xe)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(144),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$o){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Ic=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$ee=preg_match('~sql~',$_POST["format"]);if($ee){echo"-- Adminer $ia ".$bc[DRIVER]." ".str_replace("\n"," ",$h->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$h->query("SET time_zone = '+00:00'");$h->query("SET sql_mode = ''");}}$Sh=$_POST["db_style"];$k=array(DB);if(DB==""){$k=$_POST["databases"];if(is_string($k))$k=explode("\n",rtrim(str_replace("\r","",$k),"\n"));}foreach((array)$k
as$l){$b->dumpDatabase($l);if($h->select_db($l)){if($ee&&preg_match('~CREATE~',$Sh)&&($j=get_val("SHOW CREATE DATABASE ".idf_escape($l),1))){set_utf8mb4($j);if($Sh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($l).";\n";echo"$j;\n";}if($ee){if($Sh)echo
use_sql($l).";\n\n";$Sf="";if($_POST["types"]){foreach(types()as$w=>$U){$xc=type_values($w);if($xc)$Sf.=($Sh!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($xc);\n\n";else$Sf.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$D=$K["ROUTINE_NAME"];$ah=$K["ROUTINE_TYPE"];$j=create_routine($ah,array("name"=>$D)+routine($K["SPECIFIC_NAME"],$ah));set_utf8mb4($j);$Sf.=($Sh!='DROP+CREATE'?"DROP $ah IF EXISTS ".idf_escape($D).";;\n":"")."$j;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$j=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($j);$Sf.=($Sh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$j;;\n\n";}}echo($Sf&&JUSH=='sql'?"DELIMITER ;;\n\n$Sf"."DELIMITER ;\n\n":$Sf);}if($_POST["table_style"]||$_POST["data_style"]){$lj=array();foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));$Ib=(DB==""||in_array($D,(array)$_POST["data"]));if($R||$Ib){if($Ic=="tar"){$wi=new
TmpFile;ob_start(array($wi,'write'),1e5);}$b->dumpTable($D,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$lj[]=$D;elseif($Ib){$q=fields($D);$b->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($q,$q)." FROM ".table($D));}if($ee&&$_POST["triggers"]&&$R&&($Ji=trigger_sql($D)))echo"\nDELIMITER ;;\n$Ji\nDELIMITER ;\n";if($Ic=="tar"){ob_end_flush();tar_file((DB!=""?"":"$l/")."$D.csv",$wi);}elseif($ee)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($D);}}foreach($lj
as$kj)$b->dumpTable($kj,$_POST["table_style"],1);if($Ic=="tar")echo
pack("x512");}}}$b->dumpFooter();exit;}page_header(lang(72),$o,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Mb=array('','USE','DROP+CREATE','CREATE');$ei=array('','DROP+CREATE','CREATE');$Jb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Jb[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(145)."<td>".html_radios("output",$b->dumpOutput(),$K["output"])."\n","<tr><th>".lang(146)."<td>".html_radios("format",$b->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(36)."<td>".html_select('db_style',$Mb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(31)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(147)):"").(support("event")?checkbox("events",1,$K["events"],lang(148)):"")),"<tr><th>".lang(125)."<td>".html_select('table_style',$ei,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(50)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(142)):""),"<tr><th>".lang(149)."<td>".html_select('data_style',$Jb,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(72),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$ug=array();if(DB!=""){$Ya=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Ya>".lang(125)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(149)."<input type='checkbox' id='check-data'$Ya></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$lj="";$fi=tables_list();foreach($fi
as$D=>$U){$tg=preg_replace('~_.*~','',$D);$Ya=($a==""||$a==(substr($a,-1)=="%"?"$tg%":$D));$xg="<tr><td>".checkbox("tables[]",$D,$Ya,$D,"","block");if($U!==null&&!preg_match('~table~i',$U))$lj.="$xg\n";else
echo"$xg<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$Ya)."</label>\n";$ug[$tg]++;}echo$lj;if($fi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(36)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$k=$b->databases();if($k){foreach($k
as$l){if(!information_schema($l)){$tg=preg_replace('~_.*~','',$l);echo"<tr><td>".checkbox("databases[]",$l,$a==""||$a=="$tg%",$l,"","block")."\n";$ug[$tg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Vc=true;foreach($ug
as$_=>$X){if($_!=""&&$X>1){echo($Vc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$_%")."'>".h($_)."</a>";$Vc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(70));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(150)."</a>";$I=$h->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$od=$I;if(!$I)$I=$h->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($od?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(34)."<th>".lang(33)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$od||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$o&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);$b->dumpFooter();exit;}restart_session();$Fd=&get_session("queries");$Ed=&$Fd[DB];if(!$o&&$_POST["clear"]){$Ed=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(71):lang(63)),$o);if(!$o&&$_POST){$t=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$Jh=$b->importServerPath();$t=@fopen((file_exists($Jh)?$Jh:"compress.zlib://$Jh.gz"),"rb");$H=($t?fread($t,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($Re=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Re,2*strlen($H)+memory_get_usage()+8e6));if($H!=""&&strlen($H)<1e6){$Dg=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ed||first(end($Ed))!=$Dg){restart_session();$Ed[]=array($Dg,time());set_session("queries",$Fd);stop_session();}}$Fh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Sb=";";$E=0;$rc=true;$i=connect($b->credentials());if(is_object($i)&&DB!=""){$i->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$i);}$mb=0;$zc=array();$Zf='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|-- |$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$_i=microtime(true);$pa=get_settings("adminer_import");$ic=$b->dumpFormat();unset($ic["sql"]);while($H!=""){if(!$E&&preg_match("~^$Fh*+DELIMITER\\s+(\\S+)~i",$H,$C)){$Sb=$C[1];$H=substr($H,strlen($C[0]));}else{preg_match('('.preg_quote($Sb)."\\s*|$Zf)",$H,$C,PREG_OFFSET_CAPTURE,$E);list($hd,$og)=$C[0];if(!$hd&&$t&&!feof($t))$H.=fread($t,1e5);else{if(!$hd&&rtrim($H)=="")break;$E=$og+strlen($hd);if($hd&&rtrim($hd)!=$Sb){$Ra=$n->hasCStyleEscapes()||(JUSH=="pgsql"&&($og>0&&strtolower($H[$og-1])=="e"));$hg=($hd=='/*'?'\*/':($hd=='['?']':(preg_match('~^-- |^#~',$hd)?"\n":preg_quote($hd).($Ra?"|\\\\.":""))));while(preg_match("($hg|\$)s",$H,$C,PREG_OFFSET_CAPTURE,$E)){$eh=$C[0][0];if(!$eh&&$t&&!feof($t))$H.=fread($t,1e5);else{$E=$C[0][1]+strlen($eh);if(!$eh||$eh[0]!="\\")break;}}}else{$rc=false;$Dg=substr($H,0,$og);$mb++;$xg="<pre id='sql-$mb'><code class='jush-".JUSH."'>".$b->sqlCommandQuery($Dg)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$Fh*+ATTACH\\b~i",$Dg,$C)){echo$xg,"<p class='error'>".lang(151)."\n";$zc[]=" <a href='#sql-$mb'>$mb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$xg;ob_flush();flush();}$Oh=microtime(true);if($h->multi_query($Dg)&&is_object($i)&&preg_match("~^$Fh*+USE\\b~i",$Dg))$i->query($Dg);do{$I=$h->store_result();if($h->error){echo($_POST["only_errors"]?$xg:""),"<p class='error'>".lang(152).($h->errno?" ($h->errno)":"").": ".error()."\n";$zc[]=" <a href='#sql-$mb'>$mb</a>";if($_POST["error_stops"])break
2;}else{$pi=" <span class='time'>(".format_time($Oh).")</span>".(strlen($Dg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Dg))."'>".lang(10)."</a>":"");$ra=$h->affected_rows;$oj=($_POST["only_errors"]?"":$n->warnings());$pj="warnings-$mb";if($oj)$pi.=", <a href='#$pj'>".lang(45)."</a>".script("qsl('a').onclick = partial(toggle, '$pj');","");$Gc=null;$Hc="explain-$mb";if(is_object($I)){$A=$_POST["limit"];$Kf=select($I,$i,array(),$A);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$mf=$I->num_rows;echo"<p class='sql-footer'>".($mf?($A&&$mf>$A?lang(153,$A):"").lang(154,$mf):""),$pi;if($i&&preg_match("~^($Fh|\\()*+SELECT\\b~i",$Dg)&&($Gc=explain($i,$Dg)))echo", <a href='#$Hc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Hc');","");$w="export-$mb";echo", <a href='#$w'>".lang(72)."</a>".script("qsl('a').onclick = partial(toggle, '$w');","")."<span id='$w' class='hidden'>: ".html_select("output",$b->dumpOutput(),$pa["output"])." ".html_select("format",$ic,$pa["format"]).input_hidden("query",$Dg)."<input type='submit' name='export' value='".lang(72)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$Fh*+(CREATE|DROP|ALTER)$Fh++(DATABASE|SCHEMA)\\b~i",$Dg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(isset($h->info)?$h->info:"")."'>".lang(155,$ra)."$pi\n";}echo($oj?"<div id='$pj' class='hidden'>\n$oj</div>\n":"");if($Gc){echo"<div id='$Hc' class='hidden explain'>\n";select($Gc,$i,$Kf);echo"</div>\n";}}$Oh=microtime(true);}while($h->next_result());}$H=substr($H,$E);$E=0;}}}}if($rc)echo"<p class='message'>".lang(156)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(157,$mb-count($zc))," <span class='time'>(".format_time($_i).")</span>\n";elseif($zc&&$mb>1)echo"<p class='error'>".lang(152).": ".implode("",$zc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Ec="<input type='submit' value='".lang(158)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$Dg=$_GET["sql"];if($_POST)$Dg=$_POST["query"];elseif($_GET["history"]=="all")$Dg=$Ed;elseif($_GET["history"]!="")$Dg=$Ed[$_GET["history"]][0];echo"<p>";textarea("query",$Dg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";$b->sqlPrintAfter();echo"$Ec\n",lang(159).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(160)."</legend><div>";$ud=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$ud (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Ec":lang(161)),"</div></fieldset>\n";$Md=$b->importServerPath();if($Md)echo"<fieldset><legend>".lang(162)."</legend><div>",lang(163,"<code>".h($Md)."$ud</code>"),' <input type="submit" name="webfile" value="'.lang(164).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(165))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(166))."\n",input_token();if(!isset($_GET["import"])&&$Ed){print_fieldset("history",lang(167),$_GET["history"]!="");for($X=end($Ed);$X;$X=prev($Ed)){$_=key($Ed);list($Dg,$pi,$mc)=$X;echo'<a href="'.h(ME."sql=&history=$_").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$pi)."'>".@date("H:i:s",$pi)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Dg)))),80,"</code>").($mc?" <span class='time'>($mc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(168)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(169)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$q=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$q):""):where($_GET,$q));$Vi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($q
as$D=>$p){if(!isset($p["privileges"][$Vi?"update":"insert"])||$b->fieldName($p)==""||$p["generated"])unset($q[$D]);}if($_POST&&!$o&&!isset($_GET["select"])){$Be=$_POST["referer"];if($_POST["insert"])$Be=($Vi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Be))$Be=ME."select=".urlencode($a);$z=indexes($a);$Qi=unique_array($_GET["where"],$z);$Gg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Be,lang(170),$n->delete($a,$Gg,!$Qi));else{$O=array();foreach($q
as$D=>$p){$X=process_input($p);if($X!==false&&$X!==null)$O[idf_escape($D)]=$X;}if($Vi){if(!$O)redirect($Be);queries_redirect($Be,lang(171),$n->update($a,$O,$Gg,!$Qi));if(is_ajax()){page_headers();page_messages($o);exit;}}else{$I=$n->insert($a,$O);$te=($I?last_id($I):0);queries_redirect($Be,lang(172,($te?" $te":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($q
as$D=>$p){if(isset($p["privileges"]["select"])){$xa=($_POST["clone"]&&$p["auto_increment"]?"''":convert_field($p));$M[]=($xa?"$xa AS ":"").idf_escape($D);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=$n->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$o=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$q){if(!$Z){$I=$n->select($a,array("*"),$Z,array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array($n->primary=>"");}if($K){foreach($K
as$_=>$X){if(!$Z)$K[$_]=null;$q[$_]=array("field"=>$_,"null"=>($_!=$n->primary),"auto_increment"=>($_==$n->primary));}}}edit_form($a,$q,$K,$Vi);}elseif(isset($_GET["create"])){$a=$_GET["create"];$bg=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$_)$bg[$_]=$_;$Mg=referencable_primary($a);$fd=array();foreach($Mg
as$ai=>$p)$fd[str_replace("`","``",$ai)."`".str_replace("`","``",$p["field"])]=$ai;$Nf=array();$S=array();if($a!=""){$Nf=fields($a);$S=table_status($a);if(!$S)$o=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$o){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(173),drop_tables(array($a)));else{$q=array();$va=array();$Zi=false;$dd=array();$Mf=reset($Nf);$ta=" FIRST";foreach($K["fields"]as$_=>$p){$s=$fd[$p["type"]];$Ki=($s!==null?$Mg[$s]:$p);if($p["field"]!=""){if(!$p["generated"])$p["default"]=null;$Bg=process_field($p,$Ki);$va[]=array($p["orig"],$Bg,$ta);if(!$Mf||$Bg!==process_field($Mf,$Mf)){$q[]=array($p["orig"],$Bg,$ta);if($p["orig"]!=""||$ta)$Zi=true;}if($s!==null)$dd[idf_escape($p["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$fd[$p["type"]],'source'=>array($p["field"]),'target'=>array($Ki["field"]),'on_delete'=>$p["on_delete"],));$ta=" AFTER ".idf_escape($p["field"]);}elseif($p["orig"]!=""){$Zi=true;$q[]=array($p["orig"]);}if($p["orig"]!=""){$Mf=next($Nf);if(!$Mf)$ta="";}}$dg="";if(support("partitioning")){if(isset($bg[$K["partition_by"]])){$Yf=array();foreach($K
as$_=>$X){if(preg_match('~^partition~',$_))$Yf[$_]=$X;}foreach($Yf["partition_names"]as$_=>$D){if($D==""){unset($Yf["partition_names"][$_]);unset($Yf["partition_values"][$_]);}}if($Yf!=get_partitions_info($a)){$eg=array();if($Yf["partition_by"]=='RANGE'||$Yf["partition_by"]=='LIST'){foreach($Yf["partition_names"]as$_=>$D){$Y=$Yf["partition_values"][$_];$eg[]="\n  PARTITION ".idf_escape($D)." VALUES ".($Yf["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$dg.="\nPARTITION BY $Yf[partition_by]($Yf[partition])";if($eg)$dg.=" (".implode(",",$eg)."\n)";elseif($Yf["partitions"])$dg.=" PARTITIONS ".(+$Yf["partitions"]);}}elseif(preg_match("~partitioned~",$S["Create_options"]))$dg.="\nREMOVE PARTITIONING";}$Se=lang(174);if($a==""){cookie("adminer_engine",$K["Engine"]);$Se=lang(175);}$D=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$Se,alter_table($a,$D,(JUSH=="sqlite"&&($Zi||$dd)?$va:$q),$dd,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$dg));}}page_header(($a!=""?lang(43):lang(73)),$o,array("table"=>$a),h($a));if(!$_POST){$Mi=$n->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Mi["int"])?"int":(isset($Mi["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($Nf
as$p){$p["generated"]=$p["generated"]?:(isset($p["default"])?"DEFAULT":"");$K["fields"][]=$p;}if(support("partitioning")){$K+=get_partitions_info($a);$K["partition_names"][]="";$K["partition_values"][]="";}}}$ib=collations();$tc=$n->engines();foreach($tc
as$sc){if(!strcasecmp($sc,$K["Engine"])){$K["Engine"]=$sc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(176).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($tc?html_select("Engine",array(""=>"(".lang(177).")")+$tc,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($ib)echo"<datalist id='collations'>".optionlist($ib)."</datalist>",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(102).")'>");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$ib,"TABLE",$fd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(50).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(178),"columnShow(this.checked, 5)","jsonly");$pb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$pb,lang(49),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($pb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($pb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$a));if(support("partitioning")){$cg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(180),$K["partition_by"]);echo"<p>".html_select("partition_by",array(""=>"")+$bg,$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(181).": <input type='number' name='partitions' class='size".($cg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($cg?"":" class='hidden'").">\n","<thead><tr><th>".lang(182)."<th>".lang(183)."</thead>\n";foreach($K["partition_names"]as$_=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($_==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($K["partition_values"][$_]).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Rd=array("PRIMARY","UNIQUE","INDEX");$S=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Rd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Rd[]="SPATIAL";$z=indexes($a);$vg=array();if(JUSH=="mongo"){$vg=$z["_id_"];unset($Rd[0]);unset($z["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$o&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($K["indexes"]as$y){$D=$y["name"];if(in_array($y["type"],$Rd)){$f=array();$ze=array();$Ub=array();$O=array();ksort($y["columns"]);foreach($y["columns"]as$_=>$e){if($e!=""){$ye=$y["lengths"][$_];$Tb=$y["descs"][$_];$O[]=idf_escape($e).($ye?"(".(+$ye).")":"").($Tb?" DESC":"");$f[]=$e;$ze[]=($ye?:null);$Ub[]=$Tb;}}$Fc=$z[$D];if($Fc){ksort($Fc["columns"]);ksort($Fc["lengths"]);ksort($Fc["descs"]);if($y["type"]==$Fc["type"]&&array_values($Fc["columns"])===$f&&(!$Fc["lengths"]||array_values($Fc["lengths"])===$ze)&&array_values($Fc["descs"])===$Ub){unset($z[$D]);continue;}}if($f)$c[]=array($y["type"],$D,$O);}}foreach($z
as$D=>$Fc)$c[]=array($Fc["type"],$D,"DROP");if(!$c)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(184),alter_indexes($a,$c));}page_header(lang(134),$o,array("table"=>$a),h($a));$q=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$_=>$y){if($y["columns"][count($y["columns"])]!="")$K["indexes"][$_]["columns"][]="";}$y=end($K["indexes"]);if($y["type"]||array_filter($y["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($z
as$_=>$y){$z[$_]["name"]=$_;$z[$_]["columns"][]="";}$z[]=array("columns"=>array(1=>""));$K["indexes"]=$z;}$ze=(JUSH=="sql"||JUSH=="mssql");$zh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(185),'<th><input type="submit" class="wayoff">',lang(47).($ze?"<span class='idxopts".($zh?"":" hidden")."'> (".lang(186).")</span>":"");if($ze||support("descidx"))echo
checkbox("options",1,$zh,lang(108),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(187),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".lang(109)."'>",'</noscript>
</thead>
';if($vg){echo"<tr><td>PRIMARY<td>";foreach($vg["columns"]as$_=>$e)echo
select_input(" disabled",$q,$e),"<label><input disabled type='checkbox'>".lang(58)."</label> ";echo"<td><td>\n";}$he=1;foreach($K["indexes"]as$y){if(!$_POST["drop_col"]||$he!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$he][type]",array(-1=>"")+$Rd,$y["type"],($he==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"<td>";ksort($y["columns"]);$v=1;foreach($y["columns"]as$_=>$e){echo"<span>".select_input(" name='indexes[$he][columns][$v]' title='".lang(47)."'",($q?array_combine($q,$q):$q),$e,"partial(".($v==count($y["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($zh?"":" hidden")."'>",($ze?"<input type='number' name='indexes[$he][lengths][$v]' class='size' value='".h($y["lengths"][$_])."' title='".lang(107)."'>":""),(support("descidx")?checkbox("indexes[$he][descs][$v]",1,$y["descs"][$_],lang(58)):""),"</span> </span>";$v++;}echo"<td><input name='indexes[$he][name]' value='".h($y["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$he]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=5.1.0")."' alt='x' title='".lang(112)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$he++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$o&&!isset($_POST["add_x"])){$D=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(188),drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),lang(189),rename_database($D,$K["collation"]));}else{$k=explode("\n",str_replace("\r","",$D));$Th=true;$se="";foreach($k
as$l){if(count($k)==1||$l!=""){if(!create_database($l,$K["collation"]))$Th=false;$se=$l;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($se),lang(190),$Th);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(191));}}page_header(DB!=""?lang(66):lang(116),$o,array(),h(DB));$ib=collations();$D=DB;if($_POST)$D=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$ib);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$od){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$od,$C)&&$C[1]){$D=stripcslashes(idf_unescape("`$C[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($D,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" autofocus value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($ib?html_select("collation",array(""=>"(".lang(102).")")+$ib,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=5.1.0")."' alt='+' title='".lang(109)."'>\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$o){$B=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$B,lang(192));else{$D=trim($K["name"]);$B.=urlencode($D);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($D),$B,lang(193));elseif($_GET["ns"]!=$D)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($D),$B,lang(194));else
redirect($B);}}page_header($_GET["ns"]!=""?lang(67):lang(68),$o);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?:$_GET["call"]);page_header(lang(195).": ".h($da),$o);$ah=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Nd=array();$Sf=array();foreach($ah["fields"]as$v=>$p){if(substr($p["inout"],-3)=="OUT")$Sf[$v]="@".idf_escape($p["field"])." AS ".idf_escape($p["field"]);if(!$p["inout"]||substr($p["inout"],0,2)=="IN")$Nd[]=$v;}if(!$o&&$_POST){$Sa=array();foreach($ah["fields"]as$_=>$p){if(in_array($_,$Nd)){$X=process_input($p);if($X===false)$X="''";if(isset($Sf[$_]))$h->query("SET @".idf_escape($p["field"])." = $X");}$Sa[]=(isset($Sf[$_])?"@".idf_escape($p["field"]):$X);}$H=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Sa).")";$Oh=microtime(true);$I=$h->multi_query($H);$ra=$h->affected_rows;echo$b->selectQuery($H,$Oh,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$i=connect($b->credentials());if(is_object($i))$i->select_db(DB);do{$I=$h->store_result();if(is_object($I))select($I,$i);else
echo"<p class='message'>".lang(196,$ra)." <span class='time'>".@date("H:i:s")."</span>\n";}while($h->next_result());if($Sf)select($h->query("SELECT ".implode(", ",$Sf)));}}echo'
<form action="" method="post">
';if($Nd){echo"<table class='layout'>\n";foreach($Nd
as$_){$p=$ah["fields"][$_];$D=$p["field"];echo"<tr><th>".$b->fieldName($p);$Y=$_POST["fields"][$D];if($Y!=""){if($p["type"]=="set")$Y=implode(",",$Y);}input($p,$Y,(string)$_POST["function"][$D]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(195),'">
',input_token(),'</form>

<pre>
';function
pre_tr($eh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($eh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($C){$Wc=pre_tr($C[2]);return"<table>\n".($C[1]?"<thead>$Wc</thead>\n":$Wc).pre_tr($C[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($ah['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$K=$_POST;if($_POST&&!$o&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$ii=array();foreach($K["source"]as$_=>$X)$ii[$_]=$K["target"][$_];$K["target"]=$ii;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $D"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$c="ALTER TABLE ".table($a);$I=($D==""||queries("$c DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D)));if(!$K["drop"])$I=queries("$c ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(197):($D!=""?lang(198):lang(199))),$I);if(!$K["drop"])$o="$o<br>".lang(200);}page_header(lang(201),$o,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($D!=""){$fd=foreign_keys($a);$K=$fd[$D];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$Eh=array_keys(fields($a));if($K["db"]!="")$h->select_db($K["db"]);if($K["ns"]!=""){$Of=get_schema();set_schema($K["ns"]);}$Lg=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$ii=array_keys(fields(in_array($K["table"],$Lg)?$K["table"]:reset($Lg)));$zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(202).": ".html_select("table",$Lg,$K["table"],$zf)."\n";if(support("scheme")){$hh=array_filter($b->schemas(),function($gh){return!preg_match('~^information_schema$~i',$gh);});echo
lang(75).": ".html_select("ns",$hh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$zf);if($K["ns"]!="")set_schema($Of);}elseif(JUSH!="sqlite"){$Nb=array();foreach($b->databases()as$l){if(!information_schema($l))$Nb[]=$l;}echo
lang(74).": ".html_select("db",$Nb,$K["db"]!=""?$K["db"]:$_GET["db"],$zf);}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(203),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(136),'<th id="label-target">',lang(137),'</thead>
';$he=0;foreach($K["source"]as$_=>$X){echo"<tr>","<td>".html_select("source[".(+$_)."]",array(-1=>"")+$Eh,$X,($he==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$_)."]",$ii,$K["target"][$_],"","label-target");$he++;}echo'</table>
<p>
',lang(104),': ',html_select("on_delete",array(-1=>"")+explode("|",$n->onActions),$K["on_delete"]),' ',lang(103),': ',html_select("on_update",array(-1=>"")+explode("|",$n->onActions),$K["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(204),'"></noscript>
';if($D!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$Pf="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status($a);$Pf=strtoupper($P["Engine"]);}if($_POST&&!$o){$D=trim($K["name"]);$xa=" AS\n$K[select]";$Be=ME."table=".urlencode($D);$Se=lang(205);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&JUSH!="sqlite"&&$U=="VIEW"&&$Pf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$xa,$Be,$Se);else{$ki=$D."_adminer_".uniqid();drop_create("DROP $Pf ".table($a),"CREATE $U ".table($D).$xa,"DROP $U ".table($D),"CREATE $U ".table($ki).$xa,"DROP $U ".table($ki),($_POST["drop"]?substr(ME,0,-1):$Be),lang(206),$Se,lang(207),$a,$D);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($Pf!="VIEW");if(!$o)$o=error();}page_header(($a!=""?lang(42):lang(208)),$o,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(187),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(131)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Zd=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Ph=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$o){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(209));elseif(in_array($K["INTERVAL_FIELD"],$Zd)&&isset($Ph[$K["STATUS"]])){$fh="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(210):lang(211)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$fh.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$fh)."\n".$Ph[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(212).": ".h($aa):lang(213)),$o);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(187),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(214),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(215),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(216),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Zd,$K["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$Ph,$K["STATUS"]),'<tr><th>',lang(49),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(217)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?:$_GET["procedure"]);$ah=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$o){$Lf=routine($_GET["procedure"],$ah);$ki="$K[name]_adminer_".uniqid();foreach($K["fields"]as$_=>$p){if($p["field"]=="")unset($K["fields"][$_]);}drop_create("DROP $ah ".routine_id($da,$Lf),create_routine($ah,$K),"DROP $ah ".routine_id($K["name"],$K),create_routine($ah,array("name"=>$ki)+$K),"DROP $ah ".routine_id($ki,$K),substr(ME,0,-1),lang(218),lang(219),lang(220),$da,$K["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(221):lang(222)).": ".h($da):(isset($_GET["function"])?lang(223):lang(224))),$o);if(!$_POST){if($da=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$ah);$K["name"]=$da;}}$ib=get_vals("SHOW CHARACTER SET");sort($ib);$bh=routine_languages();echo($ib?"<datalist id='collations'>".optionlist($ib)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(187),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($bh?lang(19).": ".html_select("language",$bh,$K["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$ib,$ah);if(isset($_GET["function"])){echo"<tr><td>".lang(225);edit_type("returns",$K["returns"],$ib,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$da));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$K=$_POST;if($_POST&&!$o){$B=substr(ME,0,-1);$D=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$B,lang(226));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($D),$B,lang(227));elseif($fa!=$D)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($D),$B,lang(228));else
redirect($B);}page_header($fa!=""?lang(229).": ".h($fa):lang(230),$o);if(!$K)$K["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$fa))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$K=$_POST;if($_POST&&!$o){$B=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$B,lang(231));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$B,lang(232));}page_header($ga!=""?lang(233).": ".h($ga):lang(234),$o);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!=""){$Mi=$n->types();$xc=type_values($Mi[$ga]);if($xc)echo"<code class='jush-".JUSH."'>ENUM (".h($xc).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(129)."'>".confirm(lang(179,$ga))."\n";}else{echo
lang(187).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$D=$_GET["name"];$K=$_POST;if($K&&!$o){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),0,array(),$D,($K["drop"]?"":$K["clause"]));else{$I=($D==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($D)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(235):($D!=""?lang(236):lang(237))),$I);}page_header(($D!=""?lang(238).": ".h($D):lang(141)),$o,array("table"=>$a));if(!$K){$Za=$n->checkConstraints($a);$K=array("name"=>$D,"clause"=>$Za[$D]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(187).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D=$_GET["name"];$Ii=trigger_options();$K=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$o&&in_array($_POST["Timing"],$Ii["Timing"])&&in_array($_POST["Event"],$Ii["Event"])&&in_array($_POST["Type"],$Ii["Type"])){$wf=" ON ".table($a);$cc="DROP TRIGGER ".idf_escape($D).(JUSH=="pgsql"?$wf:"");$Be=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($cc,$Be,lang(239));else{if($D!="")queries($cc);queries_redirect($Be,($D!=""?lang(240):lang(241)),queries(create_trigger($wf,$_POST)));if($D!="")queries(create_trigger($wf,$K+array("Type"=>reset($Ii["Type"]))));}}$K=$_POST;}page_header(($D!=""?lang(242).": ".h($D):lang(243)),$o,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(244),'<td>',html_select("Timing",$Ii["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(245),'<td>',html_select("Event",$Ii["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Ii["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(48),'<td>',html_select("Type",$Ii["Type"],$K["Type"]),'</table>
<p>',lang(187),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$_g=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$yb)$_g[$yb][$K["Privilege"]]=$K["Comment"];}$_g["Server Admin"]+=$_g["File access on server"];$_g["Databases"]["Create routine"]=$_g["Procedures"]["Create routine"];unset($_g["Procedures"]["Create routine"]);$_g["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$_g["Columns"][$X]=$_g["Tables"][$X];unset($_g["Server Admin"]["Usage"]);foreach($_g["Tables"]as$_=>$X)unset($_g["Databases"][$_]);$ff=array();if($_POST){foreach($_POST["objects"]as$_=>$X)$ff[$X]=(array)$ff[$X]+(array)$_POST["grants"][$_];}$pd=array();$uf="";if(isset($_GET["host"])&&($I=$h->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$C)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$C[1],$Ie,PREG_SET_ORDER)){foreach($Ie
as$X){if($X[1]!="USAGE")$pd["$C[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$pd["$C[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$C))$uf=$C[1];}}if($_POST&&!$o){$vf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $vf",ME."privileges=",lang(246));else{$hf=q($_POST["user"])."@".q($_POST["host"]);$fg=$_POST["pass"];if($fg!=''&&!$_POST["hashed"]&&!min_version(8)){$fg=get_val("SELECT PASSWORD(".q($fg).")");$o=!$fg;}$Bb=false;if(!$o){if($vf!=$hf){$Bb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $hf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($fg));$o=!$Bb;}elseif($fg!=$uf)queries("SET PASSWORD FOR $hf = ".q($fg));}if(!$o){$Xg=array();foreach($ff
as$of=>$od){if(isset($_GET["grant"]))$od=array_filter($od);$od=array_keys($od);if(isset($_GET["grant"]))$Xg=array_diff(array_keys(array_filter($ff[$of],'strlen')),$od);elseif($vf==$hf){$sf=array_keys((array)$pd[$of]);$Xg=array_diff($sf,$od);$od=array_diff($od,$sf);unset($pd[$of]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$of,$C)&&(!grant("REVOKE",$Xg,$C[2]," ON $C[1] FROM $hf")||!grant("GRANT",$od,$C[2]," ON $C[1] TO $hf"))){$o=true;break;}}}if(!$o&&isset($_GET["host"])){if($vf!=$hf)queries("DROP USER $vf");elseif(!isset($_GET["grant"])){foreach($pd
as$of=>$Xg){if(preg_match('~^(.+)(\(.*\))?$~U',$of,$C))grant("REVOKE",array_keys($Xg),$C[2]," ON $C[1] FROM $hf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(247):lang(248)),!$o);if($Bb)$h->query("DROP USER $hf");}}page_header((isset($_GET["host"])?lang(34).": ".h("$ha@$_GET[host]"):lang(150)),$o,array("privileges"=>array('',lang(70))));$K=$_POST;if($K)$pd=$ff;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$uf;if($uf!="")$K["hashed"]=true;$pd[(DB==""||$pd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(33),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(249),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(70).doc_link(array('sql'=>"grant.html#priv_level"));$v=0;foreach($pd
as$of=>$od){echo'<th>'.($of!="*.*"?"<input name='objects[$v]' value='".h($of)."' size='10' autocapitalize='off'>":input_hidden("objects[$v]","*.*")."*.*");$v++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(33),"Databases"=>lang(36),"Tables"=>lang(133),"Columns"=>lang(47),"Procedures"=>lang(250),)as$yb=>$Tb){foreach((array)$_g[$yb]as$zg=>$nb){echo"<tr><td".($Tb?">$Tb<td":" colspan='2'").' lang="en" title="'.h($nb).'">'.h($zg);$v=0;foreach($pd
as$of=>$od){$D="'grants[$v][".h(strtoupper($zg))."]'";$Y=$od[strtoupper($zg)];if($yb=="Server Admin"&&$of!=(isset($pd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".lang(251)."<option value='0'".($Y=="0"?" selected":"").">".lang(252)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($zg=="All privileges"?" id='grants-$v-all'>":">".($zg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$v-all'); };"))),"</label>";$v++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(129),'">',confirm(lang(179,"$ha@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$o){$ne=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$ne++;}queries_redirect(ME."processlist=",lang(253,$ne),$ne||!$_POST["kill"]);}}page_header(lang(117),$o);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$v=-1;foreach(process_list()as$v=>$K){if(!$v){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$_=>$X)echo"<th>$_".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($_),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$_=>$X)echo"<td>".((JUSH=="sql"&&$_=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$_=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$_=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(254).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($v+1)."/".lang(255,max_connections()),"<p><input type='submit' value='".lang(256)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$z=indexes($a);$q=fields($a);$fd=column_foreign_keys($a);$qf=$S["Oid"];$qa=get_settings("adminer_import");$Yg=array();$f=array();$kh=array();$Hf=array();$oi=null;foreach($q
as$_=>$p){$D=$b->fieldName($p);$df=html_entity_decode(strip_tags($D),ENT_QUOTES);if(isset($p["privileges"]["select"])&&$D!=""){$f[$_]=$df;if(is_shortable($p))$oi=$b->selectLengthProcess();}if(isset($p["privileges"]["where"])&&$D!="")$kh[$_]=$df;if(isset($p["privileges"]["order"])&&$D!="")$Hf[$_]=$df;$Yg+=$p["privileges"];}list($M,$qd)=$b->selectColumnsProcess($f,$z);$M=array_unique($M);$qd=array_unique($qd);$de=count($qd)<count($M);$Z=$b->selectSearchProcess($q,$z);$Gf=$b->selectOrderProcess($q,$z);$A=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Ri=>$K){$xa=convert_field($q[key($K)]);$M=array($xa?:idf_escape(key($K)));$Z[]=where_check($Ri,$q);$J=$n->select($a,$M,$Z,$M);if($J)echo
reset($J->fetch_row());}exit;}$vg=$Ti=null;foreach($z
as$y){if($y["type"]=="PRIMARY"){$vg=array_flip($y["columns"]);$Ti=($M?$vg:array());foreach($Ti
as$_=>$X){if(in_array(idf_escape($_),$M))unset($Ti[$_]);}break;}}if($qf&&!$vg){$vg=$Ti=array($qf=>0);$z[]=array("type"=>"PRIMARY","columns"=>array($qf));}if($_POST&&!$o){$rj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Za=array();foreach($_POST["check"]as$Va)$Za[]=where_check($Va,$q);$rj[]="((".implode(") OR (",$Za)."))";}$rj=($rj?"\nWHERE ".implode(" AND ",$rj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);$b->dumpTable($a,"");$jd=($M?implode(", ",$M):"*").convert_fields($f,$q,$M)."\nFROM ".table($a);$sd=($qd&&$de?"\nGROUP BY ".implode(", ",$qd):"").($Gf?"\nORDER BY ".implode(", ",$Gf):"");$H="SELECT $jd$rj$sd";if(is_array($_POST["check"])&&!$vg){$Pi=array();foreach($_POST["check"]as$X)$Pi[]="(SELECT".limit($jd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q).$sd,1).")";$H=implode(" UNION ALL ",$Pi);}$b->dumpData($a,"table",$H);$b->dumpFooter();exit;}if(!$b->selectEmailProcess($Z,$fd)){if($_POST["save"]||$_POST["delete"]){$I=true;$ra=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$D=>$X){$X=process_input($q[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$O){if($_POST["clone"])$H="INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a);if($_POST["all"]||($vg&&is_array($_POST["check"]))||$de){$I=($_POST["delete"]?$n->delete($a,$rj):($_POST["clone"]?queries("INSERT $H$rj".$n->insertReturning($a)):$n->update($a,$O,$rj)));$ra=$h->affected_rows+(is_object($I)?$I->num_rows:0);}else{foreach((array)$_POST["check"]as$X){$qj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q);$I=($_POST["delete"]?$n->delete($a,$qj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$qj)):$n->update($a,$O,$qj,1)));if(!$I)break;$ra+=$h->affected_rows;}}}$Se=lang(257,$ra);if($_POST["clone"]&&$I&&$ra==1){$te=last_id($I);if($te)$Se=lang(172," $te");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Se,$I);if(!$_POST["delete"]){$sg=(array)$_POST["fields"];edit_form($a,array_intersect_key($q,$sg),$sg,!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$o=lang(258);else{$I=true;$ra=0;foreach($_POST["val"]as$Ri=>$K){$O=array();foreach($K
as$_=>$X){$_=bracket_escape($_,1);$O[idf_escape($_)]=(preg_match('~char|text~',$q[$_]["type"])||$X!=""?$b->processInput($q[$_],$X):"NULL");}$I=$n->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Ri,$q),!$de&&!$vg," ");if(!$I)break;$ra+=$h->affected_rows;}queries_redirect(remove_from_uri(),lang(257,$ra),$I);}}elseif(!is_string($Tc=get_file("csv_file",true)))$o=upload_error($Tc);elseif(!preg_match('~~u',$Tc))$o=lang(259);else{save_settings(array("output"=>$qa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$jb=array_keys($q);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Tc,$Ie);$ra=count($Ie[0]);$n->begin();$qh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($Ie[0]as$_=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$qh]*)$qh~",$X.$qh,$Je);if(!$_&&!array_diff($Je[1],$jb)){$jb=$Je[1];$ra--;}else{$O=array();foreach($Je[1]as$v=>$fb)$O[idf_escape($jb[$v])]=($fb==""&&$q[$jb[$v]]["null"]?"NULL":q(preg_match('~^".*"$~s',$fb)?str_replace('""','"',substr($fb,1,-1)):$fb));$L[]=$O;}}$I=(!$L||$n->insertUpdate($a,$L,$vg));if($I)$n->commit();queries_redirect(remove_from_uri("page"),lang(260,$ra),$I);$n->rollback();}}}$ai=$b->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $ai",$o);$O=null;if(isset($Yg["insert"])||!support("table")){$Yf=array();foreach((array)$_GET["where"]as$X){if(isset($fd[$X["col"]])&&count($fd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$Yf["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$Yf?"&".http_build_query($Yf):"";}$b->selectLinks($S,$O);if(!$f&&support("table"))echo"<p class='error'>".lang(261).($q?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";$b->selectColumnsPrint($M,$f);$b->selectSearchPrint($Z,$kh,$z);$b->selectOrderPrint($Gf,$Hf,$z);$b->selectLimitPrint($A);$b->selectLengthPrint($oi);$b->selectActionPrint($z);echo"</form>\n";$F=$_GET["page"];if($F=="last"){$id=get_val(count_rows($a,$Z,$de,$qd));$F=floor(max(0,$id-1)/$A);}$lh=$M;$rd=$qd;if(!$lh){$lh[]="*";$zb=convert_fields($f,$q,$M);if($zb)$lh[]=substr($zb,2);}foreach($M
as$_=>$X){$p=$q[idf_unescape($X)];if($p&&($xa=convert_field($p)))$lh[$_]="$xa AS $X";}if(!$de&&$Ti){foreach($Ti
as$_=>$X){$lh[]=idf_escape($_);if($rd)$rd[]=idf_escape($_);}}$I=$n->select($a,$lh,$Z,$rd,$Gf,$A,$F,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$F)$I->seek($A*$F);$qc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($F&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$A!=""&&$qd&&$de&&JUSH=="sql")$id=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Fa=$b->backwardKeys($a,$ai);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$qd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(262)."</a>");$ef=array();$ld=array();reset($M);$Ig=1;foreach($L[0]as$_=>$X){if(!isset($Ti[$_])){$X=$_GET["columns"][key($M)];$p=$q[$M?($X?$X["col"]:current($M)):$_];$D=($p?$b->fieldName($p,$Ig):($X["fun"]?"*":h($_)));if($D!=""){$Ig++;$ef[$_]=$D;$e=idf_escape($_);$Hd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($_);$Tb="&desc%5B0%5D=1";$Dh=isset($p["privileges"]["order"]);echo"<th id='th[".h(bracket_escape($_))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$kd=apply_sql_function($X["fun"],$D);echo($Dh?'<a href="'.h($Hd.($Gf[0]==$e||$Gf[0]==$_||(!$Gf&&$de&&$qd[0]==$e)?$Tb:'')).'">'."$kd</a>":$kd),"<span class='column hidden'>";if($Dh)echo"<a href='".h($Hd.$Tb)."' title='".lang(58)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($p["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(55).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($_)."');");echo"</span>";}$ld[$_]=$X["fun"];next($M);}}$ze=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$_=>$X)$ze[$_]=max($ze[$_],min(40,strlen(utf8_decode($X))));}}echo($Fa?"<th>".lang(263):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach($b->rowDescriptions($L,$fd)as$cf=>$K){$Qi=unique_array($L[$cf],$z);if(!$Qi){$Qi=array();foreach($L[$cf]as$_=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$_))$Qi[$_]=$X;}}$Ri="";foreach($Qi
as$_=>$X){if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$q[$_]["type"])&&strlen($X)>64){$_=(strpos($_,'(')?$_:idf_escape($_));$_="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$q[$_]["collation"])?$_:"CONVERT($_ USING ".charset($h).")").")";$X=md5($X);}$Ri.="&".($X!==null?urlencode("where[".bracket_escape($_)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($_));}echo"<tr>".(!$qd&&$M?"":"<td>".checkbox("check[]",substr($Ri,1),in_array(substr($Ri,1),(array)$_POST["check"])).($de||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Ri)."' class='edit'>".lang(264)."</a>"));foreach($K
as$_=>$X){if(isset($ef[$_])){$p=$q[$_];$X=$n->value($X,$p);if($X!=""&&(!isset($qc[$_])||$qc[$_]!=""))$qc[$_]=(is_mail($X)?$ef[$_]:"");$B="";if(preg_match('~blob|bytea|raw|file~',$p["type"])&&$X!="")$B=ME.'download='.urlencode($a).'&field='.urlencode($_).$Ri;if(!$B&&$X!==null){foreach((array)$fd[$_]as$s){if(count($fd[$_])==1||end($s["source"])==$_){$B="";foreach($s["source"]as$v=>$Eh)$B.=where_link($v,$s["target"][$v],$L[$cf][$Eh]);$B=($s["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($s["db"]),ME):ME).'select='.urlencode($s["table"]).$B;if($s["ns"])$B=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($s["ns"]),$B);if(count($s["source"])==1)break;}}}if($_=="COUNT(*)"){$B=ME."select=".urlencode($a);$v=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Qi))$B.=where_link($v++,$W["col"],$W["val"],$W["op"]);}foreach($Qi
as$je=>$W)$B.=where_link($v++,$je,$W);}$X=select_value($X,$B,$p,$oi);$w=h("val[$Ri][".bracket_escape($_)."]");$Y=$_POST["val"][$Ri][bracket_escape($_)];$lc=!is_array($K[$_])&&is_utf8($X)&&$L[$cf][$_]==$K[$_]&&!$ld[$_]&&!$p["generated"];$mi=preg_match('~text|json|lob~',$p["type"]);echo"<td id='$w'".(preg_match(number_type(),$p["type"])&&is_numeric(strip_tags($X))?" class='number'":"");if(($_GET["modify"]&&$lc)||$Y!==null){$vd=h($Y!==null?$Y:$K[$_]);echo">".($mi?"<textarea name='$w' cols='30' rows='".(substr_count($K[$_],"\n")+1)."'>$vd</textarea>":"<input name='$w' value='$vd' size='$ze[$_]'>");}else{$De=strpos($X,"<i>…</i>");echo" data-text='".($De?2:($mi?1:0))."'".($lc?"":" data-warning='".h(lang(265))."'").">$X";}}}if($Fa)echo"<td>";$b->backwardKeysPrint($Fa,$L[$cf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$F){$Dc=true;if($_GET["page"]!="last"){if($A==""||(count($L)<$A&&($L||!$F)))$id=($F?$F*$A:0)+count($L);elseif(JUSH!="sql"||!$de){$id=($de?false:found_rows($S,$Z));if($id<max(1e4,2*($F+1)*$A))$id=first(slow_query(count_rows($a,$Z,$de,$qd)));else$Dc=false;}}$Wf=($A!=""&&($id===false||$id>$A||$F));if($Wf)echo(($id===false?count($L)+1:$id-$F*$A)>$A?'<p><a href="'.h(remove_from_uri("page")."&page=".($F+1)).'" class="loadmore">'.lang(266).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$A).", '".lang(267)."…');",""):''),"\n";}echo"<div class='footer'><div>\n";if($L||$F){if($Wf){$Le=($id===false?$F+(count($L)>=$A?2:1):floor(($id-1)/$A));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(268)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(268)."', '".($F+1)."')); return false; };"),pagination(0,$F).($F>5?" …":"");for($v=max(1,$F-4);$v<min($Le,$F+5);$v++)echo
pagination($v,$F);if($Le>0)echo($F+5<$Le?" …":""),($Dc&&$id!==false?pagination($Le,$F):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Le'>".lang(269)."</a>");}else
echo"<legend>".lang(268)."</legend>",pagination(0,$F).($F>1?" …":""),($F?pagination($F,$F):""),($Le>$F?pagination($F+1,$F).($Le>$F+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(270)."</legend>";$Zb=($Dc?"":"~ ").$id;$_f="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Zb' : checked); selectCount('selected2', this.checked || !checked ? '$Zb' : checked);";echo
checkbox("all",1,0,($id!==false?($Dc?"":"~ ").lang(154,$id):""),$_f)."\n","</fieldset>\n";if($b->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(262),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(258).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(128),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(254),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$gd=$b->dumpFormat();foreach((array)$_GET["columns"]as$e){if($e["fun"]){unset($gd['sql']);break;}}if($gd){print_fieldset("export",lang(72)." <span id='selected2'></span>");$Tf=$b->dumpOutput();echo($Tf?html_select("output",$Tf,$qa["output"])." ":""),html_select("format",$gd,$qa["format"])," <input type='submit' name='export' value='".lang(72)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($qc,'strlen'),$f);}echo"</div></div>\n";if($b->selectImportPrint())echo"<div>","<a href='#import'>".lang(71)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$qa["format"])," <input type='submit' name='import' value='".lang(71)."'>","</span>","</div>";echo
input_token(),"</form>\n",(!$qd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(119):lang(118));$hj=($P?show_status():show_variables());if(!$hj)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($hj
as$K){echo"<tr>";$_=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($_)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Wh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$S){json_row("Comment-$D",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$_)json_row("$_-$D",h($S[$_]));foreach($Wh+array("Auto_increment"=>0,"Rows"=>0)as$_=>$X){if($S[$_]!=""){$X=format_number($S[$_]);if($X>=0)json_row("$_-$D",($_=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Wh[$_]))$Wh[$_]+=($S["Engine"]!="InnoDB"||$_!="Data_free"?$S[$_]:0);}elseif(array_key_exists($_,$S))json_row("$_-$D","?");}}}foreach($Wh
as$_=>$X)json_row("sum-$_",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$h->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$l=>$X){json_row("tables-$l",$X);json_row("size-$l",db_size($l));}json_row("");}exit;}else{$gi=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($gi&&!$o&&!$_POST["search"]){$I=true;$Se="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$Se=lang(271);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Se=lang(272);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Se=lang(273);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$Se=lang(274);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$Se.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Se=lang(275);}elseif(!$_POST["tables"])$Se=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$Se.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Se,$I);}page_header(($_GET["ns"]==""?lang(36).": ".h(DB):lang(75).": ".h($_GET["ns"])),$o,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(276)."</h3>\n";$fi=tables_list();if(!$fi)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(277)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(55)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$n->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(133),'<td>'.lang(278).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(124).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(279).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(280).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(281).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(50).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(282).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(49).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($fi
as$D=>$U){$kj=($U!==null&&!preg_match('~table|sequence~i',$U));$w=h("Table-".$D);echo'<tr><td>'.checkbox(($kj?"views[]":"tables[]"),$D,in_array($D,$gi,true),"","","",$w),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".lang(41)."' id='$w'>".h($D).'</a>':h($D));if($kj)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($D).'" title="'.lang(42).'">'.(preg_match('~materialized~i',$U)?lang(131):lang(132)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.lang(40).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(135)),"Data_free"=>array("edit",lang(44)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(40)),)as$_=>$B){$w=" id='$_-".h($D)."'";echo($B?"<td align='right'>".(support("table")||$_=="Rows"||(support("indexes")&&$_!="Data_length")?"<a href='".h(ME."$B[0]=").urlencode($D)."'$w title='$B[1]'>?</a>":"<span$w>?</span>"):"<td id='$_-".h($D)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":""),"\n";}echo"<tr><td><th>".lang(255,count($fi)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$_)echo"<td align='right' id='sum-$_'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$ej="<input type='submit' value='".lang(283)."'> ".on_help("'VACUUM'");$Cf="<input type='submit' name='optimize' value='".lang(284)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(128)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$ej."<input type='submit' name='check' value='".lang(285)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$ej.$Cf:(JUSH=="sql"?"<input type='submit' value='".lang(286)."'> ".on_help("'ANALYZE TABLE'").$Cf."<input type='submit' name='check' value='".lang(285)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(287)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(288)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(129)."'>".on_help("'DROP TABLE'").confirm()."\n";$k=(support("scheme")?$b->schemas():$b->databases());if(count($k)!=1&&JUSH!="sqlite"){$l=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(289).": ",($k?html_select("target",$k,$l):'<input name="target" value="'.h($l).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(290)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(291)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(292)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(73)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(208)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(147)."</h3>\n";$ch=routines();if($ch){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(187).'<td>'.lang(48).'<td>'.lang(225)."<td></thead>\n";foreach($ch
as$K){$D=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$D).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$D).'">'.lang(138)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(224).'</a>':'').'<a href="'.h(ME).'function=">'.lang(223)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(293)."</h3>\n";$th=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($th){echo"<table class='odds'>\n","<thead><tr><th>".lang(187)."</thead>\n";foreach($th
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(230)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(31)."</h3>\n";$cj=types();if($cj){echo"<table class='odds'>\n","<thead><tr><th>".lang(187)."</thead>\n";foreach($cj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(234)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(148)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(187)."<td>".lang(294)."<td>".lang(214)."<td>".lang(215)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(295)."<td>".$K["Execute at"]:lang(216)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(138).'</a>';echo"</table>\n";$Bc=get_val("SELECT @@event_scheduler");if($Bc&&$Bc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Bc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(213)."</a>\n";}if($fi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();