<?php // -*-mode: PHP; coding:utf-8;-*-
namespace MRBS;

/**************************************************************************
 *   MRBS Configuration File
 *   Configure this file for your site.
 *   You shouldn't have to modify anything outside this file.
 *
 *   This file has already been populated with the minimum set of configuration
 *   variables that you will need to change to get your system up and running.
 *   If you want to change any of the other settings in systemdefaults.inc.php
 *   or areadefaults.inc.php, then copy the relevant lines into this file
 *   and edit them here.   This file will override the default settings and
 *   when you upgrade to a new version of MRBS the config file is preserved.
 **************************************************************************/

/**********
 * Timezone
 **********/
 
// The timezone your meeting rooms run in. It is especially important
// to set this if you're using PHP 5 on Linux. In this configuration
// if you don't, meetings in a different DST than you are currently
// in are offset by the DST offset incorrectly.
//
// Note that timezones can be set on a per-area basis, so strictly speaking this
// setting should be in areadefaults.inc.php, but as it is so important to set
// the right timezone it is included here.
//
// When upgrading an existing installation, this should be set to the
// timezone the web server runs in.  See the INSTALL document for more information.
//
// A list of valid timezones can be found at http://php.net/manual/timezones.php
// The following line must be uncommented by removing the '//' at the beginning
$timezone = "America/Argentina/Buenos_Aires";
//$locale = "es-es";
$override_locale = "es_AR.UTF-8";
/*******************
 * Database settings
 ******************/
// Which database system: "pgsql"=PostgreSQL, "mysql"=MySQL
$dbsys = "mysql";
// Hostname of database server. For pgsql, can use "" instead of localhost
// to use Unix Domain Sockets instead of TCP/IP. For mysql "localhost"
// tells the system to use Unix Domain Sockets, and $db_port will be ignored;
// if you want to force TCP connection you can use "127.0.0.1".
$db_host = "localhost";
// If you need to use a non standard port for the database connection you
// can uncomment the following line and specify the port number
// $db_port = 1234;
// Database name:
$db_database = "mrbs";
// Schema name.  This only applies to PostgreSQL and is only necessary if you have more
// than one schema in your database and also you are using the same MRBS table names in
// multiple schemas.
//$db_schema = "public";
// Database login user name:
$db_login = "mrbs";
// Database login password:
$db_password = 'gleich';
// Prefix for table names.  This will allow multiple installations where only
// one database is available
$db_tbl_prefix = "mrbs_";
// Set $db_persist to TRUE to use PHP persistent (pooled) database connections.  Note
// that persistent connections are not recommended unless your system suffers significant
// performance problems without them.   They can cause problems with transactions and
// locks (see http://php.net/manual/en/features.persistent-connections.php) and although
// MRBS tries to avoid those problems, it is generally better not to use persistent
// connections if you can.
$db_persist = FALSE;


/* Add lines from systemdefaults.inc.php and areadefaults.inc.php below here
   to change the default configuration. Do _NOT_ modify systemdefaults.inc.php
   or areadefaults.inc.php.  */


$mrbs_admin = "Soporte adum";
$mrbs_admin_email = "hospitaldepcadum@gmail.com";
//$mrbs_company = "a.d.u.m.";
$max_slots = 90;
$weekstarts = 1;
$morningstarts         = 8;
$morningstarts_minutes = 0;
$eveningends = '20';
$eveningends_minutes = '30';
$mrbs_company_more_info = "Agremiacion Docente Universitaria Marplatense";
$mrbs_company_url = "http://www.adum.org.ar/";
$mrbs_company_logo = "adum.png";

// bloquear acceso publico a la info
$auth['deny_public_access'] = TRUE;
$auth['only_admin_can_book'] = TRUE;
//only_admin_can_book a ver si anda
unset($booking_types);    // Include this line when copying to config.inc.php
//# Tipos de reservas (Carreras)
$booking_types[] = "A";
$booking_types[] = "B";
$booking_types[] = "C";
$booking_types[] = "D";
//$booking_types[] = "E";
$booking_types[] = "F";
$booking_types[] = "G";
$booking_types[] = "H";
//$booking_types[] = "I";
$booking_types[] = "J";
$booking_types[] = "K";
$booking_types[] = "L";

// Entry types
//unset($vocab["type.E"]);
//unset($vocab["type.I"]);
$vocab["type.A"]             = "Capacitación";
$vocab["type.B"]             = "Postgrado";
$vocab["type.C"]             = "Fiesta";
$vocab["type.D"]             = "Act.externas";
//$vocab["type.E"]             = "Act.UNMDP";
$vocab["type.F"]             = "Congreso/Jornadas";
$vocab["type.G"]             = "Clase/Tesis";
$vocab["type.H"]             = "Concurso";
//$vocab["type.I"]             = "LIMPIEZA";
$vocab["type.J"]             = "Act.ADUM";
$vocab["type.K"]             = "Act.UNMDP";
$vocab["type.L"]             = "Limpieza";

// These are the colours used for distinguishing between the dfferent
// types of bookings in the main
// displays in the day, week and month views
//unset($color_types);
//$color_types = array(
//	'A' => "#88FF00",
 //       'B' => "#14BC00",
   //     'C' => "#FE9A2E",
     //   'D' => "#46C6F2",
       // 'F' => "#5E46F2",
//        'G' => "#E71717",
//        'H' => "#E76817",
//	'J' => "#AEC144",
 //       );
//
$auth["session_php"]["session_expire_time"] = 72000;

